(ns simply-ux.utils)


(defn pretty-state
	"Returns a :pre tag with the given `state` in pretty format.
   Useful for examining and debugging state."
	[state]
  [:pre (with-out-str
          (cljs.pprint/pprint state))])


(defn track-life-cycle-events
  [component-name component]
  (-> component
      (assoc :component-will-mount
             (fn []
               (println component-name "WILL MOUNT")))

      (assoc :component-did-mount
             (fn []
               (println component-name "DID MOUNT")))

      (assoc :component-did-update
             (fn []
               (println component-name "DID UPDATE")))

      (update :render (fn [render]
                        (fn [state]
                          (println component-name "RENDER")

                          (render state))))))
