(ns simply-ux.http-api
  (:require [cljs-http.client :as http]
            [simply-ux.ui-app :as ui-app]
            [simply-ux.http-requests :as http-requests]))

(defn ->http-method
  [http-method]
  (case http-method
    :get http/get
    :post http/post))


(defn poll-until
  [{:keys [url
           http-method
           params
           polling-successful-when

           ;; Polling Settings

           polling-interval
           try-count
           max-tries

           ;; Callbacks

           on-polling
           on-polling-success
           on-timeout
           on-polling-error]

    :or {http-method :get
         params {}

         polling-interval 2
         try-count 0
         max-tries 5

         on-polling (fn [])
         on-timeout (fn [])
         on-polling-error (fn [_])}

    :as polling-params}]

  (on-polling)

  (ui-app/run-delayed
   {:seconds polling-interval}
   (fn []
     (if (= try-count max-tries)
       (on-timeout)

       (http-requests/make-request
        (http-requests/authenticated-request
         (->http-method http-method)
         url
         {:edn-params params})
        (fn [response]
          (if (http-requests/successful-request? response)
            (let [body (:body response)]
              (if (true? (polling-successful-when body))
                (on-polling-success body)
                (poll-until
                 (assoc polling-params
                        :try-count (inc try-count)))))
            (on-polling-error response))))))))


(defn request-then-poll
  [& {{:keys [url
              http-method
              params
              on-request-start
              on-successful-request
              should-poll?
              on-request-error]
       :or {http-method :post
            params {}
            on-request-start (fn [])
            on-successful-request (fn [])
            should-poll? (fn [_] true)
            on-request-error (fn [_])}} :initial-request

      polling-params :polling}]

  (on-request-start)

  (http-requests/make-request
   (http-requests/authenticated-request
    (->http-method http-method)
    url
    {:edn-params params})
   (fn [response]
     (if (and (http-requests/successful-request? response)
              (should-poll? response))
       (do
         (on-successful-request)

         (poll-until polling-params))
       (on-request-error response)))))
