(ns simply-ux.component.config)


(defn config-map? [component]
  (map? component))


(defn extract-state-scope
  [component]
  (:state-scope component))


(defn extract-props
  [component]
  (merge {}
         (:default-props component)
         (:props component)))


(defn extract-initial-state
  [component]
  (:initial-state component))


(def non-life-cycle-functions
  [:state-scope
   :default-props
   :props
   :initial-state
   :render])


(defn extract-life-cycle-functions
  [component]
  (apply dissoc
         component non-life-cycle-functions))


(defn component-acts-as-a-container?
  [component]
  (or (and (config-map? component)
           (or (:act-as-container? component)
               (:do-not-react-to-state-changes? component)))
      false))
