/*
 * Decompiled with CFR 0.152.
 */
package datasplash.fns;

import clojure.lang.IFn;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;

public class ExtractKeyFn
implements ElasticsearchIO.Write.FieldValueExtractFn {
    private final IFn keyFn;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public ExtractKeyFn(IFn keyFunction) {
        this.keyFn = keyFunction;
    }

    public String apply(JsonNode input) {
        String jsonString;
        try {
            if (input.isMissingNode()) {
                throw new RuntimeException("Unable to extract field: " + input.asText());
            }
            jsonString = MAPPER.writer().writeValueAsString((Object)input);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return String.valueOf(this.keyFn.invoke((Object)jsonString));
    }
}

