/*
 * Decompiled with CFR 0.152.
 */
package datasplash.fns;

import clojure.lang.IFn;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Combine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClojureCombineFn
extends Combine.CombineFn<Object, Object, Object> {
    private static final long serialVersionUID = 0L;
    private final IFn initFn;
    private final IFn extractFn;
    private final IFn reduceFn;
    private final IFn combineFn;
    private final IFn combineFnRaw;
    private final Coder accCoder;
    private final Coder outputCoder;

    public ClojureCombineFn(Map<String, IFn> fns_map, Coder output_coder, Coder acc_coder) {
        this.initFn = fns_map.get("init-fn");
        this.extractFn = fns_map.get("extract-fn");
        this.reduceFn = fns_map.get("reduce-fn");
        this.combineFn = fns_map.get("combine-fn");
        this.combineFnRaw = fns_map.get("combine-fn-raw");
        this.accCoder = acc_coder;
        this.outputCoder = output_coder;
    }

    public Object createAccumulator() {
        return this.initFn.invoke();
    }

    public Object addInput(Object acc, Object elt) {
        return this.reduceFn.invoke(acc, elt);
    }

    public Object mergeAccumulators(Iterable<Object> accs) {
        return this.combineFn.invoke(accs);
    }

    public Object extractOutput(Object acc) {
        return this.extractFn.invoke(acc);
    }

    public Coder getDefaultOutputCoder(Object a, Object b) {
        return this.outputCoder;
    }

    public Coder getAccumulatorCoder(Object a, Object b) {
        return this.accCoder;
    }

    public IFn getInitFn() {
        return this.initFn;
    }

    public IFn getReduceFn() {
        return this.reduceFn;
    }

    public IFn getMergeFn() {
        return this.combineFnRaw;
    }

    public IFn getExtractFn() {
        return this.extractFn;
    }
}

