/*
 * Decompiled with CFR 0.152.
 */
package datasplash.fns;

import clojure.lang.IFn;
import java.util.Map;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;

public final class FileNamePolicy
extends FileBasedSink.FilenamePolicy {
    private static final long serialVersionUID = 0L;
    private final IFn windowedFn;
    private final IFn unwindowedFn;
    private final ResourceId prefix;
    private final String raw_prefix;

    public FileNamePolicy(Map<String, Object> params_map) {
        this.windowedFn = (IFn)params_map.get("windowed-fn");
        this.unwindowedFn = (IFn)params_map.get("unwindowed-fn");
        this.raw_prefix = (String)params_map.get("prefix");
        this.prefix = FileBasedSink.convertToFileResourceIfPossible((String)this.raw_prefix);
    }

    public ResourceId windowedFilename(int shardNumber, int numShards, BoundedWindow window, PaneInfo paneInfo, FileBasedSink.OutputFileHints outputFileHints) {
        String fileName = (String)this.windowedFn.invoke((Object)shardNumber, (Object)numShards, (Object)window, (Object)outputFileHints.getSuggestedFilenameSuffix());
        return this.prefix.getCurrentDirectory().resolve(fileName, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
    }

    public ResourceId unwindowedFilename(int shardNumber, int numShards, FileBasedSink.OutputFileHints outputFileHints) {
        String fileName = (String)this.unwindowedFn.invoke((Object)shardNumber, (Object)numShards, (Object)outputFileHints.getSuggestedFilenameSuffix());
        return this.prefix.getCurrentDirectory().resolve(fileName, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
    }
}

