(ns xd-table.demo
  (:require [reagent.core :as r]
            [xd-table.core :refer [xd-table]]))

(defn demo []
  [:div.xd-demo
    [:h1 "XD-Table"]
    [xd-table
      {:cell-fn
         (fn [{:keys [hue sat val opc] :or {hue 100 sat 100 val 50 opc 1}}]
           (let [hsl (str "hsla(" hue "," sat "%," val "%," opc ")")]
             [:div {:style {:background-color hsl}} (pr-str val)]))

       :dims
         [{:id :sat :vals [100 80 60 40 20]}
          {:id :hue :vals [360 300 240 180 120 60 0]}
          {:id :val :vals [100 90 80 70 60 50 40 30 20 10]}
          {:id :opc :vals [1 0.5]}]

       :dim-yz? true
       :dim-xz? true}]])

(r/render [demo] (.getElementById js/document "app"))
