// Compiled by ClojureScript 1.9.229 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__26570__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__26570__auto__){
return or__26570__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__26570__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__26570__auto__)){
return or__26570__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__33302_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__33302_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__33307 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__33308 = null;
var count__33309 = (0);
var i__33310 = (0);
while(true){
if((i__33310 < count__33309)){
var n = cljs.core._nth.call(null,chunk__33308,i__33310);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__33311 = seq__33307;
var G__33312 = chunk__33308;
var G__33313 = count__33309;
var G__33314 = (i__33310 + (1));
seq__33307 = G__33311;
chunk__33308 = G__33312;
count__33309 = G__33313;
i__33310 = G__33314;
continue;
} else {
var temp__6728__auto__ = cljs.core.seq.call(null,seq__33307);
if(temp__6728__auto__){
var seq__33307__$1 = temp__6728__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33307__$1)){
var c__27473__auto__ = cljs.core.chunk_first.call(null,seq__33307__$1);
var G__33315 = cljs.core.chunk_rest.call(null,seq__33307__$1);
var G__33316 = c__27473__auto__;
var G__33317 = cljs.core.count.call(null,c__27473__auto__);
var G__33318 = (0);
seq__33307 = G__33315;
chunk__33308 = G__33316;
count__33309 = G__33317;
i__33310 = G__33318;
continue;
} else {
var n = cljs.core.first.call(null,seq__33307__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__33319 = cljs.core.next.call(null,seq__33307__$1);
var G__33320 = null;
var G__33321 = (0);
var G__33322 = (0);
seq__33307 = G__33319;
chunk__33308 = G__33320;
count__33309 = G__33321;
i__33310 = G__33322;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__33373_33384 = cljs.core.seq.call(null,deps);
var chunk__33374_33385 = null;
var count__33375_33386 = (0);
var i__33376_33387 = (0);
while(true){
if((i__33376_33387 < count__33375_33386)){
var dep_33388 = cljs.core._nth.call(null,chunk__33374_33385,i__33376_33387);
topo_sort_helper_STAR_.call(null,dep_33388,(depth + (1)),state);

var G__33389 = seq__33373_33384;
var G__33390 = chunk__33374_33385;
var G__33391 = count__33375_33386;
var G__33392 = (i__33376_33387 + (1));
seq__33373_33384 = G__33389;
chunk__33374_33385 = G__33390;
count__33375_33386 = G__33391;
i__33376_33387 = G__33392;
continue;
} else {
var temp__6728__auto___33393 = cljs.core.seq.call(null,seq__33373_33384);
if(temp__6728__auto___33393){
var seq__33373_33394__$1 = temp__6728__auto___33393;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33373_33394__$1)){
var c__27473__auto___33395 = cljs.core.chunk_first.call(null,seq__33373_33394__$1);
var G__33396 = cljs.core.chunk_rest.call(null,seq__33373_33394__$1);
var G__33397 = c__27473__auto___33395;
var G__33398 = cljs.core.count.call(null,c__27473__auto___33395);
var G__33399 = (0);
seq__33373_33384 = G__33396;
chunk__33374_33385 = G__33397;
count__33375_33386 = G__33398;
i__33376_33387 = G__33399;
continue;
} else {
var dep_33400 = cljs.core.first.call(null,seq__33373_33394__$1);
topo_sort_helper_STAR_.call(null,dep_33400,(depth + (1)),state);

var G__33401 = cljs.core.next.call(null,seq__33373_33394__$1);
var G__33402 = null;
var G__33403 = (0);
var G__33404 = (0);
seq__33373_33384 = G__33401;
chunk__33374_33385 = G__33402;
count__33375_33386 = G__33403;
i__33376_33387 = G__33404;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__33377){
var vec__33381 = p__33377;
var seq__33382 = cljs.core.seq.call(null,vec__33381);
var first__33383 = cljs.core.first.call(null,seq__33382);
var seq__33382__$1 = cljs.core.next.call(null,seq__33382);
var x = first__33383;
var xs = seq__33382__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__33381,seq__33382,first__33383,seq__33382__$1,x,xs,get_deps__$1){
return (function (p1__33323_SHARP_){
return clojure.set.difference.call(null,p1__33323_SHARP_,x);
});})(vec__33381,seq__33382,first__33383,seq__33382__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__33417 = cljs.core.seq.call(null,provides);
var chunk__33418 = null;
var count__33419 = (0);
var i__33420 = (0);
while(true){
if((i__33420 < count__33419)){
var prov = cljs.core._nth.call(null,chunk__33418,i__33420);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__33421_33429 = cljs.core.seq.call(null,requires);
var chunk__33422_33430 = null;
var count__33423_33431 = (0);
var i__33424_33432 = (0);
while(true){
if((i__33424_33432 < count__33423_33431)){
var req_33433 = cljs.core._nth.call(null,chunk__33422_33430,i__33424_33432);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33433,prov);

var G__33434 = seq__33421_33429;
var G__33435 = chunk__33422_33430;
var G__33436 = count__33423_33431;
var G__33437 = (i__33424_33432 + (1));
seq__33421_33429 = G__33434;
chunk__33422_33430 = G__33435;
count__33423_33431 = G__33436;
i__33424_33432 = G__33437;
continue;
} else {
var temp__6728__auto___33438 = cljs.core.seq.call(null,seq__33421_33429);
if(temp__6728__auto___33438){
var seq__33421_33439__$1 = temp__6728__auto___33438;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33421_33439__$1)){
var c__27473__auto___33440 = cljs.core.chunk_first.call(null,seq__33421_33439__$1);
var G__33441 = cljs.core.chunk_rest.call(null,seq__33421_33439__$1);
var G__33442 = c__27473__auto___33440;
var G__33443 = cljs.core.count.call(null,c__27473__auto___33440);
var G__33444 = (0);
seq__33421_33429 = G__33441;
chunk__33422_33430 = G__33442;
count__33423_33431 = G__33443;
i__33424_33432 = G__33444;
continue;
} else {
var req_33445 = cljs.core.first.call(null,seq__33421_33439__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33445,prov);

var G__33446 = cljs.core.next.call(null,seq__33421_33439__$1);
var G__33447 = null;
var G__33448 = (0);
var G__33449 = (0);
seq__33421_33429 = G__33446;
chunk__33422_33430 = G__33447;
count__33423_33431 = G__33448;
i__33424_33432 = G__33449;
continue;
}
} else {
}
}
break;
}

var G__33450 = seq__33417;
var G__33451 = chunk__33418;
var G__33452 = count__33419;
var G__33453 = (i__33420 + (1));
seq__33417 = G__33450;
chunk__33418 = G__33451;
count__33419 = G__33452;
i__33420 = G__33453;
continue;
} else {
var temp__6728__auto__ = cljs.core.seq.call(null,seq__33417);
if(temp__6728__auto__){
var seq__33417__$1 = temp__6728__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33417__$1)){
var c__27473__auto__ = cljs.core.chunk_first.call(null,seq__33417__$1);
var G__33454 = cljs.core.chunk_rest.call(null,seq__33417__$1);
var G__33455 = c__27473__auto__;
var G__33456 = cljs.core.count.call(null,c__27473__auto__);
var G__33457 = (0);
seq__33417 = G__33454;
chunk__33418 = G__33455;
count__33419 = G__33456;
i__33420 = G__33457;
continue;
} else {
var prov = cljs.core.first.call(null,seq__33417__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__33425_33458 = cljs.core.seq.call(null,requires);
var chunk__33426_33459 = null;
var count__33427_33460 = (0);
var i__33428_33461 = (0);
while(true){
if((i__33428_33461 < count__33427_33460)){
var req_33462 = cljs.core._nth.call(null,chunk__33426_33459,i__33428_33461);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33462,prov);

var G__33463 = seq__33425_33458;
var G__33464 = chunk__33426_33459;
var G__33465 = count__33427_33460;
var G__33466 = (i__33428_33461 + (1));
seq__33425_33458 = G__33463;
chunk__33426_33459 = G__33464;
count__33427_33460 = G__33465;
i__33428_33461 = G__33466;
continue;
} else {
var temp__6728__auto___33467__$1 = cljs.core.seq.call(null,seq__33425_33458);
if(temp__6728__auto___33467__$1){
var seq__33425_33468__$1 = temp__6728__auto___33467__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33425_33468__$1)){
var c__27473__auto___33469 = cljs.core.chunk_first.call(null,seq__33425_33468__$1);
var G__33470 = cljs.core.chunk_rest.call(null,seq__33425_33468__$1);
var G__33471 = c__27473__auto___33469;
var G__33472 = cljs.core.count.call(null,c__27473__auto___33469);
var G__33473 = (0);
seq__33425_33458 = G__33470;
chunk__33426_33459 = G__33471;
count__33427_33460 = G__33472;
i__33428_33461 = G__33473;
continue;
} else {
var req_33474 = cljs.core.first.call(null,seq__33425_33468__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33474,prov);

var G__33475 = cljs.core.next.call(null,seq__33425_33468__$1);
var G__33476 = null;
var G__33477 = (0);
var G__33478 = (0);
seq__33425_33458 = G__33475;
chunk__33426_33459 = G__33476;
count__33427_33460 = G__33477;
i__33428_33461 = G__33478;
continue;
}
} else {
}
}
break;
}

var G__33479 = cljs.core.next.call(null,seq__33417__$1);
var G__33480 = null;
var G__33481 = (0);
var G__33482 = (0);
seq__33417 = G__33479;
chunk__33418 = G__33480;
count__33419 = G__33481;
i__33420 = G__33482;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__33487_33491 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__33488_33492 = null;
var count__33489_33493 = (0);
var i__33490_33494 = (0);
while(true){
if((i__33490_33494 < count__33489_33493)){
var ns_33495 = cljs.core._nth.call(null,chunk__33488_33492,i__33490_33494);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_33495);

var G__33496 = seq__33487_33491;
var G__33497 = chunk__33488_33492;
var G__33498 = count__33489_33493;
var G__33499 = (i__33490_33494 + (1));
seq__33487_33491 = G__33496;
chunk__33488_33492 = G__33497;
count__33489_33493 = G__33498;
i__33490_33494 = G__33499;
continue;
} else {
var temp__6728__auto___33500 = cljs.core.seq.call(null,seq__33487_33491);
if(temp__6728__auto___33500){
var seq__33487_33501__$1 = temp__6728__auto___33500;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33487_33501__$1)){
var c__27473__auto___33502 = cljs.core.chunk_first.call(null,seq__33487_33501__$1);
var G__33503 = cljs.core.chunk_rest.call(null,seq__33487_33501__$1);
var G__33504 = c__27473__auto___33502;
var G__33505 = cljs.core.count.call(null,c__27473__auto___33502);
var G__33506 = (0);
seq__33487_33491 = G__33503;
chunk__33488_33492 = G__33504;
count__33489_33493 = G__33505;
i__33490_33494 = G__33506;
continue;
} else {
var ns_33507 = cljs.core.first.call(null,seq__33487_33501__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_33507);

var G__33508 = cljs.core.next.call(null,seq__33487_33501__$1);
var G__33509 = null;
var G__33510 = (0);
var G__33511 = (0);
seq__33487_33491 = G__33508;
chunk__33488_33492 = G__33509;
count__33489_33493 = G__33510;
i__33490_33494 = G__33511;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__26570__auto__ = goog.require__;
if(cljs.core.truth_(or__26570__auto__)){
return or__26570__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__33512__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__33512 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33513__i = 0, G__33513__a = new Array(arguments.length -  0);
while (G__33513__i < G__33513__a.length) {G__33513__a[G__33513__i] = arguments[G__33513__i + 0]; ++G__33513__i;}
  args = new cljs.core.IndexedSeq(G__33513__a,0);
} 
return G__33512__delegate.call(this,args);};
G__33512.cljs$lang$maxFixedArity = 0;
G__33512.cljs$lang$applyTo = (function (arglist__33514){
var args = cljs.core.seq(arglist__33514);
return G__33512__delegate(args);
});
G__33512.cljs$core$IFn$_invoke$arity$variadic = G__33512__delegate;
return G__33512;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__33516 = cljs.core._EQ_;
var expr__33517 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__33516.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__33517))){
var path_parts = ((function (pred__33516,expr__33517){
return (function (p1__33515_SHARP_){
return clojure.string.split.call(null,p1__33515_SHARP_,/[\/\\]/);
});})(pred__33516,expr__33517))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__33516,expr__33517){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e33519){if((e33519 instanceof Error)){
var e = e33519;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e33519;

}
}})());
});
;})(path_parts,sep,root,pred__33516,expr__33517))
} else {
if(cljs.core.truth_(pred__33516.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__33517))){
return ((function (pred__33516,expr__33517){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__33516,expr__33517){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__33516,expr__33517))
);

return deferred.addErrback(((function (deferred,pred__33516,expr__33517){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__33516,expr__33517))
);
});
;})(pred__33516,expr__33517))
} else {
return ((function (pred__33516,expr__33517){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__33516,expr__33517))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__33520,callback){
var map__33523 = p__33520;
var map__33523__$1 = ((((!((map__33523 == null)))?((((map__33523.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33523.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33523):map__33523);
var file_msg = map__33523__$1;
var request_url = cljs.core.get.call(null,map__33523__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__33523,map__33523__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__33523,map__33523__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__29219__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto__){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto__){
return (function (state_33547){
var state_val_33548 = (state_33547[(1)]);
if((state_val_33548 === (7))){
var inst_33543 = (state_33547[(2)]);
var state_33547__$1 = state_33547;
var statearr_33549_33569 = state_33547__$1;
(statearr_33549_33569[(2)] = inst_33543);

(statearr_33549_33569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33548 === (1))){
var state_33547__$1 = state_33547;
var statearr_33550_33570 = state_33547__$1;
(statearr_33550_33570[(2)] = null);

(statearr_33550_33570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33548 === (4))){
var inst_33527 = (state_33547[(7)]);
var inst_33527__$1 = (state_33547[(2)]);
var state_33547__$1 = (function (){var statearr_33551 = state_33547;
(statearr_33551[(7)] = inst_33527__$1);

return statearr_33551;
})();
if(cljs.core.truth_(inst_33527__$1)){
var statearr_33552_33571 = state_33547__$1;
(statearr_33552_33571[(1)] = (5));

} else {
var statearr_33553_33572 = state_33547__$1;
(statearr_33553_33572[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33548 === (6))){
var state_33547__$1 = state_33547;
var statearr_33554_33573 = state_33547__$1;
(statearr_33554_33573[(2)] = null);

(statearr_33554_33573[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33548 === (3))){
var inst_33545 = (state_33547[(2)]);
var state_33547__$1 = state_33547;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33547__$1,inst_33545);
} else {
if((state_val_33548 === (2))){
var state_33547__$1 = state_33547;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33547__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_33548 === (11))){
var inst_33539 = (state_33547[(2)]);
var state_33547__$1 = (function (){var statearr_33555 = state_33547;
(statearr_33555[(8)] = inst_33539);

return statearr_33555;
})();
var statearr_33556_33574 = state_33547__$1;
(statearr_33556_33574[(2)] = null);

(statearr_33556_33574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33548 === (9))){
var inst_33531 = (state_33547[(9)]);
var inst_33533 = (state_33547[(10)]);
var inst_33535 = inst_33533.call(null,inst_33531);
var state_33547__$1 = state_33547;
var statearr_33557_33575 = state_33547__$1;
(statearr_33557_33575[(2)] = inst_33535);

(statearr_33557_33575[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33548 === (5))){
var inst_33527 = (state_33547[(7)]);
var inst_33529 = figwheel.client.file_reloading.blocking_load.call(null,inst_33527);
var state_33547__$1 = state_33547;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33547__$1,(8),inst_33529);
} else {
if((state_val_33548 === (10))){
var inst_33531 = (state_33547[(9)]);
var inst_33537 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_33531);
var state_33547__$1 = state_33547;
var statearr_33558_33576 = state_33547__$1;
(statearr_33558_33576[(2)] = inst_33537);

(statearr_33558_33576[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33548 === (8))){
var inst_33527 = (state_33547[(7)]);
var inst_33533 = (state_33547[(10)]);
var inst_33531 = (state_33547[(2)]);
var inst_33532 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_33533__$1 = cljs.core.get.call(null,inst_33532,inst_33527);
var state_33547__$1 = (function (){var statearr_33559 = state_33547;
(statearr_33559[(9)] = inst_33531);

(statearr_33559[(10)] = inst_33533__$1);

return statearr_33559;
})();
if(cljs.core.truth_(inst_33533__$1)){
var statearr_33560_33577 = state_33547__$1;
(statearr_33560_33577[(1)] = (9));

} else {
var statearr_33561_33578 = state_33547__$1;
(statearr_33561_33578[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto__))
;
return ((function (switch__29105__auto__,c__29219__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__29106__auto__ = null;
var figwheel$client$file_reloading$state_machine__29106__auto____0 = (function (){
var statearr_33565 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33565[(0)] = figwheel$client$file_reloading$state_machine__29106__auto__);

(statearr_33565[(1)] = (1));

return statearr_33565;
});
var figwheel$client$file_reloading$state_machine__29106__auto____1 = (function (state_33547){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_33547);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e33566){if((e33566 instanceof Object)){
var ex__29109__auto__ = e33566;
var statearr_33567_33579 = state_33547;
(statearr_33567_33579[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33547);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33566;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33580 = state_33547;
state_33547 = G__33580;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__29106__auto__ = function(state_33547){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__29106__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__29106__auto____1.call(this,state_33547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__29106__auto____0;
figwheel$client$file_reloading$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__29106__auto____1;
return figwheel$client$file_reloading$state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto__))
})();
var state__29221__auto__ = (function (){var statearr_33568 = f__29220__auto__.call(null);
(statearr_33568[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto__);

return statearr_33568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto__))
);

return c__29219__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__33581,callback){
var map__33584 = p__33581;
var map__33584__$1 = ((((!((map__33584 == null)))?((((map__33584.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33584.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33584):map__33584);
var file_msg = map__33584__$1;
var namespace = cljs.core.get.call(null,map__33584__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__33584,map__33584__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__33584,map__33584__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__33586){
var map__33589 = p__33586;
var map__33589__$1 = ((((!((map__33589 == null)))?((((map__33589.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33589.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33589):map__33589);
var file_msg = map__33589__$1;
var namespace = cljs.core.get.call(null,map__33589__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__26558__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__26558__auto__){
var or__26570__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26570__auto__)){
return or__26570__auto__;
} else {
var or__26570__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26570__auto____$1)){
return or__26570__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__26558__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__33591,callback){
var map__33594 = p__33591;
var map__33594__$1 = ((((!((map__33594 == null)))?((((map__33594.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33594.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33594):map__33594);
var file_msg = map__33594__$1;
var request_url = cljs.core.get.call(null,map__33594__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__33594__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__29219__auto___33698 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___33698,out){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___33698,out){
return (function (state_33680){
var state_val_33681 = (state_33680[(1)]);
if((state_val_33681 === (1))){
var inst_33654 = cljs.core.seq.call(null,files);
var inst_33655 = cljs.core.first.call(null,inst_33654);
var inst_33656 = cljs.core.next.call(null,inst_33654);
var inst_33657 = files;
var state_33680__$1 = (function (){var statearr_33682 = state_33680;
(statearr_33682[(7)] = inst_33656);

(statearr_33682[(8)] = inst_33655);

(statearr_33682[(9)] = inst_33657);

return statearr_33682;
})();
var statearr_33683_33699 = state_33680__$1;
(statearr_33683_33699[(2)] = null);

(statearr_33683_33699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33681 === (2))){
var inst_33663 = (state_33680[(10)]);
var inst_33657 = (state_33680[(9)]);
var inst_33662 = cljs.core.seq.call(null,inst_33657);
var inst_33663__$1 = cljs.core.first.call(null,inst_33662);
var inst_33664 = cljs.core.next.call(null,inst_33662);
var inst_33665 = (inst_33663__$1 == null);
var inst_33666 = cljs.core.not.call(null,inst_33665);
var state_33680__$1 = (function (){var statearr_33684 = state_33680;
(statearr_33684[(10)] = inst_33663__$1);

(statearr_33684[(11)] = inst_33664);

return statearr_33684;
})();
if(inst_33666){
var statearr_33685_33700 = state_33680__$1;
(statearr_33685_33700[(1)] = (4));

} else {
var statearr_33686_33701 = state_33680__$1;
(statearr_33686_33701[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33681 === (3))){
var inst_33678 = (state_33680[(2)]);
var state_33680__$1 = state_33680;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33680__$1,inst_33678);
} else {
if((state_val_33681 === (4))){
var inst_33663 = (state_33680[(10)]);
var inst_33668 = figwheel.client.file_reloading.reload_js_file.call(null,inst_33663);
var state_33680__$1 = state_33680;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33680__$1,(7),inst_33668);
} else {
if((state_val_33681 === (5))){
var inst_33674 = cljs.core.async.close_BANG_.call(null,out);
var state_33680__$1 = state_33680;
var statearr_33687_33702 = state_33680__$1;
(statearr_33687_33702[(2)] = inst_33674);

(statearr_33687_33702[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33681 === (6))){
var inst_33676 = (state_33680[(2)]);
var state_33680__$1 = state_33680;
var statearr_33688_33703 = state_33680__$1;
(statearr_33688_33703[(2)] = inst_33676);

(statearr_33688_33703[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33681 === (7))){
var inst_33664 = (state_33680[(11)]);
var inst_33670 = (state_33680[(2)]);
var inst_33671 = cljs.core.async.put_BANG_.call(null,out,inst_33670);
var inst_33657 = inst_33664;
var state_33680__$1 = (function (){var statearr_33689 = state_33680;
(statearr_33689[(12)] = inst_33671);

(statearr_33689[(9)] = inst_33657);

return statearr_33689;
})();
var statearr_33690_33704 = state_33680__$1;
(statearr_33690_33704[(2)] = null);

(statearr_33690_33704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__29219__auto___33698,out))
;
return ((function (switch__29105__auto__,c__29219__auto___33698,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29106__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29106__auto____0 = (function (){
var statearr_33694 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33694[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29106__auto__);

(statearr_33694[(1)] = (1));

return statearr_33694;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29106__auto____1 = (function (state_33680){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_33680);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e33695){if((e33695 instanceof Object)){
var ex__29109__auto__ = e33695;
var statearr_33696_33705 = state_33680;
(statearr_33696_33705[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33680);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33695;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33706 = state_33680;
state_33680 = G__33706;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29106__auto__ = function(state_33680){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29106__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29106__auto____1.call(this,state_33680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29106__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29106__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___33698,out))
})();
var state__29221__auto__ = (function (){var statearr_33697 = f__29220__auto__.call(null);
(statearr_33697[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___33698);

return statearr_33697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___33698,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__33707,opts){
var map__33711 = p__33707;
var map__33711__$1 = ((((!((map__33711 == null)))?((((map__33711.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33711.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33711):map__33711);
var eval_body__$1 = cljs.core.get.call(null,map__33711__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__33711__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__26558__auto__ = eval_body__$1;
if(cljs.core.truth_(and__26558__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__26558__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e33713){var e = e33713;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6726__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__33714_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__33714_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6726__auto__)){
var file_msg = temp__6726__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__33723){
var vec__33724 = p__33723;
var k = cljs.core.nth.call(null,vec__33724,(0),null);
var v = cljs.core.nth.call(null,vec__33724,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__33727){
var vec__33728 = p__33727;
var k = cljs.core.nth.call(null,vec__33728,(0),null);
var v = cljs.core.nth.call(null,vec__33728,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__33734,p__33735){
var map__33982 = p__33734;
var map__33982__$1 = ((((!((map__33982 == null)))?((((map__33982.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33982.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33982):map__33982);
var opts = map__33982__$1;
var before_jsload = cljs.core.get.call(null,map__33982__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__33982__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__33982__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__33983 = p__33735;
var map__33983__$1 = ((((!((map__33983 == null)))?((((map__33983.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33983.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33983):map__33983);
var msg = map__33983__$1;
var files = cljs.core.get.call(null,map__33983__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__33983__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__33983__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__29219__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_34136){
var state_val_34137 = (state_34136[(1)]);
if((state_val_34137 === (7))){
var inst_34000 = (state_34136[(7)]);
var inst_33999 = (state_34136[(8)]);
var inst_33998 = (state_34136[(9)]);
var inst_33997 = (state_34136[(10)]);
var inst_34005 = cljs.core._nth.call(null,inst_33998,inst_34000);
var inst_34006 = figwheel.client.file_reloading.eval_body.call(null,inst_34005,opts);
var inst_34007 = (inst_34000 + (1));
var tmp34138 = inst_33999;
var tmp34139 = inst_33998;
var tmp34140 = inst_33997;
var inst_33997__$1 = tmp34140;
var inst_33998__$1 = tmp34139;
var inst_33999__$1 = tmp34138;
var inst_34000__$1 = inst_34007;
var state_34136__$1 = (function (){var statearr_34141 = state_34136;
(statearr_34141[(7)] = inst_34000__$1);

(statearr_34141[(8)] = inst_33999__$1);

(statearr_34141[(9)] = inst_33998__$1);

(statearr_34141[(11)] = inst_34006);

(statearr_34141[(10)] = inst_33997__$1);

return statearr_34141;
})();
var statearr_34142_34228 = state_34136__$1;
(statearr_34142_34228[(2)] = null);

(statearr_34142_34228[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (20))){
var inst_34040 = (state_34136[(12)]);
var inst_34048 = figwheel.client.file_reloading.sort_files.call(null,inst_34040);
var state_34136__$1 = state_34136;
var statearr_34143_34229 = state_34136__$1;
(statearr_34143_34229[(2)] = inst_34048);

(statearr_34143_34229[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (27))){
var state_34136__$1 = state_34136;
var statearr_34144_34230 = state_34136__$1;
(statearr_34144_34230[(2)] = null);

(statearr_34144_34230[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (1))){
var inst_33989 = (state_34136[(13)]);
var inst_33986 = before_jsload.call(null,files);
var inst_33987 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_33988 = (function (){return ((function (inst_33989,inst_33986,inst_33987,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33731_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__33731_SHARP_);
});
;})(inst_33989,inst_33986,inst_33987,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33989__$1 = cljs.core.filter.call(null,inst_33988,files);
var inst_33990 = cljs.core.not_empty.call(null,inst_33989__$1);
var state_34136__$1 = (function (){var statearr_34145 = state_34136;
(statearr_34145[(13)] = inst_33989__$1);

(statearr_34145[(14)] = inst_33987);

(statearr_34145[(15)] = inst_33986);

return statearr_34145;
})();
if(cljs.core.truth_(inst_33990)){
var statearr_34146_34231 = state_34136__$1;
(statearr_34146_34231[(1)] = (2));

} else {
var statearr_34147_34232 = state_34136__$1;
(statearr_34147_34232[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (24))){
var state_34136__$1 = state_34136;
var statearr_34148_34233 = state_34136__$1;
(statearr_34148_34233[(2)] = null);

(statearr_34148_34233[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (39))){
var inst_34090 = (state_34136[(16)]);
var state_34136__$1 = state_34136;
var statearr_34149_34234 = state_34136__$1;
(statearr_34149_34234[(2)] = inst_34090);

(statearr_34149_34234[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (46))){
var inst_34131 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
var statearr_34150_34235 = state_34136__$1;
(statearr_34150_34235[(2)] = inst_34131);

(statearr_34150_34235[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (4))){
var inst_34034 = (state_34136[(2)]);
var inst_34035 = cljs.core.List.EMPTY;
var inst_34036 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_34035);
var inst_34037 = (function (){return ((function (inst_34034,inst_34035,inst_34036,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33732_SHARP_){
var and__26558__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__33732_SHARP_);
if(cljs.core.truth_(and__26558__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__33732_SHARP_));
} else {
return and__26558__auto__;
}
});
;})(inst_34034,inst_34035,inst_34036,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34038 = cljs.core.filter.call(null,inst_34037,files);
var inst_34039 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_34040 = cljs.core.concat.call(null,inst_34038,inst_34039);
var state_34136__$1 = (function (){var statearr_34151 = state_34136;
(statearr_34151[(17)] = inst_34036);

(statearr_34151[(18)] = inst_34034);

(statearr_34151[(12)] = inst_34040);

return statearr_34151;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_34152_34236 = state_34136__$1;
(statearr_34152_34236[(1)] = (16));

} else {
var statearr_34153_34237 = state_34136__$1;
(statearr_34153_34237[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (15))){
var inst_34024 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
var statearr_34154_34238 = state_34136__$1;
(statearr_34154_34238[(2)] = inst_34024);

(statearr_34154_34238[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (21))){
var inst_34050 = (state_34136[(19)]);
var inst_34050__$1 = (state_34136[(2)]);
var inst_34051 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_34050__$1);
var state_34136__$1 = (function (){var statearr_34155 = state_34136;
(statearr_34155[(19)] = inst_34050__$1);

return statearr_34155;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34136__$1,(22),inst_34051);
} else {
if((state_val_34137 === (31))){
var inst_34134 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34136__$1,inst_34134);
} else {
if((state_val_34137 === (32))){
var inst_34090 = (state_34136[(16)]);
var inst_34095 = inst_34090.cljs$lang$protocol_mask$partition0$;
var inst_34096 = (inst_34095 & (64));
var inst_34097 = inst_34090.cljs$core$ISeq$;
var inst_34098 = (inst_34096) || (inst_34097);
var state_34136__$1 = state_34136;
if(cljs.core.truth_(inst_34098)){
var statearr_34156_34239 = state_34136__$1;
(statearr_34156_34239[(1)] = (35));

} else {
var statearr_34157_34240 = state_34136__$1;
(statearr_34157_34240[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (40))){
var inst_34111 = (state_34136[(20)]);
var inst_34110 = (state_34136[(2)]);
var inst_34111__$1 = cljs.core.get.call(null,inst_34110,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_34112 = cljs.core.get.call(null,inst_34110,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_34113 = cljs.core.not_empty.call(null,inst_34111__$1);
var state_34136__$1 = (function (){var statearr_34158 = state_34136;
(statearr_34158[(20)] = inst_34111__$1);

(statearr_34158[(21)] = inst_34112);

return statearr_34158;
})();
if(cljs.core.truth_(inst_34113)){
var statearr_34159_34241 = state_34136__$1;
(statearr_34159_34241[(1)] = (41));

} else {
var statearr_34160_34242 = state_34136__$1;
(statearr_34160_34242[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (33))){
var state_34136__$1 = state_34136;
var statearr_34161_34243 = state_34136__$1;
(statearr_34161_34243[(2)] = false);

(statearr_34161_34243[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (13))){
var inst_34010 = (state_34136[(22)]);
var inst_34014 = cljs.core.chunk_first.call(null,inst_34010);
var inst_34015 = cljs.core.chunk_rest.call(null,inst_34010);
var inst_34016 = cljs.core.count.call(null,inst_34014);
var inst_33997 = inst_34015;
var inst_33998 = inst_34014;
var inst_33999 = inst_34016;
var inst_34000 = (0);
var state_34136__$1 = (function (){var statearr_34162 = state_34136;
(statearr_34162[(7)] = inst_34000);

(statearr_34162[(8)] = inst_33999);

(statearr_34162[(9)] = inst_33998);

(statearr_34162[(10)] = inst_33997);

return statearr_34162;
})();
var statearr_34163_34244 = state_34136__$1;
(statearr_34163_34244[(2)] = null);

(statearr_34163_34244[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (22))){
var inst_34054 = (state_34136[(23)]);
var inst_34050 = (state_34136[(19)]);
var inst_34058 = (state_34136[(24)]);
var inst_34053 = (state_34136[(25)]);
var inst_34053__$1 = (state_34136[(2)]);
var inst_34054__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34053__$1);
var inst_34055 = (function (){var all_files = inst_34050;
var res_SINGLEQUOTE_ = inst_34053__$1;
var res = inst_34054__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_34054,inst_34050,inst_34058,inst_34053,inst_34053__$1,inst_34054__$1,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33733_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__33733_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_34054,inst_34050,inst_34058,inst_34053,inst_34053__$1,inst_34054__$1,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34056 = cljs.core.filter.call(null,inst_34055,inst_34053__$1);
var inst_34057 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_34058__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34057);
var inst_34059 = cljs.core.not_empty.call(null,inst_34058__$1);
var state_34136__$1 = (function (){var statearr_34164 = state_34136;
(statearr_34164[(23)] = inst_34054__$1);

(statearr_34164[(26)] = inst_34056);

(statearr_34164[(24)] = inst_34058__$1);

(statearr_34164[(25)] = inst_34053__$1);

return statearr_34164;
})();
if(cljs.core.truth_(inst_34059)){
var statearr_34165_34245 = state_34136__$1;
(statearr_34165_34245[(1)] = (23));

} else {
var statearr_34166_34246 = state_34136__$1;
(statearr_34166_34246[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (36))){
var state_34136__$1 = state_34136;
var statearr_34167_34247 = state_34136__$1;
(statearr_34167_34247[(2)] = false);

(statearr_34167_34247[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (41))){
var inst_34111 = (state_34136[(20)]);
var inst_34115 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_34116 = cljs.core.map.call(null,inst_34115,inst_34111);
var inst_34117 = cljs.core.pr_str.call(null,inst_34116);
var inst_34118 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_34117)].join('');
var inst_34119 = figwheel.client.utils.log.call(null,inst_34118);
var state_34136__$1 = state_34136;
var statearr_34168_34248 = state_34136__$1;
(statearr_34168_34248[(2)] = inst_34119);

(statearr_34168_34248[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (43))){
var inst_34112 = (state_34136[(21)]);
var inst_34122 = (state_34136[(2)]);
var inst_34123 = cljs.core.not_empty.call(null,inst_34112);
var state_34136__$1 = (function (){var statearr_34169 = state_34136;
(statearr_34169[(27)] = inst_34122);

return statearr_34169;
})();
if(cljs.core.truth_(inst_34123)){
var statearr_34170_34249 = state_34136__$1;
(statearr_34170_34249[(1)] = (44));

} else {
var statearr_34171_34250 = state_34136__$1;
(statearr_34171_34250[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (29))){
var inst_34054 = (state_34136[(23)]);
var inst_34056 = (state_34136[(26)]);
var inst_34090 = (state_34136[(16)]);
var inst_34050 = (state_34136[(19)]);
var inst_34058 = (state_34136[(24)]);
var inst_34053 = (state_34136[(25)]);
var inst_34086 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_34089 = (function (){var all_files = inst_34050;
var res_SINGLEQUOTE_ = inst_34053;
var res = inst_34054;
var files_not_loaded = inst_34056;
var dependencies_that_loaded = inst_34058;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34090,inst_34050,inst_34058,inst_34053,inst_34086,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34088){
var map__34172 = p__34088;
var map__34172__$1 = ((((!((map__34172 == null)))?((((map__34172.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34172.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34172):map__34172);
var namespace = cljs.core.get.call(null,map__34172__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34090,inst_34050,inst_34058,inst_34053,inst_34086,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34090__$1 = cljs.core.group_by.call(null,inst_34089,inst_34056);
var inst_34092 = (inst_34090__$1 == null);
var inst_34093 = cljs.core.not.call(null,inst_34092);
var state_34136__$1 = (function (){var statearr_34174 = state_34136;
(statearr_34174[(28)] = inst_34086);

(statearr_34174[(16)] = inst_34090__$1);

return statearr_34174;
})();
if(inst_34093){
var statearr_34175_34251 = state_34136__$1;
(statearr_34175_34251[(1)] = (32));

} else {
var statearr_34176_34252 = state_34136__$1;
(statearr_34176_34252[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (44))){
var inst_34112 = (state_34136[(21)]);
var inst_34125 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_34112);
var inst_34126 = cljs.core.pr_str.call(null,inst_34125);
var inst_34127 = [cljs.core.str("not required: "),cljs.core.str(inst_34126)].join('');
var inst_34128 = figwheel.client.utils.log.call(null,inst_34127);
var state_34136__$1 = state_34136;
var statearr_34177_34253 = state_34136__$1;
(statearr_34177_34253[(2)] = inst_34128);

(statearr_34177_34253[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (6))){
var inst_34031 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
var statearr_34178_34254 = state_34136__$1;
(statearr_34178_34254[(2)] = inst_34031);

(statearr_34178_34254[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (28))){
var inst_34056 = (state_34136[(26)]);
var inst_34083 = (state_34136[(2)]);
var inst_34084 = cljs.core.not_empty.call(null,inst_34056);
var state_34136__$1 = (function (){var statearr_34179 = state_34136;
(statearr_34179[(29)] = inst_34083);

return statearr_34179;
})();
if(cljs.core.truth_(inst_34084)){
var statearr_34180_34255 = state_34136__$1;
(statearr_34180_34255[(1)] = (29));

} else {
var statearr_34181_34256 = state_34136__$1;
(statearr_34181_34256[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (25))){
var inst_34054 = (state_34136[(23)]);
var inst_34070 = (state_34136[(2)]);
var inst_34071 = cljs.core.not_empty.call(null,inst_34054);
var state_34136__$1 = (function (){var statearr_34182 = state_34136;
(statearr_34182[(30)] = inst_34070);

return statearr_34182;
})();
if(cljs.core.truth_(inst_34071)){
var statearr_34183_34257 = state_34136__$1;
(statearr_34183_34257[(1)] = (26));

} else {
var statearr_34184_34258 = state_34136__$1;
(statearr_34184_34258[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (34))){
var inst_34105 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
if(cljs.core.truth_(inst_34105)){
var statearr_34185_34259 = state_34136__$1;
(statearr_34185_34259[(1)] = (38));

} else {
var statearr_34186_34260 = state_34136__$1;
(statearr_34186_34260[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (17))){
var state_34136__$1 = state_34136;
var statearr_34187_34261 = state_34136__$1;
(statearr_34187_34261[(2)] = recompile_dependents);

(statearr_34187_34261[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (3))){
var state_34136__$1 = state_34136;
var statearr_34188_34262 = state_34136__$1;
(statearr_34188_34262[(2)] = null);

(statearr_34188_34262[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (12))){
var inst_34027 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
var statearr_34189_34263 = state_34136__$1;
(statearr_34189_34263[(2)] = inst_34027);

(statearr_34189_34263[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (2))){
var inst_33989 = (state_34136[(13)]);
var inst_33996 = cljs.core.seq.call(null,inst_33989);
var inst_33997 = inst_33996;
var inst_33998 = null;
var inst_33999 = (0);
var inst_34000 = (0);
var state_34136__$1 = (function (){var statearr_34190 = state_34136;
(statearr_34190[(7)] = inst_34000);

(statearr_34190[(8)] = inst_33999);

(statearr_34190[(9)] = inst_33998);

(statearr_34190[(10)] = inst_33997);

return statearr_34190;
})();
var statearr_34191_34264 = state_34136__$1;
(statearr_34191_34264[(2)] = null);

(statearr_34191_34264[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (23))){
var inst_34054 = (state_34136[(23)]);
var inst_34056 = (state_34136[(26)]);
var inst_34050 = (state_34136[(19)]);
var inst_34058 = (state_34136[(24)]);
var inst_34053 = (state_34136[(25)]);
var inst_34061 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_34063 = (function (){var all_files = inst_34050;
var res_SINGLEQUOTE_ = inst_34053;
var res = inst_34054;
var files_not_loaded = inst_34056;
var dependencies_that_loaded = inst_34058;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34050,inst_34058,inst_34053,inst_34061,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34062){
var map__34192 = p__34062;
var map__34192__$1 = ((((!((map__34192 == null)))?((((map__34192.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34192.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34192):map__34192);
var request_url = cljs.core.get.call(null,map__34192__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34050,inst_34058,inst_34053,inst_34061,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34064 = cljs.core.reverse.call(null,inst_34058);
var inst_34065 = cljs.core.map.call(null,inst_34063,inst_34064);
var inst_34066 = cljs.core.pr_str.call(null,inst_34065);
var inst_34067 = figwheel.client.utils.log.call(null,inst_34066);
var state_34136__$1 = (function (){var statearr_34194 = state_34136;
(statearr_34194[(31)] = inst_34061);

return statearr_34194;
})();
var statearr_34195_34265 = state_34136__$1;
(statearr_34195_34265[(2)] = inst_34067);

(statearr_34195_34265[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (35))){
var state_34136__$1 = state_34136;
var statearr_34196_34266 = state_34136__$1;
(statearr_34196_34266[(2)] = true);

(statearr_34196_34266[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (19))){
var inst_34040 = (state_34136[(12)]);
var inst_34046 = figwheel.client.file_reloading.expand_files.call(null,inst_34040);
var state_34136__$1 = state_34136;
var statearr_34197_34267 = state_34136__$1;
(statearr_34197_34267[(2)] = inst_34046);

(statearr_34197_34267[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (11))){
var state_34136__$1 = state_34136;
var statearr_34198_34268 = state_34136__$1;
(statearr_34198_34268[(2)] = null);

(statearr_34198_34268[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (9))){
var inst_34029 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
var statearr_34199_34269 = state_34136__$1;
(statearr_34199_34269[(2)] = inst_34029);

(statearr_34199_34269[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (5))){
var inst_34000 = (state_34136[(7)]);
var inst_33999 = (state_34136[(8)]);
var inst_34002 = (inst_34000 < inst_33999);
var inst_34003 = inst_34002;
var state_34136__$1 = state_34136;
if(cljs.core.truth_(inst_34003)){
var statearr_34200_34270 = state_34136__$1;
(statearr_34200_34270[(1)] = (7));

} else {
var statearr_34201_34271 = state_34136__$1;
(statearr_34201_34271[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (14))){
var inst_34010 = (state_34136[(22)]);
var inst_34019 = cljs.core.first.call(null,inst_34010);
var inst_34020 = figwheel.client.file_reloading.eval_body.call(null,inst_34019,opts);
var inst_34021 = cljs.core.next.call(null,inst_34010);
var inst_33997 = inst_34021;
var inst_33998 = null;
var inst_33999 = (0);
var inst_34000 = (0);
var state_34136__$1 = (function (){var statearr_34202 = state_34136;
(statearr_34202[(7)] = inst_34000);

(statearr_34202[(32)] = inst_34020);

(statearr_34202[(8)] = inst_33999);

(statearr_34202[(9)] = inst_33998);

(statearr_34202[(10)] = inst_33997);

return statearr_34202;
})();
var statearr_34203_34272 = state_34136__$1;
(statearr_34203_34272[(2)] = null);

(statearr_34203_34272[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (45))){
var state_34136__$1 = state_34136;
var statearr_34204_34273 = state_34136__$1;
(statearr_34204_34273[(2)] = null);

(statearr_34204_34273[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (26))){
var inst_34054 = (state_34136[(23)]);
var inst_34056 = (state_34136[(26)]);
var inst_34050 = (state_34136[(19)]);
var inst_34058 = (state_34136[(24)]);
var inst_34053 = (state_34136[(25)]);
var inst_34073 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_34075 = (function (){var all_files = inst_34050;
var res_SINGLEQUOTE_ = inst_34053;
var res = inst_34054;
var files_not_loaded = inst_34056;
var dependencies_that_loaded = inst_34058;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34050,inst_34058,inst_34053,inst_34073,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34074){
var map__34205 = p__34074;
var map__34205__$1 = ((((!((map__34205 == null)))?((((map__34205.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34205.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34205):map__34205);
var namespace = cljs.core.get.call(null,map__34205__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__34205__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34050,inst_34058,inst_34053,inst_34073,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34076 = cljs.core.map.call(null,inst_34075,inst_34054);
var inst_34077 = cljs.core.pr_str.call(null,inst_34076);
var inst_34078 = figwheel.client.utils.log.call(null,inst_34077);
var inst_34079 = (function (){var all_files = inst_34050;
var res_SINGLEQUOTE_ = inst_34053;
var res = inst_34054;
var files_not_loaded = inst_34056;
var dependencies_that_loaded = inst_34058;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34050,inst_34058,inst_34053,inst_34073,inst_34075,inst_34076,inst_34077,inst_34078,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34054,inst_34056,inst_34050,inst_34058,inst_34053,inst_34073,inst_34075,inst_34076,inst_34077,inst_34078,state_val_34137,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34080 = setTimeout(inst_34079,(10));
var state_34136__$1 = (function (){var statearr_34207 = state_34136;
(statearr_34207[(33)] = inst_34073);

(statearr_34207[(34)] = inst_34078);

return statearr_34207;
})();
var statearr_34208_34274 = state_34136__$1;
(statearr_34208_34274[(2)] = inst_34080);

(statearr_34208_34274[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (16))){
var state_34136__$1 = state_34136;
var statearr_34209_34275 = state_34136__$1;
(statearr_34209_34275[(2)] = reload_dependents);

(statearr_34209_34275[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (38))){
var inst_34090 = (state_34136[(16)]);
var inst_34107 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34090);
var state_34136__$1 = state_34136;
var statearr_34210_34276 = state_34136__$1;
(statearr_34210_34276[(2)] = inst_34107);

(statearr_34210_34276[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (30))){
var state_34136__$1 = state_34136;
var statearr_34211_34277 = state_34136__$1;
(statearr_34211_34277[(2)] = null);

(statearr_34211_34277[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (10))){
var inst_34010 = (state_34136[(22)]);
var inst_34012 = cljs.core.chunked_seq_QMARK_.call(null,inst_34010);
var state_34136__$1 = state_34136;
if(inst_34012){
var statearr_34212_34278 = state_34136__$1;
(statearr_34212_34278[(1)] = (13));

} else {
var statearr_34213_34279 = state_34136__$1;
(statearr_34213_34279[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (18))){
var inst_34044 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
if(cljs.core.truth_(inst_34044)){
var statearr_34214_34280 = state_34136__$1;
(statearr_34214_34280[(1)] = (19));

} else {
var statearr_34215_34281 = state_34136__$1;
(statearr_34215_34281[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (42))){
var state_34136__$1 = state_34136;
var statearr_34216_34282 = state_34136__$1;
(statearr_34216_34282[(2)] = null);

(statearr_34216_34282[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (37))){
var inst_34102 = (state_34136[(2)]);
var state_34136__$1 = state_34136;
var statearr_34217_34283 = state_34136__$1;
(statearr_34217_34283[(2)] = inst_34102);

(statearr_34217_34283[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34137 === (8))){
var inst_34010 = (state_34136[(22)]);
var inst_33997 = (state_34136[(10)]);
var inst_34010__$1 = cljs.core.seq.call(null,inst_33997);
var state_34136__$1 = (function (){var statearr_34218 = state_34136;
(statearr_34218[(22)] = inst_34010__$1);

return statearr_34218;
})();
if(inst_34010__$1){
var statearr_34219_34284 = state_34136__$1;
(statearr_34219_34284[(1)] = (10));

} else {
var statearr_34220_34285 = state_34136__$1;
(statearr_34220_34285[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__29105__auto__,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29106__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29106__auto____0 = (function (){
var statearr_34224 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34224[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__29106__auto__);

(statearr_34224[(1)] = (1));

return statearr_34224;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29106__auto____1 = (function (state_34136){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_34136);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e34225){if((e34225 instanceof Object)){
var ex__29109__auto__ = e34225;
var statearr_34226_34286 = state_34136;
(statearr_34226_34286[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34136);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34225;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34287 = state_34136;
state_34136 = G__34287;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__29106__auto__ = function(state_34136){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29106__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29106__auto____1.call(this,state_34136);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__29106__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__29106__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__29221__auto__ = (function (){var statearr_34227 = f__29220__auto__.call(null);
(statearr_34227[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto__);

return statearr_34227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto__,map__33982,map__33982__$1,opts,before_jsload,on_jsload,reload_dependents,map__33983,map__33983__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__29219__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__34290,link){
var map__34293 = p__34290;
var map__34293__$1 = ((((!((map__34293 == null)))?((((map__34293.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34293.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34293):map__34293);
var file = cljs.core.get.call(null,map__34293__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6728__auto__ = link.href;
if(cljs.core.truth_(temp__6728__auto__)){
var link_href = temp__6728__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6728__auto__,map__34293,map__34293__$1,file){
return (function (p1__34288_SHARP_,p2__34289_SHARP_){
if(cljs.core._EQ_.call(null,p1__34288_SHARP_,p2__34289_SHARP_)){
return p1__34288_SHARP_;
} else {
return false;
}
});})(link_href,temp__6728__auto__,map__34293,map__34293__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6728__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__34299){
var map__34300 = p__34299;
var map__34300__$1 = ((((!((map__34300 == null)))?((((map__34300.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34300.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34300):map__34300);
var match_length = cljs.core.get.call(null,map__34300__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__34300__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__34295_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__34295_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6728__auto__)){
var res = temp__6728__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args34302 = [];
var len__27753__auto___34305 = arguments.length;
var i__27754__auto___34306 = (0);
while(true){
if((i__27754__auto___34306 < len__27753__auto___34305)){
args34302.push((arguments[i__27754__auto___34306]));

var G__34307 = (i__27754__auto___34306 + (1));
i__27754__auto___34306 = G__34307;
continue;
} else {
}
break;
}

var G__34304 = args34302.length;
switch (G__34304) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34302.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__34309_SHARP_,p2__34310_SHARP_){
return cljs.core.assoc.call(null,p1__34309_SHARP_,cljs.core.get.call(null,p2__34310_SHARP_,key),p2__34310_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__34311){
var map__34314 = p__34311;
var map__34314__$1 = ((((!((map__34314 == null)))?((((map__34314.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34314.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34314):map__34314);
var f_data = map__34314__$1;
var file = cljs.core.get.call(null,map__34314__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6728__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6728__auto__)){
var link = temp__6728__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__34316,p__34317){
var map__34326 = p__34316;
var map__34326__$1 = ((((!((map__34326 == null)))?((((map__34326.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34326.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34326):map__34326);
var opts = map__34326__$1;
var on_cssload = cljs.core.get.call(null,map__34326__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__34327 = p__34317;
var map__34327__$1 = ((((!((map__34327 == null)))?((((map__34327.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34327.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34327):map__34327);
var files_msg = map__34327__$1;
var files = cljs.core.get.call(null,map__34327__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__34330_34334 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
var chunk__34331_34335 = null;
var count__34332_34336 = (0);
var i__34333_34337 = (0);
while(true){
if((i__34333_34337 < count__34332_34336)){
var f_34338 = cljs.core._nth.call(null,chunk__34331_34335,i__34333_34337);
figwheel.client.file_reloading.reload_css_file.call(null,f_34338);

var G__34339 = seq__34330_34334;
var G__34340 = chunk__34331_34335;
var G__34341 = count__34332_34336;
var G__34342 = (i__34333_34337 + (1));
seq__34330_34334 = G__34339;
chunk__34331_34335 = G__34340;
count__34332_34336 = G__34341;
i__34333_34337 = G__34342;
continue;
} else {
var temp__6728__auto___34343 = cljs.core.seq.call(null,seq__34330_34334);
if(temp__6728__auto___34343){
var seq__34330_34344__$1 = temp__6728__auto___34343;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34330_34344__$1)){
var c__27473__auto___34345 = cljs.core.chunk_first.call(null,seq__34330_34344__$1);
var G__34346 = cljs.core.chunk_rest.call(null,seq__34330_34344__$1);
var G__34347 = c__27473__auto___34345;
var G__34348 = cljs.core.count.call(null,c__27473__auto___34345);
var G__34349 = (0);
seq__34330_34334 = G__34346;
chunk__34331_34335 = G__34347;
count__34332_34336 = G__34348;
i__34333_34337 = G__34349;
continue;
} else {
var f_34350 = cljs.core.first.call(null,seq__34330_34344__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_34350);

var G__34351 = cljs.core.next.call(null,seq__34330_34344__$1);
var G__34352 = null;
var G__34353 = (0);
var G__34354 = (0);
seq__34330_34334 = G__34351;
chunk__34331_34335 = G__34352;
count__34332_34336 = G__34353;
i__34333_34337 = G__34354;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__34326,map__34326__$1,opts,on_cssload,map__34327,map__34327__$1,files_msg,files){
return (function (){
figwheel.client.file_reloading.on_cssload_custom_event.call(null,files);

return on_cssload.call(null,files);
});})(map__34326,map__34326__$1,opts,on_cssload,map__34327,map__34327__$1,files_msg,files))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1475875134326