# XD-Table

Table component for Reagent to render x-dimensional vector spaces (demo: https://aw7.github.io/z-com-demo/#xd-table).

## Installation

* add the dependency:
  ```Clojure
  :dependencies [[z-com/xd-table "0.3.0"]]
  ````

* include the stylesheet `resources/public/css/xd-table.css` in your HTML


## Usage

```Clojure
(ns xd-table-app
  (:require [z-com.core :as z]))

(defn table []
  [:div
    [:h1 "Table"]
    [z/xd-table
      :cell-fn
      (fn [{:keys [hue sat val opc]}]
        (let [hsl (str "hsla(" hue "," sat "%," val "%," opc ")")]
          [:div {:style {:background-color hsl :width 30 :height 30}}]))

      :dims
      [{:id :sat :vals [100 80 60 40 20]}
       {:id :hue :vals [360 300 240 180 120 60 0]}
       {:id :val :vals [100 90 80 70 60 50 40 30 20 10]}
       {:id :opc :vals [1 0.5]}]

      :dim-yz? true
      :dim-xz? true]])
```

* `:cell-fn` receives a map of the dimensions and their values, and returns the content of the respective cell as a hiccup-value

* `:dims` specifies the dimensions of the table as a sequence of maps, each providing the `:id` keyword of the dimension (the dimension value is provided with that keyword to `:cell-fn`) and a range of `:vals`

* when `:dim-yz?` is true the y-dimension is sub-divided by another dimension; likewise for `:dim-xz?` and the x-dimension

* the standard dimension selector component can be replaced with a custom one `:selection-com` (e.g. `re-com.core/single-dropdown`); likewise for the value selector `:radio-button-com` (e.g. `re-com.core/radio-button`)
