(ns navtree-demo.index
  (:require [reagent.core :as r]
            [navtree.core :as n]))

(defn expensive-op []
  (doseq [i (range 500)] (js.console.log i)))

(def demo-tree
  {:label "Root"
   :children
   [{:label "child 1"
     :children
     [{:label "child 1.1"}]}
    {:label "child 2"}]})

(def demo-tree-delays
  {:label "Root"
   :children
   (delay
     (do (expensive-op)
         [{:label "child 1"
           :children
           [{:label "child 1.1"}]}
          {:label "child 2"}]))})

(def demo-tree-delays-list
  {:label "Root"
   :children
   (delay
     (do (expensive-op)
         (list {:label "child 1"
                 :children
                 (list {:label "child 1.1"})}
                {:label "child 2"})))})

(defn demo []
  (r/with-let [sp-ratom1 (r/atom (list "Root"))
               sp-ratom2 (r/atom (list))
               content-map {"child 1.1" "Content!"}]
    [:div.demo
      [:h1 "Navtree (0.6.0)"]

      [:h3 "Navtree [:selection-path, :on-selection-path]"]
      [n/navtree
        :tree demo-tree-delays
        :selection-path @sp-ratom1 :on-selection-path #(reset! sp-ratom1 %)
        :whitelist? true
        :id-fn :label :label-fn :label :children-fn :children]

      [:hr]

      [:h3 "Navtree [:selection-path-ratom, :keynav?]"]
      [n/navtree
        :tree demo-tree-delays-list
        :selection-path-ratom sp-ratom2
        :whitelist? true :keynav? true :jump-to-content? true
        :id-fn :label, :label-fn :label, :children-fn :children
        :content-fn
          #(delay (expensive-op)
                  (when-let [c (get content-map %)] [:b c]))]]))

(defn mount-root [] (r/render [demo] (.getElementById js/document "root")))
(defn init! [] (mount-root))
(defonce init_ (init!))
(defn on-js-reload [] (mount-root))
