// Compiled by ClojureScript 1.9.456 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__27021__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__27021__auto__){
return or__27021__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__27021__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__27021__auto__)){
return or__27021__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__35038_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__35038_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__35043 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__35044 = null;
var count__35045 = (0);
var i__35046 = (0);
while(true){
if((i__35046 < count__35045)){
var n = cljs.core._nth.call(null,chunk__35044,i__35046);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__35047 = seq__35043;
var G__35048 = chunk__35044;
var G__35049 = count__35045;
var G__35050 = (i__35046 + (1));
seq__35043 = G__35047;
chunk__35044 = G__35048;
count__35045 = G__35049;
i__35046 = G__35050;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__35043);
if(temp__6753__auto__){
var seq__35043__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35043__$1)){
var c__27932__auto__ = cljs.core.chunk_first.call(null,seq__35043__$1);
var G__35051 = cljs.core.chunk_rest.call(null,seq__35043__$1);
var G__35052 = c__27932__auto__;
var G__35053 = cljs.core.count.call(null,c__27932__auto__);
var G__35054 = (0);
seq__35043 = G__35051;
chunk__35044 = G__35052;
count__35045 = G__35053;
i__35046 = G__35054;
continue;
} else {
var n = cljs.core.first.call(null,seq__35043__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__35055 = cljs.core.next.call(null,seq__35043__$1);
var G__35056 = null;
var G__35057 = (0);
var G__35058 = (0);
seq__35043 = G__35055;
chunk__35044 = G__35056;
count__35045 = G__35057;
i__35046 = G__35058;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__35109_35120 = cljs.core.seq.call(null,deps);
var chunk__35110_35121 = null;
var count__35111_35122 = (0);
var i__35112_35123 = (0);
while(true){
if((i__35112_35123 < count__35111_35122)){
var dep_35124 = cljs.core._nth.call(null,chunk__35110_35121,i__35112_35123);
topo_sort_helper_STAR_.call(null,dep_35124,(depth + (1)),state);

var G__35125 = seq__35109_35120;
var G__35126 = chunk__35110_35121;
var G__35127 = count__35111_35122;
var G__35128 = (i__35112_35123 + (1));
seq__35109_35120 = G__35125;
chunk__35110_35121 = G__35126;
count__35111_35122 = G__35127;
i__35112_35123 = G__35128;
continue;
} else {
var temp__6753__auto___35129 = cljs.core.seq.call(null,seq__35109_35120);
if(temp__6753__auto___35129){
var seq__35109_35130__$1 = temp__6753__auto___35129;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35109_35130__$1)){
var c__27932__auto___35131 = cljs.core.chunk_first.call(null,seq__35109_35130__$1);
var G__35132 = cljs.core.chunk_rest.call(null,seq__35109_35130__$1);
var G__35133 = c__27932__auto___35131;
var G__35134 = cljs.core.count.call(null,c__27932__auto___35131);
var G__35135 = (0);
seq__35109_35120 = G__35132;
chunk__35110_35121 = G__35133;
count__35111_35122 = G__35134;
i__35112_35123 = G__35135;
continue;
} else {
var dep_35136 = cljs.core.first.call(null,seq__35109_35130__$1);
topo_sort_helper_STAR_.call(null,dep_35136,(depth + (1)),state);

var G__35137 = cljs.core.next.call(null,seq__35109_35130__$1);
var G__35138 = null;
var G__35139 = (0);
var G__35140 = (0);
seq__35109_35120 = G__35137;
chunk__35110_35121 = G__35138;
count__35111_35122 = G__35139;
i__35112_35123 = G__35140;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__35113){
var vec__35117 = p__35113;
var seq__35118 = cljs.core.seq.call(null,vec__35117);
var first__35119 = cljs.core.first.call(null,seq__35118);
var seq__35118__$1 = cljs.core.next.call(null,seq__35118);
var x = first__35119;
var xs = seq__35118__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__35117,seq__35118,first__35119,seq__35118__$1,x,xs,get_deps__$1){
return (function (p1__35059_SHARP_){
return clojure.set.difference.call(null,p1__35059_SHARP_,x);
});})(vec__35117,seq__35118,first__35119,seq__35118__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__35153 = cljs.core.seq.call(null,provides);
var chunk__35154 = null;
var count__35155 = (0);
var i__35156 = (0);
while(true){
if((i__35156 < count__35155)){
var prov = cljs.core._nth.call(null,chunk__35154,i__35156);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__35157_35165 = cljs.core.seq.call(null,requires);
var chunk__35158_35166 = null;
var count__35159_35167 = (0);
var i__35160_35168 = (0);
while(true){
if((i__35160_35168 < count__35159_35167)){
var req_35169 = cljs.core._nth.call(null,chunk__35158_35166,i__35160_35168);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_35169,prov);

var G__35170 = seq__35157_35165;
var G__35171 = chunk__35158_35166;
var G__35172 = count__35159_35167;
var G__35173 = (i__35160_35168 + (1));
seq__35157_35165 = G__35170;
chunk__35158_35166 = G__35171;
count__35159_35167 = G__35172;
i__35160_35168 = G__35173;
continue;
} else {
var temp__6753__auto___35174 = cljs.core.seq.call(null,seq__35157_35165);
if(temp__6753__auto___35174){
var seq__35157_35175__$1 = temp__6753__auto___35174;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35157_35175__$1)){
var c__27932__auto___35176 = cljs.core.chunk_first.call(null,seq__35157_35175__$1);
var G__35177 = cljs.core.chunk_rest.call(null,seq__35157_35175__$1);
var G__35178 = c__27932__auto___35176;
var G__35179 = cljs.core.count.call(null,c__27932__auto___35176);
var G__35180 = (0);
seq__35157_35165 = G__35177;
chunk__35158_35166 = G__35178;
count__35159_35167 = G__35179;
i__35160_35168 = G__35180;
continue;
} else {
var req_35181 = cljs.core.first.call(null,seq__35157_35175__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_35181,prov);

var G__35182 = cljs.core.next.call(null,seq__35157_35175__$1);
var G__35183 = null;
var G__35184 = (0);
var G__35185 = (0);
seq__35157_35165 = G__35182;
chunk__35158_35166 = G__35183;
count__35159_35167 = G__35184;
i__35160_35168 = G__35185;
continue;
}
} else {
}
}
break;
}

var G__35186 = seq__35153;
var G__35187 = chunk__35154;
var G__35188 = count__35155;
var G__35189 = (i__35156 + (1));
seq__35153 = G__35186;
chunk__35154 = G__35187;
count__35155 = G__35188;
i__35156 = G__35189;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__35153);
if(temp__6753__auto__){
var seq__35153__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35153__$1)){
var c__27932__auto__ = cljs.core.chunk_first.call(null,seq__35153__$1);
var G__35190 = cljs.core.chunk_rest.call(null,seq__35153__$1);
var G__35191 = c__27932__auto__;
var G__35192 = cljs.core.count.call(null,c__27932__auto__);
var G__35193 = (0);
seq__35153 = G__35190;
chunk__35154 = G__35191;
count__35155 = G__35192;
i__35156 = G__35193;
continue;
} else {
var prov = cljs.core.first.call(null,seq__35153__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__35161_35194 = cljs.core.seq.call(null,requires);
var chunk__35162_35195 = null;
var count__35163_35196 = (0);
var i__35164_35197 = (0);
while(true){
if((i__35164_35197 < count__35163_35196)){
var req_35198 = cljs.core._nth.call(null,chunk__35162_35195,i__35164_35197);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_35198,prov);

var G__35199 = seq__35161_35194;
var G__35200 = chunk__35162_35195;
var G__35201 = count__35163_35196;
var G__35202 = (i__35164_35197 + (1));
seq__35161_35194 = G__35199;
chunk__35162_35195 = G__35200;
count__35163_35196 = G__35201;
i__35164_35197 = G__35202;
continue;
} else {
var temp__6753__auto___35203__$1 = cljs.core.seq.call(null,seq__35161_35194);
if(temp__6753__auto___35203__$1){
var seq__35161_35204__$1 = temp__6753__auto___35203__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35161_35204__$1)){
var c__27932__auto___35205 = cljs.core.chunk_first.call(null,seq__35161_35204__$1);
var G__35206 = cljs.core.chunk_rest.call(null,seq__35161_35204__$1);
var G__35207 = c__27932__auto___35205;
var G__35208 = cljs.core.count.call(null,c__27932__auto___35205);
var G__35209 = (0);
seq__35161_35194 = G__35206;
chunk__35162_35195 = G__35207;
count__35163_35196 = G__35208;
i__35164_35197 = G__35209;
continue;
} else {
var req_35210 = cljs.core.first.call(null,seq__35161_35204__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_35210,prov);

var G__35211 = cljs.core.next.call(null,seq__35161_35204__$1);
var G__35212 = null;
var G__35213 = (0);
var G__35214 = (0);
seq__35161_35194 = G__35211;
chunk__35162_35195 = G__35212;
count__35163_35196 = G__35213;
i__35164_35197 = G__35214;
continue;
}
} else {
}
}
break;
}

var G__35215 = cljs.core.next.call(null,seq__35153__$1);
var G__35216 = null;
var G__35217 = (0);
var G__35218 = (0);
seq__35153 = G__35215;
chunk__35154 = G__35216;
count__35155 = G__35217;
i__35156 = G__35218;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__35223_35227 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__35224_35228 = null;
var count__35225_35229 = (0);
var i__35226_35230 = (0);
while(true){
if((i__35226_35230 < count__35225_35229)){
var ns_35231 = cljs.core._nth.call(null,chunk__35224_35228,i__35226_35230);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_35231);

var G__35232 = seq__35223_35227;
var G__35233 = chunk__35224_35228;
var G__35234 = count__35225_35229;
var G__35235 = (i__35226_35230 + (1));
seq__35223_35227 = G__35232;
chunk__35224_35228 = G__35233;
count__35225_35229 = G__35234;
i__35226_35230 = G__35235;
continue;
} else {
var temp__6753__auto___35236 = cljs.core.seq.call(null,seq__35223_35227);
if(temp__6753__auto___35236){
var seq__35223_35237__$1 = temp__6753__auto___35236;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35223_35237__$1)){
var c__27932__auto___35238 = cljs.core.chunk_first.call(null,seq__35223_35237__$1);
var G__35239 = cljs.core.chunk_rest.call(null,seq__35223_35237__$1);
var G__35240 = c__27932__auto___35238;
var G__35241 = cljs.core.count.call(null,c__27932__auto___35238);
var G__35242 = (0);
seq__35223_35227 = G__35239;
chunk__35224_35228 = G__35240;
count__35225_35229 = G__35241;
i__35226_35230 = G__35242;
continue;
} else {
var ns_35243 = cljs.core.first.call(null,seq__35223_35237__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_35243);

var G__35244 = cljs.core.next.call(null,seq__35223_35237__$1);
var G__35245 = null;
var G__35246 = (0);
var G__35247 = (0);
seq__35223_35227 = G__35244;
chunk__35224_35228 = G__35245;
count__35225_35229 = G__35246;
i__35226_35230 = G__35247;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__27021__auto__ = goog.require__;
if(cljs.core.truth_(or__27021__auto__)){
return or__27021__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__35248__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__35248 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__35249__i = 0, G__35249__a = new Array(arguments.length -  0);
while (G__35249__i < G__35249__a.length) {G__35249__a[G__35249__i] = arguments[G__35249__i + 0]; ++G__35249__i;}
  args = new cljs.core.IndexedSeq(G__35249__a,0);
} 
return G__35248__delegate.call(this,args);};
G__35248.cljs$lang$maxFixedArity = 0;
G__35248.cljs$lang$applyTo = (function (arglist__35250){
var args = cljs.core.seq(arglist__35250);
return G__35248__delegate(args);
});
G__35248.cljs$core$IFn$_invoke$arity$variadic = G__35248__delegate;
return G__35248;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__35251 = cljs.core._EQ_;
var expr__35252 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__35251.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__35252))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__35251,expr__35252){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__35251,expr__35252))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__35251,expr__35252){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e35254){if((e35254 instanceof Error)){
var e = e35254;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e35254;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__35251,expr__35252))
} else {
if(cljs.core.truth_(pred__35251.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__35252))){
return ((function (pred__35251,expr__35252){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__35251,expr__35252){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__35251,expr__35252))
);

return deferred.addErrback(((function (deferred,pred__35251,expr__35252){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__35251,expr__35252))
);
});
;})(pred__35251,expr__35252))
} else {
if(cljs.core.truth_(pred__35251.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__35252))){
return ((function (pred__35251,expr__35252){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e35255){if((e35255 instanceof Error)){
var e = e35255;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e35255;

}
}})());
});
;})(pred__35251,expr__35252))
} else {
return ((function (pred__35251,expr__35252){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__35251,expr__35252))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__35256,callback){
var map__35259 = p__35256;
var map__35259__$1 = ((((!((map__35259 == null)))?((((map__35259.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35259.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35259):map__35259);
var file_msg = map__35259__$1;
var request_url = cljs.core.get.call(null,map__35259__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Attempting to load "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__35259,map__35259__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FigWheel: Successfully loaded "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Error loading file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__35259,map__35259__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__30406__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto__){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto__){
return (function (state_35283){
var state_val_35284 = (state_35283[(1)]);
if((state_val_35284 === (7))){
var inst_35279 = (state_35283[(2)]);
var state_35283__$1 = state_35283;
var statearr_35285_35305 = state_35283__$1;
(statearr_35285_35305[(2)] = inst_35279);

(statearr_35285_35305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35284 === (1))){
var state_35283__$1 = state_35283;
var statearr_35286_35306 = state_35283__$1;
(statearr_35286_35306[(2)] = null);

(statearr_35286_35306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35284 === (4))){
var inst_35263 = (state_35283[(7)]);
var inst_35263__$1 = (state_35283[(2)]);
var state_35283__$1 = (function (){var statearr_35287 = state_35283;
(statearr_35287[(7)] = inst_35263__$1);

return statearr_35287;
})();
if(cljs.core.truth_(inst_35263__$1)){
var statearr_35288_35307 = state_35283__$1;
(statearr_35288_35307[(1)] = (5));

} else {
var statearr_35289_35308 = state_35283__$1;
(statearr_35289_35308[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35284 === (6))){
var state_35283__$1 = state_35283;
var statearr_35290_35309 = state_35283__$1;
(statearr_35290_35309[(2)] = null);

(statearr_35290_35309[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35284 === (3))){
var inst_35281 = (state_35283[(2)]);
var state_35283__$1 = state_35283;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35283__$1,inst_35281);
} else {
if((state_val_35284 === (2))){
var state_35283__$1 = state_35283;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35283__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_35284 === (11))){
var inst_35275 = (state_35283[(2)]);
var state_35283__$1 = (function (){var statearr_35291 = state_35283;
(statearr_35291[(8)] = inst_35275);

return statearr_35291;
})();
var statearr_35292_35310 = state_35283__$1;
(statearr_35292_35310[(2)] = null);

(statearr_35292_35310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35284 === (9))){
var inst_35267 = (state_35283[(9)]);
var inst_35269 = (state_35283[(10)]);
var inst_35271 = inst_35269.call(null,inst_35267);
var state_35283__$1 = state_35283;
var statearr_35293_35311 = state_35283__$1;
(statearr_35293_35311[(2)] = inst_35271);

(statearr_35293_35311[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35284 === (5))){
var inst_35263 = (state_35283[(7)]);
var inst_35265 = figwheel.client.file_reloading.blocking_load.call(null,inst_35263);
var state_35283__$1 = state_35283;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35283__$1,(8),inst_35265);
} else {
if((state_val_35284 === (10))){
var inst_35267 = (state_35283[(9)]);
var inst_35273 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_35267);
var state_35283__$1 = state_35283;
var statearr_35294_35312 = state_35283__$1;
(statearr_35294_35312[(2)] = inst_35273);

(statearr_35294_35312[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35284 === (8))){
var inst_35269 = (state_35283[(10)]);
var inst_35263 = (state_35283[(7)]);
var inst_35267 = (state_35283[(2)]);
var inst_35268 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_35269__$1 = cljs.core.get.call(null,inst_35268,inst_35263);
var state_35283__$1 = (function (){var statearr_35295 = state_35283;
(statearr_35295[(9)] = inst_35267);

(statearr_35295[(10)] = inst_35269__$1);

return statearr_35295;
})();
if(cljs.core.truth_(inst_35269__$1)){
var statearr_35296_35313 = state_35283__$1;
(statearr_35296_35313[(1)] = (9));

} else {
var statearr_35297_35314 = state_35283__$1;
(statearr_35297_35314[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto__))
;
return ((function (switch__30292__auto__,c__30406__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__30293__auto__ = null;
var figwheel$client$file_reloading$state_machine__30293__auto____0 = (function (){
var statearr_35301 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35301[(0)] = figwheel$client$file_reloading$state_machine__30293__auto__);

(statearr_35301[(1)] = (1));

return statearr_35301;
});
var figwheel$client$file_reloading$state_machine__30293__auto____1 = (function (state_35283){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_35283);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e35302){if((e35302 instanceof Object)){
var ex__30296__auto__ = e35302;
var statearr_35303_35315 = state_35283;
(statearr_35303_35315[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35283);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35302;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35316 = state_35283;
state_35283 = G__35316;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__30293__auto__ = function(state_35283){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__30293__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__30293__auto____1.call(this,state_35283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__30293__auto____0;
figwheel$client$file_reloading$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__30293__auto____1;
return figwheel$client$file_reloading$state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto__))
})();
var state__30408__auto__ = (function (){var statearr_35304 = f__30407__auto__.call(null);
(statearr_35304[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto__);

return statearr_35304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto__))
);

return c__30406__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__35317,callback){
var map__35320 = p__35317;
var map__35320__$1 = ((((!((map__35320 == null)))?((((map__35320.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35320.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35320):map__35320);
var file_msg = map__35320__$1;
var namespace = cljs.core.get.call(null,map__35320__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__35320,map__35320__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__35320,map__35320__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__35322){
var map__35325 = p__35322;
var map__35325__$1 = ((((!((map__35325 == null)))?((((map__35325.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35325.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35325):map__35325);
var file_msg = map__35325__$1;
var namespace = cljs.core.get.call(null,map__35325__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__35327){
var map__35330 = p__35327;
var map__35330__$1 = ((((!((map__35330 == null)))?((((map__35330.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35330.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35330):map__35330);
var file_msg = map__35330__$1;
var namespace = cljs.core.get.call(null,map__35330__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__27009__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__27009__auto__){
var or__27021__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27021__auto__)){
return or__27021__auto__;
} else {
var or__27021__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27021__auto____$1)){
return or__27021__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__27009__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__35332,callback){
var map__35335 = p__35332;
var map__35335__$1 = ((((!((map__35335 == null)))?((((map__35335.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35335.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35335):map__35335);
var file_msg = map__35335__$1;
var request_url = cljs.core.get.call(null,map__35335__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__35335__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not trying to load file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__30406__auto___35439 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___35439,out){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___35439,out){
return (function (state_35421){
var state_val_35422 = (state_35421[(1)]);
if((state_val_35422 === (1))){
var inst_35395 = cljs.core.seq.call(null,files);
var inst_35396 = cljs.core.first.call(null,inst_35395);
var inst_35397 = cljs.core.next.call(null,inst_35395);
var inst_35398 = files;
var state_35421__$1 = (function (){var statearr_35423 = state_35421;
(statearr_35423[(7)] = inst_35396);

(statearr_35423[(8)] = inst_35398);

(statearr_35423[(9)] = inst_35397);

return statearr_35423;
})();
var statearr_35424_35440 = state_35421__$1;
(statearr_35424_35440[(2)] = null);

(statearr_35424_35440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35422 === (2))){
var inst_35398 = (state_35421[(8)]);
var inst_35404 = (state_35421[(10)]);
var inst_35403 = cljs.core.seq.call(null,inst_35398);
var inst_35404__$1 = cljs.core.first.call(null,inst_35403);
var inst_35405 = cljs.core.next.call(null,inst_35403);
var inst_35406 = (inst_35404__$1 == null);
var inst_35407 = cljs.core.not.call(null,inst_35406);
var state_35421__$1 = (function (){var statearr_35425 = state_35421;
(statearr_35425[(10)] = inst_35404__$1);

(statearr_35425[(11)] = inst_35405);

return statearr_35425;
})();
if(inst_35407){
var statearr_35426_35441 = state_35421__$1;
(statearr_35426_35441[(1)] = (4));

} else {
var statearr_35427_35442 = state_35421__$1;
(statearr_35427_35442[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35422 === (3))){
var inst_35419 = (state_35421[(2)]);
var state_35421__$1 = state_35421;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35421__$1,inst_35419);
} else {
if((state_val_35422 === (4))){
var inst_35404 = (state_35421[(10)]);
var inst_35409 = figwheel.client.file_reloading.reload_js_file.call(null,inst_35404);
var state_35421__$1 = state_35421;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35421__$1,(7),inst_35409);
} else {
if((state_val_35422 === (5))){
var inst_35415 = cljs.core.async.close_BANG_.call(null,out);
var state_35421__$1 = state_35421;
var statearr_35428_35443 = state_35421__$1;
(statearr_35428_35443[(2)] = inst_35415);

(statearr_35428_35443[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35422 === (6))){
var inst_35417 = (state_35421[(2)]);
var state_35421__$1 = state_35421;
var statearr_35429_35444 = state_35421__$1;
(statearr_35429_35444[(2)] = inst_35417);

(statearr_35429_35444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35422 === (7))){
var inst_35405 = (state_35421[(11)]);
var inst_35411 = (state_35421[(2)]);
var inst_35412 = cljs.core.async.put_BANG_.call(null,out,inst_35411);
var inst_35398 = inst_35405;
var state_35421__$1 = (function (){var statearr_35430 = state_35421;
(statearr_35430[(8)] = inst_35398);

(statearr_35430[(12)] = inst_35412);

return statearr_35430;
})();
var statearr_35431_35445 = state_35421__$1;
(statearr_35431_35445[(2)] = null);

(statearr_35431_35445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__30406__auto___35439,out))
;
return ((function (switch__30292__auto__,c__30406__auto___35439,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30293__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30293__auto____0 = (function (){
var statearr_35435 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35435[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30293__auto__);

(statearr_35435[(1)] = (1));

return statearr_35435;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30293__auto____1 = (function (state_35421){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_35421);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e35436){if((e35436 instanceof Object)){
var ex__30296__auto__ = e35436;
var statearr_35437_35446 = state_35421;
(statearr_35437_35446[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35421);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35436;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35447 = state_35421;
state_35421 = G__35447;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30293__auto__ = function(state_35421){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30293__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30293__auto____1.call(this,state_35421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30293__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30293__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___35439,out))
})();
var state__30408__auto__ = (function (){var statearr_35438 = f__30407__auto__.call(null);
(statearr_35438[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___35439);

return statearr_35438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___35439,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__35448,opts){
var map__35452 = p__35448;
var map__35452__$1 = ((((!((map__35452 == null)))?((((map__35452.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35452.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35452):map__35452);
var eval_body = cljs.core.get.call(null,map__35452__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__35452__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__27009__auto__ = eval_body;
if(cljs.core.truth_(and__27009__auto__)){
return typeof eval_body === 'string';
} else {
return and__27009__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Evaling file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e35454){var e = e35454;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Unable to evaluate "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__35455_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__35455_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__35464){
var vec__35465 = p__35464;
var k = cljs.core.nth.call(null,vec__35465,(0),null);
var v = cljs.core.nth.call(null,vec__35465,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__35468){
var vec__35469 = p__35468;
var k = cljs.core.nth.call(null,vec__35469,(0),null);
var v = cljs.core.nth.call(null,vec__35469,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__35475,p__35476){
var map__35724 = p__35475;
var map__35724__$1 = ((((!((map__35724 == null)))?((((map__35724.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35724.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35724):map__35724);
var opts = map__35724__$1;
var before_jsload = cljs.core.get.call(null,map__35724__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__35724__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__35724__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__35725 = p__35476;
var map__35725__$1 = ((((!((map__35725 == null)))?((((map__35725.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35725.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35725):map__35725);
var msg = map__35725__$1;
var files = cljs.core.get.call(null,map__35725__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__35725__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__35725__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__30406__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_35879){
var state_val_35880 = (state_35879[(1)]);
if((state_val_35880 === (7))){
var inst_35742 = (state_35879[(7)]);
var inst_35739 = (state_35879[(8)]);
var inst_35740 = (state_35879[(9)]);
var inst_35741 = (state_35879[(10)]);
var inst_35747 = cljs.core._nth.call(null,inst_35740,inst_35742);
var inst_35748 = figwheel.client.file_reloading.eval_body.call(null,inst_35747,opts);
var inst_35749 = (inst_35742 + (1));
var tmp35881 = inst_35739;
var tmp35882 = inst_35740;
var tmp35883 = inst_35741;
var inst_35739__$1 = tmp35881;
var inst_35740__$1 = tmp35882;
var inst_35741__$1 = tmp35883;
var inst_35742__$1 = inst_35749;
var state_35879__$1 = (function (){var statearr_35884 = state_35879;
(statearr_35884[(7)] = inst_35742__$1);

(statearr_35884[(8)] = inst_35739__$1);

(statearr_35884[(9)] = inst_35740__$1);

(statearr_35884[(10)] = inst_35741__$1);

(statearr_35884[(11)] = inst_35748);

return statearr_35884;
})();
var statearr_35885_35971 = state_35879__$1;
(statearr_35885_35971[(2)] = null);

(statearr_35885_35971[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (20))){
var inst_35782 = (state_35879[(12)]);
var inst_35790 = figwheel.client.file_reloading.sort_files.call(null,inst_35782);
var state_35879__$1 = state_35879;
var statearr_35886_35972 = state_35879__$1;
(statearr_35886_35972[(2)] = inst_35790);

(statearr_35886_35972[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (27))){
var state_35879__$1 = state_35879;
var statearr_35887_35973 = state_35879__$1;
(statearr_35887_35973[(2)] = null);

(statearr_35887_35973[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (1))){
var inst_35731 = (state_35879[(13)]);
var inst_35728 = before_jsload.call(null,files);
var inst_35729 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_35730 = (function (){return ((function (inst_35731,inst_35728,inst_35729,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__35472_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__35472_SHARP_);
});
;})(inst_35731,inst_35728,inst_35729,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35731__$1 = cljs.core.filter.call(null,inst_35730,files);
var inst_35732 = cljs.core.not_empty.call(null,inst_35731__$1);
var state_35879__$1 = (function (){var statearr_35888 = state_35879;
(statearr_35888[(14)] = inst_35728);

(statearr_35888[(13)] = inst_35731__$1);

(statearr_35888[(15)] = inst_35729);

return statearr_35888;
})();
if(cljs.core.truth_(inst_35732)){
var statearr_35889_35974 = state_35879__$1;
(statearr_35889_35974[(1)] = (2));

} else {
var statearr_35890_35975 = state_35879__$1;
(statearr_35890_35975[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (24))){
var state_35879__$1 = state_35879;
var statearr_35891_35976 = state_35879__$1;
(statearr_35891_35976[(2)] = null);

(statearr_35891_35976[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (39))){
var inst_35832 = (state_35879[(16)]);
var state_35879__$1 = state_35879;
var statearr_35892_35977 = state_35879__$1;
(statearr_35892_35977[(2)] = inst_35832);

(statearr_35892_35977[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (46))){
var inst_35874 = (state_35879[(2)]);
var state_35879__$1 = state_35879;
var statearr_35893_35978 = state_35879__$1;
(statearr_35893_35978[(2)] = inst_35874);

(statearr_35893_35978[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (4))){
var inst_35776 = (state_35879[(2)]);
var inst_35777 = cljs.core.List.EMPTY;
var inst_35778 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_35777);
var inst_35779 = (function (){return ((function (inst_35776,inst_35777,inst_35778,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__35473_SHARP_){
var and__27009__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__35473_SHARP_);
if(cljs.core.truth_(and__27009__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__35473_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__35473_SHARP_)));
} else {
return and__27009__auto__;
}
});
;})(inst_35776,inst_35777,inst_35778,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35780 = cljs.core.filter.call(null,inst_35779,files);
var inst_35781 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_35782 = cljs.core.concat.call(null,inst_35780,inst_35781);
var state_35879__$1 = (function (){var statearr_35894 = state_35879;
(statearr_35894[(17)] = inst_35776);

(statearr_35894[(18)] = inst_35778);

(statearr_35894[(12)] = inst_35782);

return statearr_35894;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_35895_35979 = state_35879__$1;
(statearr_35895_35979[(1)] = (16));

} else {
var statearr_35896_35980 = state_35879__$1;
(statearr_35896_35980[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (15))){
var inst_35766 = (state_35879[(2)]);
var state_35879__$1 = state_35879;
var statearr_35897_35981 = state_35879__$1;
(statearr_35897_35981[(2)] = inst_35766);

(statearr_35897_35981[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (21))){
var inst_35792 = (state_35879[(19)]);
var inst_35792__$1 = (state_35879[(2)]);
var inst_35793 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_35792__$1);
var state_35879__$1 = (function (){var statearr_35898 = state_35879;
(statearr_35898[(19)] = inst_35792__$1);

return statearr_35898;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35879__$1,(22),inst_35793);
} else {
if((state_val_35880 === (31))){
var inst_35877 = (state_35879[(2)]);
var state_35879__$1 = state_35879;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35879__$1,inst_35877);
} else {
if((state_val_35880 === (32))){
var inst_35832 = (state_35879[(16)]);
var inst_35837 = inst_35832.cljs$lang$protocol_mask$partition0$;
var inst_35838 = (inst_35837 & (64));
var inst_35839 = inst_35832.cljs$core$ISeq$;
var inst_35840 = (cljs.core.PROTOCOL_SENTINEL === inst_35839);
var inst_35841 = (inst_35838) || (inst_35840);
var state_35879__$1 = state_35879;
if(cljs.core.truth_(inst_35841)){
var statearr_35899_35982 = state_35879__$1;
(statearr_35899_35982[(1)] = (35));

} else {
var statearr_35900_35983 = state_35879__$1;
(statearr_35900_35983[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (40))){
var inst_35854 = (state_35879[(20)]);
var inst_35853 = (state_35879[(2)]);
var inst_35854__$1 = cljs.core.get.call(null,inst_35853,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_35855 = cljs.core.get.call(null,inst_35853,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_35856 = cljs.core.not_empty.call(null,inst_35854__$1);
var state_35879__$1 = (function (){var statearr_35901 = state_35879;
(statearr_35901[(20)] = inst_35854__$1);

(statearr_35901[(21)] = inst_35855);

return statearr_35901;
})();
if(cljs.core.truth_(inst_35856)){
var statearr_35902_35984 = state_35879__$1;
(statearr_35902_35984[(1)] = (41));

} else {
var statearr_35903_35985 = state_35879__$1;
(statearr_35903_35985[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (33))){
var state_35879__$1 = state_35879;
var statearr_35904_35986 = state_35879__$1;
(statearr_35904_35986[(2)] = false);

(statearr_35904_35986[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (13))){
var inst_35752 = (state_35879[(22)]);
var inst_35756 = cljs.core.chunk_first.call(null,inst_35752);
var inst_35757 = cljs.core.chunk_rest.call(null,inst_35752);
var inst_35758 = cljs.core.count.call(null,inst_35756);
var inst_35739 = inst_35757;
var inst_35740 = inst_35756;
var inst_35741 = inst_35758;
var inst_35742 = (0);
var state_35879__$1 = (function (){var statearr_35905 = state_35879;
(statearr_35905[(7)] = inst_35742);

(statearr_35905[(8)] = inst_35739);

(statearr_35905[(9)] = inst_35740);

(statearr_35905[(10)] = inst_35741);

return statearr_35905;
})();
var statearr_35906_35987 = state_35879__$1;
(statearr_35906_35987[(2)] = null);

(statearr_35906_35987[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (22))){
var inst_35792 = (state_35879[(19)]);
var inst_35800 = (state_35879[(23)]);
var inst_35796 = (state_35879[(24)]);
var inst_35795 = (state_35879[(25)]);
var inst_35795__$1 = (state_35879[(2)]);
var inst_35796__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_35795__$1);
var inst_35797 = (function (){var all_files = inst_35792;
var res_SINGLEQUOTE_ = inst_35795__$1;
var res = inst_35796__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_35792,inst_35800,inst_35796,inst_35795,inst_35795__$1,inst_35796__$1,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__35474_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__35474_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_35792,inst_35800,inst_35796,inst_35795,inst_35795__$1,inst_35796__$1,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35798 = cljs.core.filter.call(null,inst_35797,inst_35795__$1);
var inst_35799 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_35800__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_35799);
var inst_35801 = cljs.core.not_empty.call(null,inst_35800__$1);
var state_35879__$1 = (function (){var statearr_35907 = state_35879;
(statearr_35907[(26)] = inst_35798);

(statearr_35907[(23)] = inst_35800__$1);

(statearr_35907[(24)] = inst_35796__$1);

(statearr_35907[(25)] = inst_35795__$1);

return statearr_35907;
})();
if(cljs.core.truth_(inst_35801)){
var statearr_35908_35988 = state_35879__$1;
(statearr_35908_35988[(1)] = (23));

} else {
var statearr_35909_35989 = state_35879__$1;
(statearr_35909_35989[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (36))){
var state_35879__$1 = state_35879;
var statearr_35910_35990 = state_35879__$1;
(statearr_35910_35990[(2)] = false);

(statearr_35910_35990[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (41))){
var inst_35854 = (state_35879[(20)]);
var inst_35858 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_35859 = cljs.core.map.call(null,inst_35858,inst_35854);
var inst_35860 = cljs.core.pr_str.call(null,inst_35859);
var inst_35861 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("figwheel-no-load meta-data: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35860)].join('');
var inst_35862 = figwheel.client.utils.log.call(null,inst_35861);
var state_35879__$1 = state_35879;
var statearr_35911_35991 = state_35879__$1;
(statearr_35911_35991[(2)] = inst_35862);

(statearr_35911_35991[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (43))){
var inst_35855 = (state_35879[(21)]);
var inst_35865 = (state_35879[(2)]);
var inst_35866 = cljs.core.not_empty.call(null,inst_35855);
var state_35879__$1 = (function (){var statearr_35912 = state_35879;
(statearr_35912[(27)] = inst_35865);

return statearr_35912;
})();
if(cljs.core.truth_(inst_35866)){
var statearr_35913_35992 = state_35879__$1;
(statearr_35913_35992[(1)] = (44));

} else {
var statearr_35914_35993 = state_35879__$1;
(statearr_35914_35993[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (29))){
var inst_35792 = (state_35879[(19)]);
var inst_35798 = (state_35879[(26)]);
var inst_35800 = (state_35879[(23)]);
var inst_35832 = (state_35879[(16)]);
var inst_35796 = (state_35879[(24)]);
var inst_35795 = (state_35879[(25)]);
var inst_35828 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_35831 = (function (){var all_files = inst_35792;
var res_SINGLEQUOTE_ = inst_35795;
var res = inst_35796;
var files_not_loaded = inst_35798;
var dependencies_that_loaded = inst_35800;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35792,inst_35798,inst_35800,inst_35832,inst_35796,inst_35795,inst_35828,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__35830){
var map__35915 = p__35830;
var map__35915__$1 = ((((!((map__35915 == null)))?((((map__35915.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35915.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35915):map__35915);
var namespace = cljs.core.get.call(null,map__35915__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35792,inst_35798,inst_35800,inst_35832,inst_35796,inst_35795,inst_35828,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35832__$1 = cljs.core.group_by.call(null,inst_35831,inst_35798);
var inst_35834 = (inst_35832__$1 == null);
var inst_35835 = cljs.core.not.call(null,inst_35834);
var state_35879__$1 = (function (){var statearr_35917 = state_35879;
(statearr_35917[(28)] = inst_35828);

(statearr_35917[(16)] = inst_35832__$1);

return statearr_35917;
})();
if(inst_35835){
var statearr_35918_35994 = state_35879__$1;
(statearr_35918_35994[(1)] = (32));

} else {
var statearr_35919_35995 = state_35879__$1;
(statearr_35919_35995[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (44))){
var inst_35855 = (state_35879[(21)]);
var inst_35868 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_35855);
var inst_35869 = cljs.core.pr_str.call(null,inst_35868);
var inst_35870 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("not required: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35869)].join('');
var inst_35871 = figwheel.client.utils.log.call(null,inst_35870);
var state_35879__$1 = state_35879;
var statearr_35920_35996 = state_35879__$1;
(statearr_35920_35996[(2)] = inst_35871);

(statearr_35920_35996[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (6))){
var inst_35773 = (state_35879[(2)]);
var state_35879__$1 = state_35879;
var statearr_35921_35997 = state_35879__$1;
(statearr_35921_35997[(2)] = inst_35773);

(statearr_35921_35997[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (28))){
var inst_35798 = (state_35879[(26)]);
var inst_35825 = (state_35879[(2)]);
var inst_35826 = cljs.core.not_empty.call(null,inst_35798);
var state_35879__$1 = (function (){var statearr_35922 = state_35879;
(statearr_35922[(29)] = inst_35825);

return statearr_35922;
})();
if(cljs.core.truth_(inst_35826)){
var statearr_35923_35998 = state_35879__$1;
(statearr_35923_35998[(1)] = (29));

} else {
var statearr_35924_35999 = state_35879__$1;
(statearr_35924_35999[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (25))){
var inst_35796 = (state_35879[(24)]);
var inst_35812 = (state_35879[(2)]);
var inst_35813 = cljs.core.not_empty.call(null,inst_35796);
var state_35879__$1 = (function (){var statearr_35925 = state_35879;
(statearr_35925[(30)] = inst_35812);

return statearr_35925;
})();
if(cljs.core.truth_(inst_35813)){
var statearr_35926_36000 = state_35879__$1;
(statearr_35926_36000[(1)] = (26));

} else {
var statearr_35927_36001 = state_35879__$1;
(statearr_35927_36001[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (34))){
var inst_35848 = (state_35879[(2)]);
var state_35879__$1 = state_35879;
if(cljs.core.truth_(inst_35848)){
var statearr_35928_36002 = state_35879__$1;
(statearr_35928_36002[(1)] = (38));

} else {
var statearr_35929_36003 = state_35879__$1;
(statearr_35929_36003[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (17))){
var state_35879__$1 = state_35879;
var statearr_35930_36004 = state_35879__$1;
(statearr_35930_36004[(2)] = recompile_dependents);

(statearr_35930_36004[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (3))){
var state_35879__$1 = state_35879;
var statearr_35931_36005 = state_35879__$1;
(statearr_35931_36005[(2)] = null);

(statearr_35931_36005[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (12))){
var inst_35769 = (state_35879[(2)]);
var state_35879__$1 = state_35879;
var statearr_35932_36006 = state_35879__$1;
(statearr_35932_36006[(2)] = inst_35769);

(statearr_35932_36006[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (2))){
var inst_35731 = (state_35879[(13)]);
var inst_35738 = cljs.core.seq.call(null,inst_35731);
var inst_35739 = inst_35738;
var inst_35740 = null;
var inst_35741 = (0);
var inst_35742 = (0);
var state_35879__$1 = (function (){var statearr_35933 = state_35879;
(statearr_35933[(7)] = inst_35742);

(statearr_35933[(8)] = inst_35739);

(statearr_35933[(9)] = inst_35740);

(statearr_35933[(10)] = inst_35741);

return statearr_35933;
})();
var statearr_35934_36007 = state_35879__$1;
(statearr_35934_36007[(2)] = null);

(statearr_35934_36007[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (23))){
var inst_35792 = (state_35879[(19)]);
var inst_35798 = (state_35879[(26)]);
var inst_35800 = (state_35879[(23)]);
var inst_35796 = (state_35879[(24)]);
var inst_35795 = (state_35879[(25)]);
var inst_35803 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_35805 = (function (){var all_files = inst_35792;
var res_SINGLEQUOTE_ = inst_35795;
var res = inst_35796;
var files_not_loaded = inst_35798;
var dependencies_that_loaded = inst_35800;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35792,inst_35798,inst_35800,inst_35796,inst_35795,inst_35803,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__35804){
var map__35935 = p__35804;
var map__35935__$1 = ((((!((map__35935 == null)))?((((map__35935.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35935.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35935):map__35935);
var request_url = cljs.core.get.call(null,map__35935__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35792,inst_35798,inst_35800,inst_35796,inst_35795,inst_35803,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35806 = cljs.core.reverse.call(null,inst_35800);
var inst_35807 = cljs.core.map.call(null,inst_35805,inst_35806);
var inst_35808 = cljs.core.pr_str.call(null,inst_35807);
var inst_35809 = figwheel.client.utils.log.call(null,inst_35808);
var state_35879__$1 = (function (){var statearr_35937 = state_35879;
(statearr_35937[(31)] = inst_35803);

return statearr_35937;
})();
var statearr_35938_36008 = state_35879__$1;
(statearr_35938_36008[(2)] = inst_35809);

(statearr_35938_36008[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (35))){
var state_35879__$1 = state_35879;
var statearr_35939_36009 = state_35879__$1;
(statearr_35939_36009[(2)] = true);

(statearr_35939_36009[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (19))){
var inst_35782 = (state_35879[(12)]);
var inst_35788 = figwheel.client.file_reloading.expand_files.call(null,inst_35782);
var state_35879__$1 = state_35879;
var statearr_35940_36010 = state_35879__$1;
(statearr_35940_36010[(2)] = inst_35788);

(statearr_35940_36010[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (11))){
var state_35879__$1 = state_35879;
var statearr_35941_36011 = state_35879__$1;
(statearr_35941_36011[(2)] = null);

(statearr_35941_36011[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (9))){
var inst_35771 = (state_35879[(2)]);
var state_35879__$1 = state_35879;
var statearr_35942_36012 = state_35879__$1;
(statearr_35942_36012[(2)] = inst_35771);

(statearr_35942_36012[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (5))){
var inst_35742 = (state_35879[(7)]);
var inst_35741 = (state_35879[(10)]);
var inst_35744 = (inst_35742 < inst_35741);
var inst_35745 = inst_35744;
var state_35879__$1 = state_35879;
if(cljs.core.truth_(inst_35745)){
var statearr_35943_36013 = state_35879__$1;
(statearr_35943_36013[(1)] = (7));

} else {
var statearr_35944_36014 = state_35879__$1;
(statearr_35944_36014[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (14))){
var inst_35752 = (state_35879[(22)]);
var inst_35761 = cljs.core.first.call(null,inst_35752);
var inst_35762 = figwheel.client.file_reloading.eval_body.call(null,inst_35761,opts);
var inst_35763 = cljs.core.next.call(null,inst_35752);
var inst_35739 = inst_35763;
var inst_35740 = null;
var inst_35741 = (0);
var inst_35742 = (0);
var state_35879__$1 = (function (){var statearr_35945 = state_35879;
(statearr_35945[(32)] = inst_35762);

(statearr_35945[(7)] = inst_35742);

(statearr_35945[(8)] = inst_35739);

(statearr_35945[(9)] = inst_35740);

(statearr_35945[(10)] = inst_35741);

return statearr_35945;
})();
var statearr_35946_36015 = state_35879__$1;
(statearr_35946_36015[(2)] = null);

(statearr_35946_36015[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (45))){
var state_35879__$1 = state_35879;
var statearr_35947_36016 = state_35879__$1;
(statearr_35947_36016[(2)] = null);

(statearr_35947_36016[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (26))){
var inst_35792 = (state_35879[(19)]);
var inst_35798 = (state_35879[(26)]);
var inst_35800 = (state_35879[(23)]);
var inst_35796 = (state_35879[(24)]);
var inst_35795 = (state_35879[(25)]);
var inst_35815 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_35817 = (function (){var all_files = inst_35792;
var res_SINGLEQUOTE_ = inst_35795;
var res = inst_35796;
var files_not_loaded = inst_35798;
var dependencies_that_loaded = inst_35800;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35792,inst_35798,inst_35800,inst_35796,inst_35795,inst_35815,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__35816){
var map__35948 = p__35816;
var map__35948__$1 = ((((!((map__35948 == null)))?((((map__35948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35948.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35948):map__35948);
var namespace = cljs.core.get.call(null,map__35948__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__35948__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35792,inst_35798,inst_35800,inst_35796,inst_35795,inst_35815,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35818 = cljs.core.map.call(null,inst_35817,inst_35796);
var inst_35819 = cljs.core.pr_str.call(null,inst_35818);
var inst_35820 = figwheel.client.utils.log.call(null,inst_35819);
var inst_35821 = (function (){var all_files = inst_35792;
var res_SINGLEQUOTE_ = inst_35795;
var res = inst_35796;
var files_not_loaded = inst_35798;
var dependencies_that_loaded = inst_35800;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35792,inst_35798,inst_35800,inst_35796,inst_35795,inst_35815,inst_35817,inst_35818,inst_35819,inst_35820,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35792,inst_35798,inst_35800,inst_35796,inst_35795,inst_35815,inst_35817,inst_35818,inst_35819,inst_35820,state_val_35880,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35822 = setTimeout(inst_35821,(10));
var state_35879__$1 = (function (){var statearr_35950 = state_35879;
(statearr_35950[(33)] = inst_35815);

(statearr_35950[(34)] = inst_35820);

return statearr_35950;
})();
var statearr_35951_36017 = state_35879__$1;
(statearr_35951_36017[(2)] = inst_35822);

(statearr_35951_36017[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (16))){
var state_35879__$1 = state_35879;
var statearr_35952_36018 = state_35879__$1;
(statearr_35952_36018[(2)] = reload_dependents);

(statearr_35952_36018[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (38))){
var inst_35832 = (state_35879[(16)]);
var inst_35850 = cljs.core.apply.call(null,cljs.core.hash_map,inst_35832);
var state_35879__$1 = state_35879;
var statearr_35953_36019 = state_35879__$1;
(statearr_35953_36019[(2)] = inst_35850);

(statearr_35953_36019[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (30))){
var state_35879__$1 = state_35879;
var statearr_35954_36020 = state_35879__$1;
(statearr_35954_36020[(2)] = null);

(statearr_35954_36020[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (10))){
var inst_35752 = (state_35879[(22)]);
var inst_35754 = cljs.core.chunked_seq_QMARK_.call(null,inst_35752);
var state_35879__$1 = state_35879;
if(inst_35754){
var statearr_35955_36021 = state_35879__$1;
(statearr_35955_36021[(1)] = (13));

} else {
var statearr_35956_36022 = state_35879__$1;
(statearr_35956_36022[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (18))){
var inst_35786 = (state_35879[(2)]);
var state_35879__$1 = state_35879;
if(cljs.core.truth_(inst_35786)){
var statearr_35957_36023 = state_35879__$1;
(statearr_35957_36023[(1)] = (19));

} else {
var statearr_35958_36024 = state_35879__$1;
(statearr_35958_36024[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (42))){
var state_35879__$1 = state_35879;
var statearr_35959_36025 = state_35879__$1;
(statearr_35959_36025[(2)] = null);

(statearr_35959_36025[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (37))){
var inst_35845 = (state_35879[(2)]);
var state_35879__$1 = state_35879;
var statearr_35960_36026 = state_35879__$1;
(statearr_35960_36026[(2)] = inst_35845);

(statearr_35960_36026[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35880 === (8))){
var inst_35739 = (state_35879[(8)]);
var inst_35752 = (state_35879[(22)]);
var inst_35752__$1 = cljs.core.seq.call(null,inst_35739);
var state_35879__$1 = (function (){var statearr_35961 = state_35879;
(statearr_35961[(22)] = inst_35752__$1);

return statearr_35961;
})();
if(inst_35752__$1){
var statearr_35962_36027 = state_35879__$1;
(statearr_35962_36027[(1)] = (10));

} else {
var statearr_35963_36028 = state_35879__$1;
(statearr_35963_36028[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__30292__auto__,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30293__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30293__auto____0 = (function (){
var statearr_35967 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35967[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__30293__auto__);

(statearr_35967[(1)] = (1));

return statearr_35967;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30293__auto____1 = (function (state_35879){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_35879);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e35968){if((e35968 instanceof Object)){
var ex__30296__auto__ = e35968;
var statearr_35969_36029 = state_35879;
(statearr_35969_36029[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35879);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35968;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36030 = state_35879;
state_35879 = G__36030;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__30293__auto__ = function(state_35879){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30293__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30293__auto____1.call(this,state_35879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30293__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30293__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__30408__auto__ = (function (){var statearr_35970 = f__30407__auto__.call(null);
(statearr_35970[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto__);

return statearr_35970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto__,map__35724,map__35724__$1,opts,before_jsload,on_jsload,reload_dependents,map__35725,map__35725__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__30406__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__36033,link){
var map__36036 = p__36033;
var map__36036__$1 = ((((!((map__36036 == null)))?((((map__36036.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36036.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36036):map__36036);
var file = cljs.core.get.call(null,map__36036__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__36036,map__36036__$1,file){
return (function (p1__36031_SHARP_,p2__36032_SHARP_){
if(cljs.core._EQ_.call(null,p1__36031_SHARP_,p2__36032_SHARP_)){
return p1__36031_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__36036,map__36036__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__36042){
var map__36043 = p__36042;
var map__36043__$1 = ((((!((map__36043 == null)))?((((map__36043.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36043.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36043):map__36043);
var match_length = cljs.core.get.call(null,map__36043__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__36043__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__36038_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__36038_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__36045_SHARP_,p2__36046_SHARP_){
return cljs.core.assoc.call(null,p1__36045_SHARP_,cljs.core.get.call(null,p2__36046_SHARP_,key),p2__36046_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__6751__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6751__auto__)){
var link = temp__6751__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__6751__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__6751__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_36047 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_36047);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_36047);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__36048,p__36049){
var map__36054 = p__36048;
var map__36054__$1 = ((((!((map__36054 == null)))?((((map__36054.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36054.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36054):map__36054);
var on_cssload = cljs.core.get.call(null,map__36054__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__36055 = p__36049;
var map__36055__$1 = ((((!((map__36055 == null)))?((((map__36055.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36055.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36055):map__36055);
var files_msg = map__36055__$1;
var files = cljs.core.get.call(null,map__36055__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__6753__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__6753__auto__)){
var f_datas = temp__6753__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1486396820692