# NavTree

Reagent component for the navigation of hierarchical content structures with table of contents or content path (demo: https://aw7.github.io/z-com-demo/#navtree).

## Installation

*To install the entire library see https://github.com/aw7/z-com.*

* add the dependency:
  ```Clojure
  :dependencies [[z-com/navtree "0.8.0"]]
  ````

* include the stylesheet `resources/public/css/navtree.css` in your HTML

* if you want to use ZMDI's chevron icons for the arrows include the [ZMDI stylesheet](https://cdnjs.cloudflare.com/ajax/libs/material-design-iconic-font/2.1.2/css/material-design-iconic-font.min.css) as well

## Usage

```Clojure
(ns navtree-app
  (:require [z-com.core :as z]))

(def tree-data
  {:label "Root"
   :children
   [{:label "child 1"
     :children
     [{:label "child 1.1"}]}
      {:label "child 2"}]})

(def content-map
  {"child 1.1" "Lorem ipsum dolor sit amet"})

(def index
  [:div
    [z/navtree
      :tree tree-data
      :id-fn :label, :label-fn :label, :children-fn :children
      :expand-nav? true
      :keynav? true :jump-to-content? true
      :content-fn
      #(when-let [c (get content-map %)]
        [:div.content c])]])
```

* `:tree` is any data structure that can be navigated with the supplied `:id-fn`, `:label-fn` and `:children-fn`

* `:content-fn` is given the id-value (as returned by `:id-fn`) of the selected node and should return the content for that node

* `:expand-nav?` when true will show the entire navigation tree, when false just the current path

* `:selection-path-ratom` can be provided to read and/or control the path of the selected node

* `:keynav?` when true vi-like keyboard shortcuts to control navigation are activated

* `:jump-to-content?` when true *navtree* will automatically navigate the tree in depth-first-order until it finds a node for which `:content-fn` returns something other than `nil`
