(ns linetree.demo
  (:require [reagent.core :as r]
            [linetree.table :as table]
            [linetree.flex  :as flex]
            [linetree.core  :refer [linetree]]))

(defn node [text]
  [:div.node text])

(defn demo []
  [:div.tree-demo
    [:h1 "LineTree Demo (0.2.0)"]

    [:h2 "Table-based Tree"]
    [:h3 "Vertical"]
    [table/tree [node "A"]
      [[node "B"]
       [table/tree [node "C"]
         [[node "C1"] [node "C2"] [node "C3"]]]
       [node "D"]]]

    [:h3 "Horizontal"]
    [linetree
      :repr :table
      :orientation :h
      :node [node "A"]
      :labels {:first "up" :last "down"}
      :branches
        [{:branch [node "B"]
          :labels {:first "B-up" :last "B-down"}}
         [linetree
           :repr :table
           :orientation :h
           :node [node "C"]
           :labels {:first "only up"}
           :branches [[node "C1"] [node "C2"] [node "C3"]]]
         [node "D"]]]

    [:h2 "Flex-based Tree"]
    [:h3 "Vertical"]
    [flex/tree [node "A"]
      [[node "B"]
       [flex/tree [node "C"]
         [[node "C1"] [node "C2"] [node "C3"]]]
       [node "D"]]]

    [:h3 "Vertical (stretched)"]
    [linetree
      :repr :flex
      :orientation :v
      :stretched? true
      :node [node "A"]
      :branches
        [[node "B"]
         [flex/tree [node "C"] [[node "C1"] [node "C2"] [node "C3"]]]
         [node "D"]]]

    [:h3 "Horizontal"]
    [linetree
      :repr :flex
      :orientation :h
      :node [node "A"]
      :labels {:first "up" :last "down"}
      :branches
        [{:branch [node "B"]
          :labels {:first "B-up" :last "B-down"}}
         [flex/tree
           {:orientation :h
            :node [node "C"]
            :labels {:first "only-up"}
            :branches [[node "C1"] [node "C2"] [node "C3"]]}]
         [node "D"]]]

    [:h3 "Single/Zero Branch Cases"]
    [flex/tree [node "A"]
      [[flex/tree [node "B1"]
         [[flex/tree [node "C"] []]]]
       [node "B2"]]]])

(r/render [demo] (.getElementById js/document "app"))
