(ns line-tree.table)

(def border-settings
  {[:v :link] ["t b l" "t r b l"]
   [:v :first] ["t r b l" "r b"]
   [:v :inner] ["b l" "b l r"]
   [:v :last]  ["l b" "t r b l"]

   [:h :link] ["t r l" "t r b l"]
   [:h :first] ["t r b l" "r b"]
   [:h :inner] ["t r" "t r b"]
   [:h :last]  ["r t" "t r b l"]})

(defn skeleton
  [o line {l1 :first l2 :last}]
  (let [[l r] (get border-settings [o line])]
    (case o
      :v [:table.skeleton.v {:class (name line)}
           [:tr [:td.line.first {:class l} (when l1 [:span.line-label l1])]
                [:td.line.last  {:class r} (when l2 [:span.line-label l2])]]]
      :h [:table.skeleton.h {:class (name line)}
           [:tr [:td.line.first {:class l} (when l1 [:span.line-label l1])]]
           [:tr [:td.line.last  {:class r} (when l2 [:span.line-label l2])]]])))

(defn branches
  [o bb]
  [:table.branches {:class (name o)}
    [(case o :v :tbody>tr :h :tbody)
      (map-indexed
        (fn [i b-item]
          (let [[b ll] (if (map? b-item)
                         [(:branch b-item) (:labels b-item)]
                         [b-item {}])
                h [skeleton
                    o
                    (cond (= i 0) :first
                          (= i (-> bb count dec)) :last
                          :else :inner)
                    ll]]
            (case o
              :v [:td.branch h b]
              :h [:tr [:td.branch h] [:td b]])))
        bb)]])

(defn tree
  ([el sub-els] (tree {:orientation :v :node el :branches sub-els}))
  ([{o :orientation n :node bb :branches ll :labels}]
   (case o
     :v [:div.line-tree.line-tree-table.v
          n
          [skeleton o :link ll]
          [branches o bb]]
     :h [:table.line-tree.line-tree-table.h
          [:tr
            [:td n]
            [:td [skeleton o :link ll]]
            [:td [branches o bb]]]])))
