// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
goog.require('cljs.repl');
goog.require('figwheel.client.heads_up');
goog.require('cljs.reader');
figwheel.client._figwheel_version_ = "0.5.9";
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var args37415 = [];
var len__27957__auto___37418 = arguments.length;
var i__27958__auto___37419 = (0);
while(true){
if((i__27958__auto___37419 < len__27957__auto___37418)){
args37415.push((arguments[i__27958__auto___37419]));

var G__37420 = (i__27958__auto___37419 + (1));
i__27958__auto___37419 = G__37420;
continue;
} else {
}
break;
}

var G__37417 = args37415.length;
switch (G__37417) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37415.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),args], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__27964__auto__ = [];
var len__27957__auto___37423 = arguments.length;
var i__27958__auto___37424 = (0);
while(true){
if((i__27958__auto___37424 < len__27957__auto___37423)){
args__27964__auto__.push((arguments[i__27958__auto___37424]));

var G__37425 = (i__27958__auto___37424 + (1));
i__27958__auto___37424 = G__37425;
continue;
} else {
}
break;
}

var argseq__27965__auto__ = ((((0) < args__27964__auto__.length))?(new cljs.core.IndexedSeq(args__27964__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__27965__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq37422){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37422));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__27964__auto__ = [];
var len__27957__auto___37427 = arguments.length;
var i__27958__auto___37428 = (0);
while(true){
if((i__27958__auto___37428 < len__27957__auto___37427)){
args__27964__auto__.push((arguments[i__27958__auto___37428]));

var G__37429 = (i__27958__auto___37428 + (1));
i__27958__auto___37428 = G__37429;
continue;
} else {
}
break;
}

var argseq__27965__auto__ = ((((0) < args__27964__auto__.length))?(new cljs.core.IndexedSeq(args__27964__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__27965__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq37426){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37426));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)")].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Figwheel autoloading "),cljs.core.str((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method. 
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 *   
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__37430){
var map__37433 = p__37430;
var map__37433__$1 = ((((!((map__37433 == null)))?((((map__37433.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37433.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37433):map__37433);
var message = cljs.core.get.call(null,map__37433__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__37433__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str(class$),cljs.core.str(" : "),cljs.core.str(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__26741__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__26729__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__26729__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__26729__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__30034__auto___37595 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___37595,ch){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___37595,ch){
return (function (state_37564){
var state_val_37565 = (state_37564[(1)]);
if((state_val_37565 === (7))){
var inst_37560 = (state_37564[(2)]);
var state_37564__$1 = state_37564;
var statearr_37566_37596 = state_37564__$1;
(statearr_37566_37596[(2)] = inst_37560);

(statearr_37566_37596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37565 === (1))){
var state_37564__$1 = state_37564;
var statearr_37567_37597 = state_37564__$1;
(statearr_37567_37597[(2)] = null);

(statearr_37567_37597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37565 === (4))){
var inst_37517 = (state_37564[(7)]);
var inst_37517__$1 = (state_37564[(2)]);
var state_37564__$1 = (function (){var statearr_37568 = state_37564;
(statearr_37568[(7)] = inst_37517__$1);

return statearr_37568;
})();
if(cljs.core.truth_(inst_37517__$1)){
var statearr_37569_37598 = state_37564__$1;
(statearr_37569_37598[(1)] = (5));

} else {
var statearr_37570_37599 = state_37564__$1;
(statearr_37570_37599[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37565 === (15))){
var inst_37524 = (state_37564[(8)]);
var inst_37539 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_37524);
var inst_37540 = cljs.core.first.call(null,inst_37539);
var inst_37541 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_37540);
var inst_37542 = [cljs.core.str("Figwheel: Not loading code with warnings - "),cljs.core.str(inst_37541)].join('');
var inst_37543 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_37542);
var state_37564__$1 = state_37564;
var statearr_37571_37600 = state_37564__$1;
(statearr_37571_37600[(2)] = inst_37543);

(statearr_37571_37600[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37565 === (13))){
var inst_37548 = (state_37564[(2)]);
var state_37564__$1 = state_37564;
var statearr_37572_37601 = state_37564__$1;
(statearr_37572_37601[(2)] = inst_37548);

(statearr_37572_37601[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37565 === (6))){
var state_37564__$1 = state_37564;
var statearr_37573_37602 = state_37564__$1;
(statearr_37573_37602[(2)] = null);

(statearr_37573_37602[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37565 === (17))){
var inst_37546 = (state_37564[(2)]);
var state_37564__$1 = state_37564;
var statearr_37574_37603 = state_37564__$1;
(statearr_37574_37603[(2)] = inst_37546);

(statearr_37574_37603[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37565 === (3))){
var inst_37562 = (state_37564[(2)]);
var state_37564__$1 = state_37564;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37564__$1,inst_37562);
} else {
if((state_val_37565 === (12))){
var inst_37523 = (state_37564[(9)]);
var inst_37537 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_37523,opts);
var state_37564__$1 = state_37564;
if(cljs.core.truth_(inst_37537)){
var statearr_37575_37604 = state_37564__$1;
(statearr_37575_37604[(1)] = (15));

} else {
var statearr_37576_37605 = state_37564__$1;
(statearr_37576_37605[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37565 === (2))){
var state_37564__$1 = state_37564;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37564__$1,(4),ch);
} else {
if((state_val_37565 === (11))){
var inst_37524 = (state_37564[(8)]);
var inst_37529 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37530 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_37524);
var inst_37531 = cljs.core.async.timeout.call(null,(1000));
var inst_37532 = [inst_37530,inst_37531];
var inst_37533 = (new cljs.core.PersistentVector(null,2,(5),inst_37529,inst_37532,null));
var state_37564__$1 = state_37564;
return cljs.core.async.ioc_alts_BANG_.call(null,state_37564__$1,(14),inst_37533);
} else {
if((state_val_37565 === (9))){
var inst_37524 = (state_37564[(8)]);
var inst_37550 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_37551 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_37524);
var inst_37552 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_37551);
var inst_37553 = [cljs.core.str("Not loading: "),cljs.core.str(inst_37552)].join('');
var inst_37554 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_37553);
var state_37564__$1 = (function (){var statearr_37577 = state_37564;
(statearr_37577[(10)] = inst_37550);

return statearr_37577;
})();
var statearr_37578_37606 = state_37564__$1;
(statearr_37578_37606[(2)] = inst_37554);

(statearr_37578_37606[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37565 === (5))){
var inst_37517 = (state_37564[(7)]);
var inst_37519 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_37520 = (new cljs.core.PersistentArrayMap(null,2,inst_37519,null));
var inst_37521 = (new cljs.core.PersistentHashSet(null,inst_37520,null));
var inst_37522 = figwheel.client.focus_msgs.call(null,inst_37521,inst_37517);
var inst_37523 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_37522);
var inst_37524 = cljs.core.first.call(null,inst_37522);
var inst_37525 = figwheel.client.autoload_QMARK_.call(null);
var state_37564__$1 = (function (){var statearr_37579 = state_37564;
(statearr_37579[(8)] = inst_37524);

(statearr_37579[(9)] = inst_37523);

return statearr_37579;
})();
if(cljs.core.truth_(inst_37525)){
var statearr_37580_37607 = state_37564__$1;
(statearr_37580_37607[(1)] = (8));

} else {
var statearr_37581_37608 = state_37564__$1;
(statearr_37581_37608[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37565 === (14))){
var inst_37535 = (state_37564[(2)]);
var state_37564__$1 = state_37564;
var statearr_37582_37609 = state_37564__$1;
(statearr_37582_37609[(2)] = inst_37535);

(statearr_37582_37609[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37565 === (16))){
var state_37564__$1 = state_37564;
var statearr_37583_37610 = state_37564__$1;
(statearr_37583_37610[(2)] = null);

(statearr_37583_37610[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37565 === (10))){
var inst_37556 = (state_37564[(2)]);
var state_37564__$1 = (function (){var statearr_37584 = state_37564;
(statearr_37584[(11)] = inst_37556);

return statearr_37584;
})();
var statearr_37585_37611 = state_37564__$1;
(statearr_37585_37611[(2)] = null);

(statearr_37585_37611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37565 === (8))){
var inst_37523 = (state_37564[(9)]);
var inst_37527 = figwheel.client.reload_file_state_QMARK_.call(null,inst_37523,opts);
var state_37564__$1 = state_37564;
if(cljs.core.truth_(inst_37527)){
var statearr_37586_37612 = state_37564__$1;
(statearr_37586_37612[(1)] = (11));

} else {
var statearr_37587_37613 = state_37564__$1;
(statearr_37587_37613[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto___37595,ch))
;
return ((function (switch__29920__auto__,c__30034__auto___37595,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__29921__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__29921__auto____0 = (function (){
var statearr_37591 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37591[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__29921__auto__);

(statearr_37591[(1)] = (1));

return statearr_37591;
});
var figwheel$client$file_reloader_plugin_$_state_machine__29921__auto____1 = (function (state_37564){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_37564);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e37592){if((e37592 instanceof Object)){
var ex__29924__auto__ = e37592;
var statearr_37593_37614 = state_37564;
(statearr_37593_37614[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37564);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37592;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37615 = state_37564;
state_37564 = G__37615;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__29921__auto__ = function(state_37564){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__29921__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__29921__auto____1.call(this,state_37564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__29921__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__29921__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___37595,ch))
})();
var state__30036__auto__ = (function (){var statearr_37594 = f__30035__auto__.call(null);
(statearr_37594[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___37595);

return statearr_37594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___37595,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__37616_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__37616_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_37619 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_37619){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e37618){if((e37618 instanceof Error)){
var e = e37618;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_37619], null));
} else {
var e = e37618;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_37619))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__37620){
var map__37629 = p__37620;
var map__37629__$1 = ((((!((map__37629 == null)))?((((map__37629.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37629.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37629):map__37629);
var opts = map__37629__$1;
var build_id = cljs.core.get.call(null,map__37629__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__37629,map__37629__$1,opts,build_id){
return (function (p__37631){
var vec__37632 = p__37631;
var seq__37633 = cljs.core.seq.call(null,vec__37632);
var first__37634 = cljs.core.first.call(null,seq__37633);
var seq__37633__$1 = cljs.core.next.call(null,seq__37633);
var map__37635 = first__37634;
var map__37635__$1 = ((((!((map__37635 == null)))?((((map__37635.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37635.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37635):map__37635);
var msg = map__37635__$1;
var msg_name = cljs.core.get.call(null,map__37635__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__37633__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__37632,seq__37633,first__37634,seq__37633__$1,map__37635,map__37635__$1,msg,msg_name,_,map__37629,map__37629__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__37632,seq__37633,first__37634,seq__37633__$1,map__37635,map__37635__$1,msg,msg_name,_,map__37629,map__37629__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__37629,map__37629__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__37643){
var vec__37644 = p__37643;
var seq__37645 = cljs.core.seq.call(null,vec__37644);
var first__37646 = cljs.core.first.call(null,seq__37645);
var seq__37645__$1 = cljs.core.next.call(null,seq__37645);
var map__37647 = first__37646;
var map__37647__$1 = ((((!((map__37647 == null)))?((((map__37647.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37647.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37647):map__37647);
var msg = map__37647__$1;
var msg_name = cljs.core.get.call(null,map__37647__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__37645__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__37649){
var map__37661 = p__37649;
var map__37661__$1 = ((((!((map__37661 == null)))?((((map__37661.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37661.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37661):map__37661);
var on_compile_warning = cljs.core.get.call(null,map__37661__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__37661__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__37661,map__37661__$1,on_compile_warning,on_compile_fail){
return (function (p__37663){
var vec__37664 = p__37663;
var seq__37665 = cljs.core.seq.call(null,vec__37664);
var first__37666 = cljs.core.first.call(null,seq__37665);
var seq__37665__$1 = cljs.core.next.call(null,seq__37665);
var map__37667 = first__37666;
var map__37667__$1 = ((((!((map__37667 == null)))?((((map__37667.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37667.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37667):map__37667);
var msg = map__37667__$1;
var msg_name = cljs.core.get.call(null,map__37667__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__37665__$1;
var pred__37669 = cljs.core._EQ_;
var expr__37670 = msg_name;
if(cljs.core.truth_(pred__37669.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__37670))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__37669.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__37670))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__37661,map__37661__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__30034__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto__,msg_hist,msg_names,msg){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto__,msg_hist,msg_names,msg){
return (function (state_37898){
var state_val_37899 = (state_37898[(1)]);
if((state_val_37899 === (7))){
var inst_37818 = (state_37898[(2)]);
var state_37898__$1 = state_37898;
if(cljs.core.truth_(inst_37818)){
var statearr_37900_37950 = state_37898__$1;
(statearr_37900_37950[(1)] = (8));

} else {
var statearr_37901_37951 = state_37898__$1;
(statearr_37901_37951[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (20))){
var inst_37892 = (state_37898[(2)]);
var state_37898__$1 = state_37898;
var statearr_37902_37952 = state_37898__$1;
(statearr_37902_37952[(2)] = inst_37892);

(statearr_37902_37952[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (27))){
var inst_37888 = (state_37898[(2)]);
var state_37898__$1 = state_37898;
var statearr_37903_37953 = state_37898__$1;
(statearr_37903_37953[(2)] = inst_37888);

(statearr_37903_37953[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (1))){
var inst_37811 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_37898__$1 = state_37898;
if(cljs.core.truth_(inst_37811)){
var statearr_37904_37954 = state_37898__$1;
(statearr_37904_37954[(1)] = (2));

} else {
var statearr_37905_37955 = state_37898__$1;
(statearr_37905_37955[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (24))){
var inst_37890 = (state_37898[(2)]);
var state_37898__$1 = state_37898;
var statearr_37906_37956 = state_37898__$1;
(statearr_37906_37956[(2)] = inst_37890);

(statearr_37906_37956[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (4))){
var inst_37896 = (state_37898[(2)]);
var state_37898__$1 = state_37898;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37898__$1,inst_37896);
} else {
if((state_val_37899 === (15))){
var inst_37894 = (state_37898[(2)]);
var state_37898__$1 = state_37898;
var statearr_37907_37957 = state_37898__$1;
(statearr_37907_37957[(2)] = inst_37894);

(statearr_37907_37957[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (21))){
var inst_37847 = (state_37898[(2)]);
var inst_37848 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37849 = figwheel.client.auto_jump_to_error.call(null,opts,inst_37848);
var state_37898__$1 = (function (){var statearr_37908 = state_37898;
(statearr_37908[(7)] = inst_37847);

return statearr_37908;
})();
var statearr_37909_37958 = state_37898__$1;
(statearr_37909_37958[(2)] = inst_37849);

(statearr_37909_37958[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (31))){
var inst_37877 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_37898__$1 = state_37898;
if(cljs.core.truth_(inst_37877)){
var statearr_37910_37959 = state_37898__$1;
(statearr_37910_37959[(1)] = (34));

} else {
var statearr_37911_37960 = state_37898__$1;
(statearr_37911_37960[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (32))){
var inst_37886 = (state_37898[(2)]);
var state_37898__$1 = state_37898;
var statearr_37912_37961 = state_37898__$1;
(statearr_37912_37961[(2)] = inst_37886);

(statearr_37912_37961[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (33))){
var inst_37873 = (state_37898[(2)]);
var inst_37874 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37875 = figwheel.client.auto_jump_to_error.call(null,opts,inst_37874);
var state_37898__$1 = (function (){var statearr_37913 = state_37898;
(statearr_37913[(8)] = inst_37873);

return statearr_37913;
})();
var statearr_37914_37962 = state_37898__$1;
(statearr_37914_37962[(2)] = inst_37875);

(statearr_37914_37962[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (13))){
var inst_37832 = figwheel.client.heads_up.clear.call(null);
var state_37898__$1 = state_37898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37898__$1,(16),inst_37832);
} else {
if((state_val_37899 === (22))){
var inst_37853 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37854 = figwheel.client.heads_up.append_warning_message.call(null,inst_37853);
var state_37898__$1 = state_37898;
var statearr_37915_37963 = state_37898__$1;
(statearr_37915_37963[(2)] = inst_37854);

(statearr_37915_37963[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (36))){
var inst_37884 = (state_37898[(2)]);
var state_37898__$1 = state_37898;
var statearr_37916_37964 = state_37898__$1;
(statearr_37916_37964[(2)] = inst_37884);

(statearr_37916_37964[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (29))){
var inst_37864 = (state_37898[(2)]);
var inst_37865 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37866 = figwheel.client.auto_jump_to_error.call(null,opts,inst_37865);
var state_37898__$1 = (function (){var statearr_37917 = state_37898;
(statearr_37917[(9)] = inst_37864);

return statearr_37917;
})();
var statearr_37918_37965 = state_37898__$1;
(statearr_37918_37965[(2)] = inst_37866);

(statearr_37918_37965[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (6))){
var inst_37813 = (state_37898[(10)]);
var state_37898__$1 = state_37898;
var statearr_37919_37966 = state_37898__$1;
(statearr_37919_37966[(2)] = inst_37813);

(statearr_37919_37966[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (28))){
var inst_37860 = (state_37898[(2)]);
var inst_37861 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37862 = figwheel.client.heads_up.display_warning.call(null,inst_37861);
var state_37898__$1 = (function (){var statearr_37920 = state_37898;
(statearr_37920[(11)] = inst_37860);

return statearr_37920;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37898__$1,(29),inst_37862);
} else {
if((state_val_37899 === (25))){
var inst_37858 = figwheel.client.heads_up.clear.call(null);
var state_37898__$1 = state_37898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37898__$1,(28),inst_37858);
} else {
if((state_val_37899 === (34))){
var inst_37879 = figwheel.client.heads_up.flash_loaded.call(null);
var state_37898__$1 = state_37898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37898__$1,(37),inst_37879);
} else {
if((state_val_37899 === (17))){
var inst_37838 = (state_37898[(2)]);
var inst_37839 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37840 = figwheel.client.auto_jump_to_error.call(null,opts,inst_37839);
var state_37898__$1 = (function (){var statearr_37921 = state_37898;
(statearr_37921[(12)] = inst_37838);

return statearr_37921;
})();
var statearr_37922_37967 = state_37898__$1;
(statearr_37922_37967[(2)] = inst_37840);

(statearr_37922_37967[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (3))){
var inst_37830 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_37898__$1 = state_37898;
if(cljs.core.truth_(inst_37830)){
var statearr_37923_37968 = state_37898__$1;
(statearr_37923_37968[(1)] = (13));

} else {
var statearr_37924_37969 = state_37898__$1;
(statearr_37924_37969[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (12))){
var inst_37826 = (state_37898[(2)]);
var state_37898__$1 = state_37898;
var statearr_37925_37970 = state_37898__$1;
(statearr_37925_37970[(2)] = inst_37826);

(statearr_37925_37970[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (2))){
var inst_37813 = (state_37898[(10)]);
var inst_37813__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_37898__$1 = (function (){var statearr_37926 = state_37898;
(statearr_37926[(10)] = inst_37813__$1);

return statearr_37926;
})();
if(cljs.core.truth_(inst_37813__$1)){
var statearr_37927_37971 = state_37898__$1;
(statearr_37927_37971[(1)] = (5));

} else {
var statearr_37928_37972 = state_37898__$1;
(statearr_37928_37972[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (23))){
var inst_37856 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_37898__$1 = state_37898;
if(cljs.core.truth_(inst_37856)){
var statearr_37929_37973 = state_37898__$1;
(statearr_37929_37973[(1)] = (25));

} else {
var statearr_37930_37974 = state_37898__$1;
(statearr_37930_37974[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (35))){
var state_37898__$1 = state_37898;
var statearr_37931_37975 = state_37898__$1;
(statearr_37931_37975[(2)] = null);

(statearr_37931_37975[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (19))){
var inst_37851 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_37898__$1 = state_37898;
if(cljs.core.truth_(inst_37851)){
var statearr_37932_37976 = state_37898__$1;
(statearr_37932_37976[(1)] = (22));

} else {
var statearr_37933_37977 = state_37898__$1;
(statearr_37933_37977[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (11))){
var inst_37822 = (state_37898[(2)]);
var state_37898__$1 = state_37898;
var statearr_37934_37978 = state_37898__$1;
(statearr_37934_37978[(2)] = inst_37822);

(statearr_37934_37978[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (9))){
var inst_37824 = figwheel.client.heads_up.clear.call(null);
var state_37898__$1 = state_37898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37898__$1,(12),inst_37824);
} else {
if((state_val_37899 === (5))){
var inst_37815 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_37898__$1 = state_37898;
var statearr_37935_37979 = state_37898__$1;
(statearr_37935_37979[(2)] = inst_37815);

(statearr_37935_37979[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (14))){
var inst_37842 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_37898__$1 = state_37898;
if(cljs.core.truth_(inst_37842)){
var statearr_37936_37980 = state_37898__$1;
(statearr_37936_37980[(1)] = (18));

} else {
var statearr_37937_37981 = state_37898__$1;
(statearr_37937_37981[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (26))){
var inst_37868 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_37898__$1 = state_37898;
if(cljs.core.truth_(inst_37868)){
var statearr_37938_37982 = state_37898__$1;
(statearr_37938_37982[(1)] = (30));

} else {
var statearr_37939_37983 = state_37898__$1;
(statearr_37939_37983[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (16))){
var inst_37834 = (state_37898[(2)]);
var inst_37835 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37836 = figwheel.client.heads_up.display_exception.call(null,inst_37835);
var state_37898__$1 = (function (){var statearr_37940 = state_37898;
(statearr_37940[(13)] = inst_37834);

return statearr_37940;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37898__$1,(17),inst_37836);
} else {
if((state_val_37899 === (30))){
var inst_37870 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37871 = figwheel.client.heads_up.display_warning.call(null,inst_37870);
var state_37898__$1 = state_37898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37898__$1,(33),inst_37871);
} else {
if((state_val_37899 === (10))){
var inst_37828 = (state_37898[(2)]);
var state_37898__$1 = state_37898;
var statearr_37941_37984 = state_37898__$1;
(statearr_37941_37984[(2)] = inst_37828);

(statearr_37941_37984[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (18))){
var inst_37844 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_37845 = figwheel.client.heads_up.display_exception.call(null,inst_37844);
var state_37898__$1 = state_37898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37898__$1,(21),inst_37845);
} else {
if((state_val_37899 === (37))){
var inst_37881 = (state_37898[(2)]);
var state_37898__$1 = state_37898;
var statearr_37942_37985 = state_37898__$1;
(statearr_37942_37985[(2)] = inst_37881);

(statearr_37942_37985[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37899 === (8))){
var inst_37820 = figwheel.client.heads_up.flash_loaded.call(null);
var state_37898__$1 = state_37898;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37898__$1,(11),inst_37820);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__29920__auto__,c__30034__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29921__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29921__auto____0 = (function (){
var statearr_37946 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37946[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29921__auto__);

(statearr_37946[(1)] = (1));

return statearr_37946;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29921__auto____1 = (function (state_37898){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_37898);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e37947){if((e37947 instanceof Object)){
var ex__29924__auto__ = e37947;
var statearr_37948_37986 = state_37898;
(statearr_37948_37986[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37898);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37947;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37987 = state_37898;
state_37898 = G__37987;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29921__auto__ = function(state_37898){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29921__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29921__auto____1.call(this,state_37898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29921__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29921__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto__,msg_hist,msg_names,msg))
})();
var state__30036__auto__ = (function (){var statearr_37949 = f__30035__auto__.call(null);
(statearr_37949[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto__);

return statearr_37949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto__,msg_hist,msg_names,msg))
);

return c__30034__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__30034__auto___38050 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___38050,ch){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___38050,ch){
return (function (state_38033){
var state_val_38034 = (state_38033[(1)]);
if((state_val_38034 === (1))){
var state_38033__$1 = state_38033;
var statearr_38035_38051 = state_38033__$1;
(statearr_38035_38051[(2)] = null);

(statearr_38035_38051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38034 === (2))){
var state_38033__$1 = state_38033;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38033__$1,(4),ch);
} else {
if((state_val_38034 === (3))){
var inst_38031 = (state_38033[(2)]);
var state_38033__$1 = state_38033;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38033__$1,inst_38031);
} else {
if((state_val_38034 === (4))){
var inst_38021 = (state_38033[(7)]);
var inst_38021__$1 = (state_38033[(2)]);
var state_38033__$1 = (function (){var statearr_38036 = state_38033;
(statearr_38036[(7)] = inst_38021__$1);

return statearr_38036;
})();
if(cljs.core.truth_(inst_38021__$1)){
var statearr_38037_38052 = state_38033__$1;
(statearr_38037_38052[(1)] = (5));

} else {
var statearr_38038_38053 = state_38033__$1;
(statearr_38038_38053[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38034 === (5))){
var inst_38021 = (state_38033[(7)]);
var inst_38023 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_38021);
var state_38033__$1 = state_38033;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38033__$1,(8),inst_38023);
} else {
if((state_val_38034 === (6))){
var state_38033__$1 = state_38033;
var statearr_38039_38054 = state_38033__$1;
(statearr_38039_38054[(2)] = null);

(statearr_38039_38054[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38034 === (7))){
var inst_38029 = (state_38033[(2)]);
var state_38033__$1 = state_38033;
var statearr_38040_38055 = state_38033__$1;
(statearr_38040_38055[(2)] = inst_38029);

(statearr_38040_38055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38034 === (8))){
var inst_38025 = (state_38033[(2)]);
var state_38033__$1 = (function (){var statearr_38041 = state_38033;
(statearr_38041[(8)] = inst_38025);

return statearr_38041;
})();
var statearr_38042_38056 = state_38033__$1;
(statearr_38042_38056[(2)] = null);

(statearr_38042_38056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__30034__auto___38050,ch))
;
return ((function (switch__29920__auto__,c__30034__auto___38050,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__29921__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__29921__auto____0 = (function (){
var statearr_38046 = [null,null,null,null,null,null,null,null,null];
(statearr_38046[(0)] = figwheel$client$heads_up_plugin_$_state_machine__29921__auto__);

(statearr_38046[(1)] = (1));

return statearr_38046;
});
var figwheel$client$heads_up_plugin_$_state_machine__29921__auto____1 = (function (state_38033){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_38033);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e38047){if((e38047 instanceof Object)){
var ex__29924__auto__ = e38047;
var statearr_38048_38057 = state_38033;
(statearr_38048_38057[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38033);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38047;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38058 = state_38033;
state_38033 = G__38058;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__29921__auto__ = function(state_38033){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__29921__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__29921__auto____1.call(this,state_38033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__29921__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__29921__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___38050,ch))
})();
var state__30036__auto__ = (function (){var statearr_38049 = f__30035__auto__.call(null);
(statearr_38049[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___38050);

return statearr_38049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___38050,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__30034__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto__){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto__){
return (function (state_38079){
var state_val_38080 = (state_38079[(1)]);
if((state_val_38080 === (1))){
var inst_38074 = cljs.core.async.timeout.call(null,(3000));
var state_38079__$1 = state_38079;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38079__$1,(2),inst_38074);
} else {
if((state_val_38080 === (2))){
var inst_38076 = (state_38079[(2)]);
var inst_38077 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_38079__$1 = (function (){var statearr_38081 = state_38079;
(statearr_38081[(7)] = inst_38076);

return statearr_38081;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38079__$1,inst_38077);
} else {
return null;
}
}
});})(c__30034__auto__))
;
return ((function (switch__29920__auto__,c__30034__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__29921__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__29921__auto____0 = (function (){
var statearr_38085 = [null,null,null,null,null,null,null,null];
(statearr_38085[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__29921__auto__);

(statearr_38085[(1)] = (1));

return statearr_38085;
});
var figwheel$client$enforce_project_plugin_$_state_machine__29921__auto____1 = (function (state_38079){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_38079);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e38086){if((e38086 instanceof Object)){
var ex__29924__auto__ = e38086;
var statearr_38087_38089 = state_38079;
(statearr_38087_38089[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38079);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38086;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38090 = state_38079;
state_38079 = G__38090;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__29921__auto__ = function(state_38079){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__29921__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__29921__auto____1.call(this,state_38079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__29921__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__29921__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto__))
})();
var state__30036__auto__ = (function (){var statearr_38088 = f__30035__auto__.call(null);
(statearr_38088[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto__);

return statearr_38088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto__))
);

return c__30034__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__6753__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__6753__auto__)){
var figwheel_version = temp__6753__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__30034__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto__,figwheel_version,temp__6753__auto__){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto__,figwheel_version,temp__6753__auto__){
return (function (state_38113){
var state_val_38114 = (state_38113[(1)]);
if((state_val_38114 === (1))){
var inst_38107 = cljs.core.async.timeout.call(null,(2000));
var state_38113__$1 = state_38113;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38113__$1,(2),inst_38107);
} else {
if((state_val_38114 === (2))){
var inst_38109 = (state_38113[(2)]);
var inst_38110 = [cljs.core.str("Figwheel Client Version <strong>"),cljs.core.str(figwheel.client._figwheel_version_),cljs.core.str("</strong> is not equal to "),cljs.core.str("Figwheel Sidecar Version <strong>"),cljs.core.str(figwheel_version),cljs.core.str("</strong>"),cljs.core.str(".  Shutting down Websocket Connection!"),cljs.core.str("<h4>To fix try:</h4>"),cljs.core.str("<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>"),cljs.core.str("<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>"),cljs.core.str("<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>")].join('');
var inst_38111 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_38110);
var state_38113__$1 = (function (){var statearr_38115 = state_38113;
(statearr_38115[(7)] = inst_38109);

return statearr_38115;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38113__$1,inst_38111);
} else {
return null;
}
}
});})(c__30034__auto__,figwheel_version,temp__6753__auto__))
;
return ((function (switch__29920__auto__,c__30034__auto__,figwheel_version,temp__6753__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29921__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29921__auto____0 = (function (){
var statearr_38119 = [null,null,null,null,null,null,null,null];
(statearr_38119[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29921__auto__);

(statearr_38119[(1)] = (1));

return statearr_38119;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29921__auto____1 = (function (state_38113){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_38113);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e38120){if((e38120 instanceof Object)){
var ex__29924__auto__ = e38120;
var statearr_38121_38123 = state_38113;
(statearr_38121_38123[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38113);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38124 = state_38113;
state_38113 = G__38124;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29921__auto__ = function(state_38113){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29921__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29921__auto____1.call(this,state_38113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29921__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29921__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto__,figwheel_version,temp__6753__auto__))
})();
var state__30036__auto__ = (function (){var statearr_38122 = f__30035__auto__.call(null);
(statearr_38122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto__);

return statearr_38122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto__,figwheel_version,temp__6753__auto__))
);

return c__30034__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__38125){
var map__38129 = p__38125;
var map__38129__$1 = ((((!((map__38129 == null)))?((((map__38129.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38129.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38129):map__38129);
var file = cljs.core.get.call(null,map__38129__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__38129__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__38129__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__38131 = "";
var G__38131__$1 = (cljs.core.truth_(file)?[cljs.core.str(G__38131),cljs.core.str("file "),cljs.core.str(file)].join(''):G__38131);
var G__38131__$2 = (cljs.core.truth_(line)?[cljs.core.str(G__38131__$1),cljs.core.str(" at line "),cljs.core.str(line)].join(''):G__38131__$1);
if(cljs.core.truth_((function (){var and__26729__auto__ = line;
if(cljs.core.truth_(and__26729__auto__)){
return column;
} else {
return and__26729__auto__;
}
})())){
return [cljs.core.str(G__38131__$2),cljs.core.str(", column "),cljs.core.str(column)].join('');
} else {
return G__38131__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__38132){
var map__38139 = p__38132;
var map__38139__$1 = ((((!((map__38139 == null)))?((((map__38139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38139.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38139):map__38139);
var ed = map__38139__$1;
var formatted_exception = cljs.core.get.call(null,map__38139__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__38139__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__38139__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__38141_38145 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__38142_38146 = null;
var count__38143_38147 = (0);
var i__38144_38148 = (0);
while(true){
if((i__38144_38148 < count__38143_38147)){
var msg_38149 = cljs.core._nth.call(null,chunk__38142_38146,i__38144_38148);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_38149);

var G__38150 = seq__38141_38145;
var G__38151 = chunk__38142_38146;
var G__38152 = count__38143_38147;
var G__38153 = (i__38144_38148 + (1));
seq__38141_38145 = G__38150;
chunk__38142_38146 = G__38151;
count__38143_38147 = G__38152;
i__38144_38148 = G__38153;
continue;
} else {
var temp__6753__auto___38154 = cljs.core.seq.call(null,seq__38141_38145);
if(temp__6753__auto___38154){
var seq__38141_38155__$1 = temp__6753__auto___38154;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38141_38155__$1)){
var c__27647__auto___38156 = cljs.core.chunk_first.call(null,seq__38141_38155__$1);
var G__38157 = cljs.core.chunk_rest.call(null,seq__38141_38155__$1);
var G__38158 = c__27647__auto___38156;
var G__38159 = cljs.core.count.call(null,c__27647__auto___38156);
var G__38160 = (0);
seq__38141_38145 = G__38157;
chunk__38142_38146 = G__38158;
count__38143_38147 = G__38159;
i__38144_38148 = G__38160;
continue;
} else {
var msg_38161 = cljs.core.first.call(null,seq__38141_38155__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_38161);

var G__38162 = cljs.core.next.call(null,seq__38141_38155__$1);
var G__38163 = null;
var G__38164 = (0);
var G__38165 = (0);
seq__38141_38145 = G__38162;
chunk__38142_38146 = G__38163;
count__38143_38147 = G__38164;
i__38144_38148 = G__38165;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Error on "),cljs.core.str(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__38166){
var map__38169 = p__38166;
var map__38169__$1 = ((((!((map__38169 == null)))?((((map__38169.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38169.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38169):map__38169);
var w = map__38169__$1;
var message = cljs.core.get.call(null,map__38169__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str("Figwheel: Compile Warning - "),cljs.core.str(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message)),cljs.core.str(" in "),cljs.core.str(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/out/figwheel/client.cljs",33,1,357,357,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/out/figwheel/client.cljs",30,1,349,349,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,[cljs.core.str("ws://"),cljs.core.str((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str("/figwheel-ws")].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__26729__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__26729__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__26729__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__38181 = cljs.core.seq.call(null,plugins);
var chunk__38182 = null;
var count__38183 = (0);
var i__38184 = (0);
while(true){
if((i__38184 < count__38183)){
var vec__38185 = cljs.core._nth.call(null,chunk__38182,i__38184);
var k = cljs.core.nth.call(null,vec__38185,(0),null);
var plugin = cljs.core.nth.call(null,vec__38185,(1),null);
if(cljs.core.truth_(plugin)){
var pl_38191 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__38181,chunk__38182,count__38183,i__38184,pl_38191,vec__38185,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_38191.call(null,msg_hist);
});})(seq__38181,chunk__38182,count__38183,i__38184,pl_38191,vec__38185,k,plugin))
);
} else {
}

var G__38192 = seq__38181;
var G__38193 = chunk__38182;
var G__38194 = count__38183;
var G__38195 = (i__38184 + (1));
seq__38181 = G__38192;
chunk__38182 = G__38193;
count__38183 = G__38194;
i__38184 = G__38195;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__38181);
if(temp__6753__auto__){
var seq__38181__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38181__$1)){
var c__27647__auto__ = cljs.core.chunk_first.call(null,seq__38181__$1);
var G__38196 = cljs.core.chunk_rest.call(null,seq__38181__$1);
var G__38197 = c__27647__auto__;
var G__38198 = cljs.core.count.call(null,c__27647__auto__);
var G__38199 = (0);
seq__38181 = G__38196;
chunk__38182 = G__38197;
count__38183 = G__38198;
i__38184 = G__38199;
continue;
} else {
var vec__38188 = cljs.core.first.call(null,seq__38181__$1);
var k = cljs.core.nth.call(null,vec__38188,(0),null);
var plugin = cljs.core.nth.call(null,vec__38188,(1),null);
if(cljs.core.truth_(plugin)){
var pl_38200 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__38181,chunk__38182,count__38183,i__38184,pl_38200,vec__38188,k,plugin,seq__38181__$1,temp__6753__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_38200.call(null,msg_hist);
});})(seq__38181,chunk__38182,count__38183,i__38184,pl_38200,vec__38188,k,plugin,seq__38181__$1,temp__6753__auto__))
);
} else {
}

var G__38201 = cljs.core.next.call(null,seq__38181__$1);
var G__38202 = null;
var G__38203 = (0);
var G__38204 = (0);
seq__38181 = G__38201;
chunk__38182 = G__38202;
count__38183 = G__38203;
i__38184 = G__38204;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args38205 = [];
var len__27957__auto___38212 = arguments.length;
var i__27958__auto___38213 = (0);
while(true){
if((i__27958__auto___38213 < len__27957__auto___38212)){
args38205.push((arguments[i__27958__auto___38213]));

var G__38214 = (i__27958__auto___38213 + (1));
i__27958__auto___38213 = G__38214;
continue;
} else {
}
break;
}

var G__38207 = args38205.length;
switch (G__38207) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38205.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__38208_38216 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__38209_38217 = null;
var count__38210_38218 = (0);
var i__38211_38219 = (0);
while(true){
if((i__38211_38219 < count__38210_38218)){
var msg_38220 = cljs.core._nth.call(null,chunk__38209_38217,i__38211_38219);
figwheel.client.socket.handle_incoming_message.call(null,msg_38220);

var G__38221 = seq__38208_38216;
var G__38222 = chunk__38209_38217;
var G__38223 = count__38210_38218;
var G__38224 = (i__38211_38219 + (1));
seq__38208_38216 = G__38221;
chunk__38209_38217 = G__38222;
count__38210_38218 = G__38223;
i__38211_38219 = G__38224;
continue;
} else {
var temp__6753__auto___38225 = cljs.core.seq.call(null,seq__38208_38216);
if(temp__6753__auto___38225){
var seq__38208_38226__$1 = temp__6753__auto___38225;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38208_38226__$1)){
var c__27647__auto___38227 = cljs.core.chunk_first.call(null,seq__38208_38226__$1);
var G__38228 = cljs.core.chunk_rest.call(null,seq__38208_38226__$1);
var G__38229 = c__27647__auto___38227;
var G__38230 = cljs.core.count.call(null,c__27647__auto___38227);
var G__38231 = (0);
seq__38208_38216 = G__38228;
chunk__38209_38217 = G__38229;
count__38210_38218 = G__38230;
i__38211_38219 = G__38231;
continue;
} else {
var msg_38232 = cljs.core.first.call(null,seq__38208_38226__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_38232);

var G__38233 = cljs.core.next.call(null,seq__38208_38226__$1);
var G__38234 = null;
var G__38235 = (0);
var G__38236 = (0);
seq__38208_38216 = G__38233;
chunk__38209_38217 = G__38234;
count__38210_38218 = G__38235;
i__38211_38219 = G__38236;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__27964__auto__ = [];
var len__27957__auto___38241 = arguments.length;
var i__27958__auto___38242 = (0);
while(true){
if((i__27958__auto___38242 < len__27957__auto___38241)){
args__27964__auto__.push((arguments[i__27958__auto___38242]));

var G__38243 = (i__27958__auto___38242 + (1));
i__27958__auto___38242 = G__38243;
continue;
} else {
}
break;
}

var argseq__27965__auto__ = ((((0) < args__27964__auto__.length))?(new cljs.core.IndexedSeq(args__27964__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__27965__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__38238){
var map__38239 = p__38238;
var map__38239__$1 = ((((!((map__38239 == null)))?((((map__38239.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38239.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38239):map__38239);
var opts = map__38239__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq38237){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38237));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e38245){if((e38245 instanceof Error)){
var e = e38245;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e38245;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__38249){
var map__38250 = p__38249;
var map__38250__$1 = ((((!((map__38250 == null)))?((((map__38250.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38250.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38250):map__38250);
var msg_name = cljs.core.get.call(null,map__38250__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1489589612167