# LineTree

Tree component for Reagent with support for vertical and horizontal orientations (demo: https://aw7.github.io/z-com-demo/#linetree).

## Installation

*To install the entire library see https://github.com/aw7/z-com.*

* add the dependency:
  ```Clojure
  :dependencies [[z-com/linetree "0.4.0"]]
  ````

* include the stylesheet `resources/public/css/linetree.css` in your HTML

## Usage

```Clojure
  (ns linetree-app
    (:require [reagent.core :as r]
              [z-com.core :as z]))

  (defn index []
    [:div [:h1 "Tree"]
      [z/linetree
        :repr :flex
        :orientation :h
        :node [:span "A"]
        :labels {:first "up" :last "down"}
        :branches
          [{:node [:span "B"]
            :labels {:first "B-up" :last "B-down"}}
           [linetree
             :repr :table
             :orientation :h
             :node [:span "C"]
             :labels {:first "only up"}
             :branches [[:span "C1"] [:span "C2"] [:span "C3"]]]
           [:span "D"]]]])
```

* `:repr` can be `:flex` (default) or `:table`

* `:orientation` can be horizontal `:h` or vertical `:v`

* `:node` can be any hiccup/string value

* `:labels` is a map specifying `:first` and/or `:last` with hiccup/string values

* `:branches` is a sequence of either hiccup/string values for terminal nodes, maps of linetree arguments, or nested linetree values
