// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.async.Deferred');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__26741__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__26741__auto__){
return or__26741__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__26741__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__33893_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__33893_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__33898 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__33899 = null;
var count__33900 = (0);
var i__33901 = (0);
while(true){
if((i__33901 < count__33900)){
var n = cljs.core._nth.call(null,chunk__33899,i__33901);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__33902 = seq__33898;
var G__33903 = chunk__33899;
var G__33904 = count__33900;
var G__33905 = (i__33901 + (1));
seq__33898 = G__33902;
chunk__33899 = G__33903;
count__33900 = G__33904;
i__33901 = G__33905;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__33898);
if(temp__6753__auto__){
var seq__33898__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33898__$1)){
var c__27647__auto__ = cljs.core.chunk_first.call(null,seq__33898__$1);
var G__33906 = cljs.core.chunk_rest.call(null,seq__33898__$1);
var G__33907 = c__27647__auto__;
var G__33908 = cljs.core.count.call(null,c__27647__auto__);
var G__33909 = (0);
seq__33898 = G__33906;
chunk__33899 = G__33907;
count__33900 = G__33908;
i__33901 = G__33909;
continue;
} else {
var n = cljs.core.first.call(null,seq__33898__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__33910 = cljs.core.next.call(null,seq__33898__$1);
var G__33911 = null;
var G__33912 = (0);
var G__33913 = (0);
seq__33898 = G__33910;
chunk__33899 = G__33911;
count__33900 = G__33912;
i__33901 = G__33913;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__33964_33975 = cljs.core.seq.call(null,deps);
var chunk__33965_33976 = null;
var count__33966_33977 = (0);
var i__33967_33978 = (0);
while(true){
if((i__33967_33978 < count__33966_33977)){
var dep_33979 = cljs.core._nth.call(null,chunk__33965_33976,i__33967_33978);
topo_sort_helper_STAR_.call(null,dep_33979,(depth + (1)),state);

var G__33980 = seq__33964_33975;
var G__33981 = chunk__33965_33976;
var G__33982 = count__33966_33977;
var G__33983 = (i__33967_33978 + (1));
seq__33964_33975 = G__33980;
chunk__33965_33976 = G__33981;
count__33966_33977 = G__33982;
i__33967_33978 = G__33983;
continue;
} else {
var temp__6753__auto___33984 = cljs.core.seq.call(null,seq__33964_33975);
if(temp__6753__auto___33984){
var seq__33964_33985__$1 = temp__6753__auto___33984;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33964_33985__$1)){
var c__27647__auto___33986 = cljs.core.chunk_first.call(null,seq__33964_33985__$1);
var G__33987 = cljs.core.chunk_rest.call(null,seq__33964_33985__$1);
var G__33988 = c__27647__auto___33986;
var G__33989 = cljs.core.count.call(null,c__27647__auto___33986);
var G__33990 = (0);
seq__33964_33975 = G__33987;
chunk__33965_33976 = G__33988;
count__33966_33977 = G__33989;
i__33967_33978 = G__33990;
continue;
} else {
var dep_33991 = cljs.core.first.call(null,seq__33964_33985__$1);
topo_sort_helper_STAR_.call(null,dep_33991,(depth + (1)),state);

var G__33992 = cljs.core.next.call(null,seq__33964_33985__$1);
var G__33993 = null;
var G__33994 = (0);
var G__33995 = (0);
seq__33964_33975 = G__33992;
chunk__33965_33976 = G__33993;
count__33966_33977 = G__33994;
i__33967_33978 = G__33995;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__33968){
var vec__33972 = p__33968;
var seq__33973 = cljs.core.seq.call(null,vec__33972);
var first__33974 = cljs.core.first.call(null,seq__33973);
var seq__33973__$1 = cljs.core.next.call(null,seq__33973);
var x = first__33974;
var xs = seq__33973__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__33972,seq__33973,first__33974,seq__33973__$1,x,xs,get_deps__$1){
return (function (p1__33914_SHARP_){
return clojure.set.difference.call(null,p1__33914_SHARP_,x);
});})(vec__33972,seq__33973,first__33974,seq__33973__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__34008 = cljs.core.seq.call(null,provides);
var chunk__34009 = null;
var count__34010 = (0);
var i__34011 = (0);
while(true){
if((i__34011 < count__34010)){
var prov = cljs.core._nth.call(null,chunk__34009,i__34011);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__34012_34020 = cljs.core.seq.call(null,requires);
var chunk__34013_34021 = null;
var count__34014_34022 = (0);
var i__34015_34023 = (0);
while(true){
if((i__34015_34023 < count__34014_34022)){
var req_34024 = cljs.core._nth.call(null,chunk__34013_34021,i__34015_34023);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34024,prov);

var G__34025 = seq__34012_34020;
var G__34026 = chunk__34013_34021;
var G__34027 = count__34014_34022;
var G__34028 = (i__34015_34023 + (1));
seq__34012_34020 = G__34025;
chunk__34013_34021 = G__34026;
count__34014_34022 = G__34027;
i__34015_34023 = G__34028;
continue;
} else {
var temp__6753__auto___34029 = cljs.core.seq.call(null,seq__34012_34020);
if(temp__6753__auto___34029){
var seq__34012_34030__$1 = temp__6753__auto___34029;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34012_34030__$1)){
var c__27647__auto___34031 = cljs.core.chunk_first.call(null,seq__34012_34030__$1);
var G__34032 = cljs.core.chunk_rest.call(null,seq__34012_34030__$1);
var G__34033 = c__27647__auto___34031;
var G__34034 = cljs.core.count.call(null,c__27647__auto___34031);
var G__34035 = (0);
seq__34012_34020 = G__34032;
chunk__34013_34021 = G__34033;
count__34014_34022 = G__34034;
i__34015_34023 = G__34035;
continue;
} else {
var req_34036 = cljs.core.first.call(null,seq__34012_34030__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34036,prov);

var G__34037 = cljs.core.next.call(null,seq__34012_34030__$1);
var G__34038 = null;
var G__34039 = (0);
var G__34040 = (0);
seq__34012_34020 = G__34037;
chunk__34013_34021 = G__34038;
count__34014_34022 = G__34039;
i__34015_34023 = G__34040;
continue;
}
} else {
}
}
break;
}

var G__34041 = seq__34008;
var G__34042 = chunk__34009;
var G__34043 = count__34010;
var G__34044 = (i__34011 + (1));
seq__34008 = G__34041;
chunk__34009 = G__34042;
count__34010 = G__34043;
i__34011 = G__34044;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__34008);
if(temp__6753__auto__){
var seq__34008__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34008__$1)){
var c__27647__auto__ = cljs.core.chunk_first.call(null,seq__34008__$1);
var G__34045 = cljs.core.chunk_rest.call(null,seq__34008__$1);
var G__34046 = c__27647__auto__;
var G__34047 = cljs.core.count.call(null,c__27647__auto__);
var G__34048 = (0);
seq__34008 = G__34045;
chunk__34009 = G__34046;
count__34010 = G__34047;
i__34011 = G__34048;
continue;
} else {
var prov = cljs.core.first.call(null,seq__34008__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__34016_34049 = cljs.core.seq.call(null,requires);
var chunk__34017_34050 = null;
var count__34018_34051 = (0);
var i__34019_34052 = (0);
while(true){
if((i__34019_34052 < count__34018_34051)){
var req_34053 = cljs.core._nth.call(null,chunk__34017_34050,i__34019_34052);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34053,prov);

var G__34054 = seq__34016_34049;
var G__34055 = chunk__34017_34050;
var G__34056 = count__34018_34051;
var G__34057 = (i__34019_34052 + (1));
seq__34016_34049 = G__34054;
chunk__34017_34050 = G__34055;
count__34018_34051 = G__34056;
i__34019_34052 = G__34057;
continue;
} else {
var temp__6753__auto___34058__$1 = cljs.core.seq.call(null,seq__34016_34049);
if(temp__6753__auto___34058__$1){
var seq__34016_34059__$1 = temp__6753__auto___34058__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34016_34059__$1)){
var c__27647__auto___34060 = cljs.core.chunk_first.call(null,seq__34016_34059__$1);
var G__34061 = cljs.core.chunk_rest.call(null,seq__34016_34059__$1);
var G__34062 = c__27647__auto___34060;
var G__34063 = cljs.core.count.call(null,c__27647__auto___34060);
var G__34064 = (0);
seq__34016_34049 = G__34061;
chunk__34017_34050 = G__34062;
count__34018_34051 = G__34063;
i__34019_34052 = G__34064;
continue;
} else {
var req_34065 = cljs.core.first.call(null,seq__34016_34059__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34065,prov);

var G__34066 = cljs.core.next.call(null,seq__34016_34059__$1);
var G__34067 = null;
var G__34068 = (0);
var G__34069 = (0);
seq__34016_34049 = G__34066;
chunk__34017_34050 = G__34067;
count__34018_34051 = G__34068;
i__34019_34052 = G__34069;
continue;
}
} else {
}
}
break;
}

var G__34070 = cljs.core.next.call(null,seq__34008__$1);
var G__34071 = null;
var G__34072 = (0);
var G__34073 = (0);
seq__34008 = G__34070;
chunk__34009 = G__34071;
count__34010 = G__34072;
i__34011 = G__34073;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__34078_34082 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__34079_34083 = null;
var count__34080_34084 = (0);
var i__34081_34085 = (0);
while(true){
if((i__34081_34085 < count__34080_34084)){
var ns_34086 = cljs.core._nth.call(null,chunk__34079_34083,i__34081_34085);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_34086);

var G__34087 = seq__34078_34082;
var G__34088 = chunk__34079_34083;
var G__34089 = count__34080_34084;
var G__34090 = (i__34081_34085 + (1));
seq__34078_34082 = G__34087;
chunk__34079_34083 = G__34088;
count__34080_34084 = G__34089;
i__34081_34085 = G__34090;
continue;
} else {
var temp__6753__auto___34091 = cljs.core.seq.call(null,seq__34078_34082);
if(temp__6753__auto___34091){
var seq__34078_34092__$1 = temp__6753__auto___34091;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34078_34092__$1)){
var c__27647__auto___34093 = cljs.core.chunk_first.call(null,seq__34078_34092__$1);
var G__34094 = cljs.core.chunk_rest.call(null,seq__34078_34092__$1);
var G__34095 = c__27647__auto___34093;
var G__34096 = cljs.core.count.call(null,c__27647__auto___34093);
var G__34097 = (0);
seq__34078_34082 = G__34094;
chunk__34079_34083 = G__34095;
count__34080_34084 = G__34096;
i__34081_34085 = G__34097;
continue;
} else {
var ns_34098 = cljs.core.first.call(null,seq__34078_34092__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_34098);

var G__34099 = cljs.core.next.call(null,seq__34078_34092__$1);
var G__34100 = null;
var G__34101 = (0);
var G__34102 = (0);
seq__34078_34082 = G__34099;
chunk__34079_34083 = G__34100;
count__34080_34084 = G__34101;
i__34081_34085 = G__34102;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__26741__auto__ = goog.require__;
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__34103__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__34103 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34104__i = 0, G__34104__a = new Array(arguments.length -  0);
while (G__34104__i < G__34104__a.length) {G__34104__a[G__34104__i] = arguments[G__34104__i + 0]; ++G__34104__i;}
  args = new cljs.core.IndexedSeq(G__34104__a,0);
} 
return G__34103__delegate.call(this,args);};
G__34103.cljs$lang$maxFixedArity = 0;
G__34103.cljs$lang$applyTo = (function (arglist__34105){
var args = cljs.core.seq(arglist__34105);
return G__34103__delegate(args);
});
G__34103.cljs$core$IFn$_invoke$arity$variadic = G__34103__delegate;
return G__34103;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__34106 = cljs.core._EQ_;
var expr__34107 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__34106.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__34107))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str(node_path_lib.sep),cljs.core.str(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__34106,expr__34107){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__34106,expr__34107))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__34106,expr__34107){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e34109){if((e34109 instanceof Error)){
var e = e34109;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e34109;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__34106,expr__34107))
} else {
if(cljs.core.truth_(pred__34106.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__34107))){
return ((function (pred__34106,expr__34107){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__34106,expr__34107){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__34106,expr__34107))
);

return deferred.addErrback(((function (deferred,pred__34106,expr__34107){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__34106,expr__34107))
);
});
;})(pred__34106,expr__34107))
} else {
if(cljs.core.truth_(pred__34106.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__34107))){
return ((function (pred__34106,expr__34107){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e34110){if((e34110 instanceof Error)){
var e = e34110;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e34110;

}
}})());
});
;})(pred__34106,expr__34107))
} else {
return ((function (pred__34106,expr__34107){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__34106,expr__34107))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__34111,callback){
var map__34114 = p__34111;
var map__34114__$1 = ((((!((map__34114 == null)))?((((map__34114.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34114.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34114):map__34114);
var file_msg = map__34114__$1;
var request_url = cljs.core.get.call(null,map__34114__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__34114,map__34114__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__34114,map__34114__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__29422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto__){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto__){
return (function (state_34138){
var state_val_34139 = (state_34138[(1)]);
if((state_val_34139 === (7))){
var inst_34134 = (state_34138[(2)]);
var state_34138__$1 = state_34138;
var statearr_34140_34160 = state_34138__$1;
(statearr_34140_34160[(2)] = inst_34134);

(statearr_34140_34160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34139 === (1))){
var state_34138__$1 = state_34138;
var statearr_34141_34161 = state_34138__$1;
(statearr_34141_34161[(2)] = null);

(statearr_34141_34161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34139 === (4))){
var inst_34118 = (state_34138[(7)]);
var inst_34118__$1 = (state_34138[(2)]);
var state_34138__$1 = (function (){var statearr_34142 = state_34138;
(statearr_34142[(7)] = inst_34118__$1);

return statearr_34142;
})();
if(cljs.core.truth_(inst_34118__$1)){
var statearr_34143_34162 = state_34138__$1;
(statearr_34143_34162[(1)] = (5));

} else {
var statearr_34144_34163 = state_34138__$1;
(statearr_34144_34163[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34139 === (6))){
var state_34138__$1 = state_34138;
var statearr_34145_34164 = state_34138__$1;
(statearr_34145_34164[(2)] = null);

(statearr_34145_34164[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34139 === (3))){
var inst_34136 = (state_34138[(2)]);
var state_34138__$1 = state_34138;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34138__$1,inst_34136);
} else {
if((state_val_34139 === (2))){
var state_34138__$1 = state_34138;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34138__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_34139 === (11))){
var inst_34130 = (state_34138[(2)]);
var state_34138__$1 = (function (){var statearr_34146 = state_34138;
(statearr_34146[(8)] = inst_34130);

return statearr_34146;
})();
var statearr_34147_34165 = state_34138__$1;
(statearr_34147_34165[(2)] = null);

(statearr_34147_34165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34139 === (9))){
var inst_34122 = (state_34138[(9)]);
var inst_34124 = (state_34138[(10)]);
var inst_34126 = inst_34124.call(null,inst_34122);
var state_34138__$1 = state_34138;
var statearr_34148_34166 = state_34138__$1;
(statearr_34148_34166[(2)] = inst_34126);

(statearr_34148_34166[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34139 === (5))){
var inst_34118 = (state_34138[(7)]);
var inst_34120 = figwheel.client.file_reloading.blocking_load.call(null,inst_34118);
var state_34138__$1 = state_34138;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34138__$1,(8),inst_34120);
} else {
if((state_val_34139 === (10))){
var inst_34122 = (state_34138[(9)]);
var inst_34128 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_34122);
var state_34138__$1 = state_34138;
var statearr_34149_34167 = state_34138__$1;
(statearr_34149_34167[(2)] = inst_34128);

(statearr_34149_34167[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34139 === (8))){
var inst_34124 = (state_34138[(10)]);
var inst_34118 = (state_34138[(7)]);
var inst_34122 = (state_34138[(2)]);
var inst_34123 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_34124__$1 = cljs.core.get.call(null,inst_34123,inst_34118);
var state_34138__$1 = (function (){var statearr_34150 = state_34138;
(statearr_34150[(9)] = inst_34122);

(statearr_34150[(10)] = inst_34124__$1);

return statearr_34150;
})();
if(cljs.core.truth_(inst_34124__$1)){
var statearr_34151_34168 = state_34138__$1;
(statearr_34151_34168[(1)] = (9));

} else {
var statearr_34152_34169 = state_34138__$1;
(statearr_34152_34169[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto__))
;
return ((function (switch__29308__auto__,c__29422__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__29309__auto__ = null;
var figwheel$client$file_reloading$state_machine__29309__auto____0 = (function (){
var statearr_34156 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34156[(0)] = figwheel$client$file_reloading$state_machine__29309__auto__);

(statearr_34156[(1)] = (1));

return statearr_34156;
});
var figwheel$client$file_reloading$state_machine__29309__auto____1 = (function (state_34138){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_34138);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e34157){if((e34157 instanceof Object)){
var ex__29312__auto__ = e34157;
var statearr_34158_34170 = state_34138;
(statearr_34158_34170[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34138);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34157;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34171 = state_34138;
state_34138 = G__34171;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__29309__auto__ = function(state_34138){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__29309__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__29309__auto____1.call(this,state_34138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__29309__auto____0;
figwheel$client$file_reloading$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__29309__auto____1;
return figwheel$client$file_reloading$state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto__))
})();
var state__29424__auto__ = (function (){var statearr_34159 = f__29423__auto__.call(null);
(statearr_34159[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto__);

return statearr_34159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto__))
);

return c__29422__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__34172,callback){
var map__34175 = p__34172;
var map__34175__$1 = ((((!((map__34175 == null)))?((((map__34175.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34175.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34175):map__34175);
var file_msg = map__34175__$1;
var namespace = cljs.core.get.call(null,map__34175__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__34175,map__34175__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__34175,map__34175__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__34177){
var map__34180 = p__34177;
var map__34180__$1 = ((((!((map__34180 == null)))?((((map__34180.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34180.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34180):map__34180);
var file_msg = map__34180__$1;
var namespace = cljs.core.get.call(null,map__34180__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__34182){
var map__34185 = p__34182;
var map__34185__$1 = ((((!((map__34185 == null)))?((((map__34185.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34185.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34185):map__34185);
var file_msg = map__34185__$1;
var namespace = cljs.core.get.call(null,map__34185__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__26729__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__26729__auto__){
var or__26741__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
var or__26741__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26741__auto____$1)){
return or__26741__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__26729__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__34187,callback){
var map__34190 = p__34187;
var map__34190__$1 = ((((!((map__34190 == null)))?((((map__34190.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34190.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34190):map__34190);
var file_msg = map__34190__$1;
var request_url = cljs.core.get.call(null,map__34190__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__34190__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__29422__auto___34294 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___34294,out){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___34294,out){
return (function (state_34276){
var state_val_34277 = (state_34276[(1)]);
if((state_val_34277 === (1))){
var inst_34250 = cljs.core.seq.call(null,files);
var inst_34251 = cljs.core.first.call(null,inst_34250);
var inst_34252 = cljs.core.next.call(null,inst_34250);
var inst_34253 = files;
var state_34276__$1 = (function (){var statearr_34278 = state_34276;
(statearr_34278[(7)] = inst_34253);

(statearr_34278[(8)] = inst_34251);

(statearr_34278[(9)] = inst_34252);

return statearr_34278;
})();
var statearr_34279_34295 = state_34276__$1;
(statearr_34279_34295[(2)] = null);

(statearr_34279_34295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34277 === (2))){
var inst_34259 = (state_34276[(10)]);
var inst_34253 = (state_34276[(7)]);
var inst_34258 = cljs.core.seq.call(null,inst_34253);
var inst_34259__$1 = cljs.core.first.call(null,inst_34258);
var inst_34260 = cljs.core.next.call(null,inst_34258);
var inst_34261 = (inst_34259__$1 == null);
var inst_34262 = cljs.core.not.call(null,inst_34261);
var state_34276__$1 = (function (){var statearr_34280 = state_34276;
(statearr_34280[(10)] = inst_34259__$1);

(statearr_34280[(11)] = inst_34260);

return statearr_34280;
})();
if(inst_34262){
var statearr_34281_34296 = state_34276__$1;
(statearr_34281_34296[(1)] = (4));

} else {
var statearr_34282_34297 = state_34276__$1;
(statearr_34282_34297[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34277 === (3))){
var inst_34274 = (state_34276[(2)]);
var state_34276__$1 = state_34276;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34276__$1,inst_34274);
} else {
if((state_val_34277 === (4))){
var inst_34259 = (state_34276[(10)]);
var inst_34264 = figwheel.client.file_reloading.reload_js_file.call(null,inst_34259);
var state_34276__$1 = state_34276;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34276__$1,(7),inst_34264);
} else {
if((state_val_34277 === (5))){
var inst_34270 = cljs.core.async.close_BANG_.call(null,out);
var state_34276__$1 = state_34276;
var statearr_34283_34298 = state_34276__$1;
(statearr_34283_34298[(2)] = inst_34270);

(statearr_34283_34298[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34277 === (6))){
var inst_34272 = (state_34276[(2)]);
var state_34276__$1 = state_34276;
var statearr_34284_34299 = state_34276__$1;
(statearr_34284_34299[(2)] = inst_34272);

(statearr_34284_34299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34277 === (7))){
var inst_34260 = (state_34276[(11)]);
var inst_34266 = (state_34276[(2)]);
var inst_34267 = cljs.core.async.put_BANG_.call(null,out,inst_34266);
var inst_34253 = inst_34260;
var state_34276__$1 = (function (){var statearr_34285 = state_34276;
(statearr_34285[(7)] = inst_34253);

(statearr_34285[(12)] = inst_34267);

return statearr_34285;
})();
var statearr_34286_34300 = state_34276__$1;
(statearr_34286_34300[(2)] = null);

(statearr_34286_34300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__29422__auto___34294,out))
;
return ((function (switch__29308__auto__,c__29422__auto___34294,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29309__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29309__auto____0 = (function (){
var statearr_34290 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34290[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29309__auto__);

(statearr_34290[(1)] = (1));

return statearr_34290;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29309__auto____1 = (function (state_34276){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_34276);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e34291){if((e34291 instanceof Object)){
var ex__29312__auto__ = e34291;
var statearr_34292_34301 = state_34276;
(statearr_34292_34301[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34276);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34291;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34302 = state_34276;
state_34276 = G__34302;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29309__auto__ = function(state_34276){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29309__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29309__auto____1.call(this,state_34276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29309__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29309__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___34294,out))
})();
var state__29424__auto__ = (function (){var statearr_34293 = f__29423__auto__.call(null);
(statearr_34293[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___34294);

return statearr_34293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___34294,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__34303,opts){
var map__34307 = p__34303;
var map__34307__$1 = ((((!((map__34307 == null)))?((((map__34307.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34307.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34307):map__34307);
var eval_body = cljs.core.get.call(null,map__34307__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__34307__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__26729__auto__ = eval_body;
if(cljs.core.truth_(and__26729__auto__)){
return typeof eval_body === 'string';
} else {
return and__26729__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e34309){var e = e34309;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__34310_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__34310_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__34319){
var vec__34320 = p__34319;
var k = cljs.core.nth.call(null,vec__34320,(0),null);
var v = cljs.core.nth.call(null,vec__34320,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__34323){
var vec__34324 = p__34323;
var k = cljs.core.nth.call(null,vec__34324,(0),null);
var v = cljs.core.nth.call(null,vec__34324,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__34330,p__34331){
var map__34579 = p__34330;
var map__34579__$1 = ((((!((map__34579 == null)))?((((map__34579.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34579.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34579):map__34579);
var opts = map__34579__$1;
var before_jsload = cljs.core.get.call(null,map__34579__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__34579__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__34579__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__34580 = p__34331;
var map__34580__$1 = ((((!((map__34580 == null)))?((((map__34580.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34580.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34580):map__34580);
var msg = map__34580__$1;
var files = cljs.core.get.call(null,map__34580__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__34580__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__34580__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__29422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_34734){
var state_val_34735 = (state_34734[(1)]);
if((state_val_34735 === (7))){
var inst_34595 = (state_34734[(7)]);
var inst_34594 = (state_34734[(8)]);
var inst_34596 = (state_34734[(9)]);
var inst_34597 = (state_34734[(10)]);
var inst_34602 = cljs.core._nth.call(null,inst_34595,inst_34597);
var inst_34603 = figwheel.client.file_reloading.eval_body.call(null,inst_34602,opts);
var inst_34604 = (inst_34597 + (1));
var tmp34736 = inst_34595;
var tmp34737 = inst_34594;
var tmp34738 = inst_34596;
var inst_34594__$1 = tmp34737;
var inst_34595__$1 = tmp34736;
var inst_34596__$1 = tmp34738;
var inst_34597__$1 = inst_34604;
var state_34734__$1 = (function (){var statearr_34739 = state_34734;
(statearr_34739[(7)] = inst_34595__$1);

(statearr_34739[(8)] = inst_34594__$1);

(statearr_34739[(11)] = inst_34603);

(statearr_34739[(9)] = inst_34596__$1);

(statearr_34739[(10)] = inst_34597__$1);

return statearr_34739;
})();
var statearr_34740_34826 = state_34734__$1;
(statearr_34740_34826[(2)] = null);

(statearr_34740_34826[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (20))){
var inst_34637 = (state_34734[(12)]);
var inst_34645 = figwheel.client.file_reloading.sort_files.call(null,inst_34637);
var state_34734__$1 = state_34734;
var statearr_34741_34827 = state_34734__$1;
(statearr_34741_34827[(2)] = inst_34645);

(statearr_34741_34827[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (27))){
var state_34734__$1 = state_34734;
var statearr_34742_34828 = state_34734__$1;
(statearr_34742_34828[(2)] = null);

(statearr_34742_34828[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (1))){
var inst_34586 = (state_34734[(13)]);
var inst_34583 = before_jsload.call(null,files);
var inst_34584 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_34585 = (function (){return ((function (inst_34586,inst_34583,inst_34584,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__34327_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__34327_SHARP_);
});
;})(inst_34586,inst_34583,inst_34584,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34586__$1 = cljs.core.filter.call(null,inst_34585,files);
var inst_34587 = cljs.core.not_empty.call(null,inst_34586__$1);
var state_34734__$1 = (function (){var statearr_34743 = state_34734;
(statearr_34743[(14)] = inst_34584);

(statearr_34743[(13)] = inst_34586__$1);

(statearr_34743[(15)] = inst_34583);

return statearr_34743;
})();
if(cljs.core.truth_(inst_34587)){
var statearr_34744_34829 = state_34734__$1;
(statearr_34744_34829[(1)] = (2));

} else {
var statearr_34745_34830 = state_34734__$1;
(statearr_34745_34830[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (24))){
var state_34734__$1 = state_34734;
var statearr_34746_34831 = state_34734__$1;
(statearr_34746_34831[(2)] = null);

(statearr_34746_34831[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (39))){
var inst_34687 = (state_34734[(16)]);
var state_34734__$1 = state_34734;
var statearr_34747_34832 = state_34734__$1;
(statearr_34747_34832[(2)] = inst_34687);

(statearr_34747_34832[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (46))){
var inst_34729 = (state_34734[(2)]);
var state_34734__$1 = state_34734;
var statearr_34748_34833 = state_34734__$1;
(statearr_34748_34833[(2)] = inst_34729);

(statearr_34748_34833[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (4))){
var inst_34631 = (state_34734[(2)]);
var inst_34632 = cljs.core.List.EMPTY;
var inst_34633 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_34632);
var inst_34634 = (function (){return ((function (inst_34631,inst_34632,inst_34633,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__34328_SHARP_){
var and__26729__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__34328_SHARP_);
if(cljs.core.truth_(and__26729__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__34328_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__34328_SHARP_)));
} else {
return and__26729__auto__;
}
});
;})(inst_34631,inst_34632,inst_34633,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34635 = cljs.core.filter.call(null,inst_34634,files);
var inst_34636 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_34637 = cljs.core.concat.call(null,inst_34635,inst_34636);
var state_34734__$1 = (function (){var statearr_34749 = state_34734;
(statearr_34749[(17)] = inst_34631);

(statearr_34749[(18)] = inst_34633);

(statearr_34749[(12)] = inst_34637);

return statearr_34749;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_34750_34834 = state_34734__$1;
(statearr_34750_34834[(1)] = (16));

} else {
var statearr_34751_34835 = state_34734__$1;
(statearr_34751_34835[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (15))){
var inst_34621 = (state_34734[(2)]);
var state_34734__$1 = state_34734;
var statearr_34752_34836 = state_34734__$1;
(statearr_34752_34836[(2)] = inst_34621);

(statearr_34752_34836[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (21))){
var inst_34647 = (state_34734[(19)]);
var inst_34647__$1 = (state_34734[(2)]);
var inst_34648 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_34647__$1);
var state_34734__$1 = (function (){var statearr_34753 = state_34734;
(statearr_34753[(19)] = inst_34647__$1);

return statearr_34753;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34734__$1,(22),inst_34648);
} else {
if((state_val_34735 === (31))){
var inst_34732 = (state_34734[(2)]);
var state_34734__$1 = state_34734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34734__$1,inst_34732);
} else {
if((state_val_34735 === (32))){
var inst_34687 = (state_34734[(16)]);
var inst_34692 = inst_34687.cljs$lang$protocol_mask$partition0$;
var inst_34693 = (inst_34692 & (64));
var inst_34694 = inst_34687.cljs$core$ISeq$;
var inst_34695 = (cljs.core.PROTOCOL_SENTINEL === inst_34694);
var inst_34696 = (inst_34693) || (inst_34695);
var state_34734__$1 = state_34734;
if(cljs.core.truth_(inst_34696)){
var statearr_34754_34837 = state_34734__$1;
(statearr_34754_34837[(1)] = (35));

} else {
var statearr_34755_34838 = state_34734__$1;
(statearr_34755_34838[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (40))){
var inst_34709 = (state_34734[(20)]);
var inst_34708 = (state_34734[(2)]);
var inst_34709__$1 = cljs.core.get.call(null,inst_34708,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_34710 = cljs.core.get.call(null,inst_34708,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_34711 = cljs.core.not_empty.call(null,inst_34709__$1);
var state_34734__$1 = (function (){var statearr_34756 = state_34734;
(statearr_34756[(21)] = inst_34710);

(statearr_34756[(20)] = inst_34709__$1);

return statearr_34756;
})();
if(cljs.core.truth_(inst_34711)){
var statearr_34757_34839 = state_34734__$1;
(statearr_34757_34839[(1)] = (41));

} else {
var statearr_34758_34840 = state_34734__$1;
(statearr_34758_34840[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (33))){
var state_34734__$1 = state_34734;
var statearr_34759_34841 = state_34734__$1;
(statearr_34759_34841[(2)] = false);

(statearr_34759_34841[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (13))){
var inst_34607 = (state_34734[(22)]);
var inst_34611 = cljs.core.chunk_first.call(null,inst_34607);
var inst_34612 = cljs.core.chunk_rest.call(null,inst_34607);
var inst_34613 = cljs.core.count.call(null,inst_34611);
var inst_34594 = inst_34612;
var inst_34595 = inst_34611;
var inst_34596 = inst_34613;
var inst_34597 = (0);
var state_34734__$1 = (function (){var statearr_34760 = state_34734;
(statearr_34760[(7)] = inst_34595);

(statearr_34760[(8)] = inst_34594);

(statearr_34760[(9)] = inst_34596);

(statearr_34760[(10)] = inst_34597);

return statearr_34760;
})();
var statearr_34761_34842 = state_34734__$1;
(statearr_34761_34842[(2)] = null);

(statearr_34761_34842[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (22))){
var inst_34647 = (state_34734[(19)]);
var inst_34655 = (state_34734[(23)]);
var inst_34651 = (state_34734[(24)]);
var inst_34650 = (state_34734[(25)]);
var inst_34650__$1 = (state_34734[(2)]);
var inst_34651__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34650__$1);
var inst_34652 = (function (){var all_files = inst_34647;
var res_SINGLEQUOTE_ = inst_34650__$1;
var res = inst_34651__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_34647,inst_34655,inst_34651,inst_34650,inst_34650__$1,inst_34651__$1,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__34329_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__34329_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_34647,inst_34655,inst_34651,inst_34650,inst_34650__$1,inst_34651__$1,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34653 = cljs.core.filter.call(null,inst_34652,inst_34650__$1);
var inst_34654 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_34655__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34654);
var inst_34656 = cljs.core.not_empty.call(null,inst_34655__$1);
var state_34734__$1 = (function (){var statearr_34762 = state_34734;
(statearr_34762[(23)] = inst_34655__$1);

(statearr_34762[(24)] = inst_34651__$1);

(statearr_34762[(25)] = inst_34650__$1);

(statearr_34762[(26)] = inst_34653);

return statearr_34762;
})();
if(cljs.core.truth_(inst_34656)){
var statearr_34763_34843 = state_34734__$1;
(statearr_34763_34843[(1)] = (23));

} else {
var statearr_34764_34844 = state_34734__$1;
(statearr_34764_34844[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (36))){
var state_34734__$1 = state_34734;
var statearr_34765_34845 = state_34734__$1;
(statearr_34765_34845[(2)] = false);

(statearr_34765_34845[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (41))){
var inst_34709 = (state_34734[(20)]);
var inst_34713 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_34714 = cljs.core.map.call(null,inst_34713,inst_34709);
var inst_34715 = cljs.core.pr_str.call(null,inst_34714);
var inst_34716 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_34715)].join('');
var inst_34717 = figwheel.client.utils.log.call(null,inst_34716);
var state_34734__$1 = state_34734;
var statearr_34766_34846 = state_34734__$1;
(statearr_34766_34846[(2)] = inst_34717);

(statearr_34766_34846[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (43))){
var inst_34710 = (state_34734[(21)]);
var inst_34720 = (state_34734[(2)]);
var inst_34721 = cljs.core.not_empty.call(null,inst_34710);
var state_34734__$1 = (function (){var statearr_34767 = state_34734;
(statearr_34767[(27)] = inst_34720);

return statearr_34767;
})();
if(cljs.core.truth_(inst_34721)){
var statearr_34768_34847 = state_34734__$1;
(statearr_34768_34847[(1)] = (44));

} else {
var statearr_34769_34848 = state_34734__$1;
(statearr_34769_34848[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (29))){
var inst_34647 = (state_34734[(19)]);
var inst_34655 = (state_34734[(23)]);
var inst_34651 = (state_34734[(24)]);
var inst_34650 = (state_34734[(25)]);
var inst_34653 = (state_34734[(26)]);
var inst_34687 = (state_34734[(16)]);
var inst_34683 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_34686 = (function (){var all_files = inst_34647;
var res_SINGLEQUOTE_ = inst_34650;
var res = inst_34651;
var files_not_loaded = inst_34653;
var dependencies_that_loaded = inst_34655;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34647,inst_34655,inst_34651,inst_34650,inst_34653,inst_34687,inst_34683,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34685){
var map__34770 = p__34685;
var map__34770__$1 = ((((!((map__34770 == null)))?((((map__34770.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34770.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34770):map__34770);
var namespace = cljs.core.get.call(null,map__34770__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34647,inst_34655,inst_34651,inst_34650,inst_34653,inst_34687,inst_34683,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34687__$1 = cljs.core.group_by.call(null,inst_34686,inst_34653);
var inst_34689 = (inst_34687__$1 == null);
var inst_34690 = cljs.core.not.call(null,inst_34689);
var state_34734__$1 = (function (){var statearr_34772 = state_34734;
(statearr_34772[(28)] = inst_34683);

(statearr_34772[(16)] = inst_34687__$1);

return statearr_34772;
})();
if(inst_34690){
var statearr_34773_34849 = state_34734__$1;
(statearr_34773_34849[(1)] = (32));

} else {
var statearr_34774_34850 = state_34734__$1;
(statearr_34774_34850[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (44))){
var inst_34710 = (state_34734[(21)]);
var inst_34723 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_34710);
var inst_34724 = cljs.core.pr_str.call(null,inst_34723);
var inst_34725 = [cljs.core.str("not required: "),cljs.core.str(inst_34724)].join('');
var inst_34726 = figwheel.client.utils.log.call(null,inst_34725);
var state_34734__$1 = state_34734;
var statearr_34775_34851 = state_34734__$1;
(statearr_34775_34851[(2)] = inst_34726);

(statearr_34775_34851[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (6))){
var inst_34628 = (state_34734[(2)]);
var state_34734__$1 = state_34734;
var statearr_34776_34852 = state_34734__$1;
(statearr_34776_34852[(2)] = inst_34628);

(statearr_34776_34852[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (28))){
var inst_34653 = (state_34734[(26)]);
var inst_34680 = (state_34734[(2)]);
var inst_34681 = cljs.core.not_empty.call(null,inst_34653);
var state_34734__$1 = (function (){var statearr_34777 = state_34734;
(statearr_34777[(29)] = inst_34680);

return statearr_34777;
})();
if(cljs.core.truth_(inst_34681)){
var statearr_34778_34853 = state_34734__$1;
(statearr_34778_34853[(1)] = (29));

} else {
var statearr_34779_34854 = state_34734__$1;
(statearr_34779_34854[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (25))){
var inst_34651 = (state_34734[(24)]);
var inst_34667 = (state_34734[(2)]);
var inst_34668 = cljs.core.not_empty.call(null,inst_34651);
var state_34734__$1 = (function (){var statearr_34780 = state_34734;
(statearr_34780[(30)] = inst_34667);

return statearr_34780;
})();
if(cljs.core.truth_(inst_34668)){
var statearr_34781_34855 = state_34734__$1;
(statearr_34781_34855[(1)] = (26));

} else {
var statearr_34782_34856 = state_34734__$1;
(statearr_34782_34856[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (34))){
var inst_34703 = (state_34734[(2)]);
var state_34734__$1 = state_34734;
if(cljs.core.truth_(inst_34703)){
var statearr_34783_34857 = state_34734__$1;
(statearr_34783_34857[(1)] = (38));

} else {
var statearr_34784_34858 = state_34734__$1;
(statearr_34784_34858[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (17))){
var state_34734__$1 = state_34734;
var statearr_34785_34859 = state_34734__$1;
(statearr_34785_34859[(2)] = recompile_dependents);

(statearr_34785_34859[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (3))){
var state_34734__$1 = state_34734;
var statearr_34786_34860 = state_34734__$1;
(statearr_34786_34860[(2)] = null);

(statearr_34786_34860[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (12))){
var inst_34624 = (state_34734[(2)]);
var state_34734__$1 = state_34734;
var statearr_34787_34861 = state_34734__$1;
(statearr_34787_34861[(2)] = inst_34624);

(statearr_34787_34861[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (2))){
var inst_34586 = (state_34734[(13)]);
var inst_34593 = cljs.core.seq.call(null,inst_34586);
var inst_34594 = inst_34593;
var inst_34595 = null;
var inst_34596 = (0);
var inst_34597 = (0);
var state_34734__$1 = (function (){var statearr_34788 = state_34734;
(statearr_34788[(7)] = inst_34595);

(statearr_34788[(8)] = inst_34594);

(statearr_34788[(9)] = inst_34596);

(statearr_34788[(10)] = inst_34597);

return statearr_34788;
})();
var statearr_34789_34862 = state_34734__$1;
(statearr_34789_34862[(2)] = null);

(statearr_34789_34862[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (23))){
var inst_34647 = (state_34734[(19)]);
var inst_34655 = (state_34734[(23)]);
var inst_34651 = (state_34734[(24)]);
var inst_34650 = (state_34734[(25)]);
var inst_34653 = (state_34734[(26)]);
var inst_34658 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_34660 = (function (){var all_files = inst_34647;
var res_SINGLEQUOTE_ = inst_34650;
var res = inst_34651;
var files_not_loaded = inst_34653;
var dependencies_that_loaded = inst_34655;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34647,inst_34655,inst_34651,inst_34650,inst_34653,inst_34658,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34659){
var map__34790 = p__34659;
var map__34790__$1 = ((((!((map__34790 == null)))?((((map__34790.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34790.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34790):map__34790);
var request_url = cljs.core.get.call(null,map__34790__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34647,inst_34655,inst_34651,inst_34650,inst_34653,inst_34658,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34661 = cljs.core.reverse.call(null,inst_34655);
var inst_34662 = cljs.core.map.call(null,inst_34660,inst_34661);
var inst_34663 = cljs.core.pr_str.call(null,inst_34662);
var inst_34664 = figwheel.client.utils.log.call(null,inst_34663);
var state_34734__$1 = (function (){var statearr_34792 = state_34734;
(statearr_34792[(31)] = inst_34658);

return statearr_34792;
})();
var statearr_34793_34863 = state_34734__$1;
(statearr_34793_34863[(2)] = inst_34664);

(statearr_34793_34863[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (35))){
var state_34734__$1 = state_34734;
var statearr_34794_34864 = state_34734__$1;
(statearr_34794_34864[(2)] = true);

(statearr_34794_34864[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (19))){
var inst_34637 = (state_34734[(12)]);
var inst_34643 = figwheel.client.file_reloading.expand_files.call(null,inst_34637);
var state_34734__$1 = state_34734;
var statearr_34795_34865 = state_34734__$1;
(statearr_34795_34865[(2)] = inst_34643);

(statearr_34795_34865[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (11))){
var state_34734__$1 = state_34734;
var statearr_34796_34866 = state_34734__$1;
(statearr_34796_34866[(2)] = null);

(statearr_34796_34866[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (9))){
var inst_34626 = (state_34734[(2)]);
var state_34734__$1 = state_34734;
var statearr_34797_34867 = state_34734__$1;
(statearr_34797_34867[(2)] = inst_34626);

(statearr_34797_34867[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (5))){
var inst_34596 = (state_34734[(9)]);
var inst_34597 = (state_34734[(10)]);
var inst_34599 = (inst_34597 < inst_34596);
var inst_34600 = inst_34599;
var state_34734__$1 = state_34734;
if(cljs.core.truth_(inst_34600)){
var statearr_34798_34868 = state_34734__$1;
(statearr_34798_34868[(1)] = (7));

} else {
var statearr_34799_34869 = state_34734__$1;
(statearr_34799_34869[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (14))){
var inst_34607 = (state_34734[(22)]);
var inst_34616 = cljs.core.first.call(null,inst_34607);
var inst_34617 = figwheel.client.file_reloading.eval_body.call(null,inst_34616,opts);
var inst_34618 = cljs.core.next.call(null,inst_34607);
var inst_34594 = inst_34618;
var inst_34595 = null;
var inst_34596 = (0);
var inst_34597 = (0);
var state_34734__$1 = (function (){var statearr_34800 = state_34734;
(statearr_34800[(7)] = inst_34595);

(statearr_34800[(8)] = inst_34594);

(statearr_34800[(32)] = inst_34617);

(statearr_34800[(9)] = inst_34596);

(statearr_34800[(10)] = inst_34597);

return statearr_34800;
})();
var statearr_34801_34870 = state_34734__$1;
(statearr_34801_34870[(2)] = null);

(statearr_34801_34870[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (45))){
var state_34734__$1 = state_34734;
var statearr_34802_34871 = state_34734__$1;
(statearr_34802_34871[(2)] = null);

(statearr_34802_34871[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (26))){
var inst_34647 = (state_34734[(19)]);
var inst_34655 = (state_34734[(23)]);
var inst_34651 = (state_34734[(24)]);
var inst_34650 = (state_34734[(25)]);
var inst_34653 = (state_34734[(26)]);
var inst_34670 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_34672 = (function (){var all_files = inst_34647;
var res_SINGLEQUOTE_ = inst_34650;
var res = inst_34651;
var files_not_loaded = inst_34653;
var dependencies_that_loaded = inst_34655;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34647,inst_34655,inst_34651,inst_34650,inst_34653,inst_34670,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34671){
var map__34803 = p__34671;
var map__34803__$1 = ((((!((map__34803 == null)))?((((map__34803.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34803.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34803):map__34803);
var namespace = cljs.core.get.call(null,map__34803__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__34803__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34647,inst_34655,inst_34651,inst_34650,inst_34653,inst_34670,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34673 = cljs.core.map.call(null,inst_34672,inst_34651);
var inst_34674 = cljs.core.pr_str.call(null,inst_34673);
var inst_34675 = figwheel.client.utils.log.call(null,inst_34674);
var inst_34676 = (function (){var all_files = inst_34647;
var res_SINGLEQUOTE_ = inst_34650;
var res = inst_34651;
var files_not_loaded = inst_34653;
var dependencies_that_loaded = inst_34655;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34647,inst_34655,inst_34651,inst_34650,inst_34653,inst_34670,inst_34672,inst_34673,inst_34674,inst_34675,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34647,inst_34655,inst_34651,inst_34650,inst_34653,inst_34670,inst_34672,inst_34673,inst_34674,inst_34675,state_val_34735,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34677 = setTimeout(inst_34676,(10));
var state_34734__$1 = (function (){var statearr_34805 = state_34734;
(statearr_34805[(33)] = inst_34675);

(statearr_34805[(34)] = inst_34670);

return statearr_34805;
})();
var statearr_34806_34872 = state_34734__$1;
(statearr_34806_34872[(2)] = inst_34677);

(statearr_34806_34872[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (16))){
var state_34734__$1 = state_34734;
var statearr_34807_34873 = state_34734__$1;
(statearr_34807_34873[(2)] = reload_dependents);

(statearr_34807_34873[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (38))){
var inst_34687 = (state_34734[(16)]);
var inst_34705 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34687);
var state_34734__$1 = state_34734;
var statearr_34808_34874 = state_34734__$1;
(statearr_34808_34874[(2)] = inst_34705);

(statearr_34808_34874[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (30))){
var state_34734__$1 = state_34734;
var statearr_34809_34875 = state_34734__$1;
(statearr_34809_34875[(2)] = null);

(statearr_34809_34875[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (10))){
var inst_34607 = (state_34734[(22)]);
var inst_34609 = cljs.core.chunked_seq_QMARK_.call(null,inst_34607);
var state_34734__$1 = state_34734;
if(inst_34609){
var statearr_34810_34876 = state_34734__$1;
(statearr_34810_34876[(1)] = (13));

} else {
var statearr_34811_34877 = state_34734__$1;
(statearr_34811_34877[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (18))){
var inst_34641 = (state_34734[(2)]);
var state_34734__$1 = state_34734;
if(cljs.core.truth_(inst_34641)){
var statearr_34812_34878 = state_34734__$1;
(statearr_34812_34878[(1)] = (19));

} else {
var statearr_34813_34879 = state_34734__$1;
(statearr_34813_34879[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (42))){
var state_34734__$1 = state_34734;
var statearr_34814_34880 = state_34734__$1;
(statearr_34814_34880[(2)] = null);

(statearr_34814_34880[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (37))){
var inst_34700 = (state_34734[(2)]);
var state_34734__$1 = state_34734;
var statearr_34815_34881 = state_34734__$1;
(statearr_34815_34881[(2)] = inst_34700);

(statearr_34815_34881[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34735 === (8))){
var inst_34594 = (state_34734[(8)]);
var inst_34607 = (state_34734[(22)]);
var inst_34607__$1 = cljs.core.seq.call(null,inst_34594);
var state_34734__$1 = (function (){var statearr_34816 = state_34734;
(statearr_34816[(22)] = inst_34607__$1);

return statearr_34816;
})();
if(inst_34607__$1){
var statearr_34817_34882 = state_34734__$1;
(statearr_34817_34882[(1)] = (10));

} else {
var statearr_34818_34883 = state_34734__$1;
(statearr_34818_34883[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__29308__auto__,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29309__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29309__auto____0 = (function (){
var statearr_34822 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34822[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__29309__auto__);

(statearr_34822[(1)] = (1));

return statearr_34822;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29309__auto____1 = (function (state_34734){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_34734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e34823){if((e34823 instanceof Object)){
var ex__29312__auto__ = e34823;
var statearr_34824_34884 = state_34734;
(statearr_34824_34884[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34734);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34823;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34885 = state_34734;
state_34734 = G__34885;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__29309__auto__ = function(state_34734){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29309__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29309__auto____1.call(this,state_34734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__29309__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__29309__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__29424__auto__ = (function (){var statearr_34825 = f__29423__auto__.call(null);
(statearr_34825[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto__);

return statearr_34825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto__,map__34579,map__34579__$1,opts,before_jsload,on_jsload,reload_dependents,map__34580,map__34580__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__29422__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__34888,link){
var map__34891 = p__34888;
var map__34891__$1 = ((((!((map__34891 == null)))?((((map__34891.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34891.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34891):map__34891);
var file = cljs.core.get.call(null,map__34891__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__34891,map__34891__$1,file){
return (function (p1__34886_SHARP_,p2__34887_SHARP_){
if(cljs.core._EQ_.call(null,p1__34886_SHARP_,p2__34887_SHARP_)){
return p1__34886_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__34891,map__34891__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__34897){
var map__34898 = p__34897;
var map__34898__$1 = ((((!((map__34898 == null)))?((((map__34898.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34898.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34898):map__34898);
var match_length = cljs.core.get.call(null,map__34898__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__34898__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__34893_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__34893_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__34900_SHARP_,p2__34901_SHARP_){
return cljs.core.assoc.call(null,p1__34900_SHARP_,cljs.core.get.call(null,p2__34901_SHARP_,key),p2__34901_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__6751__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6751__auto__)){
var link = temp__6751__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__6751__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__6751__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_34902 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_34902);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_34902);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__34903,p__34904){
var map__34909 = p__34903;
var map__34909__$1 = ((((!((map__34909 == null)))?((((map__34909.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34909.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34909):map__34909);
var on_cssload = cljs.core.get.call(null,map__34909__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__34910 = p__34904;
var map__34910__$1 = ((((!((map__34910 == null)))?((((map__34910.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34910.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34910):map__34910);
var files_msg = map__34910__$1;
var files = cljs.core.get.call(null,map__34910__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__6753__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__6753__auto__)){
var f_datas = temp__6753__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1489515138552