// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
goog.require('cljs.repl');
goog.require('figwheel.client.heads_up');
goog.require('cljs.reader');
figwheel.client._figwheel_version_ = "0.5.9";
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var args35536 = [];
var len__27957__auto___35539 = arguments.length;
var i__27958__auto___35540 = (0);
while(true){
if((i__27958__auto___35540 < len__27957__auto___35539)){
args35536.push((arguments[i__27958__auto___35540]));

var G__35541 = (i__27958__auto___35540 + (1));
i__27958__auto___35540 = G__35541;
continue;
} else {
}
break;
}

var G__35538 = args35536.length;
switch (G__35538) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35536.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),args], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__27964__auto__ = [];
var len__27957__auto___35544 = arguments.length;
var i__27958__auto___35545 = (0);
while(true){
if((i__27958__auto___35545 < len__27957__auto___35544)){
args__27964__auto__.push((arguments[i__27958__auto___35545]));

var G__35546 = (i__27958__auto___35545 + (1));
i__27958__auto___35545 = G__35546;
continue;
} else {
}
break;
}

var argseq__27965__auto__ = ((((0) < args__27964__auto__.length))?(new cljs.core.IndexedSeq(args__27964__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__27965__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq35543){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq35543));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__27964__auto__ = [];
var len__27957__auto___35548 = arguments.length;
var i__27958__auto___35549 = (0);
while(true){
if((i__27958__auto___35549 < len__27957__auto___35548)){
args__27964__auto__.push((arguments[i__27958__auto___35549]));

var G__35550 = (i__27958__auto___35549 + (1));
i__27958__auto___35549 = G__35550;
continue;
} else {
}
break;
}

var argseq__27965__auto__ = ((((0) < args__27964__auto__.length))?(new cljs.core.IndexedSeq(args__27964__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__27965__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq35547){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq35547));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)")].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Figwheel autoloading "),cljs.core.str((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method. 
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 *   
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__35551){
var map__35554 = p__35551;
var map__35554__$1 = ((((!((map__35554 == null)))?((((map__35554.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35554.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35554):map__35554);
var message = cljs.core.get.call(null,map__35554__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__35554__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str(class$),cljs.core.str(" : "),cljs.core.str(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__26741__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__26729__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__26729__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__26729__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__29422__auto___35716 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___35716,ch){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___35716,ch){
return (function (state_35685){
var state_val_35686 = (state_35685[(1)]);
if((state_val_35686 === (7))){
var inst_35681 = (state_35685[(2)]);
var state_35685__$1 = state_35685;
var statearr_35687_35717 = state_35685__$1;
(statearr_35687_35717[(2)] = inst_35681);

(statearr_35687_35717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (1))){
var state_35685__$1 = state_35685;
var statearr_35688_35718 = state_35685__$1;
(statearr_35688_35718[(2)] = null);

(statearr_35688_35718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (4))){
var inst_35638 = (state_35685[(7)]);
var inst_35638__$1 = (state_35685[(2)]);
var state_35685__$1 = (function (){var statearr_35689 = state_35685;
(statearr_35689[(7)] = inst_35638__$1);

return statearr_35689;
})();
if(cljs.core.truth_(inst_35638__$1)){
var statearr_35690_35719 = state_35685__$1;
(statearr_35690_35719[(1)] = (5));

} else {
var statearr_35691_35720 = state_35685__$1;
(statearr_35691_35720[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (15))){
var inst_35645 = (state_35685[(8)]);
var inst_35660 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_35645);
var inst_35661 = cljs.core.first.call(null,inst_35660);
var inst_35662 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_35661);
var inst_35663 = [cljs.core.str("Figwheel: Not loading code with warnings - "),cljs.core.str(inst_35662)].join('');
var inst_35664 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_35663);
var state_35685__$1 = state_35685;
var statearr_35692_35721 = state_35685__$1;
(statearr_35692_35721[(2)] = inst_35664);

(statearr_35692_35721[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (13))){
var inst_35669 = (state_35685[(2)]);
var state_35685__$1 = state_35685;
var statearr_35693_35722 = state_35685__$1;
(statearr_35693_35722[(2)] = inst_35669);

(statearr_35693_35722[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (6))){
var state_35685__$1 = state_35685;
var statearr_35694_35723 = state_35685__$1;
(statearr_35694_35723[(2)] = null);

(statearr_35694_35723[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (17))){
var inst_35667 = (state_35685[(2)]);
var state_35685__$1 = state_35685;
var statearr_35695_35724 = state_35685__$1;
(statearr_35695_35724[(2)] = inst_35667);

(statearr_35695_35724[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (3))){
var inst_35683 = (state_35685[(2)]);
var state_35685__$1 = state_35685;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35685__$1,inst_35683);
} else {
if((state_val_35686 === (12))){
var inst_35644 = (state_35685[(9)]);
var inst_35658 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_35644,opts);
var state_35685__$1 = state_35685;
if(cljs.core.truth_(inst_35658)){
var statearr_35696_35725 = state_35685__$1;
(statearr_35696_35725[(1)] = (15));

} else {
var statearr_35697_35726 = state_35685__$1;
(statearr_35697_35726[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (2))){
var state_35685__$1 = state_35685;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35685__$1,(4),ch);
} else {
if((state_val_35686 === (11))){
var inst_35645 = (state_35685[(8)]);
var inst_35650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35651 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_35645);
var inst_35652 = cljs.core.async.timeout.call(null,(1000));
var inst_35653 = [inst_35651,inst_35652];
var inst_35654 = (new cljs.core.PersistentVector(null,2,(5),inst_35650,inst_35653,null));
var state_35685__$1 = state_35685;
return cljs.core.async.ioc_alts_BANG_.call(null,state_35685__$1,(14),inst_35654);
} else {
if((state_val_35686 === (9))){
var inst_35645 = (state_35685[(8)]);
var inst_35671 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_35672 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_35645);
var inst_35673 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_35672);
var inst_35674 = [cljs.core.str("Not loading: "),cljs.core.str(inst_35673)].join('');
var inst_35675 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_35674);
var state_35685__$1 = (function (){var statearr_35698 = state_35685;
(statearr_35698[(10)] = inst_35671);

return statearr_35698;
})();
var statearr_35699_35727 = state_35685__$1;
(statearr_35699_35727[(2)] = inst_35675);

(statearr_35699_35727[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (5))){
var inst_35638 = (state_35685[(7)]);
var inst_35640 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_35641 = (new cljs.core.PersistentArrayMap(null,2,inst_35640,null));
var inst_35642 = (new cljs.core.PersistentHashSet(null,inst_35641,null));
var inst_35643 = figwheel.client.focus_msgs.call(null,inst_35642,inst_35638);
var inst_35644 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_35643);
var inst_35645 = cljs.core.first.call(null,inst_35643);
var inst_35646 = figwheel.client.autoload_QMARK_.call(null);
var state_35685__$1 = (function (){var statearr_35700 = state_35685;
(statearr_35700[(9)] = inst_35644);

(statearr_35700[(8)] = inst_35645);

return statearr_35700;
})();
if(cljs.core.truth_(inst_35646)){
var statearr_35701_35728 = state_35685__$1;
(statearr_35701_35728[(1)] = (8));

} else {
var statearr_35702_35729 = state_35685__$1;
(statearr_35702_35729[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (14))){
var inst_35656 = (state_35685[(2)]);
var state_35685__$1 = state_35685;
var statearr_35703_35730 = state_35685__$1;
(statearr_35703_35730[(2)] = inst_35656);

(statearr_35703_35730[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (16))){
var state_35685__$1 = state_35685;
var statearr_35704_35731 = state_35685__$1;
(statearr_35704_35731[(2)] = null);

(statearr_35704_35731[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (10))){
var inst_35677 = (state_35685[(2)]);
var state_35685__$1 = (function (){var statearr_35705 = state_35685;
(statearr_35705[(11)] = inst_35677);

return statearr_35705;
})();
var statearr_35706_35732 = state_35685__$1;
(statearr_35706_35732[(2)] = null);

(statearr_35706_35732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35686 === (8))){
var inst_35644 = (state_35685[(9)]);
var inst_35648 = figwheel.client.reload_file_state_QMARK_.call(null,inst_35644,opts);
var state_35685__$1 = state_35685;
if(cljs.core.truth_(inst_35648)){
var statearr_35707_35733 = state_35685__$1;
(statearr_35707_35733[(1)] = (11));

} else {
var statearr_35708_35734 = state_35685__$1;
(statearr_35708_35734[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___35716,ch))
;
return ((function (switch__29308__auto__,c__29422__auto___35716,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__29309__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__29309__auto____0 = (function (){
var statearr_35712 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35712[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__29309__auto__);

(statearr_35712[(1)] = (1));

return statearr_35712;
});
var figwheel$client$file_reloader_plugin_$_state_machine__29309__auto____1 = (function (state_35685){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_35685);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e35713){if((e35713 instanceof Object)){
var ex__29312__auto__ = e35713;
var statearr_35714_35735 = state_35685;
(statearr_35714_35735[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35685);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35713;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35736 = state_35685;
state_35685 = G__35736;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__29309__auto__ = function(state_35685){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__29309__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__29309__auto____1.call(this,state_35685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__29309__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__29309__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___35716,ch))
})();
var state__29424__auto__ = (function (){var statearr_35715 = f__29423__auto__.call(null);
(statearr_35715[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___35716);

return statearr_35715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___35716,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__35737_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__35737_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_35740 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_35740){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e35739){if((e35739 instanceof Error)){
var e = e35739;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_35740], null));
} else {
var e = e35739;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_35740))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__35741){
var map__35750 = p__35741;
var map__35750__$1 = ((((!((map__35750 == null)))?((((map__35750.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35750.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35750):map__35750);
var opts = map__35750__$1;
var build_id = cljs.core.get.call(null,map__35750__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__35750,map__35750__$1,opts,build_id){
return (function (p__35752){
var vec__35753 = p__35752;
var seq__35754 = cljs.core.seq.call(null,vec__35753);
var first__35755 = cljs.core.first.call(null,seq__35754);
var seq__35754__$1 = cljs.core.next.call(null,seq__35754);
var map__35756 = first__35755;
var map__35756__$1 = ((((!((map__35756 == null)))?((((map__35756.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35756.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35756):map__35756);
var msg = map__35756__$1;
var msg_name = cljs.core.get.call(null,map__35756__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__35754__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__35753,seq__35754,first__35755,seq__35754__$1,map__35756,map__35756__$1,msg,msg_name,_,map__35750,map__35750__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__35753,seq__35754,first__35755,seq__35754__$1,map__35756,map__35756__$1,msg,msg_name,_,map__35750,map__35750__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__35750,map__35750__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__35764){
var vec__35765 = p__35764;
var seq__35766 = cljs.core.seq.call(null,vec__35765);
var first__35767 = cljs.core.first.call(null,seq__35766);
var seq__35766__$1 = cljs.core.next.call(null,seq__35766);
var map__35768 = first__35767;
var map__35768__$1 = ((((!((map__35768 == null)))?((((map__35768.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35768.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35768):map__35768);
var msg = map__35768__$1;
var msg_name = cljs.core.get.call(null,map__35768__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__35766__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__35770){
var map__35782 = p__35770;
var map__35782__$1 = ((((!((map__35782 == null)))?((((map__35782.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35782.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35782):map__35782);
var on_compile_warning = cljs.core.get.call(null,map__35782__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__35782__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__35782,map__35782__$1,on_compile_warning,on_compile_fail){
return (function (p__35784){
var vec__35785 = p__35784;
var seq__35786 = cljs.core.seq.call(null,vec__35785);
var first__35787 = cljs.core.first.call(null,seq__35786);
var seq__35786__$1 = cljs.core.next.call(null,seq__35786);
var map__35788 = first__35787;
var map__35788__$1 = ((((!((map__35788 == null)))?((((map__35788.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35788.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35788):map__35788);
var msg = map__35788__$1;
var msg_name = cljs.core.get.call(null,map__35788__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__35786__$1;
var pred__35790 = cljs.core._EQ_;
var expr__35791 = msg_name;
if(cljs.core.truth_(pred__35790.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__35791))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__35790.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__35791))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__35782,map__35782__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__29422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto__,msg_hist,msg_names,msg){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto__,msg_hist,msg_names,msg){
return (function (state_36019){
var state_val_36020 = (state_36019[(1)]);
if((state_val_36020 === (7))){
var inst_35939 = (state_36019[(2)]);
var state_36019__$1 = state_36019;
if(cljs.core.truth_(inst_35939)){
var statearr_36021_36071 = state_36019__$1;
(statearr_36021_36071[(1)] = (8));

} else {
var statearr_36022_36072 = state_36019__$1;
(statearr_36022_36072[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (20))){
var inst_36013 = (state_36019[(2)]);
var state_36019__$1 = state_36019;
var statearr_36023_36073 = state_36019__$1;
(statearr_36023_36073[(2)] = inst_36013);

(statearr_36023_36073[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (27))){
var inst_36009 = (state_36019[(2)]);
var state_36019__$1 = state_36019;
var statearr_36024_36074 = state_36019__$1;
(statearr_36024_36074[(2)] = inst_36009);

(statearr_36024_36074[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (1))){
var inst_35932 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_36019__$1 = state_36019;
if(cljs.core.truth_(inst_35932)){
var statearr_36025_36075 = state_36019__$1;
(statearr_36025_36075[(1)] = (2));

} else {
var statearr_36026_36076 = state_36019__$1;
(statearr_36026_36076[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (24))){
var inst_36011 = (state_36019[(2)]);
var state_36019__$1 = state_36019;
var statearr_36027_36077 = state_36019__$1;
(statearr_36027_36077[(2)] = inst_36011);

(statearr_36027_36077[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (4))){
var inst_36017 = (state_36019[(2)]);
var state_36019__$1 = state_36019;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36019__$1,inst_36017);
} else {
if((state_val_36020 === (15))){
var inst_36015 = (state_36019[(2)]);
var state_36019__$1 = state_36019;
var statearr_36028_36078 = state_36019__$1;
(statearr_36028_36078[(2)] = inst_36015);

(statearr_36028_36078[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (21))){
var inst_35968 = (state_36019[(2)]);
var inst_35969 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35970 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35969);
var state_36019__$1 = (function (){var statearr_36029 = state_36019;
(statearr_36029[(7)] = inst_35968);

return statearr_36029;
})();
var statearr_36030_36079 = state_36019__$1;
(statearr_36030_36079[(2)] = inst_35970);

(statearr_36030_36079[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (31))){
var inst_35998 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_36019__$1 = state_36019;
if(cljs.core.truth_(inst_35998)){
var statearr_36031_36080 = state_36019__$1;
(statearr_36031_36080[(1)] = (34));

} else {
var statearr_36032_36081 = state_36019__$1;
(statearr_36032_36081[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (32))){
var inst_36007 = (state_36019[(2)]);
var state_36019__$1 = state_36019;
var statearr_36033_36082 = state_36019__$1;
(statearr_36033_36082[(2)] = inst_36007);

(statearr_36033_36082[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (33))){
var inst_35994 = (state_36019[(2)]);
var inst_35995 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35996 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35995);
var state_36019__$1 = (function (){var statearr_36034 = state_36019;
(statearr_36034[(8)] = inst_35994);

return statearr_36034;
})();
var statearr_36035_36083 = state_36019__$1;
(statearr_36035_36083[(2)] = inst_35996);

(statearr_36035_36083[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (13))){
var inst_35953 = figwheel.client.heads_up.clear.call(null);
var state_36019__$1 = state_36019;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36019__$1,(16),inst_35953);
} else {
if((state_val_36020 === (22))){
var inst_35974 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35975 = figwheel.client.heads_up.append_warning_message.call(null,inst_35974);
var state_36019__$1 = state_36019;
var statearr_36036_36084 = state_36019__$1;
(statearr_36036_36084[(2)] = inst_35975);

(statearr_36036_36084[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (36))){
var inst_36005 = (state_36019[(2)]);
var state_36019__$1 = state_36019;
var statearr_36037_36085 = state_36019__$1;
(statearr_36037_36085[(2)] = inst_36005);

(statearr_36037_36085[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (29))){
var inst_35985 = (state_36019[(2)]);
var inst_35986 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35987 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35986);
var state_36019__$1 = (function (){var statearr_36038 = state_36019;
(statearr_36038[(9)] = inst_35985);

return statearr_36038;
})();
var statearr_36039_36086 = state_36019__$1;
(statearr_36039_36086[(2)] = inst_35987);

(statearr_36039_36086[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (6))){
var inst_35934 = (state_36019[(10)]);
var state_36019__$1 = state_36019;
var statearr_36040_36087 = state_36019__$1;
(statearr_36040_36087[(2)] = inst_35934);

(statearr_36040_36087[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (28))){
var inst_35981 = (state_36019[(2)]);
var inst_35982 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35983 = figwheel.client.heads_up.display_warning.call(null,inst_35982);
var state_36019__$1 = (function (){var statearr_36041 = state_36019;
(statearr_36041[(11)] = inst_35981);

return statearr_36041;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36019__$1,(29),inst_35983);
} else {
if((state_val_36020 === (25))){
var inst_35979 = figwheel.client.heads_up.clear.call(null);
var state_36019__$1 = state_36019;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36019__$1,(28),inst_35979);
} else {
if((state_val_36020 === (34))){
var inst_36000 = figwheel.client.heads_up.flash_loaded.call(null);
var state_36019__$1 = state_36019;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36019__$1,(37),inst_36000);
} else {
if((state_val_36020 === (17))){
var inst_35959 = (state_36019[(2)]);
var inst_35960 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35961 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35960);
var state_36019__$1 = (function (){var statearr_36042 = state_36019;
(statearr_36042[(12)] = inst_35959);

return statearr_36042;
})();
var statearr_36043_36088 = state_36019__$1;
(statearr_36043_36088[(2)] = inst_35961);

(statearr_36043_36088[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (3))){
var inst_35951 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_36019__$1 = state_36019;
if(cljs.core.truth_(inst_35951)){
var statearr_36044_36089 = state_36019__$1;
(statearr_36044_36089[(1)] = (13));

} else {
var statearr_36045_36090 = state_36019__$1;
(statearr_36045_36090[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (12))){
var inst_35947 = (state_36019[(2)]);
var state_36019__$1 = state_36019;
var statearr_36046_36091 = state_36019__$1;
(statearr_36046_36091[(2)] = inst_35947);

(statearr_36046_36091[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (2))){
var inst_35934 = (state_36019[(10)]);
var inst_35934__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_36019__$1 = (function (){var statearr_36047 = state_36019;
(statearr_36047[(10)] = inst_35934__$1);

return statearr_36047;
})();
if(cljs.core.truth_(inst_35934__$1)){
var statearr_36048_36092 = state_36019__$1;
(statearr_36048_36092[(1)] = (5));

} else {
var statearr_36049_36093 = state_36019__$1;
(statearr_36049_36093[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (23))){
var inst_35977 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_36019__$1 = state_36019;
if(cljs.core.truth_(inst_35977)){
var statearr_36050_36094 = state_36019__$1;
(statearr_36050_36094[(1)] = (25));

} else {
var statearr_36051_36095 = state_36019__$1;
(statearr_36051_36095[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (35))){
var state_36019__$1 = state_36019;
var statearr_36052_36096 = state_36019__$1;
(statearr_36052_36096[(2)] = null);

(statearr_36052_36096[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (19))){
var inst_35972 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_36019__$1 = state_36019;
if(cljs.core.truth_(inst_35972)){
var statearr_36053_36097 = state_36019__$1;
(statearr_36053_36097[(1)] = (22));

} else {
var statearr_36054_36098 = state_36019__$1;
(statearr_36054_36098[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (11))){
var inst_35943 = (state_36019[(2)]);
var state_36019__$1 = state_36019;
var statearr_36055_36099 = state_36019__$1;
(statearr_36055_36099[(2)] = inst_35943);

(statearr_36055_36099[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (9))){
var inst_35945 = figwheel.client.heads_up.clear.call(null);
var state_36019__$1 = state_36019;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36019__$1,(12),inst_35945);
} else {
if((state_val_36020 === (5))){
var inst_35936 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_36019__$1 = state_36019;
var statearr_36056_36100 = state_36019__$1;
(statearr_36056_36100[(2)] = inst_35936);

(statearr_36056_36100[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (14))){
var inst_35963 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_36019__$1 = state_36019;
if(cljs.core.truth_(inst_35963)){
var statearr_36057_36101 = state_36019__$1;
(statearr_36057_36101[(1)] = (18));

} else {
var statearr_36058_36102 = state_36019__$1;
(statearr_36058_36102[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (26))){
var inst_35989 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_36019__$1 = state_36019;
if(cljs.core.truth_(inst_35989)){
var statearr_36059_36103 = state_36019__$1;
(statearr_36059_36103[(1)] = (30));

} else {
var statearr_36060_36104 = state_36019__$1;
(statearr_36060_36104[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (16))){
var inst_35955 = (state_36019[(2)]);
var inst_35956 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35957 = figwheel.client.heads_up.display_exception.call(null,inst_35956);
var state_36019__$1 = (function (){var statearr_36061 = state_36019;
(statearr_36061[(13)] = inst_35955);

return statearr_36061;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36019__$1,(17),inst_35957);
} else {
if((state_val_36020 === (30))){
var inst_35991 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35992 = figwheel.client.heads_up.display_warning.call(null,inst_35991);
var state_36019__$1 = state_36019;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36019__$1,(33),inst_35992);
} else {
if((state_val_36020 === (10))){
var inst_35949 = (state_36019[(2)]);
var state_36019__$1 = state_36019;
var statearr_36062_36105 = state_36019__$1;
(statearr_36062_36105[(2)] = inst_35949);

(statearr_36062_36105[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (18))){
var inst_35965 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35966 = figwheel.client.heads_up.display_exception.call(null,inst_35965);
var state_36019__$1 = state_36019;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36019__$1,(21),inst_35966);
} else {
if((state_val_36020 === (37))){
var inst_36002 = (state_36019[(2)]);
var state_36019__$1 = state_36019;
var statearr_36063_36106 = state_36019__$1;
(statearr_36063_36106[(2)] = inst_36002);

(statearr_36063_36106[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36020 === (8))){
var inst_35941 = figwheel.client.heads_up.flash_loaded.call(null);
var state_36019__$1 = state_36019;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36019__$1,(11),inst_35941);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__29308__auto__,c__29422__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29309__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29309__auto____0 = (function (){
var statearr_36067 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36067[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29309__auto__);

(statearr_36067[(1)] = (1));

return statearr_36067;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29309__auto____1 = (function (state_36019){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_36019);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e36068){if((e36068 instanceof Object)){
var ex__29312__auto__ = e36068;
var statearr_36069_36107 = state_36019;
(statearr_36069_36107[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36019);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36068;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36108 = state_36019;
state_36019 = G__36108;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29309__auto__ = function(state_36019){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29309__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29309__auto____1.call(this,state_36019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29309__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29309__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto__,msg_hist,msg_names,msg))
})();
var state__29424__auto__ = (function (){var statearr_36070 = f__29423__auto__.call(null);
(statearr_36070[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto__);

return statearr_36070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto__,msg_hist,msg_names,msg))
);

return c__29422__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__29422__auto___36171 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___36171,ch){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___36171,ch){
return (function (state_36154){
var state_val_36155 = (state_36154[(1)]);
if((state_val_36155 === (1))){
var state_36154__$1 = state_36154;
var statearr_36156_36172 = state_36154__$1;
(statearr_36156_36172[(2)] = null);

(statearr_36156_36172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36155 === (2))){
var state_36154__$1 = state_36154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36154__$1,(4),ch);
} else {
if((state_val_36155 === (3))){
var inst_36152 = (state_36154[(2)]);
var state_36154__$1 = state_36154;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36154__$1,inst_36152);
} else {
if((state_val_36155 === (4))){
var inst_36142 = (state_36154[(7)]);
var inst_36142__$1 = (state_36154[(2)]);
var state_36154__$1 = (function (){var statearr_36157 = state_36154;
(statearr_36157[(7)] = inst_36142__$1);

return statearr_36157;
})();
if(cljs.core.truth_(inst_36142__$1)){
var statearr_36158_36173 = state_36154__$1;
(statearr_36158_36173[(1)] = (5));

} else {
var statearr_36159_36174 = state_36154__$1;
(statearr_36159_36174[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36155 === (5))){
var inst_36142 = (state_36154[(7)]);
var inst_36144 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_36142);
var state_36154__$1 = state_36154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36154__$1,(8),inst_36144);
} else {
if((state_val_36155 === (6))){
var state_36154__$1 = state_36154;
var statearr_36160_36175 = state_36154__$1;
(statearr_36160_36175[(2)] = null);

(statearr_36160_36175[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36155 === (7))){
var inst_36150 = (state_36154[(2)]);
var state_36154__$1 = state_36154;
var statearr_36161_36176 = state_36154__$1;
(statearr_36161_36176[(2)] = inst_36150);

(statearr_36161_36176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36155 === (8))){
var inst_36146 = (state_36154[(2)]);
var state_36154__$1 = (function (){var statearr_36162 = state_36154;
(statearr_36162[(8)] = inst_36146);

return statearr_36162;
})();
var statearr_36163_36177 = state_36154__$1;
(statearr_36163_36177[(2)] = null);

(statearr_36163_36177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__29422__auto___36171,ch))
;
return ((function (switch__29308__auto__,c__29422__auto___36171,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__29309__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__29309__auto____0 = (function (){
var statearr_36167 = [null,null,null,null,null,null,null,null,null];
(statearr_36167[(0)] = figwheel$client$heads_up_plugin_$_state_machine__29309__auto__);

(statearr_36167[(1)] = (1));

return statearr_36167;
});
var figwheel$client$heads_up_plugin_$_state_machine__29309__auto____1 = (function (state_36154){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_36154);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e36168){if((e36168 instanceof Object)){
var ex__29312__auto__ = e36168;
var statearr_36169_36178 = state_36154;
(statearr_36169_36178[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36154);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36168;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36179 = state_36154;
state_36154 = G__36179;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__29309__auto__ = function(state_36154){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__29309__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__29309__auto____1.call(this,state_36154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__29309__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__29309__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___36171,ch))
})();
var state__29424__auto__ = (function (){var statearr_36170 = f__29423__auto__.call(null);
(statearr_36170[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___36171);

return statearr_36170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___36171,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__29422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto__){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto__){
return (function (state_36200){
var state_val_36201 = (state_36200[(1)]);
if((state_val_36201 === (1))){
var inst_36195 = cljs.core.async.timeout.call(null,(3000));
var state_36200__$1 = state_36200;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36200__$1,(2),inst_36195);
} else {
if((state_val_36201 === (2))){
var inst_36197 = (state_36200[(2)]);
var inst_36198 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_36200__$1 = (function (){var statearr_36202 = state_36200;
(statearr_36202[(7)] = inst_36197);

return statearr_36202;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36200__$1,inst_36198);
} else {
return null;
}
}
});})(c__29422__auto__))
;
return ((function (switch__29308__auto__,c__29422__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__29309__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__29309__auto____0 = (function (){
var statearr_36206 = [null,null,null,null,null,null,null,null];
(statearr_36206[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__29309__auto__);

(statearr_36206[(1)] = (1));

return statearr_36206;
});
var figwheel$client$enforce_project_plugin_$_state_machine__29309__auto____1 = (function (state_36200){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_36200);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e36207){if((e36207 instanceof Object)){
var ex__29312__auto__ = e36207;
var statearr_36208_36210 = state_36200;
(statearr_36208_36210[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36200);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36207;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36211 = state_36200;
state_36200 = G__36211;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__29309__auto__ = function(state_36200){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__29309__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__29309__auto____1.call(this,state_36200);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__29309__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__29309__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto__))
})();
var state__29424__auto__ = (function (){var statearr_36209 = f__29423__auto__.call(null);
(statearr_36209[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto__);

return statearr_36209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto__))
);

return c__29422__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__6753__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__6753__auto__)){
var figwheel_version = temp__6753__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__29422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto__,figwheel_version,temp__6753__auto__){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto__,figwheel_version,temp__6753__auto__){
return (function (state_36234){
var state_val_36235 = (state_36234[(1)]);
if((state_val_36235 === (1))){
var inst_36228 = cljs.core.async.timeout.call(null,(2000));
var state_36234__$1 = state_36234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36234__$1,(2),inst_36228);
} else {
if((state_val_36235 === (2))){
var inst_36230 = (state_36234[(2)]);
var inst_36231 = [cljs.core.str("Figwheel Client Version <strong>"),cljs.core.str(figwheel.client._figwheel_version_),cljs.core.str("</strong> is not equal to "),cljs.core.str("Figwheel Sidecar Version <strong>"),cljs.core.str(figwheel_version),cljs.core.str("</strong>"),cljs.core.str(".  Shutting down Websocket Connection!"),cljs.core.str("<h4>To fix try:</h4>"),cljs.core.str("<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>"),cljs.core.str("<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>"),cljs.core.str("<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>")].join('');
var inst_36232 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_36231);
var state_36234__$1 = (function (){var statearr_36236 = state_36234;
(statearr_36236[(7)] = inst_36230);

return statearr_36236;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36234__$1,inst_36232);
} else {
return null;
}
}
});})(c__29422__auto__,figwheel_version,temp__6753__auto__))
;
return ((function (switch__29308__auto__,c__29422__auto__,figwheel_version,temp__6753__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29309__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29309__auto____0 = (function (){
var statearr_36240 = [null,null,null,null,null,null,null,null];
(statearr_36240[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29309__auto__);

(statearr_36240[(1)] = (1));

return statearr_36240;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29309__auto____1 = (function (state_36234){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_36234);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e36241){if((e36241 instanceof Object)){
var ex__29312__auto__ = e36241;
var statearr_36242_36244 = state_36234;
(statearr_36242_36244[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_36234);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e36241;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36245 = state_36234;
state_36234 = G__36245;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29309__auto__ = function(state_36234){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29309__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29309__auto____1.call(this,state_36234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29309__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29309__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto__,figwheel_version,temp__6753__auto__))
})();
var state__29424__auto__ = (function (){var statearr_36243 = f__29423__auto__.call(null);
(statearr_36243[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto__);

return statearr_36243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto__,figwheel_version,temp__6753__auto__))
);

return c__29422__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__36246){
var map__36250 = p__36246;
var map__36250__$1 = ((((!((map__36250 == null)))?((((map__36250.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36250.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36250):map__36250);
var file = cljs.core.get.call(null,map__36250__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__36250__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__36250__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__36252 = "";
var G__36252__$1 = (cljs.core.truth_(file)?[cljs.core.str(G__36252),cljs.core.str("file "),cljs.core.str(file)].join(''):G__36252);
var G__36252__$2 = (cljs.core.truth_(line)?[cljs.core.str(G__36252__$1),cljs.core.str(" at line "),cljs.core.str(line)].join(''):G__36252__$1);
if(cljs.core.truth_((function (){var and__26729__auto__ = line;
if(cljs.core.truth_(and__26729__auto__)){
return column;
} else {
return and__26729__auto__;
}
})())){
return [cljs.core.str(G__36252__$2),cljs.core.str(", column "),cljs.core.str(column)].join('');
} else {
return G__36252__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__36253){
var map__36260 = p__36253;
var map__36260__$1 = ((((!((map__36260 == null)))?((((map__36260.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36260.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36260):map__36260);
var ed = map__36260__$1;
var formatted_exception = cljs.core.get.call(null,map__36260__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__36260__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__36260__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__36262_36266 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__36263_36267 = null;
var count__36264_36268 = (0);
var i__36265_36269 = (0);
while(true){
if((i__36265_36269 < count__36264_36268)){
var msg_36270 = cljs.core._nth.call(null,chunk__36263_36267,i__36265_36269);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_36270);

var G__36271 = seq__36262_36266;
var G__36272 = chunk__36263_36267;
var G__36273 = count__36264_36268;
var G__36274 = (i__36265_36269 + (1));
seq__36262_36266 = G__36271;
chunk__36263_36267 = G__36272;
count__36264_36268 = G__36273;
i__36265_36269 = G__36274;
continue;
} else {
var temp__6753__auto___36275 = cljs.core.seq.call(null,seq__36262_36266);
if(temp__6753__auto___36275){
var seq__36262_36276__$1 = temp__6753__auto___36275;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36262_36276__$1)){
var c__27647__auto___36277 = cljs.core.chunk_first.call(null,seq__36262_36276__$1);
var G__36278 = cljs.core.chunk_rest.call(null,seq__36262_36276__$1);
var G__36279 = c__27647__auto___36277;
var G__36280 = cljs.core.count.call(null,c__27647__auto___36277);
var G__36281 = (0);
seq__36262_36266 = G__36278;
chunk__36263_36267 = G__36279;
count__36264_36268 = G__36280;
i__36265_36269 = G__36281;
continue;
} else {
var msg_36282 = cljs.core.first.call(null,seq__36262_36276__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_36282);

var G__36283 = cljs.core.next.call(null,seq__36262_36276__$1);
var G__36284 = null;
var G__36285 = (0);
var G__36286 = (0);
seq__36262_36266 = G__36283;
chunk__36263_36267 = G__36284;
count__36264_36268 = G__36285;
i__36265_36269 = G__36286;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Error on "),cljs.core.str(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__36287){
var map__36290 = p__36287;
var map__36290__$1 = ((((!((map__36290 == null)))?((((map__36290.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36290.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36290):map__36290);
var w = map__36290__$1;
var message = cljs.core.get.call(null,map__36290__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str("Figwheel: Compile Warning - "),cljs.core.str(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message)),cljs.core.str(" in "),cljs.core.str(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/out/figwheel/client.cljs",33,1,357,357,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/out/figwheel/client.cljs",30,1,349,349,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,[cljs.core.str("ws://"),cljs.core.str((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str("/figwheel-ws")].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__26729__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__26729__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__26729__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__36302 = cljs.core.seq.call(null,plugins);
var chunk__36303 = null;
var count__36304 = (0);
var i__36305 = (0);
while(true){
if((i__36305 < count__36304)){
var vec__36306 = cljs.core._nth.call(null,chunk__36303,i__36305);
var k = cljs.core.nth.call(null,vec__36306,(0),null);
var plugin = cljs.core.nth.call(null,vec__36306,(1),null);
if(cljs.core.truth_(plugin)){
var pl_36312 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__36302,chunk__36303,count__36304,i__36305,pl_36312,vec__36306,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_36312.call(null,msg_hist);
});})(seq__36302,chunk__36303,count__36304,i__36305,pl_36312,vec__36306,k,plugin))
);
} else {
}

var G__36313 = seq__36302;
var G__36314 = chunk__36303;
var G__36315 = count__36304;
var G__36316 = (i__36305 + (1));
seq__36302 = G__36313;
chunk__36303 = G__36314;
count__36304 = G__36315;
i__36305 = G__36316;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__36302);
if(temp__6753__auto__){
var seq__36302__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36302__$1)){
var c__27647__auto__ = cljs.core.chunk_first.call(null,seq__36302__$1);
var G__36317 = cljs.core.chunk_rest.call(null,seq__36302__$1);
var G__36318 = c__27647__auto__;
var G__36319 = cljs.core.count.call(null,c__27647__auto__);
var G__36320 = (0);
seq__36302 = G__36317;
chunk__36303 = G__36318;
count__36304 = G__36319;
i__36305 = G__36320;
continue;
} else {
var vec__36309 = cljs.core.first.call(null,seq__36302__$1);
var k = cljs.core.nth.call(null,vec__36309,(0),null);
var plugin = cljs.core.nth.call(null,vec__36309,(1),null);
if(cljs.core.truth_(plugin)){
var pl_36321 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__36302,chunk__36303,count__36304,i__36305,pl_36321,vec__36309,k,plugin,seq__36302__$1,temp__6753__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_36321.call(null,msg_hist);
});})(seq__36302,chunk__36303,count__36304,i__36305,pl_36321,vec__36309,k,plugin,seq__36302__$1,temp__6753__auto__))
);
} else {
}

var G__36322 = cljs.core.next.call(null,seq__36302__$1);
var G__36323 = null;
var G__36324 = (0);
var G__36325 = (0);
seq__36302 = G__36322;
chunk__36303 = G__36323;
count__36304 = G__36324;
i__36305 = G__36325;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args36326 = [];
var len__27957__auto___36333 = arguments.length;
var i__27958__auto___36334 = (0);
while(true){
if((i__27958__auto___36334 < len__27957__auto___36333)){
args36326.push((arguments[i__27958__auto___36334]));

var G__36335 = (i__27958__auto___36334 + (1));
i__27958__auto___36334 = G__36335;
continue;
} else {
}
break;
}

var G__36328 = args36326.length;
switch (G__36328) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args36326.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__36329_36337 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__36330_36338 = null;
var count__36331_36339 = (0);
var i__36332_36340 = (0);
while(true){
if((i__36332_36340 < count__36331_36339)){
var msg_36341 = cljs.core._nth.call(null,chunk__36330_36338,i__36332_36340);
figwheel.client.socket.handle_incoming_message.call(null,msg_36341);

var G__36342 = seq__36329_36337;
var G__36343 = chunk__36330_36338;
var G__36344 = count__36331_36339;
var G__36345 = (i__36332_36340 + (1));
seq__36329_36337 = G__36342;
chunk__36330_36338 = G__36343;
count__36331_36339 = G__36344;
i__36332_36340 = G__36345;
continue;
} else {
var temp__6753__auto___36346 = cljs.core.seq.call(null,seq__36329_36337);
if(temp__6753__auto___36346){
var seq__36329_36347__$1 = temp__6753__auto___36346;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__36329_36347__$1)){
var c__27647__auto___36348 = cljs.core.chunk_first.call(null,seq__36329_36347__$1);
var G__36349 = cljs.core.chunk_rest.call(null,seq__36329_36347__$1);
var G__36350 = c__27647__auto___36348;
var G__36351 = cljs.core.count.call(null,c__27647__auto___36348);
var G__36352 = (0);
seq__36329_36337 = G__36349;
chunk__36330_36338 = G__36350;
count__36331_36339 = G__36351;
i__36332_36340 = G__36352;
continue;
} else {
var msg_36353 = cljs.core.first.call(null,seq__36329_36347__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_36353);

var G__36354 = cljs.core.next.call(null,seq__36329_36347__$1);
var G__36355 = null;
var G__36356 = (0);
var G__36357 = (0);
seq__36329_36337 = G__36354;
chunk__36330_36338 = G__36355;
count__36331_36339 = G__36356;
i__36332_36340 = G__36357;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__27964__auto__ = [];
var len__27957__auto___36362 = arguments.length;
var i__27958__auto___36363 = (0);
while(true){
if((i__27958__auto___36363 < len__27957__auto___36362)){
args__27964__auto__.push((arguments[i__27958__auto___36363]));

var G__36364 = (i__27958__auto___36363 + (1));
i__27958__auto___36363 = G__36364;
continue;
} else {
}
break;
}

var argseq__27965__auto__ = ((((0) < args__27964__auto__.length))?(new cljs.core.IndexedSeq(args__27964__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__27965__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__36359){
var map__36360 = p__36359;
var map__36360__$1 = ((((!((map__36360 == null)))?((((map__36360.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36360.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36360):map__36360);
var opts = map__36360__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq36358){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq36358));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e36366){if((e36366 instanceof Error)){
var e = e36366;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e36366;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__36370){
var map__36371 = p__36370;
var map__36371__$1 = ((((!((map__36371 == null)))?((((map__36371.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36371.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36371):map__36371);
var msg_name = cljs.core.get.call(null,map__36371__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1489515140345