(ns elastic-input.demo
  (:require [reagent.core :as r]
            [elastic-input.core :as ei]))

(defn param-table [& rows]
  [:table.param-table
    [:tbody
      (for [[attr body] (partition 2 rows)]
        ^{:key (hash attr)}
        [:tr
          [:td.attr [:code (pr-str attr)]]
          [:td.body body]])]])

(defn demo []
  [:div.demo
    [:h1 "Elastic-Input Demo (0.2.0)"]

    [:ul
      [:li [:span.title "auto-width"]
        (r/with-let [t (r/atom "Lorem ipsum dolor sit amet")
                     b (r/atom false)
                     f (r/atom true)
                     x (r/atom 10)
                     p (r/atom "enter text")]
          [:div.card
            [:div.row
              [:div.card-demo

                [ei/elastic-input
                  :width       :auto
                  :placeholder @p
                  :container   {}
                  :focused?    @f
                  :buffer?     @b
                  :text        @t
                  :extra-len   (int @x)
                  :on-text-change #(reset! t %)]]

              [param-table
                :width [:code ":auto"]

                :placeholder
                [:textarea
                  {:value @p
                   :on-change #(reset! p (-> % .-target .-value))}]

                :buffer?
                [:input {:type      "checkbox"
                         :on-change #(swap! b not)
                         :checked   @b}]

                :focused?
                [:input {:type      "checkbox"
                         :on-change #(swap! f not)
                         :checked   @f}]

                :text
                [:textarea {:value @t
                            :on-change #(reset! t (-> % .-target .-value))}]

                :extra-len
                [:code @x]

                :on-text-change
                [:code "#(reset! ... %)"]]]])]

      [:li [:span.title "auto-height"]
        (r/with-let [t (r/atom "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")
                     b (r/atom false)
                     f (r/atom false)]
          [:div.card
            [:div.row
              [:div.card-demo

                [ei/elastic-input
                  :height    :auto
                  :container {}
                  :focused?  @f
                  :buffer?   @b
                  :text      @t
                  :width     300
                  :on-text-change #(reset! t %)]]

              [param-table
                :height [:code ":auto"]

                :buffer?
                [:input {:type      "checkbox"
                         :on-change #(swap! b not)
                         :checked   @b}]

                :focused?
                [:input {:type      "checkbox"
                         :on-change #(swap! f not)
                         :checked   @f}]

                :text
                [:textarea {:value @t
                            :on-change #(reset! t (-> % .-target .-value))}]

                :on-text-change
                [:code "#(reset! ... %)"]]]])]]])

(defn mount-root []
  (r/render [demo] (.getElementById js/document "root")))

(mount-root)
