// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args29481 = [];
var len__27957__auto___29487 = arguments.length;
var i__27958__auto___29488 = (0);
while(true){
if((i__27958__auto___29488 < len__27957__auto___29487)){
args29481.push((arguments[i__27958__auto___29488]));

var G__29489 = (i__27958__auto___29488 + (1));
i__27958__auto___29488 = G__29489;
continue;
} else {
}
break;
}

var G__29483 = args29481.length;
switch (G__29483) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29481.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async29484 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29484 = (function (f,blockable,meta29485){
this.f = f;
this.blockable = blockable;
this.meta29485 = meta29485;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29484.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29486,meta29485__$1){
var self__ = this;
var _29486__$1 = this;
return (new cljs.core.async.t_cljs$core$async29484(self__.f,self__.blockable,meta29485__$1));
});

cljs.core.async.t_cljs$core$async29484.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29486){
var self__ = this;
var _29486__$1 = this;
return self__.meta29485;
});

cljs.core.async.t_cljs$core$async29484.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29484.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async29484.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async29484.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async29484.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta29485","meta29485",-153505457,null)], null);
});

cljs.core.async.t_cljs$core$async29484.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29484.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29484";

cljs.core.async.t_cljs$core$async29484.cljs$lang$ctorPrWriter = (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async29484");
});

cljs.core.async.__GT_t_cljs$core$async29484 = (function cljs$core$async$__GT_t_cljs$core$async29484(f__$1,blockable__$1,meta29485){
return (new cljs.core.async.t_cljs$core$async29484(f__$1,blockable__$1,meta29485));
});

}

return (new cljs.core.async.t_cljs$core$async29484(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args29493 = [];
var len__27957__auto___29496 = arguments.length;
var i__27958__auto___29497 = (0);
while(true){
if((i__27958__auto___29497 < len__27957__auto___29496)){
args29493.push((arguments[i__27958__auto___29497]));

var G__29498 = (i__27958__auto___29497 + (1));
i__27958__auto___29497 = G__29498;
continue;
} else {
}
break;
}

var G__29495 = args29493.length;
switch (G__29495) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29493.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args29500 = [];
var len__27957__auto___29503 = arguments.length;
var i__27958__auto___29504 = (0);
while(true){
if((i__27958__auto___29504 < len__27957__auto___29503)){
args29500.push((arguments[i__27958__auto___29504]));

var G__29505 = (i__27958__auto___29504 + (1));
i__27958__auto___29504 = G__29505;
continue;
} else {
}
break;
}

var G__29502 = args29500.length;
switch (G__29502) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29500.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args29507 = [];
var len__27957__auto___29510 = arguments.length;
var i__27958__auto___29511 = (0);
while(true){
if((i__27958__auto___29511 < len__27957__auto___29510)){
args29507.push((arguments[i__27958__auto___29511]));

var G__29512 = (i__27958__auto___29511 + (1));
i__27958__auto___29511 = G__29512;
continue;
} else {
}
break;
}

var G__29509 = args29507.length;
switch (G__29509) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29507.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_29514 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_29514);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_29514,ret){
return (function (){
return fn1.call(null,val_29514);
});})(val_29514,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args29515 = [];
var len__27957__auto___29518 = arguments.length;
var i__27958__auto___29519 = (0);
while(true){
if((i__27958__auto___29519 < len__27957__auto___29518)){
args29515.push((arguments[i__27958__auto___29519]));

var G__29520 = (i__27958__auto___29519 + (1));
i__27958__auto___29519 = G__29520;
continue;
} else {
}
break;
}

var G__29517 = args29515.length;
switch (G__29517) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29515.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__27757__auto___29522 = n;
var x_29523 = (0);
while(true){
if((x_29523 < n__27757__auto___29522)){
(a[x_29523] = (0));

var G__29524 = (x_29523 + (1));
x_29523 = G__29524;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__29525 = (i + (1));
i = G__29525;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async29529 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29529 = (function (flag,meta29530){
this.flag = flag;
this.meta29530 = meta29530;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29529.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_29531,meta29530__$1){
var self__ = this;
var _29531__$1 = this;
return (new cljs.core.async.t_cljs$core$async29529(self__.flag,meta29530__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async29529.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_29531){
var self__ = this;
var _29531__$1 = this;
return self__.meta29530;
});})(flag))
;

cljs.core.async.t_cljs$core$async29529.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29529.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async29529.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29529.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29529.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29530","meta29530",-122840985,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async29529.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29529.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29529";

cljs.core.async.t_cljs$core$async29529.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async29529");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async29529 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async29529(flag__$1,meta29530){
return (new cljs.core.async.t_cljs$core$async29529(flag__$1,meta29530));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async29529(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async29535 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29535 = (function (flag,cb,meta29536){
this.flag = flag;
this.cb = cb;
this.meta29536 = meta29536;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29535.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29537,meta29536__$1){
var self__ = this;
var _29537__$1 = this;
return (new cljs.core.async.t_cljs$core$async29535(self__.flag,self__.cb,meta29536__$1));
});

cljs.core.async.t_cljs$core$async29535.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29537){
var self__ = this;
var _29537__$1 = this;
return self__.meta29536;
});

cljs.core.async.t_cljs$core$async29535.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29535.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async29535.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async29535.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async29535.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29536","meta29536",1612062501,null)], null);
});

cljs.core.async.t_cljs$core$async29535.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29535.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29535";

cljs.core.async.t_cljs$core$async29535.cljs$lang$ctorPrWriter = (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async29535");
});

cljs.core.async.__GT_t_cljs$core$async29535 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async29535(flag__$1,cb__$1,meta29536){
return (new cljs.core.async.t_cljs$core$async29535(flag__$1,cb__$1,meta29536));
});

}

return (new cljs.core.async.t_cljs$core$async29535(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29538_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29538_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29539_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29539_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__26741__auto__ = wport;
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
return port;
}
})()], null));
} else {
var G__29540 = (i + (1));
i = G__29540;
continue;
}
} else {
return null;
}
break;
}
})();
var or__26741__auto__ = ret;
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__26729__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__26729__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__26729__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__27964__auto__ = [];
var len__27957__auto___29546 = arguments.length;
var i__27958__auto___29547 = (0);
while(true){
if((i__27958__auto___29547 < len__27957__auto___29546)){
args__27964__auto__.push((arguments[i__27958__auto___29547]));

var G__29548 = (i__27958__auto___29547 + (1));
i__27958__auto___29547 = G__29548;
continue;
} else {
}
break;
}

var argseq__27965__auto__ = ((((1) < args__27964__auto__.length))?(new cljs.core.IndexedSeq(args__27964__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__27965__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29543){
var map__29544 = p__29543;
var map__29544__$1 = ((((!((map__29544 == null)))?((((map__29544.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29544.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29544):map__29544);
var opts = map__29544__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29541){
var G__29542 = cljs.core.first.call(null,seq29541);
var seq29541__$1 = cljs.core.next.call(null,seq29541);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29542,seq29541__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args29549 = [];
var len__27957__auto___29599 = arguments.length;
var i__27958__auto___29600 = (0);
while(true){
if((i__27958__auto___29600 < len__27957__auto___29599)){
args29549.push((arguments[i__27958__auto___29600]));

var G__29601 = (i__27958__auto___29600 + (1));
i__27958__auto___29600 = G__29601;
continue;
} else {
}
break;
}

var G__29551 = args29549.length;
switch (G__29551) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29549.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__29422__auto___29603 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___29603){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___29603){
return (function (state_29575){
var state_val_29576 = (state_29575[(1)]);
if((state_val_29576 === (7))){
var inst_29571 = (state_29575[(2)]);
var state_29575__$1 = state_29575;
var statearr_29577_29604 = state_29575__$1;
(statearr_29577_29604[(2)] = inst_29571);

(statearr_29577_29604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29576 === (1))){
var state_29575__$1 = state_29575;
var statearr_29578_29605 = state_29575__$1;
(statearr_29578_29605[(2)] = null);

(statearr_29578_29605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29576 === (4))){
var inst_29554 = (state_29575[(7)]);
var inst_29554__$1 = (state_29575[(2)]);
var inst_29555 = (inst_29554__$1 == null);
var state_29575__$1 = (function (){var statearr_29579 = state_29575;
(statearr_29579[(7)] = inst_29554__$1);

return statearr_29579;
})();
if(cljs.core.truth_(inst_29555)){
var statearr_29580_29606 = state_29575__$1;
(statearr_29580_29606[(1)] = (5));

} else {
var statearr_29581_29607 = state_29575__$1;
(statearr_29581_29607[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29576 === (13))){
var state_29575__$1 = state_29575;
var statearr_29582_29608 = state_29575__$1;
(statearr_29582_29608[(2)] = null);

(statearr_29582_29608[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29576 === (6))){
var inst_29554 = (state_29575[(7)]);
var state_29575__$1 = state_29575;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29575__$1,(11),to,inst_29554);
} else {
if((state_val_29576 === (3))){
var inst_29573 = (state_29575[(2)]);
var state_29575__$1 = state_29575;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29575__$1,inst_29573);
} else {
if((state_val_29576 === (12))){
var state_29575__$1 = state_29575;
var statearr_29583_29609 = state_29575__$1;
(statearr_29583_29609[(2)] = null);

(statearr_29583_29609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29576 === (2))){
var state_29575__$1 = state_29575;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29575__$1,(4),from);
} else {
if((state_val_29576 === (11))){
var inst_29564 = (state_29575[(2)]);
var state_29575__$1 = state_29575;
if(cljs.core.truth_(inst_29564)){
var statearr_29584_29610 = state_29575__$1;
(statearr_29584_29610[(1)] = (12));

} else {
var statearr_29585_29611 = state_29575__$1;
(statearr_29585_29611[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29576 === (9))){
var state_29575__$1 = state_29575;
var statearr_29586_29612 = state_29575__$1;
(statearr_29586_29612[(2)] = null);

(statearr_29586_29612[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29576 === (5))){
var state_29575__$1 = state_29575;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29587_29613 = state_29575__$1;
(statearr_29587_29613[(1)] = (8));

} else {
var statearr_29588_29614 = state_29575__$1;
(statearr_29588_29614[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29576 === (14))){
var inst_29569 = (state_29575[(2)]);
var state_29575__$1 = state_29575;
var statearr_29589_29615 = state_29575__$1;
(statearr_29589_29615[(2)] = inst_29569);

(statearr_29589_29615[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29576 === (10))){
var inst_29561 = (state_29575[(2)]);
var state_29575__$1 = state_29575;
var statearr_29590_29616 = state_29575__$1;
(statearr_29590_29616[(2)] = inst_29561);

(statearr_29590_29616[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29576 === (8))){
var inst_29558 = cljs.core.async.close_BANG_.call(null,to);
var state_29575__$1 = state_29575;
var statearr_29591_29617 = state_29575__$1;
(statearr_29591_29617[(2)] = inst_29558);

(statearr_29591_29617[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___29603))
;
return ((function (switch__29308__auto__,c__29422__auto___29603){
return (function() {
var cljs$core$async$state_machine__29309__auto__ = null;
var cljs$core$async$state_machine__29309__auto____0 = (function (){
var statearr_29595 = [null,null,null,null,null,null,null,null];
(statearr_29595[(0)] = cljs$core$async$state_machine__29309__auto__);

(statearr_29595[(1)] = (1));

return statearr_29595;
});
var cljs$core$async$state_machine__29309__auto____1 = (function (state_29575){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_29575);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e29596){if((e29596 instanceof Object)){
var ex__29312__auto__ = e29596;
var statearr_29597_29618 = state_29575;
(statearr_29597_29618[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29575);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29596;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29619 = state_29575;
state_29575 = G__29619;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$state_machine__29309__auto__ = function(state_29575){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29309__auto____1.call(this,state_29575);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29309__auto____0;
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29309__auto____1;
return cljs$core$async$state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___29603))
})();
var state__29424__auto__ = (function (){var statearr_29598 = f__29423__auto__.call(null);
(statearr_29598[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___29603);

return statearr_29598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___29603))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__29807){
var vec__29808 = p__29807;
var v = cljs.core.nth.call(null,vec__29808,(0),null);
var p = cljs.core.nth.call(null,vec__29808,(1),null);
var job = vec__29808;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__29422__auto___29994 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___29994,res,vec__29808,v,p,job,jobs,results){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___29994,res,vec__29808,v,p,job,jobs,results){
return (function (state_29815){
var state_val_29816 = (state_29815[(1)]);
if((state_val_29816 === (1))){
var state_29815__$1 = state_29815;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29815__$1,(2),res,v);
} else {
if((state_val_29816 === (2))){
var inst_29812 = (state_29815[(2)]);
var inst_29813 = cljs.core.async.close_BANG_.call(null,res);
var state_29815__$1 = (function (){var statearr_29817 = state_29815;
(statearr_29817[(7)] = inst_29812);

return statearr_29817;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29815__$1,inst_29813);
} else {
return null;
}
}
});})(c__29422__auto___29994,res,vec__29808,v,p,job,jobs,results))
;
return ((function (switch__29308__auto__,c__29422__auto___29994,res,vec__29808,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0 = (function (){
var statearr_29821 = [null,null,null,null,null,null,null,null];
(statearr_29821[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__);

(statearr_29821[(1)] = (1));

return statearr_29821;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1 = (function (state_29815){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_29815);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e29822){if((e29822 instanceof Object)){
var ex__29312__auto__ = e29822;
var statearr_29823_29995 = state_29815;
(statearr_29823_29995[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29815);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29822;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29996 = state_29815;
state_29815 = G__29996;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__ = function(state_29815){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1.call(this,state_29815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___29994,res,vec__29808,v,p,job,jobs,results))
})();
var state__29424__auto__ = (function (){var statearr_29824 = f__29423__auto__.call(null);
(statearr_29824[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___29994);

return statearr_29824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___29994,res,vec__29808,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__29825){
var vec__29826 = p__29825;
var v = cljs.core.nth.call(null,vec__29826,(0),null);
var p = cljs.core.nth.call(null,vec__29826,(1),null);
var job = vec__29826;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__27757__auto___29997 = n;
var __29998 = (0);
while(true){
if((__29998 < n__27757__auto___29997)){
var G__29829_29999 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__29829_29999) {
case "compute":
var c__29422__auto___30001 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__29998,c__29422__auto___30001,G__29829_29999,n__27757__auto___29997,jobs,results,process,async){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (__29998,c__29422__auto___30001,G__29829_29999,n__27757__auto___29997,jobs,results,process,async){
return (function (state_29842){
var state_val_29843 = (state_29842[(1)]);
if((state_val_29843 === (1))){
var state_29842__$1 = state_29842;
var statearr_29844_30002 = state_29842__$1;
(statearr_29844_30002[(2)] = null);

(statearr_29844_30002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29843 === (2))){
var state_29842__$1 = state_29842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29842__$1,(4),jobs);
} else {
if((state_val_29843 === (3))){
var inst_29840 = (state_29842[(2)]);
var state_29842__$1 = state_29842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29842__$1,inst_29840);
} else {
if((state_val_29843 === (4))){
var inst_29832 = (state_29842[(2)]);
var inst_29833 = process.call(null,inst_29832);
var state_29842__$1 = state_29842;
if(cljs.core.truth_(inst_29833)){
var statearr_29845_30003 = state_29842__$1;
(statearr_29845_30003[(1)] = (5));

} else {
var statearr_29846_30004 = state_29842__$1;
(statearr_29846_30004[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29843 === (5))){
var state_29842__$1 = state_29842;
var statearr_29847_30005 = state_29842__$1;
(statearr_29847_30005[(2)] = null);

(statearr_29847_30005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29843 === (6))){
var state_29842__$1 = state_29842;
var statearr_29848_30006 = state_29842__$1;
(statearr_29848_30006[(2)] = null);

(statearr_29848_30006[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29843 === (7))){
var inst_29838 = (state_29842[(2)]);
var state_29842__$1 = state_29842;
var statearr_29849_30007 = state_29842__$1;
(statearr_29849_30007[(2)] = inst_29838);

(statearr_29849_30007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__29998,c__29422__auto___30001,G__29829_29999,n__27757__auto___29997,jobs,results,process,async))
;
return ((function (__29998,switch__29308__auto__,c__29422__auto___30001,G__29829_29999,n__27757__auto___29997,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0 = (function (){
var statearr_29853 = [null,null,null,null,null,null,null];
(statearr_29853[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__);

(statearr_29853[(1)] = (1));

return statearr_29853;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1 = (function (state_29842){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_29842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e29854){if((e29854 instanceof Object)){
var ex__29312__auto__ = e29854;
var statearr_29855_30008 = state_29842;
(statearr_29855_30008[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29842);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29854;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30009 = state_29842;
state_29842 = G__30009;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__ = function(state_29842){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1.call(this,state_29842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__;
})()
;})(__29998,switch__29308__auto__,c__29422__auto___30001,G__29829_29999,n__27757__auto___29997,jobs,results,process,async))
})();
var state__29424__auto__ = (function (){var statearr_29856 = f__29423__auto__.call(null);
(statearr_29856[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___30001);

return statearr_29856;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(__29998,c__29422__auto___30001,G__29829_29999,n__27757__auto___29997,jobs,results,process,async))
);


break;
case "async":
var c__29422__auto___30010 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__29998,c__29422__auto___30010,G__29829_29999,n__27757__auto___29997,jobs,results,process,async){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (__29998,c__29422__auto___30010,G__29829_29999,n__27757__auto___29997,jobs,results,process,async){
return (function (state_29869){
var state_val_29870 = (state_29869[(1)]);
if((state_val_29870 === (1))){
var state_29869__$1 = state_29869;
var statearr_29871_30011 = state_29869__$1;
(statearr_29871_30011[(2)] = null);

(statearr_29871_30011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (2))){
var state_29869__$1 = state_29869;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29869__$1,(4),jobs);
} else {
if((state_val_29870 === (3))){
var inst_29867 = (state_29869[(2)]);
var state_29869__$1 = state_29869;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29869__$1,inst_29867);
} else {
if((state_val_29870 === (4))){
var inst_29859 = (state_29869[(2)]);
var inst_29860 = async.call(null,inst_29859);
var state_29869__$1 = state_29869;
if(cljs.core.truth_(inst_29860)){
var statearr_29872_30012 = state_29869__$1;
(statearr_29872_30012[(1)] = (5));

} else {
var statearr_29873_30013 = state_29869__$1;
(statearr_29873_30013[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (5))){
var state_29869__$1 = state_29869;
var statearr_29874_30014 = state_29869__$1;
(statearr_29874_30014[(2)] = null);

(statearr_29874_30014[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (6))){
var state_29869__$1 = state_29869;
var statearr_29875_30015 = state_29869__$1;
(statearr_29875_30015[(2)] = null);

(statearr_29875_30015[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29870 === (7))){
var inst_29865 = (state_29869[(2)]);
var state_29869__$1 = state_29869;
var statearr_29876_30016 = state_29869__$1;
(statearr_29876_30016[(2)] = inst_29865);

(statearr_29876_30016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__29998,c__29422__auto___30010,G__29829_29999,n__27757__auto___29997,jobs,results,process,async))
;
return ((function (__29998,switch__29308__auto__,c__29422__auto___30010,G__29829_29999,n__27757__auto___29997,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0 = (function (){
var statearr_29880 = [null,null,null,null,null,null,null];
(statearr_29880[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__);

(statearr_29880[(1)] = (1));

return statearr_29880;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1 = (function (state_29869){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_29869);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e29881){if((e29881 instanceof Object)){
var ex__29312__auto__ = e29881;
var statearr_29882_30017 = state_29869;
(statearr_29882_30017[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29869);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29881;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30018 = state_29869;
state_29869 = G__30018;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__ = function(state_29869){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1.call(this,state_29869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__;
})()
;})(__29998,switch__29308__auto__,c__29422__auto___30010,G__29829_29999,n__27757__auto___29997,jobs,results,process,async))
})();
var state__29424__auto__ = (function (){var statearr_29883 = f__29423__auto__.call(null);
(statearr_29883[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___30010);

return statearr_29883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(__29998,c__29422__auto___30010,G__29829_29999,n__27757__auto___29997,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__30019 = (__29998 + (1));
__29998 = G__30019;
continue;
} else {
}
break;
}

var c__29422__auto___30020 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___30020,jobs,results,process,async){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___30020,jobs,results,process,async){
return (function (state_29905){
var state_val_29906 = (state_29905[(1)]);
if((state_val_29906 === (1))){
var state_29905__$1 = state_29905;
var statearr_29907_30021 = state_29905__$1;
(statearr_29907_30021[(2)] = null);

(statearr_29907_30021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (2))){
var state_29905__$1 = state_29905;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29905__$1,(4),from);
} else {
if((state_val_29906 === (3))){
var inst_29903 = (state_29905[(2)]);
var state_29905__$1 = state_29905;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29905__$1,inst_29903);
} else {
if((state_val_29906 === (4))){
var inst_29886 = (state_29905[(7)]);
var inst_29886__$1 = (state_29905[(2)]);
var inst_29887 = (inst_29886__$1 == null);
var state_29905__$1 = (function (){var statearr_29908 = state_29905;
(statearr_29908[(7)] = inst_29886__$1);

return statearr_29908;
})();
if(cljs.core.truth_(inst_29887)){
var statearr_29909_30022 = state_29905__$1;
(statearr_29909_30022[(1)] = (5));

} else {
var statearr_29910_30023 = state_29905__$1;
(statearr_29910_30023[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (5))){
var inst_29889 = cljs.core.async.close_BANG_.call(null,jobs);
var state_29905__$1 = state_29905;
var statearr_29911_30024 = state_29905__$1;
(statearr_29911_30024[(2)] = inst_29889);

(statearr_29911_30024[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (6))){
var inst_29891 = (state_29905[(8)]);
var inst_29886 = (state_29905[(7)]);
var inst_29891__$1 = cljs.core.async.chan.call(null,(1));
var inst_29892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29893 = [inst_29886,inst_29891__$1];
var inst_29894 = (new cljs.core.PersistentVector(null,2,(5),inst_29892,inst_29893,null));
var state_29905__$1 = (function (){var statearr_29912 = state_29905;
(statearr_29912[(8)] = inst_29891__$1);

return statearr_29912;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29905__$1,(8),jobs,inst_29894);
} else {
if((state_val_29906 === (7))){
var inst_29901 = (state_29905[(2)]);
var state_29905__$1 = state_29905;
var statearr_29913_30025 = state_29905__$1;
(statearr_29913_30025[(2)] = inst_29901);

(statearr_29913_30025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29906 === (8))){
var inst_29891 = (state_29905[(8)]);
var inst_29896 = (state_29905[(2)]);
var state_29905__$1 = (function (){var statearr_29914 = state_29905;
(statearr_29914[(9)] = inst_29896);

return statearr_29914;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29905__$1,(9),results,inst_29891);
} else {
if((state_val_29906 === (9))){
var inst_29898 = (state_29905[(2)]);
var state_29905__$1 = (function (){var statearr_29915 = state_29905;
(statearr_29915[(10)] = inst_29898);

return statearr_29915;
})();
var statearr_29916_30026 = state_29905__$1;
(statearr_29916_30026[(2)] = null);

(statearr_29916_30026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___30020,jobs,results,process,async))
;
return ((function (switch__29308__auto__,c__29422__auto___30020,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0 = (function (){
var statearr_29920 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29920[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__);

(statearr_29920[(1)] = (1));

return statearr_29920;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1 = (function (state_29905){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_29905);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e29921){if((e29921 instanceof Object)){
var ex__29312__auto__ = e29921;
var statearr_29922_30027 = state_29905;
(statearr_29922_30027[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29905);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29921;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30028 = state_29905;
state_29905 = G__30028;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__ = function(state_29905){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1.call(this,state_29905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___30020,jobs,results,process,async))
})();
var state__29424__auto__ = (function (){var statearr_29923 = f__29423__auto__.call(null);
(statearr_29923[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___30020);

return statearr_29923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___30020,jobs,results,process,async))
);


var c__29422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto__,jobs,results,process,async){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto__,jobs,results,process,async){
return (function (state_29961){
var state_val_29962 = (state_29961[(1)]);
if((state_val_29962 === (7))){
var inst_29957 = (state_29961[(2)]);
var state_29961__$1 = state_29961;
var statearr_29963_30029 = state_29961__$1;
(statearr_29963_30029[(2)] = inst_29957);

(statearr_29963_30029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (20))){
var state_29961__$1 = state_29961;
var statearr_29964_30030 = state_29961__$1;
(statearr_29964_30030[(2)] = null);

(statearr_29964_30030[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (1))){
var state_29961__$1 = state_29961;
var statearr_29965_30031 = state_29961__$1;
(statearr_29965_30031[(2)] = null);

(statearr_29965_30031[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (4))){
var inst_29926 = (state_29961[(7)]);
var inst_29926__$1 = (state_29961[(2)]);
var inst_29927 = (inst_29926__$1 == null);
var state_29961__$1 = (function (){var statearr_29966 = state_29961;
(statearr_29966[(7)] = inst_29926__$1);

return statearr_29966;
})();
if(cljs.core.truth_(inst_29927)){
var statearr_29967_30032 = state_29961__$1;
(statearr_29967_30032[(1)] = (5));

} else {
var statearr_29968_30033 = state_29961__$1;
(statearr_29968_30033[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (15))){
var inst_29939 = (state_29961[(8)]);
var state_29961__$1 = state_29961;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29961__$1,(18),to,inst_29939);
} else {
if((state_val_29962 === (21))){
var inst_29952 = (state_29961[(2)]);
var state_29961__$1 = state_29961;
var statearr_29969_30034 = state_29961__$1;
(statearr_29969_30034[(2)] = inst_29952);

(statearr_29969_30034[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (13))){
var inst_29954 = (state_29961[(2)]);
var state_29961__$1 = (function (){var statearr_29970 = state_29961;
(statearr_29970[(9)] = inst_29954);

return statearr_29970;
})();
var statearr_29971_30035 = state_29961__$1;
(statearr_29971_30035[(2)] = null);

(statearr_29971_30035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (6))){
var inst_29926 = (state_29961[(7)]);
var state_29961__$1 = state_29961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29961__$1,(11),inst_29926);
} else {
if((state_val_29962 === (17))){
var inst_29947 = (state_29961[(2)]);
var state_29961__$1 = state_29961;
if(cljs.core.truth_(inst_29947)){
var statearr_29972_30036 = state_29961__$1;
(statearr_29972_30036[(1)] = (19));

} else {
var statearr_29973_30037 = state_29961__$1;
(statearr_29973_30037[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (3))){
var inst_29959 = (state_29961[(2)]);
var state_29961__$1 = state_29961;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29961__$1,inst_29959);
} else {
if((state_val_29962 === (12))){
var inst_29936 = (state_29961[(10)]);
var state_29961__$1 = state_29961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29961__$1,(14),inst_29936);
} else {
if((state_val_29962 === (2))){
var state_29961__$1 = state_29961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29961__$1,(4),results);
} else {
if((state_val_29962 === (19))){
var state_29961__$1 = state_29961;
var statearr_29974_30038 = state_29961__$1;
(statearr_29974_30038[(2)] = null);

(statearr_29974_30038[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (11))){
var inst_29936 = (state_29961[(2)]);
var state_29961__$1 = (function (){var statearr_29975 = state_29961;
(statearr_29975[(10)] = inst_29936);

return statearr_29975;
})();
var statearr_29976_30039 = state_29961__$1;
(statearr_29976_30039[(2)] = null);

(statearr_29976_30039[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (9))){
var state_29961__$1 = state_29961;
var statearr_29977_30040 = state_29961__$1;
(statearr_29977_30040[(2)] = null);

(statearr_29977_30040[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (5))){
var state_29961__$1 = state_29961;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29978_30041 = state_29961__$1;
(statearr_29978_30041[(1)] = (8));

} else {
var statearr_29979_30042 = state_29961__$1;
(statearr_29979_30042[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (14))){
var inst_29939 = (state_29961[(8)]);
var inst_29941 = (state_29961[(11)]);
var inst_29939__$1 = (state_29961[(2)]);
var inst_29940 = (inst_29939__$1 == null);
var inst_29941__$1 = cljs.core.not.call(null,inst_29940);
var state_29961__$1 = (function (){var statearr_29980 = state_29961;
(statearr_29980[(8)] = inst_29939__$1);

(statearr_29980[(11)] = inst_29941__$1);

return statearr_29980;
})();
if(inst_29941__$1){
var statearr_29981_30043 = state_29961__$1;
(statearr_29981_30043[(1)] = (15));

} else {
var statearr_29982_30044 = state_29961__$1;
(statearr_29982_30044[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (16))){
var inst_29941 = (state_29961[(11)]);
var state_29961__$1 = state_29961;
var statearr_29983_30045 = state_29961__$1;
(statearr_29983_30045[(2)] = inst_29941);

(statearr_29983_30045[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (10))){
var inst_29933 = (state_29961[(2)]);
var state_29961__$1 = state_29961;
var statearr_29984_30046 = state_29961__$1;
(statearr_29984_30046[(2)] = inst_29933);

(statearr_29984_30046[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (18))){
var inst_29944 = (state_29961[(2)]);
var state_29961__$1 = state_29961;
var statearr_29985_30047 = state_29961__$1;
(statearr_29985_30047[(2)] = inst_29944);

(statearr_29985_30047[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29962 === (8))){
var inst_29930 = cljs.core.async.close_BANG_.call(null,to);
var state_29961__$1 = state_29961;
var statearr_29986_30048 = state_29961__$1;
(statearr_29986_30048[(2)] = inst_29930);

(statearr_29986_30048[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto__,jobs,results,process,async))
;
return ((function (switch__29308__auto__,c__29422__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0 = (function (){
var statearr_29990 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29990[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__);

(statearr_29990[(1)] = (1));

return statearr_29990;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1 = (function (state_29961){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_29961);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e29991){if((e29991 instanceof Object)){
var ex__29312__auto__ = e29991;
var statearr_29992_30049 = state_29961;
(statearr_29992_30049[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29961);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29991;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30050 = state_29961;
state_29961 = G__30050;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__ = function(state_29961){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1.call(this,state_29961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29309__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto__,jobs,results,process,async))
})();
var state__29424__auto__ = (function (){var statearr_29993 = f__29423__auto__.call(null);
(statearr_29993[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto__);

return statearr_29993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto__,jobs,results,process,async))
);

return c__29422__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args30051 = [];
var len__27957__auto___30054 = arguments.length;
var i__27958__auto___30055 = (0);
while(true){
if((i__27958__auto___30055 < len__27957__auto___30054)){
args30051.push((arguments[i__27958__auto___30055]));

var G__30056 = (i__27958__auto___30055 + (1));
i__27958__auto___30055 = G__30056;
continue;
} else {
}
break;
}

var G__30053 = args30051.length;
switch (G__30053) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30051.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args30058 = [];
var len__27957__auto___30061 = arguments.length;
var i__27958__auto___30062 = (0);
while(true){
if((i__27958__auto___30062 < len__27957__auto___30061)){
args30058.push((arguments[i__27958__auto___30062]));

var G__30063 = (i__27958__auto___30062 + (1));
i__27958__auto___30062 = G__30063;
continue;
} else {
}
break;
}

var G__30060 = args30058.length;
switch (G__30060) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30058.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args30065 = [];
var len__27957__auto___30118 = arguments.length;
var i__27958__auto___30119 = (0);
while(true){
if((i__27958__auto___30119 < len__27957__auto___30118)){
args30065.push((arguments[i__27958__auto___30119]));

var G__30120 = (i__27958__auto___30119 + (1));
i__27958__auto___30119 = G__30120;
continue;
} else {
}
break;
}

var G__30067 = args30065.length;
switch (G__30067) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30065.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__29422__auto___30122 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___30122,tc,fc){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___30122,tc,fc){
return (function (state_30093){
var state_val_30094 = (state_30093[(1)]);
if((state_val_30094 === (7))){
var inst_30089 = (state_30093[(2)]);
var state_30093__$1 = state_30093;
var statearr_30095_30123 = state_30093__$1;
(statearr_30095_30123[(2)] = inst_30089);

(statearr_30095_30123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (1))){
var state_30093__$1 = state_30093;
var statearr_30096_30124 = state_30093__$1;
(statearr_30096_30124[(2)] = null);

(statearr_30096_30124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (4))){
var inst_30070 = (state_30093[(7)]);
var inst_30070__$1 = (state_30093[(2)]);
var inst_30071 = (inst_30070__$1 == null);
var state_30093__$1 = (function (){var statearr_30097 = state_30093;
(statearr_30097[(7)] = inst_30070__$1);

return statearr_30097;
})();
if(cljs.core.truth_(inst_30071)){
var statearr_30098_30125 = state_30093__$1;
(statearr_30098_30125[(1)] = (5));

} else {
var statearr_30099_30126 = state_30093__$1;
(statearr_30099_30126[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (13))){
var state_30093__$1 = state_30093;
var statearr_30100_30127 = state_30093__$1;
(statearr_30100_30127[(2)] = null);

(statearr_30100_30127[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (6))){
var inst_30070 = (state_30093[(7)]);
var inst_30076 = p.call(null,inst_30070);
var state_30093__$1 = state_30093;
if(cljs.core.truth_(inst_30076)){
var statearr_30101_30128 = state_30093__$1;
(statearr_30101_30128[(1)] = (9));

} else {
var statearr_30102_30129 = state_30093__$1;
(statearr_30102_30129[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (3))){
var inst_30091 = (state_30093[(2)]);
var state_30093__$1 = state_30093;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30093__$1,inst_30091);
} else {
if((state_val_30094 === (12))){
var state_30093__$1 = state_30093;
var statearr_30103_30130 = state_30093__$1;
(statearr_30103_30130[(2)] = null);

(statearr_30103_30130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (2))){
var state_30093__$1 = state_30093;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30093__$1,(4),ch);
} else {
if((state_val_30094 === (11))){
var inst_30070 = (state_30093[(7)]);
var inst_30080 = (state_30093[(2)]);
var state_30093__$1 = state_30093;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30093__$1,(8),inst_30080,inst_30070);
} else {
if((state_val_30094 === (9))){
var state_30093__$1 = state_30093;
var statearr_30104_30131 = state_30093__$1;
(statearr_30104_30131[(2)] = tc);

(statearr_30104_30131[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (5))){
var inst_30073 = cljs.core.async.close_BANG_.call(null,tc);
var inst_30074 = cljs.core.async.close_BANG_.call(null,fc);
var state_30093__$1 = (function (){var statearr_30105 = state_30093;
(statearr_30105[(8)] = inst_30073);

return statearr_30105;
})();
var statearr_30106_30132 = state_30093__$1;
(statearr_30106_30132[(2)] = inst_30074);

(statearr_30106_30132[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (14))){
var inst_30087 = (state_30093[(2)]);
var state_30093__$1 = state_30093;
var statearr_30107_30133 = state_30093__$1;
(statearr_30107_30133[(2)] = inst_30087);

(statearr_30107_30133[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (10))){
var state_30093__$1 = state_30093;
var statearr_30108_30134 = state_30093__$1;
(statearr_30108_30134[(2)] = fc);

(statearr_30108_30134[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30094 === (8))){
var inst_30082 = (state_30093[(2)]);
var state_30093__$1 = state_30093;
if(cljs.core.truth_(inst_30082)){
var statearr_30109_30135 = state_30093__$1;
(statearr_30109_30135[(1)] = (12));

} else {
var statearr_30110_30136 = state_30093__$1;
(statearr_30110_30136[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___30122,tc,fc))
;
return ((function (switch__29308__auto__,c__29422__auto___30122,tc,fc){
return (function() {
var cljs$core$async$state_machine__29309__auto__ = null;
var cljs$core$async$state_machine__29309__auto____0 = (function (){
var statearr_30114 = [null,null,null,null,null,null,null,null,null];
(statearr_30114[(0)] = cljs$core$async$state_machine__29309__auto__);

(statearr_30114[(1)] = (1));

return statearr_30114;
});
var cljs$core$async$state_machine__29309__auto____1 = (function (state_30093){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_30093);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e30115){if((e30115 instanceof Object)){
var ex__29312__auto__ = e30115;
var statearr_30116_30137 = state_30093;
(statearr_30116_30137[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30093);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30115;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30138 = state_30093;
state_30093 = G__30138;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$state_machine__29309__auto__ = function(state_30093){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29309__auto____1.call(this,state_30093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29309__auto____0;
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29309__auto____1;
return cljs$core$async$state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___30122,tc,fc))
})();
var state__29424__auto__ = (function (){var statearr_30117 = f__29423__auto__.call(null);
(statearr_30117[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___30122);

return statearr_30117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___30122,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__29422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto__){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto__){
return (function (state_30202){
var state_val_30203 = (state_30202[(1)]);
if((state_val_30203 === (7))){
var inst_30198 = (state_30202[(2)]);
var state_30202__$1 = state_30202;
var statearr_30204_30225 = state_30202__$1;
(statearr_30204_30225[(2)] = inst_30198);

(statearr_30204_30225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30203 === (1))){
var inst_30182 = init;
var state_30202__$1 = (function (){var statearr_30205 = state_30202;
(statearr_30205[(7)] = inst_30182);

return statearr_30205;
})();
var statearr_30206_30226 = state_30202__$1;
(statearr_30206_30226[(2)] = null);

(statearr_30206_30226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30203 === (4))){
var inst_30185 = (state_30202[(8)]);
var inst_30185__$1 = (state_30202[(2)]);
var inst_30186 = (inst_30185__$1 == null);
var state_30202__$1 = (function (){var statearr_30207 = state_30202;
(statearr_30207[(8)] = inst_30185__$1);

return statearr_30207;
})();
if(cljs.core.truth_(inst_30186)){
var statearr_30208_30227 = state_30202__$1;
(statearr_30208_30227[(1)] = (5));

} else {
var statearr_30209_30228 = state_30202__$1;
(statearr_30209_30228[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30203 === (6))){
var inst_30189 = (state_30202[(9)]);
var inst_30182 = (state_30202[(7)]);
var inst_30185 = (state_30202[(8)]);
var inst_30189__$1 = f.call(null,inst_30182,inst_30185);
var inst_30190 = cljs.core.reduced_QMARK_.call(null,inst_30189__$1);
var state_30202__$1 = (function (){var statearr_30210 = state_30202;
(statearr_30210[(9)] = inst_30189__$1);

return statearr_30210;
})();
if(inst_30190){
var statearr_30211_30229 = state_30202__$1;
(statearr_30211_30229[(1)] = (8));

} else {
var statearr_30212_30230 = state_30202__$1;
(statearr_30212_30230[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30203 === (3))){
var inst_30200 = (state_30202[(2)]);
var state_30202__$1 = state_30202;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30202__$1,inst_30200);
} else {
if((state_val_30203 === (2))){
var state_30202__$1 = state_30202;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30202__$1,(4),ch);
} else {
if((state_val_30203 === (9))){
var inst_30189 = (state_30202[(9)]);
var inst_30182 = inst_30189;
var state_30202__$1 = (function (){var statearr_30213 = state_30202;
(statearr_30213[(7)] = inst_30182);

return statearr_30213;
})();
var statearr_30214_30231 = state_30202__$1;
(statearr_30214_30231[(2)] = null);

(statearr_30214_30231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30203 === (5))){
var inst_30182 = (state_30202[(7)]);
var state_30202__$1 = state_30202;
var statearr_30215_30232 = state_30202__$1;
(statearr_30215_30232[(2)] = inst_30182);

(statearr_30215_30232[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30203 === (10))){
var inst_30196 = (state_30202[(2)]);
var state_30202__$1 = state_30202;
var statearr_30216_30233 = state_30202__$1;
(statearr_30216_30233[(2)] = inst_30196);

(statearr_30216_30233[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30203 === (8))){
var inst_30189 = (state_30202[(9)]);
var inst_30192 = cljs.core.deref.call(null,inst_30189);
var state_30202__$1 = state_30202;
var statearr_30217_30234 = state_30202__$1;
(statearr_30217_30234[(2)] = inst_30192);

(statearr_30217_30234[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto__))
;
return ((function (switch__29308__auto__,c__29422__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__29309__auto__ = null;
var cljs$core$async$reduce_$_state_machine__29309__auto____0 = (function (){
var statearr_30221 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30221[(0)] = cljs$core$async$reduce_$_state_machine__29309__auto__);

(statearr_30221[(1)] = (1));

return statearr_30221;
});
var cljs$core$async$reduce_$_state_machine__29309__auto____1 = (function (state_30202){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_30202);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e30222){if((e30222 instanceof Object)){
var ex__29312__auto__ = e30222;
var statearr_30223_30235 = state_30202;
(statearr_30223_30235[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30202);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30222;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30236 = state_30202;
state_30202 = G__30236;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__29309__auto__ = function(state_30202){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__29309__auto____1.call(this,state_30202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__29309__auto____0;
cljs$core$async$reduce_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__29309__auto____1;
return cljs$core$async$reduce_$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto__))
})();
var state__29424__auto__ = (function (){var statearr_30224 = f__29423__auto__.call(null);
(statearr_30224[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto__);

return statearr_30224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto__))
);

return c__29422__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args30237 = [];
var len__27957__auto___30289 = arguments.length;
var i__27958__auto___30290 = (0);
while(true){
if((i__27958__auto___30290 < len__27957__auto___30289)){
args30237.push((arguments[i__27958__auto___30290]));

var G__30291 = (i__27958__auto___30290 + (1));
i__27958__auto___30290 = G__30291;
continue;
} else {
}
break;
}

var G__30239 = args30237.length;
switch (G__30239) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30237.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__29422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto__){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto__){
return (function (state_30264){
var state_val_30265 = (state_30264[(1)]);
if((state_val_30265 === (7))){
var inst_30246 = (state_30264[(2)]);
var state_30264__$1 = state_30264;
var statearr_30266_30293 = state_30264__$1;
(statearr_30266_30293[(2)] = inst_30246);

(statearr_30266_30293[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30265 === (1))){
var inst_30240 = cljs.core.seq.call(null,coll);
var inst_30241 = inst_30240;
var state_30264__$1 = (function (){var statearr_30267 = state_30264;
(statearr_30267[(7)] = inst_30241);

return statearr_30267;
})();
var statearr_30268_30294 = state_30264__$1;
(statearr_30268_30294[(2)] = null);

(statearr_30268_30294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30265 === (4))){
var inst_30241 = (state_30264[(7)]);
var inst_30244 = cljs.core.first.call(null,inst_30241);
var state_30264__$1 = state_30264;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30264__$1,(7),ch,inst_30244);
} else {
if((state_val_30265 === (13))){
var inst_30258 = (state_30264[(2)]);
var state_30264__$1 = state_30264;
var statearr_30269_30295 = state_30264__$1;
(statearr_30269_30295[(2)] = inst_30258);

(statearr_30269_30295[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30265 === (6))){
var inst_30249 = (state_30264[(2)]);
var state_30264__$1 = state_30264;
if(cljs.core.truth_(inst_30249)){
var statearr_30270_30296 = state_30264__$1;
(statearr_30270_30296[(1)] = (8));

} else {
var statearr_30271_30297 = state_30264__$1;
(statearr_30271_30297[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30265 === (3))){
var inst_30262 = (state_30264[(2)]);
var state_30264__$1 = state_30264;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30264__$1,inst_30262);
} else {
if((state_val_30265 === (12))){
var state_30264__$1 = state_30264;
var statearr_30272_30298 = state_30264__$1;
(statearr_30272_30298[(2)] = null);

(statearr_30272_30298[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30265 === (2))){
var inst_30241 = (state_30264[(7)]);
var state_30264__$1 = state_30264;
if(cljs.core.truth_(inst_30241)){
var statearr_30273_30299 = state_30264__$1;
(statearr_30273_30299[(1)] = (4));

} else {
var statearr_30274_30300 = state_30264__$1;
(statearr_30274_30300[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30265 === (11))){
var inst_30255 = cljs.core.async.close_BANG_.call(null,ch);
var state_30264__$1 = state_30264;
var statearr_30275_30301 = state_30264__$1;
(statearr_30275_30301[(2)] = inst_30255);

(statearr_30275_30301[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30265 === (9))){
var state_30264__$1 = state_30264;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30276_30302 = state_30264__$1;
(statearr_30276_30302[(1)] = (11));

} else {
var statearr_30277_30303 = state_30264__$1;
(statearr_30277_30303[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30265 === (5))){
var inst_30241 = (state_30264[(7)]);
var state_30264__$1 = state_30264;
var statearr_30278_30304 = state_30264__$1;
(statearr_30278_30304[(2)] = inst_30241);

(statearr_30278_30304[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30265 === (10))){
var inst_30260 = (state_30264[(2)]);
var state_30264__$1 = state_30264;
var statearr_30279_30305 = state_30264__$1;
(statearr_30279_30305[(2)] = inst_30260);

(statearr_30279_30305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30265 === (8))){
var inst_30241 = (state_30264[(7)]);
var inst_30251 = cljs.core.next.call(null,inst_30241);
var inst_30241__$1 = inst_30251;
var state_30264__$1 = (function (){var statearr_30280 = state_30264;
(statearr_30280[(7)] = inst_30241__$1);

return statearr_30280;
})();
var statearr_30281_30306 = state_30264__$1;
(statearr_30281_30306[(2)] = null);

(statearr_30281_30306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto__))
;
return ((function (switch__29308__auto__,c__29422__auto__){
return (function() {
var cljs$core$async$state_machine__29309__auto__ = null;
var cljs$core$async$state_machine__29309__auto____0 = (function (){
var statearr_30285 = [null,null,null,null,null,null,null,null];
(statearr_30285[(0)] = cljs$core$async$state_machine__29309__auto__);

(statearr_30285[(1)] = (1));

return statearr_30285;
});
var cljs$core$async$state_machine__29309__auto____1 = (function (state_30264){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_30264);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e30286){if((e30286 instanceof Object)){
var ex__29312__auto__ = e30286;
var statearr_30287_30307 = state_30264;
(statearr_30287_30307[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30264);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30286;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30308 = state_30264;
state_30264 = G__30308;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$state_machine__29309__auto__ = function(state_30264){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29309__auto____1.call(this,state_30264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29309__auto____0;
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29309__auto____1;
return cljs$core$async$state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto__))
})();
var state__29424__auto__ = (function (){var statearr_30288 = f__29423__auto__.call(null);
(statearr_30288[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto__);

return statearr_30288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto__))
);

return c__29422__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27454__auto__ = (((_ == null))?null:_);
var m__27455__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,_);
} else {
var m__27455__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27455__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m,ch);
} else {
var m__27455__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m);
} else {
var m__27455__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async30534 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30534 = (function (ch,cs,meta30535){
this.ch = ch;
this.cs = cs;
this.meta30535 = meta30535;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30534.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_30536,meta30535__$1){
var self__ = this;
var _30536__$1 = this;
return (new cljs.core.async.t_cljs$core$async30534(self__.ch,self__.cs,meta30535__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async30534.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_30536){
var self__ = this;
var _30536__$1 = this;
return self__.meta30535;
});})(cs))
;

cljs.core.async.t_cljs$core$async30534.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30534.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async30534.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30534.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30534.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30534.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30534.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30535","meta30535",688770429,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async30534.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30534.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30534";

cljs.core.async.t_cljs$core$async30534.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async30534");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async30534 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async30534(ch__$1,cs__$1,meta30535){
return (new cljs.core.async.t_cljs$core$async30534(ch__$1,cs__$1,meta30535));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async30534(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__29422__auto___30759 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___30759,cs,m,dchan,dctr,done){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___30759,cs,m,dchan,dctr,done){
return (function (state_30671){
var state_val_30672 = (state_30671[(1)]);
if((state_val_30672 === (7))){
var inst_30667 = (state_30671[(2)]);
var state_30671__$1 = state_30671;
var statearr_30673_30760 = state_30671__$1;
(statearr_30673_30760[(2)] = inst_30667);

(statearr_30673_30760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (20))){
var inst_30570 = (state_30671[(7)]);
var inst_30582 = cljs.core.first.call(null,inst_30570);
var inst_30583 = cljs.core.nth.call(null,inst_30582,(0),null);
var inst_30584 = cljs.core.nth.call(null,inst_30582,(1),null);
var state_30671__$1 = (function (){var statearr_30674 = state_30671;
(statearr_30674[(8)] = inst_30583);

return statearr_30674;
})();
if(cljs.core.truth_(inst_30584)){
var statearr_30675_30761 = state_30671__$1;
(statearr_30675_30761[(1)] = (22));

} else {
var statearr_30676_30762 = state_30671__$1;
(statearr_30676_30762[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (27))){
var inst_30619 = (state_30671[(9)]);
var inst_30614 = (state_30671[(10)]);
var inst_30612 = (state_30671[(11)]);
var inst_30539 = (state_30671[(12)]);
var inst_30619__$1 = cljs.core._nth.call(null,inst_30612,inst_30614);
var inst_30620 = cljs.core.async.put_BANG_.call(null,inst_30619__$1,inst_30539,done);
var state_30671__$1 = (function (){var statearr_30677 = state_30671;
(statearr_30677[(9)] = inst_30619__$1);

return statearr_30677;
})();
if(cljs.core.truth_(inst_30620)){
var statearr_30678_30763 = state_30671__$1;
(statearr_30678_30763[(1)] = (30));

} else {
var statearr_30679_30764 = state_30671__$1;
(statearr_30679_30764[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (1))){
var state_30671__$1 = state_30671;
var statearr_30680_30765 = state_30671__$1;
(statearr_30680_30765[(2)] = null);

(statearr_30680_30765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (24))){
var inst_30570 = (state_30671[(7)]);
var inst_30589 = (state_30671[(2)]);
var inst_30590 = cljs.core.next.call(null,inst_30570);
var inst_30548 = inst_30590;
var inst_30549 = null;
var inst_30550 = (0);
var inst_30551 = (0);
var state_30671__$1 = (function (){var statearr_30681 = state_30671;
(statearr_30681[(13)] = inst_30551);

(statearr_30681[(14)] = inst_30550);

(statearr_30681[(15)] = inst_30548);

(statearr_30681[(16)] = inst_30549);

(statearr_30681[(17)] = inst_30589);

return statearr_30681;
})();
var statearr_30682_30766 = state_30671__$1;
(statearr_30682_30766[(2)] = null);

(statearr_30682_30766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (39))){
var state_30671__$1 = state_30671;
var statearr_30686_30767 = state_30671__$1;
(statearr_30686_30767[(2)] = null);

(statearr_30686_30767[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (4))){
var inst_30539 = (state_30671[(12)]);
var inst_30539__$1 = (state_30671[(2)]);
var inst_30540 = (inst_30539__$1 == null);
var state_30671__$1 = (function (){var statearr_30687 = state_30671;
(statearr_30687[(12)] = inst_30539__$1);

return statearr_30687;
})();
if(cljs.core.truth_(inst_30540)){
var statearr_30688_30768 = state_30671__$1;
(statearr_30688_30768[(1)] = (5));

} else {
var statearr_30689_30769 = state_30671__$1;
(statearr_30689_30769[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (15))){
var inst_30551 = (state_30671[(13)]);
var inst_30550 = (state_30671[(14)]);
var inst_30548 = (state_30671[(15)]);
var inst_30549 = (state_30671[(16)]);
var inst_30566 = (state_30671[(2)]);
var inst_30567 = (inst_30551 + (1));
var tmp30683 = inst_30550;
var tmp30684 = inst_30548;
var tmp30685 = inst_30549;
var inst_30548__$1 = tmp30684;
var inst_30549__$1 = tmp30685;
var inst_30550__$1 = tmp30683;
var inst_30551__$1 = inst_30567;
var state_30671__$1 = (function (){var statearr_30690 = state_30671;
(statearr_30690[(13)] = inst_30551__$1);

(statearr_30690[(18)] = inst_30566);

(statearr_30690[(14)] = inst_30550__$1);

(statearr_30690[(15)] = inst_30548__$1);

(statearr_30690[(16)] = inst_30549__$1);

return statearr_30690;
})();
var statearr_30691_30770 = state_30671__$1;
(statearr_30691_30770[(2)] = null);

(statearr_30691_30770[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (21))){
var inst_30593 = (state_30671[(2)]);
var state_30671__$1 = state_30671;
var statearr_30695_30771 = state_30671__$1;
(statearr_30695_30771[(2)] = inst_30593);

(statearr_30695_30771[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (31))){
var inst_30619 = (state_30671[(9)]);
var inst_30623 = done.call(null,null);
var inst_30624 = cljs.core.async.untap_STAR_.call(null,m,inst_30619);
var state_30671__$1 = (function (){var statearr_30696 = state_30671;
(statearr_30696[(19)] = inst_30623);

return statearr_30696;
})();
var statearr_30697_30772 = state_30671__$1;
(statearr_30697_30772[(2)] = inst_30624);

(statearr_30697_30772[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (32))){
var inst_30614 = (state_30671[(10)]);
var inst_30612 = (state_30671[(11)]);
var inst_30613 = (state_30671[(20)]);
var inst_30611 = (state_30671[(21)]);
var inst_30626 = (state_30671[(2)]);
var inst_30627 = (inst_30614 + (1));
var tmp30692 = inst_30612;
var tmp30693 = inst_30613;
var tmp30694 = inst_30611;
var inst_30611__$1 = tmp30694;
var inst_30612__$1 = tmp30692;
var inst_30613__$1 = tmp30693;
var inst_30614__$1 = inst_30627;
var state_30671__$1 = (function (){var statearr_30698 = state_30671;
(statearr_30698[(10)] = inst_30614__$1);

(statearr_30698[(11)] = inst_30612__$1);

(statearr_30698[(22)] = inst_30626);

(statearr_30698[(20)] = inst_30613__$1);

(statearr_30698[(21)] = inst_30611__$1);

return statearr_30698;
})();
var statearr_30699_30773 = state_30671__$1;
(statearr_30699_30773[(2)] = null);

(statearr_30699_30773[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (40))){
var inst_30639 = (state_30671[(23)]);
var inst_30643 = done.call(null,null);
var inst_30644 = cljs.core.async.untap_STAR_.call(null,m,inst_30639);
var state_30671__$1 = (function (){var statearr_30700 = state_30671;
(statearr_30700[(24)] = inst_30643);

return statearr_30700;
})();
var statearr_30701_30774 = state_30671__$1;
(statearr_30701_30774[(2)] = inst_30644);

(statearr_30701_30774[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (33))){
var inst_30630 = (state_30671[(25)]);
var inst_30632 = cljs.core.chunked_seq_QMARK_.call(null,inst_30630);
var state_30671__$1 = state_30671;
if(inst_30632){
var statearr_30702_30775 = state_30671__$1;
(statearr_30702_30775[(1)] = (36));

} else {
var statearr_30703_30776 = state_30671__$1;
(statearr_30703_30776[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (13))){
var inst_30560 = (state_30671[(26)]);
var inst_30563 = cljs.core.async.close_BANG_.call(null,inst_30560);
var state_30671__$1 = state_30671;
var statearr_30704_30777 = state_30671__$1;
(statearr_30704_30777[(2)] = inst_30563);

(statearr_30704_30777[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (22))){
var inst_30583 = (state_30671[(8)]);
var inst_30586 = cljs.core.async.close_BANG_.call(null,inst_30583);
var state_30671__$1 = state_30671;
var statearr_30705_30778 = state_30671__$1;
(statearr_30705_30778[(2)] = inst_30586);

(statearr_30705_30778[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (36))){
var inst_30630 = (state_30671[(25)]);
var inst_30634 = cljs.core.chunk_first.call(null,inst_30630);
var inst_30635 = cljs.core.chunk_rest.call(null,inst_30630);
var inst_30636 = cljs.core.count.call(null,inst_30634);
var inst_30611 = inst_30635;
var inst_30612 = inst_30634;
var inst_30613 = inst_30636;
var inst_30614 = (0);
var state_30671__$1 = (function (){var statearr_30706 = state_30671;
(statearr_30706[(10)] = inst_30614);

(statearr_30706[(11)] = inst_30612);

(statearr_30706[(20)] = inst_30613);

(statearr_30706[(21)] = inst_30611);

return statearr_30706;
})();
var statearr_30707_30779 = state_30671__$1;
(statearr_30707_30779[(2)] = null);

(statearr_30707_30779[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (41))){
var inst_30630 = (state_30671[(25)]);
var inst_30646 = (state_30671[(2)]);
var inst_30647 = cljs.core.next.call(null,inst_30630);
var inst_30611 = inst_30647;
var inst_30612 = null;
var inst_30613 = (0);
var inst_30614 = (0);
var state_30671__$1 = (function (){var statearr_30708 = state_30671;
(statearr_30708[(10)] = inst_30614);

(statearr_30708[(11)] = inst_30612);

(statearr_30708[(20)] = inst_30613);

(statearr_30708[(27)] = inst_30646);

(statearr_30708[(21)] = inst_30611);

return statearr_30708;
})();
var statearr_30709_30780 = state_30671__$1;
(statearr_30709_30780[(2)] = null);

(statearr_30709_30780[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (43))){
var state_30671__$1 = state_30671;
var statearr_30710_30781 = state_30671__$1;
(statearr_30710_30781[(2)] = null);

(statearr_30710_30781[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (29))){
var inst_30655 = (state_30671[(2)]);
var state_30671__$1 = state_30671;
var statearr_30711_30782 = state_30671__$1;
(statearr_30711_30782[(2)] = inst_30655);

(statearr_30711_30782[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (44))){
var inst_30664 = (state_30671[(2)]);
var state_30671__$1 = (function (){var statearr_30712 = state_30671;
(statearr_30712[(28)] = inst_30664);

return statearr_30712;
})();
var statearr_30713_30783 = state_30671__$1;
(statearr_30713_30783[(2)] = null);

(statearr_30713_30783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (6))){
var inst_30603 = (state_30671[(29)]);
var inst_30602 = cljs.core.deref.call(null,cs);
var inst_30603__$1 = cljs.core.keys.call(null,inst_30602);
var inst_30604 = cljs.core.count.call(null,inst_30603__$1);
var inst_30605 = cljs.core.reset_BANG_.call(null,dctr,inst_30604);
var inst_30610 = cljs.core.seq.call(null,inst_30603__$1);
var inst_30611 = inst_30610;
var inst_30612 = null;
var inst_30613 = (0);
var inst_30614 = (0);
var state_30671__$1 = (function (){var statearr_30714 = state_30671;
(statearr_30714[(30)] = inst_30605);

(statearr_30714[(10)] = inst_30614);

(statearr_30714[(11)] = inst_30612);

(statearr_30714[(20)] = inst_30613);

(statearr_30714[(29)] = inst_30603__$1);

(statearr_30714[(21)] = inst_30611);

return statearr_30714;
})();
var statearr_30715_30784 = state_30671__$1;
(statearr_30715_30784[(2)] = null);

(statearr_30715_30784[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (28))){
var inst_30630 = (state_30671[(25)]);
var inst_30611 = (state_30671[(21)]);
var inst_30630__$1 = cljs.core.seq.call(null,inst_30611);
var state_30671__$1 = (function (){var statearr_30716 = state_30671;
(statearr_30716[(25)] = inst_30630__$1);

return statearr_30716;
})();
if(inst_30630__$1){
var statearr_30717_30785 = state_30671__$1;
(statearr_30717_30785[(1)] = (33));

} else {
var statearr_30718_30786 = state_30671__$1;
(statearr_30718_30786[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (25))){
var inst_30614 = (state_30671[(10)]);
var inst_30613 = (state_30671[(20)]);
var inst_30616 = (inst_30614 < inst_30613);
var inst_30617 = inst_30616;
var state_30671__$1 = state_30671;
if(cljs.core.truth_(inst_30617)){
var statearr_30719_30787 = state_30671__$1;
(statearr_30719_30787[(1)] = (27));

} else {
var statearr_30720_30788 = state_30671__$1;
(statearr_30720_30788[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (34))){
var state_30671__$1 = state_30671;
var statearr_30721_30789 = state_30671__$1;
(statearr_30721_30789[(2)] = null);

(statearr_30721_30789[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (17))){
var state_30671__$1 = state_30671;
var statearr_30722_30790 = state_30671__$1;
(statearr_30722_30790[(2)] = null);

(statearr_30722_30790[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (3))){
var inst_30669 = (state_30671[(2)]);
var state_30671__$1 = state_30671;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30671__$1,inst_30669);
} else {
if((state_val_30672 === (12))){
var inst_30598 = (state_30671[(2)]);
var state_30671__$1 = state_30671;
var statearr_30723_30791 = state_30671__$1;
(statearr_30723_30791[(2)] = inst_30598);

(statearr_30723_30791[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (2))){
var state_30671__$1 = state_30671;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30671__$1,(4),ch);
} else {
if((state_val_30672 === (23))){
var state_30671__$1 = state_30671;
var statearr_30724_30792 = state_30671__$1;
(statearr_30724_30792[(2)] = null);

(statearr_30724_30792[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (35))){
var inst_30653 = (state_30671[(2)]);
var state_30671__$1 = state_30671;
var statearr_30725_30793 = state_30671__$1;
(statearr_30725_30793[(2)] = inst_30653);

(statearr_30725_30793[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (19))){
var inst_30570 = (state_30671[(7)]);
var inst_30574 = cljs.core.chunk_first.call(null,inst_30570);
var inst_30575 = cljs.core.chunk_rest.call(null,inst_30570);
var inst_30576 = cljs.core.count.call(null,inst_30574);
var inst_30548 = inst_30575;
var inst_30549 = inst_30574;
var inst_30550 = inst_30576;
var inst_30551 = (0);
var state_30671__$1 = (function (){var statearr_30726 = state_30671;
(statearr_30726[(13)] = inst_30551);

(statearr_30726[(14)] = inst_30550);

(statearr_30726[(15)] = inst_30548);

(statearr_30726[(16)] = inst_30549);

return statearr_30726;
})();
var statearr_30727_30794 = state_30671__$1;
(statearr_30727_30794[(2)] = null);

(statearr_30727_30794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (11))){
var inst_30548 = (state_30671[(15)]);
var inst_30570 = (state_30671[(7)]);
var inst_30570__$1 = cljs.core.seq.call(null,inst_30548);
var state_30671__$1 = (function (){var statearr_30728 = state_30671;
(statearr_30728[(7)] = inst_30570__$1);

return statearr_30728;
})();
if(inst_30570__$1){
var statearr_30729_30795 = state_30671__$1;
(statearr_30729_30795[(1)] = (16));

} else {
var statearr_30730_30796 = state_30671__$1;
(statearr_30730_30796[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (9))){
var inst_30600 = (state_30671[(2)]);
var state_30671__$1 = state_30671;
var statearr_30731_30797 = state_30671__$1;
(statearr_30731_30797[(2)] = inst_30600);

(statearr_30731_30797[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (5))){
var inst_30546 = cljs.core.deref.call(null,cs);
var inst_30547 = cljs.core.seq.call(null,inst_30546);
var inst_30548 = inst_30547;
var inst_30549 = null;
var inst_30550 = (0);
var inst_30551 = (0);
var state_30671__$1 = (function (){var statearr_30732 = state_30671;
(statearr_30732[(13)] = inst_30551);

(statearr_30732[(14)] = inst_30550);

(statearr_30732[(15)] = inst_30548);

(statearr_30732[(16)] = inst_30549);

return statearr_30732;
})();
var statearr_30733_30798 = state_30671__$1;
(statearr_30733_30798[(2)] = null);

(statearr_30733_30798[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (14))){
var state_30671__$1 = state_30671;
var statearr_30734_30799 = state_30671__$1;
(statearr_30734_30799[(2)] = null);

(statearr_30734_30799[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (45))){
var inst_30661 = (state_30671[(2)]);
var state_30671__$1 = state_30671;
var statearr_30735_30800 = state_30671__$1;
(statearr_30735_30800[(2)] = inst_30661);

(statearr_30735_30800[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (26))){
var inst_30603 = (state_30671[(29)]);
var inst_30657 = (state_30671[(2)]);
var inst_30658 = cljs.core.seq.call(null,inst_30603);
var state_30671__$1 = (function (){var statearr_30736 = state_30671;
(statearr_30736[(31)] = inst_30657);

return statearr_30736;
})();
if(inst_30658){
var statearr_30737_30801 = state_30671__$1;
(statearr_30737_30801[(1)] = (42));

} else {
var statearr_30738_30802 = state_30671__$1;
(statearr_30738_30802[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (16))){
var inst_30570 = (state_30671[(7)]);
var inst_30572 = cljs.core.chunked_seq_QMARK_.call(null,inst_30570);
var state_30671__$1 = state_30671;
if(inst_30572){
var statearr_30739_30803 = state_30671__$1;
(statearr_30739_30803[(1)] = (19));

} else {
var statearr_30740_30804 = state_30671__$1;
(statearr_30740_30804[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (38))){
var inst_30650 = (state_30671[(2)]);
var state_30671__$1 = state_30671;
var statearr_30741_30805 = state_30671__$1;
(statearr_30741_30805[(2)] = inst_30650);

(statearr_30741_30805[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (30))){
var state_30671__$1 = state_30671;
var statearr_30742_30806 = state_30671__$1;
(statearr_30742_30806[(2)] = null);

(statearr_30742_30806[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (10))){
var inst_30551 = (state_30671[(13)]);
var inst_30549 = (state_30671[(16)]);
var inst_30559 = cljs.core._nth.call(null,inst_30549,inst_30551);
var inst_30560 = cljs.core.nth.call(null,inst_30559,(0),null);
var inst_30561 = cljs.core.nth.call(null,inst_30559,(1),null);
var state_30671__$1 = (function (){var statearr_30743 = state_30671;
(statearr_30743[(26)] = inst_30560);

return statearr_30743;
})();
if(cljs.core.truth_(inst_30561)){
var statearr_30744_30807 = state_30671__$1;
(statearr_30744_30807[(1)] = (13));

} else {
var statearr_30745_30808 = state_30671__$1;
(statearr_30745_30808[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (18))){
var inst_30596 = (state_30671[(2)]);
var state_30671__$1 = state_30671;
var statearr_30746_30809 = state_30671__$1;
(statearr_30746_30809[(2)] = inst_30596);

(statearr_30746_30809[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (42))){
var state_30671__$1 = state_30671;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30671__$1,(45),dchan);
} else {
if((state_val_30672 === (37))){
var inst_30630 = (state_30671[(25)]);
var inst_30639 = (state_30671[(23)]);
var inst_30539 = (state_30671[(12)]);
var inst_30639__$1 = cljs.core.first.call(null,inst_30630);
var inst_30640 = cljs.core.async.put_BANG_.call(null,inst_30639__$1,inst_30539,done);
var state_30671__$1 = (function (){var statearr_30747 = state_30671;
(statearr_30747[(23)] = inst_30639__$1);

return statearr_30747;
})();
if(cljs.core.truth_(inst_30640)){
var statearr_30748_30810 = state_30671__$1;
(statearr_30748_30810[(1)] = (39));

} else {
var statearr_30749_30811 = state_30671__$1;
(statearr_30749_30811[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30672 === (8))){
var inst_30551 = (state_30671[(13)]);
var inst_30550 = (state_30671[(14)]);
var inst_30553 = (inst_30551 < inst_30550);
var inst_30554 = inst_30553;
var state_30671__$1 = state_30671;
if(cljs.core.truth_(inst_30554)){
var statearr_30750_30812 = state_30671__$1;
(statearr_30750_30812[(1)] = (10));

} else {
var statearr_30751_30813 = state_30671__$1;
(statearr_30751_30813[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___30759,cs,m,dchan,dctr,done))
;
return ((function (switch__29308__auto__,c__29422__auto___30759,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__29309__auto__ = null;
var cljs$core$async$mult_$_state_machine__29309__auto____0 = (function (){
var statearr_30755 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30755[(0)] = cljs$core$async$mult_$_state_machine__29309__auto__);

(statearr_30755[(1)] = (1));

return statearr_30755;
});
var cljs$core$async$mult_$_state_machine__29309__auto____1 = (function (state_30671){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_30671);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e30756){if((e30756 instanceof Object)){
var ex__29312__auto__ = e30756;
var statearr_30757_30814 = state_30671;
(statearr_30757_30814[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30671);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30756;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30815 = state_30671;
state_30671 = G__30815;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__29309__auto__ = function(state_30671){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__29309__auto____1.call(this,state_30671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__29309__auto____0;
cljs$core$async$mult_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__29309__auto____1;
return cljs$core$async$mult_$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___30759,cs,m,dchan,dctr,done))
})();
var state__29424__auto__ = (function (){var statearr_30758 = f__29423__auto__.call(null);
(statearr_30758[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___30759);

return statearr_30758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___30759,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args30816 = [];
var len__27957__auto___30819 = arguments.length;
var i__27958__auto___30820 = (0);
while(true){
if((i__27958__auto___30820 < len__27957__auto___30819)){
args30816.push((arguments[i__27958__auto___30820]));

var G__30821 = (i__27958__auto___30820 + (1));
i__27958__auto___30820 = G__30821;
continue;
} else {
}
break;
}

var G__30818 = args30816.length;
switch (G__30818) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30816.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m,ch);
} else {
var m__27455__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m,ch);
} else {
var m__27455__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m);
} else {
var m__27455__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m,state_map);
} else {
var m__27455__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27454__auto__ = (((m == null))?null:m);
var m__27455__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,m,mode);
} else {
var m__27455__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__27964__auto__ = [];
var len__27957__auto___30833 = arguments.length;
var i__27958__auto___30834 = (0);
while(true){
if((i__27958__auto___30834 < len__27957__auto___30833)){
args__27964__auto__.push((arguments[i__27958__auto___30834]));

var G__30835 = (i__27958__auto___30834 + (1));
i__27958__auto___30834 = G__30835;
continue;
} else {
}
break;
}

var argseq__27965__auto__ = ((((3) < args__27964__auto__.length))?(new cljs.core.IndexedSeq(args__27964__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__27965__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__30827){
var map__30828 = p__30827;
var map__30828__$1 = ((((!((map__30828 == null)))?((((map__30828.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30828.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30828):map__30828);
var opts = map__30828__$1;
var statearr_30830_30836 = state;
(statearr_30830_30836[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__30828,map__30828__$1,opts){
return (function (val){
var statearr_30831_30837 = state;
(statearr_30831_30837[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__30828,map__30828__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_30832_30838 = state;
(statearr_30832_30838[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq30823){
var G__30824 = cljs.core.first.call(null,seq30823);
var seq30823__$1 = cljs.core.next.call(null,seq30823);
var G__30825 = cljs.core.first.call(null,seq30823__$1);
var seq30823__$2 = cljs.core.next.call(null,seq30823__$1);
var G__30826 = cljs.core.first.call(null,seq30823__$2);
var seq30823__$3 = cljs.core.next.call(null,seq30823__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30824,G__30825,G__30826,seq30823__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31006 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31006 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta31007){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta31007 = meta31007;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31008,meta31007__$1){
var self__ = this;
var _31008__$1 = this;
return (new cljs.core.async.t_cljs$core$async31006(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta31007__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31008){
var self__ = this;
var _31008__$1 = this;
return self__.meta31007;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31006.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31006.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta31007","meta31007",-1833576629,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31006.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31006.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31006";

cljs.core.async.t_cljs$core$async31006.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async31006");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async31006 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async31006(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31007){
return (new cljs.core.async.t_cljs$core$async31006(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31007));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async31006(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29422__auto___31173 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___31173,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___31173,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31110){
var state_val_31111 = (state_31110[(1)]);
if((state_val_31111 === (7))){
var inst_31025 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31112_31174 = state_31110__$1;
(statearr_31112_31174[(2)] = inst_31025);

(statearr_31112_31174[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (20))){
var inst_31037 = (state_31110[(7)]);
var state_31110__$1 = state_31110;
var statearr_31113_31175 = state_31110__$1;
(statearr_31113_31175[(2)] = inst_31037);

(statearr_31113_31175[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (27))){
var state_31110__$1 = state_31110;
var statearr_31114_31176 = state_31110__$1;
(statearr_31114_31176[(2)] = null);

(statearr_31114_31176[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (1))){
var inst_31012 = (state_31110[(8)]);
var inst_31012__$1 = calc_state.call(null);
var inst_31014 = (inst_31012__$1 == null);
var inst_31015 = cljs.core.not.call(null,inst_31014);
var state_31110__$1 = (function (){var statearr_31115 = state_31110;
(statearr_31115[(8)] = inst_31012__$1);

return statearr_31115;
})();
if(inst_31015){
var statearr_31116_31177 = state_31110__$1;
(statearr_31116_31177[(1)] = (2));

} else {
var statearr_31117_31178 = state_31110__$1;
(statearr_31117_31178[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (24))){
var inst_31061 = (state_31110[(9)]);
var inst_31084 = (state_31110[(10)]);
var inst_31070 = (state_31110[(11)]);
var inst_31084__$1 = inst_31061.call(null,inst_31070);
var state_31110__$1 = (function (){var statearr_31118 = state_31110;
(statearr_31118[(10)] = inst_31084__$1);

return statearr_31118;
})();
if(cljs.core.truth_(inst_31084__$1)){
var statearr_31119_31179 = state_31110__$1;
(statearr_31119_31179[(1)] = (29));

} else {
var statearr_31120_31180 = state_31110__$1;
(statearr_31120_31180[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (4))){
var inst_31028 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_31028)){
var statearr_31121_31181 = state_31110__$1;
(statearr_31121_31181[(1)] = (8));

} else {
var statearr_31122_31182 = state_31110__$1;
(statearr_31122_31182[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (15))){
var inst_31055 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_31055)){
var statearr_31123_31183 = state_31110__$1;
(statearr_31123_31183[(1)] = (19));

} else {
var statearr_31124_31184 = state_31110__$1;
(statearr_31124_31184[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (21))){
var inst_31060 = (state_31110[(12)]);
var inst_31060__$1 = (state_31110[(2)]);
var inst_31061 = cljs.core.get.call(null,inst_31060__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31062 = cljs.core.get.call(null,inst_31060__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31063 = cljs.core.get.call(null,inst_31060__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31110__$1 = (function (){var statearr_31125 = state_31110;
(statearr_31125[(12)] = inst_31060__$1);

(statearr_31125[(9)] = inst_31061);

(statearr_31125[(13)] = inst_31062);

return statearr_31125;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31110__$1,(22),inst_31063);
} else {
if((state_val_31111 === (31))){
var inst_31092 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_31092)){
var statearr_31126_31185 = state_31110__$1;
(statearr_31126_31185[(1)] = (32));

} else {
var statearr_31127_31186 = state_31110__$1;
(statearr_31127_31186[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (32))){
var inst_31069 = (state_31110[(14)]);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31110__$1,(35),out,inst_31069);
} else {
if((state_val_31111 === (33))){
var inst_31060 = (state_31110[(12)]);
var inst_31037 = inst_31060;
var state_31110__$1 = (function (){var statearr_31128 = state_31110;
(statearr_31128[(7)] = inst_31037);

return statearr_31128;
})();
var statearr_31129_31187 = state_31110__$1;
(statearr_31129_31187[(2)] = null);

(statearr_31129_31187[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (13))){
var inst_31037 = (state_31110[(7)]);
var inst_31044 = inst_31037.cljs$lang$protocol_mask$partition0$;
var inst_31045 = (inst_31044 & (64));
var inst_31046 = inst_31037.cljs$core$ISeq$;
var inst_31047 = (cljs.core.PROTOCOL_SENTINEL === inst_31046);
var inst_31048 = (inst_31045) || (inst_31047);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_31048)){
var statearr_31130_31188 = state_31110__$1;
(statearr_31130_31188[(1)] = (16));

} else {
var statearr_31131_31189 = state_31110__$1;
(statearr_31131_31189[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (22))){
var inst_31069 = (state_31110[(14)]);
var inst_31070 = (state_31110[(11)]);
var inst_31068 = (state_31110[(2)]);
var inst_31069__$1 = cljs.core.nth.call(null,inst_31068,(0),null);
var inst_31070__$1 = cljs.core.nth.call(null,inst_31068,(1),null);
var inst_31071 = (inst_31069__$1 == null);
var inst_31072 = cljs.core._EQ_.call(null,inst_31070__$1,change);
var inst_31073 = (inst_31071) || (inst_31072);
var state_31110__$1 = (function (){var statearr_31132 = state_31110;
(statearr_31132[(14)] = inst_31069__$1);

(statearr_31132[(11)] = inst_31070__$1);

return statearr_31132;
})();
if(cljs.core.truth_(inst_31073)){
var statearr_31133_31190 = state_31110__$1;
(statearr_31133_31190[(1)] = (23));

} else {
var statearr_31134_31191 = state_31110__$1;
(statearr_31134_31191[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (36))){
var inst_31060 = (state_31110[(12)]);
var inst_31037 = inst_31060;
var state_31110__$1 = (function (){var statearr_31135 = state_31110;
(statearr_31135[(7)] = inst_31037);

return statearr_31135;
})();
var statearr_31136_31192 = state_31110__$1;
(statearr_31136_31192[(2)] = null);

(statearr_31136_31192[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (29))){
var inst_31084 = (state_31110[(10)]);
var state_31110__$1 = state_31110;
var statearr_31137_31193 = state_31110__$1;
(statearr_31137_31193[(2)] = inst_31084);

(statearr_31137_31193[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (6))){
var state_31110__$1 = state_31110;
var statearr_31138_31194 = state_31110__$1;
(statearr_31138_31194[(2)] = false);

(statearr_31138_31194[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (28))){
var inst_31080 = (state_31110[(2)]);
var inst_31081 = calc_state.call(null);
var inst_31037 = inst_31081;
var state_31110__$1 = (function (){var statearr_31139 = state_31110;
(statearr_31139[(7)] = inst_31037);

(statearr_31139[(15)] = inst_31080);

return statearr_31139;
})();
var statearr_31140_31195 = state_31110__$1;
(statearr_31140_31195[(2)] = null);

(statearr_31140_31195[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (25))){
var inst_31106 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31141_31196 = state_31110__$1;
(statearr_31141_31196[(2)] = inst_31106);

(statearr_31141_31196[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (34))){
var inst_31104 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31142_31197 = state_31110__$1;
(statearr_31142_31197[(2)] = inst_31104);

(statearr_31142_31197[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (17))){
var state_31110__$1 = state_31110;
var statearr_31143_31198 = state_31110__$1;
(statearr_31143_31198[(2)] = false);

(statearr_31143_31198[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (3))){
var state_31110__$1 = state_31110;
var statearr_31144_31199 = state_31110__$1;
(statearr_31144_31199[(2)] = false);

(statearr_31144_31199[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (12))){
var inst_31108 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31110__$1,inst_31108);
} else {
if((state_val_31111 === (2))){
var inst_31012 = (state_31110[(8)]);
var inst_31017 = inst_31012.cljs$lang$protocol_mask$partition0$;
var inst_31018 = (inst_31017 & (64));
var inst_31019 = inst_31012.cljs$core$ISeq$;
var inst_31020 = (cljs.core.PROTOCOL_SENTINEL === inst_31019);
var inst_31021 = (inst_31018) || (inst_31020);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_31021)){
var statearr_31145_31200 = state_31110__$1;
(statearr_31145_31200[(1)] = (5));

} else {
var statearr_31146_31201 = state_31110__$1;
(statearr_31146_31201[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (23))){
var inst_31069 = (state_31110[(14)]);
var inst_31075 = (inst_31069 == null);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_31075)){
var statearr_31147_31202 = state_31110__$1;
(statearr_31147_31202[(1)] = (26));

} else {
var statearr_31148_31203 = state_31110__$1;
(statearr_31148_31203[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (35))){
var inst_31095 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
if(cljs.core.truth_(inst_31095)){
var statearr_31149_31204 = state_31110__$1;
(statearr_31149_31204[(1)] = (36));

} else {
var statearr_31150_31205 = state_31110__$1;
(statearr_31150_31205[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (19))){
var inst_31037 = (state_31110[(7)]);
var inst_31057 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31037);
var state_31110__$1 = state_31110;
var statearr_31151_31206 = state_31110__$1;
(statearr_31151_31206[(2)] = inst_31057);

(statearr_31151_31206[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (11))){
var inst_31037 = (state_31110[(7)]);
var inst_31041 = (inst_31037 == null);
var inst_31042 = cljs.core.not.call(null,inst_31041);
var state_31110__$1 = state_31110;
if(inst_31042){
var statearr_31152_31207 = state_31110__$1;
(statearr_31152_31207[(1)] = (13));

} else {
var statearr_31153_31208 = state_31110__$1;
(statearr_31153_31208[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (9))){
var inst_31012 = (state_31110[(8)]);
var state_31110__$1 = state_31110;
var statearr_31154_31209 = state_31110__$1;
(statearr_31154_31209[(2)] = inst_31012);

(statearr_31154_31209[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (5))){
var state_31110__$1 = state_31110;
var statearr_31155_31210 = state_31110__$1;
(statearr_31155_31210[(2)] = true);

(statearr_31155_31210[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (14))){
var state_31110__$1 = state_31110;
var statearr_31156_31211 = state_31110__$1;
(statearr_31156_31211[(2)] = false);

(statearr_31156_31211[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (26))){
var inst_31070 = (state_31110[(11)]);
var inst_31077 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_31070);
var state_31110__$1 = state_31110;
var statearr_31157_31212 = state_31110__$1;
(statearr_31157_31212[(2)] = inst_31077);

(statearr_31157_31212[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (16))){
var state_31110__$1 = state_31110;
var statearr_31158_31213 = state_31110__$1;
(statearr_31158_31213[(2)] = true);

(statearr_31158_31213[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (38))){
var inst_31100 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31159_31214 = state_31110__$1;
(statearr_31159_31214[(2)] = inst_31100);

(statearr_31159_31214[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (30))){
var inst_31061 = (state_31110[(9)]);
var inst_31062 = (state_31110[(13)]);
var inst_31070 = (state_31110[(11)]);
var inst_31087 = cljs.core.empty_QMARK_.call(null,inst_31061);
var inst_31088 = inst_31062.call(null,inst_31070);
var inst_31089 = cljs.core.not.call(null,inst_31088);
var inst_31090 = (inst_31087) && (inst_31089);
var state_31110__$1 = state_31110;
var statearr_31160_31215 = state_31110__$1;
(statearr_31160_31215[(2)] = inst_31090);

(statearr_31160_31215[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (10))){
var inst_31012 = (state_31110[(8)]);
var inst_31033 = (state_31110[(2)]);
var inst_31034 = cljs.core.get.call(null,inst_31033,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31035 = cljs.core.get.call(null,inst_31033,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31036 = cljs.core.get.call(null,inst_31033,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31037 = inst_31012;
var state_31110__$1 = (function (){var statearr_31161 = state_31110;
(statearr_31161[(16)] = inst_31034);

(statearr_31161[(17)] = inst_31036);

(statearr_31161[(18)] = inst_31035);

(statearr_31161[(7)] = inst_31037);

return statearr_31161;
})();
var statearr_31162_31216 = state_31110__$1;
(statearr_31162_31216[(2)] = null);

(statearr_31162_31216[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (18))){
var inst_31052 = (state_31110[(2)]);
var state_31110__$1 = state_31110;
var statearr_31163_31217 = state_31110__$1;
(statearr_31163_31217[(2)] = inst_31052);

(statearr_31163_31217[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (37))){
var state_31110__$1 = state_31110;
var statearr_31164_31218 = state_31110__$1;
(statearr_31164_31218[(2)] = null);

(statearr_31164_31218[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31111 === (8))){
var inst_31012 = (state_31110[(8)]);
var inst_31030 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31012);
var state_31110__$1 = state_31110;
var statearr_31165_31219 = state_31110__$1;
(statearr_31165_31219[(2)] = inst_31030);

(statearr_31165_31219[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___31173,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__29308__auto__,c__29422__auto___31173,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__29309__auto__ = null;
var cljs$core$async$mix_$_state_machine__29309__auto____0 = (function (){
var statearr_31169 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31169[(0)] = cljs$core$async$mix_$_state_machine__29309__auto__);

(statearr_31169[(1)] = (1));

return statearr_31169;
});
var cljs$core$async$mix_$_state_machine__29309__auto____1 = (function (state_31110){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_31110);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e31170){if((e31170 instanceof Object)){
var ex__29312__auto__ = e31170;
var statearr_31171_31220 = state_31110;
(statearr_31171_31220[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31110);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31170;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31221 = state_31110;
state_31110 = G__31221;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__29309__auto__ = function(state_31110){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__29309__auto____1.call(this,state_31110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__29309__auto____0;
cljs$core$async$mix_$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__29309__auto____1;
return cljs$core$async$mix_$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___31173,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__29424__auto__ = (function (){var statearr_31172 = f__29423__auto__.call(null);
(statearr_31172[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___31173);

return statearr_31172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___31173,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27454__auto__ = (((p == null))?null:p);
var m__27455__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27455__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27454__auto__ = (((p == null))?null:p);
var m__27455__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,p,v,ch);
} else {
var m__27455__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args31222 = [];
var len__27957__auto___31225 = arguments.length;
var i__27958__auto___31226 = (0);
while(true){
if((i__27958__auto___31226 < len__27957__auto___31225)){
args31222.push((arguments[i__27958__auto___31226]));

var G__31227 = (i__27958__auto___31226 + (1));
i__27958__auto___31226 = G__31227;
continue;
} else {
}
break;
}

var G__31224 = args31222.length;
switch (G__31224) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31222.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27454__auto__ = (((p == null))?null:p);
var m__27455__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,p);
} else {
var m__27455__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27454__auto__ = (((p == null))?null:p);
var m__27455__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27454__auto__)]);
if(!((m__27455__auto__ == null))){
return m__27455__auto__.call(null,p,v);
} else {
var m__27455__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27455__auto____$1 == null))){
return m__27455__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args31230 = [];
var len__27957__auto___31355 = arguments.length;
var i__27958__auto___31356 = (0);
while(true){
if((i__27958__auto___31356 < len__27957__auto___31355)){
args31230.push((arguments[i__27958__auto___31356]));

var G__31357 = (i__27958__auto___31356 + (1));
i__27958__auto___31356 = G__31357;
continue;
} else {
}
break;
}

var G__31232 = args31230.length;
switch (G__31232) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31230.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__26741__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__26741__auto__,mults){
return (function (p1__31229_SHARP_){
if(cljs.core.truth_(p1__31229_SHARP_.call(null,topic))){
return p1__31229_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__31229_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__26741__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async31233 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31233 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31234){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31234 = meta31234;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31233.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31235,meta31234__$1){
var self__ = this;
var _31235__$1 = this;
return (new cljs.core.async.t_cljs$core$async31233(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31234__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31233.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31235){
var self__ = this;
var _31235__$1 = this;
return self__.meta31234;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31233.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31233.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31233.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31233.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31233.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31233.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31233.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31233.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31234","meta31234",1157127298,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31233.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31233.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31233";

cljs.core.async.t_cljs$core$async31233.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async31233");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async31233 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async31233(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31234){
return (new cljs.core.async.t_cljs$core$async31233(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31234));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async31233(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29422__auto___31359 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___31359,mults,ensure_mult,p){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___31359,mults,ensure_mult,p){
return (function (state_31307){
var state_val_31308 = (state_31307[(1)]);
if((state_val_31308 === (7))){
var inst_31303 = (state_31307[(2)]);
var state_31307__$1 = state_31307;
var statearr_31309_31360 = state_31307__$1;
(statearr_31309_31360[(2)] = inst_31303);

(statearr_31309_31360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (20))){
var state_31307__$1 = state_31307;
var statearr_31310_31361 = state_31307__$1;
(statearr_31310_31361[(2)] = null);

(statearr_31310_31361[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (1))){
var state_31307__$1 = state_31307;
var statearr_31311_31362 = state_31307__$1;
(statearr_31311_31362[(2)] = null);

(statearr_31311_31362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (24))){
var inst_31286 = (state_31307[(7)]);
var inst_31295 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_31286);
var state_31307__$1 = state_31307;
var statearr_31312_31363 = state_31307__$1;
(statearr_31312_31363[(2)] = inst_31295);

(statearr_31312_31363[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (4))){
var inst_31238 = (state_31307[(8)]);
var inst_31238__$1 = (state_31307[(2)]);
var inst_31239 = (inst_31238__$1 == null);
var state_31307__$1 = (function (){var statearr_31313 = state_31307;
(statearr_31313[(8)] = inst_31238__$1);

return statearr_31313;
})();
if(cljs.core.truth_(inst_31239)){
var statearr_31314_31364 = state_31307__$1;
(statearr_31314_31364[(1)] = (5));

} else {
var statearr_31315_31365 = state_31307__$1;
(statearr_31315_31365[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (15))){
var inst_31280 = (state_31307[(2)]);
var state_31307__$1 = state_31307;
var statearr_31316_31366 = state_31307__$1;
(statearr_31316_31366[(2)] = inst_31280);

(statearr_31316_31366[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (21))){
var inst_31300 = (state_31307[(2)]);
var state_31307__$1 = (function (){var statearr_31317 = state_31307;
(statearr_31317[(9)] = inst_31300);

return statearr_31317;
})();
var statearr_31318_31367 = state_31307__$1;
(statearr_31318_31367[(2)] = null);

(statearr_31318_31367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (13))){
var inst_31262 = (state_31307[(10)]);
var inst_31264 = cljs.core.chunked_seq_QMARK_.call(null,inst_31262);
var state_31307__$1 = state_31307;
if(inst_31264){
var statearr_31319_31368 = state_31307__$1;
(statearr_31319_31368[(1)] = (16));

} else {
var statearr_31320_31369 = state_31307__$1;
(statearr_31320_31369[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (22))){
var inst_31292 = (state_31307[(2)]);
var state_31307__$1 = state_31307;
if(cljs.core.truth_(inst_31292)){
var statearr_31321_31370 = state_31307__$1;
(statearr_31321_31370[(1)] = (23));

} else {
var statearr_31322_31371 = state_31307__$1;
(statearr_31322_31371[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (6))){
var inst_31288 = (state_31307[(11)]);
var inst_31238 = (state_31307[(8)]);
var inst_31286 = (state_31307[(7)]);
var inst_31286__$1 = topic_fn.call(null,inst_31238);
var inst_31287 = cljs.core.deref.call(null,mults);
var inst_31288__$1 = cljs.core.get.call(null,inst_31287,inst_31286__$1);
var state_31307__$1 = (function (){var statearr_31323 = state_31307;
(statearr_31323[(11)] = inst_31288__$1);

(statearr_31323[(7)] = inst_31286__$1);

return statearr_31323;
})();
if(cljs.core.truth_(inst_31288__$1)){
var statearr_31324_31372 = state_31307__$1;
(statearr_31324_31372[(1)] = (19));

} else {
var statearr_31325_31373 = state_31307__$1;
(statearr_31325_31373[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (25))){
var inst_31297 = (state_31307[(2)]);
var state_31307__$1 = state_31307;
var statearr_31326_31374 = state_31307__$1;
(statearr_31326_31374[(2)] = inst_31297);

(statearr_31326_31374[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (17))){
var inst_31262 = (state_31307[(10)]);
var inst_31271 = cljs.core.first.call(null,inst_31262);
var inst_31272 = cljs.core.async.muxch_STAR_.call(null,inst_31271);
var inst_31273 = cljs.core.async.close_BANG_.call(null,inst_31272);
var inst_31274 = cljs.core.next.call(null,inst_31262);
var inst_31248 = inst_31274;
var inst_31249 = null;
var inst_31250 = (0);
var inst_31251 = (0);
var state_31307__$1 = (function (){var statearr_31327 = state_31307;
(statearr_31327[(12)] = inst_31251);

(statearr_31327[(13)] = inst_31249);

(statearr_31327[(14)] = inst_31248);

(statearr_31327[(15)] = inst_31250);

(statearr_31327[(16)] = inst_31273);

return statearr_31327;
})();
var statearr_31328_31375 = state_31307__$1;
(statearr_31328_31375[(2)] = null);

(statearr_31328_31375[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (3))){
var inst_31305 = (state_31307[(2)]);
var state_31307__$1 = state_31307;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31307__$1,inst_31305);
} else {
if((state_val_31308 === (12))){
var inst_31282 = (state_31307[(2)]);
var state_31307__$1 = state_31307;
var statearr_31329_31376 = state_31307__$1;
(statearr_31329_31376[(2)] = inst_31282);

(statearr_31329_31376[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (2))){
var state_31307__$1 = state_31307;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31307__$1,(4),ch);
} else {
if((state_val_31308 === (23))){
var state_31307__$1 = state_31307;
var statearr_31330_31377 = state_31307__$1;
(statearr_31330_31377[(2)] = null);

(statearr_31330_31377[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (19))){
var inst_31288 = (state_31307[(11)]);
var inst_31238 = (state_31307[(8)]);
var inst_31290 = cljs.core.async.muxch_STAR_.call(null,inst_31288);
var state_31307__$1 = state_31307;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31307__$1,(22),inst_31290,inst_31238);
} else {
if((state_val_31308 === (11))){
var inst_31248 = (state_31307[(14)]);
var inst_31262 = (state_31307[(10)]);
var inst_31262__$1 = cljs.core.seq.call(null,inst_31248);
var state_31307__$1 = (function (){var statearr_31331 = state_31307;
(statearr_31331[(10)] = inst_31262__$1);

return statearr_31331;
})();
if(inst_31262__$1){
var statearr_31332_31378 = state_31307__$1;
(statearr_31332_31378[(1)] = (13));

} else {
var statearr_31333_31379 = state_31307__$1;
(statearr_31333_31379[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (9))){
var inst_31284 = (state_31307[(2)]);
var state_31307__$1 = state_31307;
var statearr_31334_31380 = state_31307__$1;
(statearr_31334_31380[(2)] = inst_31284);

(statearr_31334_31380[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (5))){
var inst_31245 = cljs.core.deref.call(null,mults);
var inst_31246 = cljs.core.vals.call(null,inst_31245);
var inst_31247 = cljs.core.seq.call(null,inst_31246);
var inst_31248 = inst_31247;
var inst_31249 = null;
var inst_31250 = (0);
var inst_31251 = (0);
var state_31307__$1 = (function (){var statearr_31335 = state_31307;
(statearr_31335[(12)] = inst_31251);

(statearr_31335[(13)] = inst_31249);

(statearr_31335[(14)] = inst_31248);

(statearr_31335[(15)] = inst_31250);

return statearr_31335;
})();
var statearr_31336_31381 = state_31307__$1;
(statearr_31336_31381[(2)] = null);

(statearr_31336_31381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (14))){
var state_31307__$1 = state_31307;
var statearr_31340_31382 = state_31307__$1;
(statearr_31340_31382[(2)] = null);

(statearr_31340_31382[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (16))){
var inst_31262 = (state_31307[(10)]);
var inst_31266 = cljs.core.chunk_first.call(null,inst_31262);
var inst_31267 = cljs.core.chunk_rest.call(null,inst_31262);
var inst_31268 = cljs.core.count.call(null,inst_31266);
var inst_31248 = inst_31267;
var inst_31249 = inst_31266;
var inst_31250 = inst_31268;
var inst_31251 = (0);
var state_31307__$1 = (function (){var statearr_31341 = state_31307;
(statearr_31341[(12)] = inst_31251);

(statearr_31341[(13)] = inst_31249);

(statearr_31341[(14)] = inst_31248);

(statearr_31341[(15)] = inst_31250);

return statearr_31341;
})();
var statearr_31342_31383 = state_31307__$1;
(statearr_31342_31383[(2)] = null);

(statearr_31342_31383[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (10))){
var inst_31251 = (state_31307[(12)]);
var inst_31249 = (state_31307[(13)]);
var inst_31248 = (state_31307[(14)]);
var inst_31250 = (state_31307[(15)]);
var inst_31256 = cljs.core._nth.call(null,inst_31249,inst_31251);
var inst_31257 = cljs.core.async.muxch_STAR_.call(null,inst_31256);
var inst_31258 = cljs.core.async.close_BANG_.call(null,inst_31257);
var inst_31259 = (inst_31251 + (1));
var tmp31337 = inst_31249;
var tmp31338 = inst_31248;
var tmp31339 = inst_31250;
var inst_31248__$1 = tmp31338;
var inst_31249__$1 = tmp31337;
var inst_31250__$1 = tmp31339;
var inst_31251__$1 = inst_31259;
var state_31307__$1 = (function (){var statearr_31343 = state_31307;
(statearr_31343[(17)] = inst_31258);

(statearr_31343[(12)] = inst_31251__$1);

(statearr_31343[(13)] = inst_31249__$1);

(statearr_31343[(14)] = inst_31248__$1);

(statearr_31343[(15)] = inst_31250__$1);

return statearr_31343;
})();
var statearr_31344_31384 = state_31307__$1;
(statearr_31344_31384[(2)] = null);

(statearr_31344_31384[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (18))){
var inst_31277 = (state_31307[(2)]);
var state_31307__$1 = state_31307;
var statearr_31345_31385 = state_31307__$1;
(statearr_31345_31385[(2)] = inst_31277);

(statearr_31345_31385[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31308 === (8))){
var inst_31251 = (state_31307[(12)]);
var inst_31250 = (state_31307[(15)]);
var inst_31253 = (inst_31251 < inst_31250);
var inst_31254 = inst_31253;
var state_31307__$1 = state_31307;
if(cljs.core.truth_(inst_31254)){
var statearr_31346_31386 = state_31307__$1;
(statearr_31346_31386[(1)] = (10));

} else {
var statearr_31347_31387 = state_31307__$1;
(statearr_31347_31387[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___31359,mults,ensure_mult,p))
;
return ((function (switch__29308__auto__,c__29422__auto___31359,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__29309__auto__ = null;
var cljs$core$async$state_machine__29309__auto____0 = (function (){
var statearr_31351 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31351[(0)] = cljs$core$async$state_machine__29309__auto__);

(statearr_31351[(1)] = (1));

return statearr_31351;
});
var cljs$core$async$state_machine__29309__auto____1 = (function (state_31307){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_31307);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e31352){if((e31352 instanceof Object)){
var ex__29312__auto__ = e31352;
var statearr_31353_31388 = state_31307;
(statearr_31353_31388[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31307);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31352;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31389 = state_31307;
state_31307 = G__31389;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$state_machine__29309__auto__ = function(state_31307){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29309__auto____1.call(this,state_31307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29309__auto____0;
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29309__auto____1;
return cljs$core$async$state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___31359,mults,ensure_mult,p))
})();
var state__29424__auto__ = (function (){var statearr_31354 = f__29423__auto__.call(null);
(statearr_31354[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___31359);

return statearr_31354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___31359,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args31390 = [];
var len__27957__auto___31393 = arguments.length;
var i__27958__auto___31394 = (0);
while(true){
if((i__27958__auto___31394 < len__27957__auto___31393)){
args31390.push((arguments[i__27958__auto___31394]));

var G__31395 = (i__27958__auto___31394 + (1));
i__27958__auto___31394 = G__31395;
continue;
} else {
}
break;
}

var G__31392 = args31390.length;
switch (G__31392) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31390.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args31397 = [];
var len__27957__auto___31400 = arguments.length;
var i__27958__auto___31401 = (0);
while(true){
if((i__27958__auto___31401 < len__27957__auto___31400)){
args31397.push((arguments[i__27958__auto___31401]));

var G__31402 = (i__27958__auto___31401 + (1));
i__27958__auto___31401 = G__31402;
continue;
} else {
}
break;
}

var G__31399 = args31397.length;
switch (G__31399) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31397.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args31404 = [];
var len__27957__auto___31475 = arguments.length;
var i__27958__auto___31476 = (0);
while(true){
if((i__27958__auto___31476 < len__27957__auto___31475)){
args31404.push((arguments[i__27958__auto___31476]));

var G__31477 = (i__27958__auto___31476 + (1));
i__27958__auto___31476 = G__31477;
continue;
} else {
}
break;
}

var G__31406 = args31404.length;
switch (G__31406) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31404.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__29422__auto___31479 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___31479,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___31479,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_31445){
var state_val_31446 = (state_31445[(1)]);
if((state_val_31446 === (7))){
var state_31445__$1 = state_31445;
var statearr_31447_31480 = state_31445__$1;
(statearr_31447_31480[(2)] = null);

(statearr_31447_31480[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31446 === (1))){
var state_31445__$1 = state_31445;
var statearr_31448_31481 = state_31445__$1;
(statearr_31448_31481[(2)] = null);

(statearr_31448_31481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31446 === (4))){
var inst_31409 = (state_31445[(7)]);
var inst_31411 = (inst_31409 < cnt);
var state_31445__$1 = state_31445;
if(cljs.core.truth_(inst_31411)){
var statearr_31449_31482 = state_31445__$1;
(statearr_31449_31482[(1)] = (6));

} else {
var statearr_31450_31483 = state_31445__$1;
(statearr_31450_31483[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31446 === (15))){
var inst_31441 = (state_31445[(2)]);
var state_31445__$1 = state_31445;
var statearr_31451_31484 = state_31445__$1;
(statearr_31451_31484[(2)] = inst_31441);

(statearr_31451_31484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31446 === (13))){
var inst_31434 = cljs.core.async.close_BANG_.call(null,out);
var state_31445__$1 = state_31445;
var statearr_31452_31485 = state_31445__$1;
(statearr_31452_31485[(2)] = inst_31434);

(statearr_31452_31485[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31446 === (6))){
var state_31445__$1 = state_31445;
var statearr_31453_31486 = state_31445__$1;
(statearr_31453_31486[(2)] = null);

(statearr_31453_31486[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31446 === (3))){
var inst_31443 = (state_31445[(2)]);
var state_31445__$1 = state_31445;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31445__$1,inst_31443);
} else {
if((state_val_31446 === (12))){
var inst_31431 = (state_31445[(8)]);
var inst_31431__$1 = (state_31445[(2)]);
var inst_31432 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_31431__$1);
var state_31445__$1 = (function (){var statearr_31454 = state_31445;
(statearr_31454[(8)] = inst_31431__$1);

return statearr_31454;
})();
if(cljs.core.truth_(inst_31432)){
var statearr_31455_31487 = state_31445__$1;
(statearr_31455_31487[(1)] = (13));

} else {
var statearr_31456_31488 = state_31445__$1;
(statearr_31456_31488[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31446 === (2))){
var inst_31408 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_31409 = (0);
var state_31445__$1 = (function (){var statearr_31457 = state_31445;
(statearr_31457[(7)] = inst_31409);

(statearr_31457[(9)] = inst_31408);

return statearr_31457;
})();
var statearr_31458_31489 = state_31445__$1;
(statearr_31458_31489[(2)] = null);

(statearr_31458_31489[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31446 === (11))){
var inst_31409 = (state_31445[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_31445,(10),Object,null,(9));
var inst_31418 = chs__$1.call(null,inst_31409);
var inst_31419 = done.call(null,inst_31409);
var inst_31420 = cljs.core.async.take_BANG_.call(null,inst_31418,inst_31419);
var state_31445__$1 = state_31445;
var statearr_31459_31490 = state_31445__$1;
(statearr_31459_31490[(2)] = inst_31420);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31445__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31446 === (9))){
var inst_31409 = (state_31445[(7)]);
var inst_31422 = (state_31445[(2)]);
var inst_31423 = (inst_31409 + (1));
var inst_31409__$1 = inst_31423;
var state_31445__$1 = (function (){var statearr_31460 = state_31445;
(statearr_31460[(7)] = inst_31409__$1);

(statearr_31460[(10)] = inst_31422);

return statearr_31460;
})();
var statearr_31461_31491 = state_31445__$1;
(statearr_31461_31491[(2)] = null);

(statearr_31461_31491[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31446 === (5))){
var inst_31429 = (state_31445[(2)]);
var state_31445__$1 = (function (){var statearr_31462 = state_31445;
(statearr_31462[(11)] = inst_31429);

return statearr_31462;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31445__$1,(12),dchan);
} else {
if((state_val_31446 === (14))){
var inst_31431 = (state_31445[(8)]);
var inst_31436 = cljs.core.apply.call(null,f,inst_31431);
var state_31445__$1 = state_31445;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31445__$1,(16),out,inst_31436);
} else {
if((state_val_31446 === (16))){
var inst_31438 = (state_31445[(2)]);
var state_31445__$1 = (function (){var statearr_31463 = state_31445;
(statearr_31463[(12)] = inst_31438);

return statearr_31463;
})();
var statearr_31464_31492 = state_31445__$1;
(statearr_31464_31492[(2)] = null);

(statearr_31464_31492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31446 === (10))){
var inst_31413 = (state_31445[(2)]);
var inst_31414 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_31445__$1 = (function (){var statearr_31465 = state_31445;
(statearr_31465[(13)] = inst_31413);

return statearr_31465;
})();
var statearr_31466_31493 = state_31445__$1;
(statearr_31466_31493[(2)] = inst_31414);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31445__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31446 === (8))){
var inst_31427 = (state_31445[(2)]);
var state_31445__$1 = state_31445;
var statearr_31467_31494 = state_31445__$1;
(statearr_31467_31494[(2)] = inst_31427);

(statearr_31467_31494[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___31479,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__29308__auto__,c__29422__auto___31479,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__29309__auto__ = null;
var cljs$core$async$state_machine__29309__auto____0 = (function (){
var statearr_31471 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31471[(0)] = cljs$core$async$state_machine__29309__auto__);

(statearr_31471[(1)] = (1));

return statearr_31471;
});
var cljs$core$async$state_machine__29309__auto____1 = (function (state_31445){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_31445);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e31472){if((e31472 instanceof Object)){
var ex__29312__auto__ = e31472;
var statearr_31473_31495 = state_31445;
(statearr_31473_31495[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31445);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31472;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31496 = state_31445;
state_31445 = G__31496;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$state_machine__29309__auto__ = function(state_31445){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29309__auto____1.call(this,state_31445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29309__auto____0;
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29309__auto____1;
return cljs$core$async$state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___31479,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__29424__auto__ = (function (){var statearr_31474 = f__29423__auto__.call(null);
(statearr_31474[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___31479);

return statearr_31474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___31479,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args31498 = [];
var len__27957__auto___31556 = arguments.length;
var i__27958__auto___31557 = (0);
while(true){
if((i__27958__auto___31557 < len__27957__auto___31556)){
args31498.push((arguments[i__27958__auto___31557]));

var G__31558 = (i__27958__auto___31557 + (1));
i__27958__auto___31557 = G__31558;
continue;
} else {
}
break;
}

var G__31500 = args31498.length;
switch (G__31500) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31498.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29422__auto___31560 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___31560,out){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___31560,out){
return (function (state_31532){
var state_val_31533 = (state_31532[(1)]);
if((state_val_31533 === (7))){
var inst_31512 = (state_31532[(7)]);
var inst_31511 = (state_31532[(8)]);
var inst_31511__$1 = (state_31532[(2)]);
var inst_31512__$1 = cljs.core.nth.call(null,inst_31511__$1,(0),null);
var inst_31513 = cljs.core.nth.call(null,inst_31511__$1,(1),null);
var inst_31514 = (inst_31512__$1 == null);
var state_31532__$1 = (function (){var statearr_31534 = state_31532;
(statearr_31534[(7)] = inst_31512__$1);

(statearr_31534[(9)] = inst_31513);

(statearr_31534[(8)] = inst_31511__$1);

return statearr_31534;
})();
if(cljs.core.truth_(inst_31514)){
var statearr_31535_31561 = state_31532__$1;
(statearr_31535_31561[(1)] = (8));

} else {
var statearr_31536_31562 = state_31532__$1;
(statearr_31536_31562[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31533 === (1))){
var inst_31501 = cljs.core.vec.call(null,chs);
var inst_31502 = inst_31501;
var state_31532__$1 = (function (){var statearr_31537 = state_31532;
(statearr_31537[(10)] = inst_31502);

return statearr_31537;
})();
var statearr_31538_31563 = state_31532__$1;
(statearr_31538_31563[(2)] = null);

(statearr_31538_31563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31533 === (4))){
var inst_31502 = (state_31532[(10)]);
var state_31532__$1 = state_31532;
return cljs.core.async.ioc_alts_BANG_.call(null,state_31532__$1,(7),inst_31502);
} else {
if((state_val_31533 === (6))){
var inst_31528 = (state_31532[(2)]);
var state_31532__$1 = state_31532;
var statearr_31539_31564 = state_31532__$1;
(statearr_31539_31564[(2)] = inst_31528);

(statearr_31539_31564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31533 === (3))){
var inst_31530 = (state_31532[(2)]);
var state_31532__$1 = state_31532;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31532__$1,inst_31530);
} else {
if((state_val_31533 === (2))){
var inst_31502 = (state_31532[(10)]);
var inst_31504 = cljs.core.count.call(null,inst_31502);
var inst_31505 = (inst_31504 > (0));
var state_31532__$1 = state_31532;
if(cljs.core.truth_(inst_31505)){
var statearr_31541_31565 = state_31532__$1;
(statearr_31541_31565[(1)] = (4));

} else {
var statearr_31542_31566 = state_31532__$1;
(statearr_31542_31566[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31533 === (11))){
var inst_31502 = (state_31532[(10)]);
var inst_31521 = (state_31532[(2)]);
var tmp31540 = inst_31502;
var inst_31502__$1 = tmp31540;
var state_31532__$1 = (function (){var statearr_31543 = state_31532;
(statearr_31543[(10)] = inst_31502__$1);

(statearr_31543[(11)] = inst_31521);

return statearr_31543;
})();
var statearr_31544_31567 = state_31532__$1;
(statearr_31544_31567[(2)] = null);

(statearr_31544_31567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31533 === (9))){
var inst_31512 = (state_31532[(7)]);
var state_31532__$1 = state_31532;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31532__$1,(11),out,inst_31512);
} else {
if((state_val_31533 === (5))){
var inst_31526 = cljs.core.async.close_BANG_.call(null,out);
var state_31532__$1 = state_31532;
var statearr_31545_31568 = state_31532__$1;
(statearr_31545_31568[(2)] = inst_31526);

(statearr_31545_31568[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31533 === (10))){
var inst_31524 = (state_31532[(2)]);
var state_31532__$1 = state_31532;
var statearr_31546_31569 = state_31532__$1;
(statearr_31546_31569[(2)] = inst_31524);

(statearr_31546_31569[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31533 === (8))){
var inst_31512 = (state_31532[(7)]);
var inst_31502 = (state_31532[(10)]);
var inst_31513 = (state_31532[(9)]);
var inst_31511 = (state_31532[(8)]);
var inst_31516 = (function (){var cs = inst_31502;
var vec__31507 = inst_31511;
var v = inst_31512;
var c = inst_31513;
return ((function (cs,vec__31507,v,c,inst_31512,inst_31502,inst_31513,inst_31511,state_val_31533,c__29422__auto___31560,out){
return (function (p1__31497_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__31497_SHARP_);
});
;})(cs,vec__31507,v,c,inst_31512,inst_31502,inst_31513,inst_31511,state_val_31533,c__29422__auto___31560,out))
})();
var inst_31517 = cljs.core.filterv.call(null,inst_31516,inst_31502);
var inst_31502__$1 = inst_31517;
var state_31532__$1 = (function (){var statearr_31547 = state_31532;
(statearr_31547[(10)] = inst_31502__$1);

return statearr_31547;
})();
var statearr_31548_31570 = state_31532__$1;
(statearr_31548_31570[(2)] = null);

(statearr_31548_31570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___31560,out))
;
return ((function (switch__29308__auto__,c__29422__auto___31560,out){
return (function() {
var cljs$core$async$state_machine__29309__auto__ = null;
var cljs$core$async$state_machine__29309__auto____0 = (function (){
var statearr_31552 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31552[(0)] = cljs$core$async$state_machine__29309__auto__);

(statearr_31552[(1)] = (1));

return statearr_31552;
});
var cljs$core$async$state_machine__29309__auto____1 = (function (state_31532){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_31532);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e31553){if((e31553 instanceof Object)){
var ex__29312__auto__ = e31553;
var statearr_31554_31571 = state_31532;
(statearr_31554_31571[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31532);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31553;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31572 = state_31532;
state_31532 = G__31572;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$state_machine__29309__auto__ = function(state_31532){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29309__auto____1.call(this,state_31532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29309__auto____0;
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29309__auto____1;
return cljs$core$async$state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___31560,out))
})();
var state__29424__auto__ = (function (){var statearr_31555 = f__29423__auto__.call(null);
(statearr_31555[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___31560);

return statearr_31555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___31560,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args31573 = [];
var len__27957__auto___31622 = arguments.length;
var i__27958__auto___31623 = (0);
while(true){
if((i__27958__auto___31623 < len__27957__auto___31622)){
args31573.push((arguments[i__27958__auto___31623]));

var G__31624 = (i__27958__auto___31623 + (1));
i__27958__auto___31623 = G__31624;
continue;
} else {
}
break;
}

var G__31575 = args31573.length;
switch (G__31575) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31573.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29422__auto___31626 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___31626,out){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___31626,out){
return (function (state_31599){
var state_val_31600 = (state_31599[(1)]);
if((state_val_31600 === (7))){
var inst_31581 = (state_31599[(7)]);
var inst_31581__$1 = (state_31599[(2)]);
var inst_31582 = (inst_31581__$1 == null);
var inst_31583 = cljs.core.not.call(null,inst_31582);
var state_31599__$1 = (function (){var statearr_31601 = state_31599;
(statearr_31601[(7)] = inst_31581__$1);

return statearr_31601;
})();
if(inst_31583){
var statearr_31602_31627 = state_31599__$1;
(statearr_31602_31627[(1)] = (8));

} else {
var statearr_31603_31628 = state_31599__$1;
(statearr_31603_31628[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31600 === (1))){
var inst_31576 = (0);
var state_31599__$1 = (function (){var statearr_31604 = state_31599;
(statearr_31604[(8)] = inst_31576);

return statearr_31604;
})();
var statearr_31605_31629 = state_31599__$1;
(statearr_31605_31629[(2)] = null);

(statearr_31605_31629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31600 === (4))){
var state_31599__$1 = state_31599;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31599__$1,(7),ch);
} else {
if((state_val_31600 === (6))){
var inst_31594 = (state_31599[(2)]);
var state_31599__$1 = state_31599;
var statearr_31606_31630 = state_31599__$1;
(statearr_31606_31630[(2)] = inst_31594);

(statearr_31606_31630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31600 === (3))){
var inst_31596 = (state_31599[(2)]);
var inst_31597 = cljs.core.async.close_BANG_.call(null,out);
var state_31599__$1 = (function (){var statearr_31607 = state_31599;
(statearr_31607[(9)] = inst_31596);

return statearr_31607;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31599__$1,inst_31597);
} else {
if((state_val_31600 === (2))){
var inst_31576 = (state_31599[(8)]);
var inst_31578 = (inst_31576 < n);
var state_31599__$1 = state_31599;
if(cljs.core.truth_(inst_31578)){
var statearr_31608_31631 = state_31599__$1;
(statearr_31608_31631[(1)] = (4));

} else {
var statearr_31609_31632 = state_31599__$1;
(statearr_31609_31632[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31600 === (11))){
var inst_31576 = (state_31599[(8)]);
var inst_31586 = (state_31599[(2)]);
var inst_31587 = (inst_31576 + (1));
var inst_31576__$1 = inst_31587;
var state_31599__$1 = (function (){var statearr_31610 = state_31599;
(statearr_31610[(8)] = inst_31576__$1);

(statearr_31610[(10)] = inst_31586);

return statearr_31610;
})();
var statearr_31611_31633 = state_31599__$1;
(statearr_31611_31633[(2)] = null);

(statearr_31611_31633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31600 === (9))){
var state_31599__$1 = state_31599;
var statearr_31612_31634 = state_31599__$1;
(statearr_31612_31634[(2)] = null);

(statearr_31612_31634[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31600 === (5))){
var state_31599__$1 = state_31599;
var statearr_31613_31635 = state_31599__$1;
(statearr_31613_31635[(2)] = null);

(statearr_31613_31635[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31600 === (10))){
var inst_31591 = (state_31599[(2)]);
var state_31599__$1 = state_31599;
var statearr_31614_31636 = state_31599__$1;
(statearr_31614_31636[(2)] = inst_31591);

(statearr_31614_31636[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31600 === (8))){
var inst_31581 = (state_31599[(7)]);
var state_31599__$1 = state_31599;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31599__$1,(11),out,inst_31581);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___31626,out))
;
return ((function (switch__29308__auto__,c__29422__auto___31626,out){
return (function() {
var cljs$core$async$state_machine__29309__auto__ = null;
var cljs$core$async$state_machine__29309__auto____0 = (function (){
var statearr_31618 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31618[(0)] = cljs$core$async$state_machine__29309__auto__);

(statearr_31618[(1)] = (1));

return statearr_31618;
});
var cljs$core$async$state_machine__29309__auto____1 = (function (state_31599){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_31599);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e31619){if((e31619 instanceof Object)){
var ex__29312__auto__ = e31619;
var statearr_31620_31637 = state_31599;
(statearr_31620_31637[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31599);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31619;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31638 = state_31599;
state_31599 = G__31638;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$state_machine__29309__auto__ = function(state_31599){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29309__auto____1.call(this,state_31599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29309__auto____0;
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29309__auto____1;
return cljs$core$async$state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___31626,out))
})();
var state__29424__auto__ = (function (){var statearr_31621 = f__29423__auto__.call(null);
(statearr_31621[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___31626);

return statearr_31621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___31626,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async31646 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31646 = (function (f,ch,meta31647){
this.f = f;
this.ch = ch;
this.meta31647 = meta31647;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31648,meta31647__$1){
var self__ = this;
var _31648__$1 = this;
return (new cljs.core.async.t_cljs$core$async31646(self__.f,self__.ch,meta31647__$1));
});

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31648){
var self__ = this;
var _31648__$1 = this;
return self__.meta31647;
});

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async31649 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31649 = (function (f,ch,meta31647,_,fn1,meta31650){
this.f = f;
this.ch = ch;
this.meta31647 = meta31647;
this._ = _;
this.fn1 = fn1;
this.meta31650 = meta31650;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31649.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31651,meta31650__$1){
var self__ = this;
var _31651__$1 = this;
return (new cljs.core.async.t_cljs$core$async31649(self__.f,self__.ch,self__.meta31647,self__._,self__.fn1,meta31650__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async31649.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31651){
var self__ = this;
var _31651__$1 = this;
return self__.meta31650;
});})(___$1))
;

cljs.core.async.t_cljs$core$async31649.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31649.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async31649.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async31649.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__31639_SHARP_){
return f1.call(null,(((p1__31639_SHARP_ == null))?null:self__.f.call(null,p1__31639_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async31649.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31647","meta31647",-360327350,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async31646","cljs.core.async/t_cljs$core$async31646",-5970565,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta31650","meta31650",-13404269,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async31649.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31649.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31649";

cljs.core.async.t_cljs$core$async31649.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async31649");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async31649 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31649(f__$1,ch__$1,meta31647__$1,___$2,fn1__$1,meta31650){
return (new cljs.core.async.t_cljs$core$async31649(f__$1,ch__$1,meta31647__$1,___$2,fn1__$1,meta31650));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async31649(self__.f,self__.ch,self__.meta31647,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__26729__auto__ = ret;
if(cljs.core.truth_(and__26729__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__26729__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31646.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async31646.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31647","meta31647",-360327350,null)], null);
});

cljs.core.async.t_cljs$core$async31646.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31646.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31646";

cljs.core.async.t_cljs$core$async31646.cljs$lang$ctorPrWriter = (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async31646");
});

cljs.core.async.__GT_t_cljs$core$async31646 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31646(f__$1,ch__$1,meta31647){
return (new cljs.core.async.t_cljs$core$async31646(f__$1,ch__$1,meta31647));
});

}

return (new cljs.core.async.t_cljs$core$async31646(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async31655 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31655 = (function (f,ch,meta31656){
this.f = f;
this.ch = ch;
this.meta31656 = meta31656;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31657,meta31656__$1){
var self__ = this;
var _31657__$1 = this;
return (new cljs.core.async.t_cljs$core$async31655(self__.f,self__.ch,meta31656__$1));
});

cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31657){
var self__ = this;
var _31657__$1 = this;
return self__.meta31656;
});

cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async31655.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31656","meta31656",331399273,null)], null);
});

cljs.core.async.t_cljs$core$async31655.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31655.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31655";

cljs.core.async.t_cljs$core$async31655.cljs$lang$ctorPrWriter = (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async31655");
});

cljs.core.async.__GT_t_cljs$core$async31655 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async31655(f__$1,ch__$1,meta31656){
return (new cljs.core.async.t_cljs$core$async31655(f__$1,ch__$1,meta31656));
});

}

return (new cljs.core.async.t_cljs$core$async31655(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async31661 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31661 = (function (p,ch,meta31662){
this.p = p;
this.ch = ch;
this.meta31662 = meta31662;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31661.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31663,meta31662__$1){
var self__ = this;
var _31663__$1 = this;
return (new cljs.core.async.t_cljs$core$async31661(self__.p,self__.ch,meta31662__$1));
});

cljs.core.async.t_cljs$core$async31661.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31663){
var self__ = this;
var _31663__$1 = this;
return self__.meta31662;
});

cljs.core.async.t_cljs$core$async31661.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31661.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31661.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31661.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31661.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async31661.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31661.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async31661.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31662","meta31662",-176358288,null)], null);
});

cljs.core.async.t_cljs$core$async31661.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31661.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31661";

cljs.core.async.t_cljs$core$async31661.cljs$lang$ctorPrWriter = (function (this__27393__auto__,writer__27394__auto__,opt__27395__auto__){
return cljs.core._write.call(null,writer__27394__auto__,"cljs.core.async/t_cljs$core$async31661");
});

cljs.core.async.__GT_t_cljs$core$async31661 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async31661(p__$1,ch__$1,meta31662){
return (new cljs.core.async.t_cljs$core$async31661(p__$1,ch__$1,meta31662));
});

}

return (new cljs.core.async.t_cljs$core$async31661(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args31664 = [];
var len__27957__auto___31708 = arguments.length;
var i__27958__auto___31709 = (0);
while(true){
if((i__27958__auto___31709 < len__27957__auto___31708)){
args31664.push((arguments[i__27958__auto___31709]));

var G__31710 = (i__27958__auto___31709 + (1));
i__27958__auto___31709 = G__31710;
continue;
} else {
}
break;
}

var G__31666 = args31664.length;
switch (G__31666) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31664.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29422__auto___31712 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___31712,out){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___31712,out){
return (function (state_31687){
var state_val_31688 = (state_31687[(1)]);
if((state_val_31688 === (7))){
var inst_31683 = (state_31687[(2)]);
var state_31687__$1 = state_31687;
var statearr_31689_31713 = state_31687__$1;
(statearr_31689_31713[(2)] = inst_31683);

(statearr_31689_31713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31688 === (1))){
var state_31687__$1 = state_31687;
var statearr_31690_31714 = state_31687__$1;
(statearr_31690_31714[(2)] = null);

(statearr_31690_31714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31688 === (4))){
var inst_31669 = (state_31687[(7)]);
var inst_31669__$1 = (state_31687[(2)]);
var inst_31670 = (inst_31669__$1 == null);
var state_31687__$1 = (function (){var statearr_31691 = state_31687;
(statearr_31691[(7)] = inst_31669__$1);

return statearr_31691;
})();
if(cljs.core.truth_(inst_31670)){
var statearr_31692_31715 = state_31687__$1;
(statearr_31692_31715[(1)] = (5));

} else {
var statearr_31693_31716 = state_31687__$1;
(statearr_31693_31716[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31688 === (6))){
var inst_31669 = (state_31687[(7)]);
var inst_31674 = p.call(null,inst_31669);
var state_31687__$1 = state_31687;
if(cljs.core.truth_(inst_31674)){
var statearr_31694_31717 = state_31687__$1;
(statearr_31694_31717[(1)] = (8));

} else {
var statearr_31695_31718 = state_31687__$1;
(statearr_31695_31718[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31688 === (3))){
var inst_31685 = (state_31687[(2)]);
var state_31687__$1 = state_31687;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31687__$1,inst_31685);
} else {
if((state_val_31688 === (2))){
var state_31687__$1 = state_31687;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31687__$1,(4),ch);
} else {
if((state_val_31688 === (11))){
var inst_31677 = (state_31687[(2)]);
var state_31687__$1 = state_31687;
var statearr_31696_31719 = state_31687__$1;
(statearr_31696_31719[(2)] = inst_31677);

(statearr_31696_31719[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31688 === (9))){
var state_31687__$1 = state_31687;
var statearr_31697_31720 = state_31687__$1;
(statearr_31697_31720[(2)] = null);

(statearr_31697_31720[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31688 === (5))){
var inst_31672 = cljs.core.async.close_BANG_.call(null,out);
var state_31687__$1 = state_31687;
var statearr_31698_31721 = state_31687__$1;
(statearr_31698_31721[(2)] = inst_31672);

(statearr_31698_31721[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31688 === (10))){
var inst_31680 = (state_31687[(2)]);
var state_31687__$1 = (function (){var statearr_31699 = state_31687;
(statearr_31699[(8)] = inst_31680);

return statearr_31699;
})();
var statearr_31700_31722 = state_31687__$1;
(statearr_31700_31722[(2)] = null);

(statearr_31700_31722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31688 === (8))){
var inst_31669 = (state_31687[(7)]);
var state_31687__$1 = state_31687;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31687__$1,(11),out,inst_31669);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___31712,out))
;
return ((function (switch__29308__auto__,c__29422__auto___31712,out){
return (function() {
var cljs$core$async$state_machine__29309__auto__ = null;
var cljs$core$async$state_machine__29309__auto____0 = (function (){
var statearr_31704 = [null,null,null,null,null,null,null,null,null];
(statearr_31704[(0)] = cljs$core$async$state_machine__29309__auto__);

(statearr_31704[(1)] = (1));

return statearr_31704;
});
var cljs$core$async$state_machine__29309__auto____1 = (function (state_31687){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_31687);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e31705){if((e31705 instanceof Object)){
var ex__29312__auto__ = e31705;
var statearr_31706_31723 = state_31687;
(statearr_31706_31723[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31687);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31705;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31724 = state_31687;
state_31687 = G__31724;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$state_machine__29309__auto__ = function(state_31687){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29309__auto____1.call(this,state_31687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29309__auto____0;
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29309__auto____1;
return cljs$core$async$state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___31712,out))
})();
var state__29424__auto__ = (function (){var statearr_31707 = f__29423__auto__.call(null);
(statearr_31707[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___31712);

return statearr_31707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___31712,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args31725 = [];
var len__27957__auto___31728 = arguments.length;
var i__27958__auto___31729 = (0);
while(true){
if((i__27958__auto___31729 < len__27957__auto___31728)){
args31725.push((arguments[i__27958__auto___31729]));

var G__31730 = (i__27958__auto___31729 + (1));
i__27958__auto___31729 = G__31730;
continue;
} else {
}
break;
}

var G__31727 = args31725.length;
switch (G__31727) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31725.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__29422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto__){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto__){
return (function (state_31897){
var state_val_31898 = (state_31897[(1)]);
if((state_val_31898 === (7))){
var inst_31893 = (state_31897[(2)]);
var state_31897__$1 = state_31897;
var statearr_31899_31940 = state_31897__$1;
(statearr_31899_31940[(2)] = inst_31893);

(statearr_31899_31940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (20))){
var inst_31863 = (state_31897[(7)]);
var inst_31874 = (state_31897[(2)]);
var inst_31875 = cljs.core.next.call(null,inst_31863);
var inst_31849 = inst_31875;
var inst_31850 = null;
var inst_31851 = (0);
var inst_31852 = (0);
var state_31897__$1 = (function (){var statearr_31900 = state_31897;
(statearr_31900[(8)] = inst_31851);

(statearr_31900[(9)] = inst_31850);

(statearr_31900[(10)] = inst_31852);

(statearr_31900[(11)] = inst_31874);

(statearr_31900[(12)] = inst_31849);

return statearr_31900;
})();
var statearr_31901_31941 = state_31897__$1;
(statearr_31901_31941[(2)] = null);

(statearr_31901_31941[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (1))){
var state_31897__$1 = state_31897;
var statearr_31902_31942 = state_31897__$1;
(statearr_31902_31942[(2)] = null);

(statearr_31902_31942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (4))){
var inst_31838 = (state_31897[(13)]);
var inst_31838__$1 = (state_31897[(2)]);
var inst_31839 = (inst_31838__$1 == null);
var state_31897__$1 = (function (){var statearr_31903 = state_31897;
(statearr_31903[(13)] = inst_31838__$1);

return statearr_31903;
})();
if(cljs.core.truth_(inst_31839)){
var statearr_31904_31943 = state_31897__$1;
(statearr_31904_31943[(1)] = (5));

} else {
var statearr_31905_31944 = state_31897__$1;
(statearr_31905_31944[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (15))){
var state_31897__$1 = state_31897;
var statearr_31909_31945 = state_31897__$1;
(statearr_31909_31945[(2)] = null);

(statearr_31909_31945[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (21))){
var state_31897__$1 = state_31897;
var statearr_31910_31946 = state_31897__$1;
(statearr_31910_31946[(2)] = null);

(statearr_31910_31946[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (13))){
var inst_31851 = (state_31897[(8)]);
var inst_31850 = (state_31897[(9)]);
var inst_31852 = (state_31897[(10)]);
var inst_31849 = (state_31897[(12)]);
var inst_31859 = (state_31897[(2)]);
var inst_31860 = (inst_31852 + (1));
var tmp31906 = inst_31851;
var tmp31907 = inst_31850;
var tmp31908 = inst_31849;
var inst_31849__$1 = tmp31908;
var inst_31850__$1 = tmp31907;
var inst_31851__$1 = tmp31906;
var inst_31852__$1 = inst_31860;
var state_31897__$1 = (function (){var statearr_31911 = state_31897;
(statearr_31911[(8)] = inst_31851__$1);

(statearr_31911[(9)] = inst_31850__$1);

(statearr_31911[(10)] = inst_31852__$1);

(statearr_31911[(14)] = inst_31859);

(statearr_31911[(12)] = inst_31849__$1);

return statearr_31911;
})();
var statearr_31912_31947 = state_31897__$1;
(statearr_31912_31947[(2)] = null);

(statearr_31912_31947[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (22))){
var state_31897__$1 = state_31897;
var statearr_31913_31948 = state_31897__$1;
(statearr_31913_31948[(2)] = null);

(statearr_31913_31948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (6))){
var inst_31838 = (state_31897[(13)]);
var inst_31847 = f.call(null,inst_31838);
var inst_31848 = cljs.core.seq.call(null,inst_31847);
var inst_31849 = inst_31848;
var inst_31850 = null;
var inst_31851 = (0);
var inst_31852 = (0);
var state_31897__$1 = (function (){var statearr_31914 = state_31897;
(statearr_31914[(8)] = inst_31851);

(statearr_31914[(9)] = inst_31850);

(statearr_31914[(10)] = inst_31852);

(statearr_31914[(12)] = inst_31849);

return statearr_31914;
})();
var statearr_31915_31949 = state_31897__$1;
(statearr_31915_31949[(2)] = null);

(statearr_31915_31949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (17))){
var inst_31863 = (state_31897[(7)]);
var inst_31867 = cljs.core.chunk_first.call(null,inst_31863);
var inst_31868 = cljs.core.chunk_rest.call(null,inst_31863);
var inst_31869 = cljs.core.count.call(null,inst_31867);
var inst_31849 = inst_31868;
var inst_31850 = inst_31867;
var inst_31851 = inst_31869;
var inst_31852 = (0);
var state_31897__$1 = (function (){var statearr_31916 = state_31897;
(statearr_31916[(8)] = inst_31851);

(statearr_31916[(9)] = inst_31850);

(statearr_31916[(10)] = inst_31852);

(statearr_31916[(12)] = inst_31849);

return statearr_31916;
})();
var statearr_31917_31950 = state_31897__$1;
(statearr_31917_31950[(2)] = null);

(statearr_31917_31950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (3))){
var inst_31895 = (state_31897[(2)]);
var state_31897__$1 = state_31897;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31897__$1,inst_31895);
} else {
if((state_val_31898 === (12))){
var inst_31883 = (state_31897[(2)]);
var state_31897__$1 = state_31897;
var statearr_31918_31951 = state_31897__$1;
(statearr_31918_31951[(2)] = inst_31883);

(statearr_31918_31951[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (2))){
var state_31897__$1 = state_31897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31897__$1,(4),in$);
} else {
if((state_val_31898 === (23))){
var inst_31891 = (state_31897[(2)]);
var state_31897__$1 = state_31897;
var statearr_31919_31952 = state_31897__$1;
(statearr_31919_31952[(2)] = inst_31891);

(statearr_31919_31952[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (19))){
var inst_31878 = (state_31897[(2)]);
var state_31897__$1 = state_31897;
var statearr_31920_31953 = state_31897__$1;
(statearr_31920_31953[(2)] = inst_31878);

(statearr_31920_31953[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (11))){
var inst_31863 = (state_31897[(7)]);
var inst_31849 = (state_31897[(12)]);
var inst_31863__$1 = cljs.core.seq.call(null,inst_31849);
var state_31897__$1 = (function (){var statearr_31921 = state_31897;
(statearr_31921[(7)] = inst_31863__$1);

return statearr_31921;
})();
if(inst_31863__$1){
var statearr_31922_31954 = state_31897__$1;
(statearr_31922_31954[(1)] = (14));

} else {
var statearr_31923_31955 = state_31897__$1;
(statearr_31923_31955[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (9))){
var inst_31885 = (state_31897[(2)]);
var inst_31886 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_31897__$1 = (function (){var statearr_31924 = state_31897;
(statearr_31924[(15)] = inst_31885);

return statearr_31924;
})();
if(cljs.core.truth_(inst_31886)){
var statearr_31925_31956 = state_31897__$1;
(statearr_31925_31956[(1)] = (21));

} else {
var statearr_31926_31957 = state_31897__$1;
(statearr_31926_31957[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (5))){
var inst_31841 = cljs.core.async.close_BANG_.call(null,out);
var state_31897__$1 = state_31897;
var statearr_31927_31958 = state_31897__$1;
(statearr_31927_31958[(2)] = inst_31841);

(statearr_31927_31958[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (14))){
var inst_31863 = (state_31897[(7)]);
var inst_31865 = cljs.core.chunked_seq_QMARK_.call(null,inst_31863);
var state_31897__$1 = state_31897;
if(inst_31865){
var statearr_31928_31959 = state_31897__$1;
(statearr_31928_31959[(1)] = (17));

} else {
var statearr_31929_31960 = state_31897__$1;
(statearr_31929_31960[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (16))){
var inst_31881 = (state_31897[(2)]);
var state_31897__$1 = state_31897;
var statearr_31930_31961 = state_31897__$1;
(statearr_31930_31961[(2)] = inst_31881);

(statearr_31930_31961[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31898 === (10))){
var inst_31850 = (state_31897[(9)]);
var inst_31852 = (state_31897[(10)]);
var inst_31857 = cljs.core._nth.call(null,inst_31850,inst_31852);
var state_31897__$1 = state_31897;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31897__$1,(13),out,inst_31857);
} else {
if((state_val_31898 === (18))){
var inst_31863 = (state_31897[(7)]);
var inst_31872 = cljs.core.first.call(null,inst_31863);
var state_31897__$1 = state_31897;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31897__$1,(20),out,inst_31872);
} else {
if((state_val_31898 === (8))){
var inst_31851 = (state_31897[(8)]);
var inst_31852 = (state_31897[(10)]);
var inst_31854 = (inst_31852 < inst_31851);
var inst_31855 = inst_31854;
var state_31897__$1 = state_31897;
if(cljs.core.truth_(inst_31855)){
var statearr_31931_31962 = state_31897__$1;
(statearr_31931_31962[(1)] = (10));

} else {
var statearr_31932_31963 = state_31897__$1;
(statearr_31932_31963[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto__))
;
return ((function (switch__29308__auto__,c__29422__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__29309__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__29309__auto____0 = (function (){
var statearr_31936 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31936[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__29309__auto__);

(statearr_31936[(1)] = (1));

return statearr_31936;
});
var cljs$core$async$mapcat_STAR__$_state_machine__29309__auto____1 = (function (state_31897){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_31897);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e31937){if((e31937 instanceof Object)){
var ex__29312__auto__ = e31937;
var statearr_31938_31964 = state_31897;
(statearr_31938_31964[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31897);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31937;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31965 = state_31897;
state_31897 = G__31965;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__29309__auto__ = function(state_31897){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__29309__auto____1.call(this,state_31897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__29309__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__29309__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto__))
})();
var state__29424__auto__ = (function (){var statearr_31939 = f__29423__auto__.call(null);
(statearr_31939[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto__);

return statearr_31939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto__))
);

return c__29422__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args31966 = [];
var len__27957__auto___31969 = arguments.length;
var i__27958__auto___31970 = (0);
while(true){
if((i__27958__auto___31970 < len__27957__auto___31969)){
args31966.push((arguments[i__27958__auto___31970]));

var G__31971 = (i__27958__auto___31970 + (1));
i__27958__auto___31970 = G__31971;
continue;
} else {
}
break;
}

var G__31968 = args31966.length;
switch (G__31968) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31966.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args31973 = [];
var len__27957__auto___31976 = arguments.length;
var i__27958__auto___31977 = (0);
while(true){
if((i__27958__auto___31977 < len__27957__auto___31976)){
args31973.push((arguments[i__27958__auto___31977]));

var G__31978 = (i__27958__auto___31977 + (1));
i__27958__auto___31977 = G__31978;
continue;
} else {
}
break;
}

var G__31975 = args31973.length;
switch (G__31975) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31973.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args31980 = [];
var len__27957__auto___32031 = arguments.length;
var i__27958__auto___32032 = (0);
while(true){
if((i__27958__auto___32032 < len__27957__auto___32031)){
args31980.push((arguments[i__27958__auto___32032]));

var G__32033 = (i__27958__auto___32032 + (1));
i__27958__auto___32032 = G__32033;
continue;
} else {
}
break;
}

var G__31982 = args31980.length;
switch (G__31982) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31980.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29422__auto___32035 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___32035,out){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___32035,out){
return (function (state_32006){
var state_val_32007 = (state_32006[(1)]);
if((state_val_32007 === (7))){
var inst_32001 = (state_32006[(2)]);
var state_32006__$1 = state_32006;
var statearr_32008_32036 = state_32006__$1;
(statearr_32008_32036[(2)] = inst_32001);

(statearr_32008_32036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32007 === (1))){
var inst_31983 = null;
var state_32006__$1 = (function (){var statearr_32009 = state_32006;
(statearr_32009[(7)] = inst_31983);

return statearr_32009;
})();
var statearr_32010_32037 = state_32006__$1;
(statearr_32010_32037[(2)] = null);

(statearr_32010_32037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32007 === (4))){
var inst_31986 = (state_32006[(8)]);
var inst_31986__$1 = (state_32006[(2)]);
var inst_31987 = (inst_31986__$1 == null);
var inst_31988 = cljs.core.not.call(null,inst_31987);
var state_32006__$1 = (function (){var statearr_32011 = state_32006;
(statearr_32011[(8)] = inst_31986__$1);

return statearr_32011;
})();
if(inst_31988){
var statearr_32012_32038 = state_32006__$1;
(statearr_32012_32038[(1)] = (5));

} else {
var statearr_32013_32039 = state_32006__$1;
(statearr_32013_32039[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32007 === (6))){
var state_32006__$1 = state_32006;
var statearr_32014_32040 = state_32006__$1;
(statearr_32014_32040[(2)] = null);

(statearr_32014_32040[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32007 === (3))){
var inst_32003 = (state_32006[(2)]);
var inst_32004 = cljs.core.async.close_BANG_.call(null,out);
var state_32006__$1 = (function (){var statearr_32015 = state_32006;
(statearr_32015[(9)] = inst_32003);

return statearr_32015;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32006__$1,inst_32004);
} else {
if((state_val_32007 === (2))){
var state_32006__$1 = state_32006;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32006__$1,(4),ch);
} else {
if((state_val_32007 === (11))){
var inst_31986 = (state_32006[(8)]);
var inst_31995 = (state_32006[(2)]);
var inst_31983 = inst_31986;
var state_32006__$1 = (function (){var statearr_32016 = state_32006;
(statearr_32016[(10)] = inst_31995);

(statearr_32016[(7)] = inst_31983);

return statearr_32016;
})();
var statearr_32017_32041 = state_32006__$1;
(statearr_32017_32041[(2)] = null);

(statearr_32017_32041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32007 === (9))){
var inst_31986 = (state_32006[(8)]);
var state_32006__$1 = state_32006;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32006__$1,(11),out,inst_31986);
} else {
if((state_val_32007 === (5))){
var inst_31986 = (state_32006[(8)]);
var inst_31983 = (state_32006[(7)]);
var inst_31990 = cljs.core._EQ_.call(null,inst_31986,inst_31983);
var state_32006__$1 = state_32006;
if(inst_31990){
var statearr_32019_32042 = state_32006__$1;
(statearr_32019_32042[(1)] = (8));

} else {
var statearr_32020_32043 = state_32006__$1;
(statearr_32020_32043[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32007 === (10))){
var inst_31998 = (state_32006[(2)]);
var state_32006__$1 = state_32006;
var statearr_32021_32044 = state_32006__$1;
(statearr_32021_32044[(2)] = inst_31998);

(statearr_32021_32044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32007 === (8))){
var inst_31983 = (state_32006[(7)]);
var tmp32018 = inst_31983;
var inst_31983__$1 = tmp32018;
var state_32006__$1 = (function (){var statearr_32022 = state_32006;
(statearr_32022[(7)] = inst_31983__$1);

return statearr_32022;
})();
var statearr_32023_32045 = state_32006__$1;
(statearr_32023_32045[(2)] = null);

(statearr_32023_32045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___32035,out))
;
return ((function (switch__29308__auto__,c__29422__auto___32035,out){
return (function() {
var cljs$core$async$state_machine__29309__auto__ = null;
var cljs$core$async$state_machine__29309__auto____0 = (function (){
var statearr_32027 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32027[(0)] = cljs$core$async$state_machine__29309__auto__);

(statearr_32027[(1)] = (1));

return statearr_32027;
});
var cljs$core$async$state_machine__29309__auto____1 = (function (state_32006){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_32006);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e32028){if((e32028 instanceof Object)){
var ex__29312__auto__ = e32028;
var statearr_32029_32046 = state_32006;
(statearr_32029_32046[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32006);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32028;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32047 = state_32006;
state_32006 = G__32047;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$state_machine__29309__auto__ = function(state_32006){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29309__auto____1.call(this,state_32006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29309__auto____0;
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29309__auto____1;
return cljs$core$async$state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___32035,out))
})();
var state__29424__auto__ = (function (){var statearr_32030 = f__29423__auto__.call(null);
(statearr_32030[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___32035);

return statearr_32030;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___32035,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args32048 = [];
var len__27957__auto___32118 = arguments.length;
var i__27958__auto___32119 = (0);
while(true){
if((i__27958__auto___32119 < len__27957__auto___32118)){
args32048.push((arguments[i__27958__auto___32119]));

var G__32120 = (i__27958__auto___32119 + (1));
i__27958__auto___32119 = G__32120;
continue;
} else {
}
break;
}

var G__32050 = args32048.length;
switch (G__32050) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32048.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29422__auto___32122 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___32122,out){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___32122,out){
return (function (state_32088){
var state_val_32089 = (state_32088[(1)]);
if((state_val_32089 === (7))){
var inst_32084 = (state_32088[(2)]);
var state_32088__$1 = state_32088;
var statearr_32090_32123 = state_32088__$1;
(statearr_32090_32123[(2)] = inst_32084);

(statearr_32090_32123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32089 === (1))){
var inst_32051 = (new Array(n));
var inst_32052 = inst_32051;
var inst_32053 = (0);
var state_32088__$1 = (function (){var statearr_32091 = state_32088;
(statearr_32091[(7)] = inst_32052);

(statearr_32091[(8)] = inst_32053);

return statearr_32091;
})();
var statearr_32092_32124 = state_32088__$1;
(statearr_32092_32124[(2)] = null);

(statearr_32092_32124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32089 === (4))){
var inst_32056 = (state_32088[(9)]);
var inst_32056__$1 = (state_32088[(2)]);
var inst_32057 = (inst_32056__$1 == null);
var inst_32058 = cljs.core.not.call(null,inst_32057);
var state_32088__$1 = (function (){var statearr_32093 = state_32088;
(statearr_32093[(9)] = inst_32056__$1);

return statearr_32093;
})();
if(inst_32058){
var statearr_32094_32125 = state_32088__$1;
(statearr_32094_32125[(1)] = (5));

} else {
var statearr_32095_32126 = state_32088__$1;
(statearr_32095_32126[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32089 === (15))){
var inst_32078 = (state_32088[(2)]);
var state_32088__$1 = state_32088;
var statearr_32096_32127 = state_32088__$1;
(statearr_32096_32127[(2)] = inst_32078);

(statearr_32096_32127[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32089 === (13))){
var state_32088__$1 = state_32088;
var statearr_32097_32128 = state_32088__$1;
(statearr_32097_32128[(2)] = null);

(statearr_32097_32128[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32089 === (6))){
var inst_32053 = (state_32088[(8)]);
var inst_32074 = (inst_32053 > (0));
var state_32088__$1 = state_32088;
if(cljs.core.truth_(inst_32074)){
var statearr_32098_32129 = state_32088__$1;
(statearr_32098_32129[(1)] = (12));

} else {
var statearr_32099_32130 = state_32088__$1;
(statearr_32099_32130[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32089 === (3))){
var inst_32086 = (state_32088[(2)]);
var state_32088__$1 = state_32088;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32088__$1,inst_32086);
} else {
if((state_val_32089 === (12))){
var inst_32052 = (state_32088[(7)]);
var inst_32076 = cljs.core.vec.call(null,inst_32052);
var state_32088__$1 = state_32088;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32088__$1,(15),out,inst_32076);
} else {
if((state_val_32089 === (2))){
var state_32088__$1 = state_32088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32088__$1,(4),ch);
} else {
if((state_val_32089 === (11))){
var inst_32068 = (state_32088[(2)]);
var inst_32069 = (new Array(n));
var inst_32052 = inst_32069;
var inst_32053 = (0);
var state_32088__$1 = (function (){var statearr_32100 = state_32088;
(statearr_32100[(7)] = inst_32052);

(statearr_32100[(10)] = inst_32068);

(statearr_32100[(8)] = inst_32053);

return statearr_32100;
})();
var statearr_32101_32131 = state_32088__$1;
(statearr_32101_32131[(2)] = null);

(statearr_32101_32131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32089 === (9))){
var inst_32052 = (state_32088[(7)]);
var inst_32066 = cljs.core.vec.call(null,inst_32052);
var state_32088__$1 = state_32088;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32088__$1,(11),out,inst_32066);
} else {
if((state_val_32089 === (5))){
var inst_32052 = (state_32088[(7)]);
var inst_32056 = (state_32088[(9)]);
var inst_32061 = (state_32088[(11)]);
var inst_32053 = (state_32088[(8)]);
var inst_32060 = (inst_32052[inst_32053] = inst_32056);
var inst_32061__$1 = (inst_32053 + (1));
var inst_32062 = (inst_32061__$1 < n);
var state_32088__$1 = (function (){var statearr_32102 = state_32088;
(statearr_32102[(11)] = inst_32061__$1);

(statearr_32102[(12)] = inst_32060);

return statearr_32102;
})();
if(cljs.core.truth_(inst_32062)){
var statearr_32103_32132 = state_32088__$1;
(statearr_32103_32132[(1)] = (8));

} else {
var statearr_32104_32133 = state_32088__$1;
(statearr_32104_32133[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32089 === (14))){
var inst_32081 = (state_32088[(2)]);
var inst_32082 = cljs.core.async.close_BANG_.call(null,out);
var state_32088__$1 = (function (){var statearr_32106 = state_32088;
(statearr_32106[(13)] = inst_32081);

return statearr_32106;
})();
var statearr_32107_32134 = state_32088__$1;
(statearr_32107_32134[(2)] = inst_32082);

(statearr_32107_32134[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32089 === (10))){
var inst_32072 = (state_32088[(2)]);
var state_32088__$1 = state_32088;
var statearr_32108_32135 = state_32088__$1;
(statearr_32108_32135[(2)] = inst_32072);

(statearr_32108_32135[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32089 === (8))){
var inst_32052 = (state_32088[(7)]);
var inst_32061 = (state_32088[(11)]);
var tmp32105 = inst_32052;
var inst_32052__$1 = tmp32105;
var inst_32053 = inst_32061;
var state_32088__$1 = (function (){var statearr_32109 = state_32088;
(statearr_32109[(7)] = inst_32052__$1);

(statearr_32109[(8)] = inst_32053);

return statearr_32109;
})();
var statearr_32110_32136 = state_32088__$1;
(statearr_32110_32136[(2)] = null);

(statearr_32110_32136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___32122,out))
;
return ((function (switch__29308__auto__,c__29422__auto___32122,out){
return (function() {
var cljs$core$async$state_machine__29309__auto__ = null;
var cljs$core$async$state_machine__29309__auto____0 = (function (){
var statearr_32114 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32114[(0)] = cljs$core$async$state_machine__29309__auto__);

(statearr_32114[(1)] = (1));

return statearr_32114;
});
var cljs$core$async$state_machine__29309__auto____1 = (function (state_32088){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_32088);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e32115){if((e32115 instanceof Object)){
var ex__29312__auto__ = e32115;
var statearr_32116_32137 = state_32088;
(statearr_32116_32137[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32088);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32115;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32138 = state_32088;
state_32088 = G__32138;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$state_machine__29309__auto__ = function(state_32088){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29309__auto____1.call(this,state_32088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29309__auto____0;
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29309__auto____1;
return cljs$core$async$state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___32122,out))
})();
var state__29424__auto__ = (function (){var statearr_32117 = f__29423__auto__.call(null);
(statearr_32117[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___32122);

return statearr_32117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___32122,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args32139 = [];
var len__27957__auto___32213 = arguments.length;
var i__27958__auto___32214 = (0);
while(true){
if((i__27958__auto___32214 < len__27957__auto___32213)){
args32139.push((arguments[i__27958__auto___32214]));

var G__32215 = (i__27958__auto___32214 + (1));
i__27958__auto___32214 = G__32215;
continue;
} else {
}
break;
}

var G__32141 = args32139.length;
switch (G__32141) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32139.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29422__auto___32217 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29422__auto___32217,out){
return (function (){
var f__29423__auto__ = (function (){var switch__29308__auto__ = ((function (c__29422__auto___32217,out){
return (function (state_32183){
var state_val_32184 = (state_32183[(1)]);
if((state_val_32184 === (7))){
var inst_32179 = (state_32183[(2)]);
var state_32183__$1 = state_32183;
var statearr_32185_32218 = state_32183__$1;
(statearr_32185_32218[(2)] = inst_32179);

(statearr_32185_32218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32184 === (1))){
var inst_32142 = [];
var inst_32143 = inst_32142;
var inst_32144 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32183__$1 = (function (){var statearr_32186 = state_32183;
(statearr_32186[(7)] = inst_32144);

(statearr_32186[(8)] = inst_32143);

return statearr_32186;
})();
var statearr_32187_32219 = state_32183__$1;
(statearr_32187_32219[(2)] = null);

(statearr_32187_32219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32184 === (4))){
var inst_32147 = (state_32183[(9)]);
var inst_32147__$1 = (state_32183[(2)]);
var inst_32148 = (inst_32147__$1 == null);
var inst_32149 = cljs.core.not.call(null,inst_32148);
var state_32183__$1 = (function (){var statearr_32188 = state_32183;
(statearr_32188[(9)] = inst_32147__$1);

return statearr_32188;
})();
if(inst_32149){
var statearr_32189_32220 = state_32183__$1;
(statearr_32189_32220[(1)] = (5));

} else {
var statearr_32190_32221 = state_32183__$1;
(statearr_32190_32221[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32184 === (15))){
var inst_32173 = (state_32183[(2)]);
var state_32183__$1 = state_32183;
var statearr_32191_32222 = state_32183__$1;
(statearr_32191_32222[(2)] = inst_32173);

(statearr_32191_32222[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32184 === (13))){
var state_32183__$1 = state_32183;
var statearr_32192_32223 = state_32183__$1;
(statearr_32192_32223[(2)] = null);

(statearr_32192_32223[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32184 === (6))){
var inst_32143 = (state_32183[(8)]);
var inst_32168 = inst_32143.length;
var inst_32169 = (inst_32168 > (0));
var state_32183__$1 = state_32183;
if(cljs.core.truth_(inst_32169)){
var statearr_32193_32224 = state_32183__$1;
(statearr_32193_32224[(1)] = (12));

} else {
var statearr_32194_32225 = state_32183__$1;
(statearr_32194_32225[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32184 === (3))){
var inst_32181 = (state_32183[(2)]);
var state_32183__$1 = state_32183;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32183__$1,inst_32181);
} else {
if((state_val_32184 === (12))){
var inst_32143 = (state_32183[(8)]);
var inst_32171 = cljs.core.vec.call(null,inst_32143);
var state_32183__$1 = state_32183;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32183__$1,(15),out,inst_32171);
} else {
if((state_val_32184 === (2))){
var state_32183__$1 = state_32183;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32183__$1,(4),ch);
} else {
if((state_val_32184 === (11))){
var inst_32147 = (state_32183[(9)]);
var inst_32151 = (state_32183[(10)]);
var inst_32161 = (state_32183[(2)]);
var inst_32162 = [];
var inst_32163 = inst_32162.push(inst_32147);
var inst_32143 = inst_32162;
var inst_32144 = inst_32151;
var state_32183__$1 = (function (){var statearr_32195 = state_32183;
(statearr_32195[(7)] = inst_32144);

(statearr_32195[(8)] = inst_32143);

(statearr_32195[(11)] = inst_32161);

(statearr_32195[(12)] = inst_32163);

return statearr_32195;
})();
var statearr_32196_32226 = state_32183__$1;
(statearr_32196_32226[(2)] = null);

(statearr_32196_32226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32184 === (9))){
var inst_32143 = (state_32183[(8)]);
var inst_32159 = cljs.core.vec.call(null,inst_32143);
var state_32183__$1 = state_32183;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32183__$1,(11),out,inst_32159);
} else {
if((state_val_32184 === (5))){
var inst_32144 = (state_32183[(7)]);
var inst_32147 = (state_32183[(9)]);
var inst_32151 = (state_32183[(10)]);
var inst_32151__$1 = f.call(null,inst_32147);
var inst_32152 = cljs.core._EQ_.call(null,inst_32151__$1,inst_32144);
var inst_32153 = cljs.core.keyword_identical_QMARK_.call(null,inst_32144,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_32154 = (inst_32152) || (inst_32153);
var state_32183__$1 = (function (){var statearr_32197 = state_32183;
(statearr_32197[(10)] = inst_32151__$1);

return statearr_32197;
})();
if(cljs.core.truth_(inst_32154)){
var statearr_32198_32227 = state_32183__$1;
(statearr_32198_32227[(1)] = (8));

} else {
var statearr_32199_32228 = state_32183__$1;
(statearr_32199_32228[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32184 === (14))){
var inst_32176 = (state_32183[(2)]);
var inst_32177 = cljs.core.async.close_BANG_.call(null,out);
var state_32183__$1 = (function (){var statearr_32201 = state_32183;
(statearr_32201[(13)] = inst_32176);

return statearr_32201;
})();
var statearr_32202_32229 = state_32183__$1;
(statearr_32202_32229[(2)] = inst_32177);

(statearr_32202_32229[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32184 === (10))){
var inst_32166 = (state_32183[(2)]);
var state_32183__$1 = state_32183;
var statearr_32203_32230 = state_32183__$1;
(statearr_32203_32230[(2)] = inst_32166);

(statearr_32203_32230[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32184 === (8))){
var inst_32143 = (state_32183[(8)]);
var inst_32147 = (state_32183[(9)]);
var inst_32151 = (state_32183[(10)]);
var inst_32156 = inst_32143.push(inst_32147);
var tmp32200 = inst_32143;
var inst_32143__$1 = tmp32200;
var inst_32144 = inst_32151;
var state_32183__$1 = (function (){var statearr_32204 = state_32183;
(statearr_32204[(7)] = inst_32144);

(statearr_32204[(8)] = inst_32143__$1);

(statearr_32204[(14)] = inst_32156);

return statearr_32204;
})();
var statearr_32205_32231 = state_32183__$1;
(statearr_32205_32231[(2)] = null);

(statearr_32205_32231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29422__auto___32217,out))
;
return ((function (switch__29308__auto__,c__29422__auto___32217,out){
return (function() {
var cljs$core$async$state_machine__29309__auto__ = null;
var cljs$core$async$state_machine__29309__auto____0 = (function (){
var statearr_32209 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32209[(0)] = cljs$core$async$state_machine__29309__auto__);

(statearr_32209[(1)] = (1));

return statearr_32209;
});
var cljs$core$async$state_machine__29309__auto____1 = (function (state_32183){
while(true){
var ret_value__29310__auto__ = (function (){try{while(true){
var result__29311__auto__ = switch__29308__auto__.call(null,state_32183);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29311__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29311__auto__;
}
break;
}
}catch (e32210){if((e32210 instanceof Object)){
var ex__29312__auto__ = e32210;
var statearr_32211_32232 = state_32183;
(statearr_32211_32232[(5)] = ex__29312__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32183);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32210;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29310__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32233 = state_32183;
state_32183 = G__32233;
continue;
} else {
return ret_value__29310__auto__;
}
break;
}
});
cljs$core$async$state_machine__29309__auto__ = function(state_32183){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29309__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29309__auto____1.call(this,state_32183);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29309__auto____0;
cljs$core$async$state_machine__29309__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29309__auto____1;
return cljs$core$async$state_machine__29309__auto__;
})()
;})(switch__29308__auto__,c__29422__auto___32217,out))
})();
var state__29424__auto__ = (function (){var statearr_32212 = f__29423__auto__.call(null);
(statearr_32212[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29422__auto___32217);

return statearr_32212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29424__auto__);
});})(c__29422__auto___32217,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1489515133043