// Compiled by ClojureScript 1.8.34 {}
goog.provide('input_flex.core');
goog.require('cljs.core');
goog.require('reagent.core');
input_flex.core.escape = (function input_flex$core$escape(txt){
return clojure.string.escape.call(null,txt,new cljs.core.PersistentArrayMap(null, 4, ["<","&lt;",">","&gt;","&","&amp;","\n","<br>"], null));
});
/**
 * Create a handler for component-did-mount and component-did-update
 */
input_flex.core.focus_ctrl_factory = (function input_flex$core$focus_ctrl_factory(focus_tracker,reset_scroll){
return (function (this$){
var n = reagent.core.dom_node.call(null,this$);
var _ = reset_scroll.call(null,n);
var map__20954 = cljs.core.deref.call(null,focus_tracker);
var map__20954__$1 = ((((!((map__20954 == null)))?((((map__20954.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20954.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20954):map__20954);
var curr = cljs.core.get.call(null,map__20954__$1,new cljs.core.Keyword(null,"curr","curr",-1092372808));
var prev = cljs.core.get.call(null,map__20954__$1,new cljs.core.Keyword(null,"prev","prev",-1597069226));
if(cljs.core.truth_((function (){var and__18406__auto__ = cljs.core.not.call(null,prev);
if(and__18406__auto__){
return curr;
} else {
return and__18406__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,focus_tracker,((function (n,_,map__20954,map__20954__$1,curr,prev){
return (function (p1__20950_SHARP_){
return cljs.core.assoc.call(null,p1__20950_SHARP_,new cljs.core.Keyword(null,"prev","prev",-1597069226),true);
});})(n,_,map__20954,map__20954__$1,curr,prev))
);

return n.focus();
} else {
if(cljs.core.truth_((function (){var and__18406__auto__ = prev;
if(cljs.core.truth_(and__18406__auto__)){
return cljs.core.not.call(null,curr);
} else {
return and__18406__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,focus_tracker,((function (n,_,map__20954,map__20954__$1,curr,prev){
return (function (p1__20951_SHARP_){
return cljs.core.assoc.call(null,p1__20951_SHARP_,new cljs.core.Keyword(null,"prev","prev",-1597069226),false);
});})(n,_,map__20954,map__20954__$1,curr,prev))
);

return n.blur();
} else {
return true;

}
}
});
});
input_flex.core.phantom_ctrl_factory = (function input_flex$core$phantom_ctrl_factory(inspect,report,display_style){
return (function (this$){
var n = reagent.core.dom_node.call(null,this$);
var _ = n.style.display = display_style;
var h = inspect.call(null,n);
var ___$1 = n.style.display = "none";
return report.call(null,h);
});
});
input_flex.core.phantom_factory = (function input_flex$core$phantom_factory(inspect,report,visible_style,sentinel_str){
var phantom_ctrl = input_flex.core.phantom_ctrl_factory.call(null,inspect,report,visible_style);
return ((function (phantom_ctrl){
return (function (opts){
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (phantom_ctrl){
return (function (opts__$1){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.phantom","div.phantom",212619045),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dangerouslySetInnerHTML","dangerouslySetInnerHTML",-554971138),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"__html","__html",674048345),[cljs.core.str(input_flex.core.escape.call(null,new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(opts__$1))),cljs.core.str(sentinel_str)].join('')], null)], null)], null);
});})(phantom_ctrl))
,new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),phantom_ctrl,new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),phantom_ctrl], null));
});
;})(phantom_ctrl))
});
input_flex.core.scroll_l = (function input_flex$core$scroll_l(dom_node){
return dom_node.scrollLeft = (0);
});
input_flex.core.scroll_t = (function input_flex$core$scroll_t(dom_node){
return dom_node.scrollTop = (0);
});
input_flex.core.tgt_val = (function input_flex$core$tgt_val(e){
return e.target.value;
});
input_flex.core.input = (function input_flex$core$input(opts){
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function (p__20959){
var map__20960 = p__20959;
var map__20960__$1 = ((((!((map__20960 == null)))?((((map__20960.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20960.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20960):map__20960);
var opts__$1 = map__20960__$1;
var input_opts = cljs.core.get.call(null,map__20960__$1,new cljs.core.Keyword(null,"input-opts","input-opts",1688681135));
var text = cljs.core.get.call(null,map__20960__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var placeholder = cljs.core.get.call(null,map__20960__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var width = cljs.core.get.call(null,map__20960__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var on_text_change = cljs.core.get.call(null,map__20960__$1,new cljs.core.Keyword(null,"on-text-change","on-text-change",-1719329456));
var on_blur = cljs.core.get.call(null,map__20960__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),((function (map__20960,map__20960__$1,opts__$1,input_opts,text,placeholder,width,on_text_change){
return (function (){
return cljs.core.List.EMPTY;
});})(map__20960,map__20960__$1,opts__$1,input_opts,text,placeholder,width,on_text_change))
);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"value","value",305978217),text,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),placeholder,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"width","width",-384071477),width], null),new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.comp.call(null,on_text_change,input_flex.core.tgt_val),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),cljs.core.comp.call(null,on_blur,input_flex.core.tgt_val)], null))], null);
}),new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),cljs.core.comp.call(null,input_flex.core.scroll_l,reagent.core.dom_node)], null));
});
input_flex.core.textarea = (function input_flex$core$textarea(opts){
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function (p__20965){
var map__20966 = p__20965;
var map__20966__$1 = ((((!((map__20966 == null)))?((((map__20966.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20966.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20966):map__20966);
var opts__$1 = map__20966__$1;
var textarea_opts = cljs.core.get.call(null,map__20966__$1,new cljs.core.Keyword(null,"textarea-opts","textarea-opts",-942779061));
var text = cljs.core.get.call(null,map__20966__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var placeholder = cljs.core.get.call(null,map__20966__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var height = cljs.core.get.call(null,map__20966__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var width = cljs.core.get.call(null,map__20966__$1,new cljs.core.Keyword(null,"width","width",-384071477),"100%");
var on_text_change = cljs.core.get.call(null,map__20966__$1,new cljs.core.Keyword(null,"on-text-change","on-text-change",-1719329456));
var on_blur = cljs.core.get.call(null,map__20966__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),((function (map__20966,map__20966__$1,opts__$1,textarea_opts,text,placeholder,height,width,on_text_change){
return (function (){
return cljs.core.List.EMPTY;
});})(map__20966,map__20966__$1,opts__$1,textarea_opts,text,placeholder,height,width,on_text_change))
);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),cljs.core.merge.call(null,textarea_opts,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"value","value",305978217),text,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),placeholder,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"width","width",-384071477),width], null),new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.comp.call(null,on_text_change,input_flex.core.tgt_val),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),cljs.core.comp.call(null,on_blur,input_flex.core.tgt_val)], null))], null);
}),new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),cljs.core.comp.call(null,input_flex.core.scroll_t,reagent.core.dom_node)], null));
});
input_flex.core.input_foc = (function input_flex$core$input_foc(opts){
var focus_tracker = reagent.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"curr","curr",-1092372808),false,new cljs.core.Keyword(null,"prev","prev",-1597069226),false], null));
var focus_ctrl = input_flex.core.focus_ctrl_factory.call(null,focus_tracker,input_flex.core.scroll_l);
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (focus_tracker,focus_ctrl){
return (function (p__20972){
var map__20973 = p__20972;
var map__20973__$1 = ((((!((map__20973 == null)))?((((map__20973.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20973.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20973):map__20973);
var opts__$1 = map__20973__$1;
var focused_QMARK_ = cljs.core.get.call(null,map__20973__$1,new cljs.core.Keyword(null,"focused?","focused?",-1922723333));
if(cljs.core.not_EQ_.call(null,focused_QMARK_,new cljs.core.Keyword(null,"curr","curr",-1092372808).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,focus_tracker)))){
cljs.core.swap_BANG_.call(null,focus_tracker,((function (map__20973,map__20973__$1,opts__$1,focused_QMARK_,focus_tracker,focus_ctrl){
return (function (p1__20968_SHARP_){
return cljs.core.update_in.call(null,p1__20968_SHARP_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"curr","curr",-1092372808)], null),cljs.core.not);
});})(map__20973,map__20973__$1,opts__$1,focused_QMARK_,focus_tracker,focus_ctrl))
);
} else {
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_flex.core.input,cljs.core.merge.call(null,opts__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input-opts","input-opts",1688681135),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(new cljs.core.Keyword(null,"curr","curr",-1092372808).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,focus_tracker)))?"active":"inactive")], null)], null))], null);
});})(focus_tracker,focus_ctrl))
,new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),focus_ctrl,new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),focus_ctrl], null));
});
input_flex.core.textarea_foc = (function input_flex$core$textarea_foc(opts){
var focus_tracker = reagent.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"prev","prev",-1597069226),false,new cljs.core.Keyword(null,"curr","curr",-1092372808),false], null));
var focus_ctrl = input_flex.core.focus_ctrl_factory.call(null,focus_tracker,input_flex.core.scroll_t);
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (focus_tracker,focus_ctrl){
return (function (p__20979){
var map__20980 = p__20979;
var map__20980__$1 = ((((!((map__20980 == null)))?((((map__20980.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20980.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20980):map__20980);
var opts__$1 = map__20980__$1;
var focused_QMARK_ = cljs.core.get.call(null,map__20980__$1,new cljs.core.Keyword(null,"focused?","focused?",-1922723333));
if(cljs.core.not_EQ_.call(null,focused_QMARK_,new cljs.core.Keyword(null,"curr","curr",-1092372808).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,focus_tracker)))){
cljs.core.swap_BANG_.call(null,focus_tracker,((function (map__20980,map__20980__$1,opts__$1,focused_QMARK_,focus_tracker,focus_ctrl){
return (function (p1__20975_SHARP_){
return cljs.core.update_in.call(null,p1__20975_SHARP_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"curr","curr",-1092372808)], null),cljs.core.not);
});})(map__20980,map__20980__$1,opts__$1,focused_QMARK_,focus_tracker,focus_ctrl))
);
} else {
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_flex.core.textarea,cljs.core.merge.call(null,opts__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"textarea-opts","textarea-opts",-942779061),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(focused_QMARK_)?"active":"inactive")], null)], null))], null);
});})(focus_tracker,focus_ctrl))
,new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),focus_ctrl,new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),focus_ctrl], null));
});
input_flex.core.textarea_auto_h = (function input_flex$core$textarea_auto_h(opts){
var with_let20988 = reagent.ratom.with_let_values.call(null,new cljs.core.Keyword(null,"with-let20988","with-let20988",1206013156));
var temp__4661__auto___20990 = reagent.ratom._STAR_ratom_context_STAR_;
if((temp__4661__auto___20990 == null)){
} else {
var c__20638__auto___20991 = temp__4661__auto___20990;
if((with_let20988.generation === c__20638__auto___20991.ratomGeneration)){
if(cljs.core.truth_(reagent.debug.has_console)){
(cljs.core.truth_(reagent.debug.tracking)?reagent.debug.track_console:console).error([cljs.core.str("Warning: The same with-let is being used more "),cljs.core.str("than once in the same reactive context.")].join(''));
} else {
}
} else {
}

with_let20988.generation = c__20638__auto___20991.ratomGeneration;
}


var init20989 = (with_let20988.length === (0));
var height = ((init20989)?(with_let20988[(0)] = reagent.core.atom.call(null,(25))):(with_let20988[(0)]));
var phantom = ((init20989)?(with_let20988[(1)] = input_flex.core.phantom_factory.call(null,((function (init20989,height,with_let20988){
return (function (p1__20982_SHARP_){
return p1__20982_SHARP_.clientHeight;
});})(init20989,height,with_let20988))
,((function (init20989,height,with_let20988){
return (function (p1__20983_SHARP_){
return cljs.core.reset_BANG_.call(null,height,p1__20983_SHARP_);
});})(init20989,height,with_let20988))
,"block","<br class='lbr'>")):(with_let20988[(1)]));
var buffer_ratom = ((init20989)?(with_let20988[(2)] = ((cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"buffer?","buffer?",607721787)))?reagent.core.atom.call(null,new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(opts)):null)):(with_let20988[(2)]));
var res__20639__auto__ = (function (){var opts__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"buffer?","buffer?",607721787).cljs$core$IFn$_invoke$arity$1(opts))?cljs.core.merge.call(null,opts,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-text-change","on-text-change",-1719329456),((function (init20989,height,phantom,buffer_ratom,with_let20988){
return (function (p1__20984_SHARP_){
return cljs.core.reset_BANG_.call(null,buffer_ratom,p1__20984_SHARP_);
});})(init20989,height,phantom,buffer_ratom,with_let20988))
,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),((function (init20989,height,phantom,buffer_ratom,with_let20988){
return (function (p1__20985_SHARP_){
return new cljs.core.Keyword(null,"on-text-change","on-text-change",-1719329456).cljs$core$IFn$_invoke$arity$1(opts).call(null,p1__20985_SHARP_);
});})(init20989,height,phantom,buffer_ratom,with_let20988))
,new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.deref.call(null,buffer_ratom)], null)):opts);
var opts__$2 = cljs.core.assoc.call(null,opts__$1,new cljs.core.Keyword(null,"height","height",1025178622),cljs.core.deref.call(null,height));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.auto-size","div.auto-size",994446854),new cljs.core.Keyword(null,"container","container",-1736937707).cljs$core$IFn$_invoke$arity$1(opts__$2),((cljs.core.contains_QMARK_.call(null,opts__$2,new cljs.core.Keyword(null,"focused?","focused?",-1922723333)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_flex.core.textarea_foc,opts__$2], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_flex.core.textarea,opts__$2], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [phantom,cljs.core.select_keys.call(null,opts__$2,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697)], null))], null)], null);
})();

return res__20639__auto__;
});
/**
 * Minimum width in case of no text
 */
input_flex.core.min_w = (10);
/**
 * Additional space at the end of text
 */
input_flex.core.extra_w = (5);
input_flex.core.input_auto_w = (function input_flex$core$input_auto_w(opts){
var with_let20998 = reagent.ratom.with_let_values.call(null,new cljs.core.Keyword(null,"with-let20998","with-let20998",573047174));
var temp__4661__auto___21000 = reagent.ratom._STAR_ratom_context_STAR_;
if((temp__4661__auto___21000 == null)){
} else {
var c__20638__auto___21001 = temp__4661__auto___21000;
if((with_let20998.generation === c__20638__auto___21001.ratomGeneration)){
if(cljs.core.truth_(reagent.debug.has_console)){
(cljs.core.truth_(reagent.debug.tracking)?reagent.debug.track_console:console).error([cljs.core.str("Warning: The same with-let is being used more "),cljs.core.str("than once in the same reactive context.")].join(''));
} else {
}
} else {
}

with_let20998.generation = c__20638__auto___21001.ratomGeneration;
}


var init20999 = (with_let20998.length === (0));
var width = ((init20999)?(with_let20998[(0)] = reagent.core.atom.call(null,input_flex.core.min_w)):(with_let20998[(0)]));
var min_w = ((init20999)?(with_let20998[(1)] = cljs.core.get.call(null,opts,new cljs.core.Keyword(null,"min-w","min-w",-1698040337),input_flex.core.min_w)):(with_let20998[(1)]));
var extra_w = ((init20999)?(with_let20998[(2)] = cljs.core.get.call(null,opts,new cljs.core.Keyword(null,"extra-w","extra-w",-1771231663),input_flex.core.extra_w)):(with_let20998[(2)]));
var phantom = ((init20999)?(with_let20998[(3)] = input_flex.core.phantom_factory.call(null,((function (init20999,width,min_w,extra_w,with_let20998){
return (function (p1__20992_SHARP_){
return p1__20992_SHARP_.clientWidth;
});})(init20999,width,min_w,extra_w,with_let20998))
,((function (init20999,width,min_w,extra_w,with_let20998){
return (function (p1__20993_SHARP_){
return cljs.core.reset_BANG_.call(null,width,(((p1__20993_SHARP_ < min_w))?(min_w + extra_w):(p1__20993_SHARP_ + extra_w)));
});})(init20999,width,min_w,extra_w,with_let20998))
,"inline-block","")):(with_let20998[(3)]));
var buffer_ratom = ((init20999)?(with_let20998[(4)] = ((cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"buffer?","buffer?",607721787)))?reagent.core.atom.call(null,new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(opts)):null)):(with_let20998[(4)]));
var res__20639__auto__ = (function (){var opts__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"buffer?","buffer?",607721787).cljs$core$IFn$_invoke$arity$1(opts))?cljs.core.merge.call(null,opts,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-text-change","on-text-change",-1719329456),((function (init20999,width,min_w,extra_w,phantom,buffer_ratom,with_let20998){
return (function (p1__20994_SHARP_){
return cljs.core.reset_BANG_.call(null,buffer_ratom,p1__20994_SHARP_);
});})(init20999,width,min_w,extra_w,phantom,buffer_ratom,with_let20998))
,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),((function (init20999,width,min_w,extra_w,phantom,buffer_ratom,with_let20998){
return (function (p1__20995_SHARP_){
return new cljs.core.Keyword(null,"on-text-change","on-text-change",-1719329456).cljs$core$IFn$_invoke$arity$1(opts).call(null,p1__20995_SHARP_);
});})(init20999,width,min_w,extra_w,phantom,buffer_ratom,with_let20998))
,new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.deref.call(null,buffer_ratom)], null)):opts);
var opts__$2 = cljs.core.assoc.call(null,opts__$1,new cljs.core.Keyword(null,"width","width",-384071477),cljs.core.deref.call(null,width));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.auto-size","div.auto-size",994446854),new cljs.core.Keyword(null,"container","container",-1736937707).cljs$core$IFn$_invoke$arity$1(opts__$2),((cljs.core.contains_QMARK_.call(null,opts__$2,new cljs.core.Keyword(null,"focused?","focused?",-1922723333)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_flex.core.input_foc,opts__$2], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_flex.core.input,opts__$2], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [phantom,cljs.core.select_keys.call(null,opts__$2,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697)], null))], null)], null);
})();

return res__20639__auto__;
});

//# sourceMappingURL=core.js.map