// Compiled by ClojureScript 1.9.229 {}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('com.cognitect.transit');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit.eq');
goog.require('goog.math.Long');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = true;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
cljs.core.UUID.prototype.cljs$core$IComparable$ = true;

cljs.core.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});
goog.math.Long.prototype.cljs$core$IEquiv$ = true;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv.call(null,other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
goog.math.Long.prototype.cljs$core$IHash$ = true;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.hash.call(null,this$__$1.toString());
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});
com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (uuid,writer,_){
var uuid__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#uuid \""),cljs.core.str(uuid__$1.toString()),cljs.core.str("\"")].join(''));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__26905_26909 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,b));
var chunk__26906_26910 = null;
var count__26907_26911 = (0);
var i__26908_26912 = (0);
while(true){
if((i__26908_26912 < count__26907_26911)){
var k_26913 = cljs.core._nth.call(null,chunk__26906_26910,i__26908_26912);
var v_26914 = (b[k_26913]);
(a[k_26913] = v_26914);

var G__26915 = seq__26905_26909;
var G__26916 = chunk__26906_26910;
var G__26917 = count__26907_26911;
var G__26918 = (i__26908_26912 + (1));
seq__26905_26909 = G__26915;
chunk__26906_26910 = G__26916;
count__26907_26911 = G__26917;
i__26908_26912 = G__26918;
continue;
} else {
var temp__6747__auto___26919 = cljs.core.seq.call(null,seq__26905_26909);
if(temp__6747__auto___26919){
var seq__26905_26920__$1 = temp__6747__auto___26919;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26905_26920__$1)){
var c__26445__auto___26921 = cljs.core.chunk_first.call(null,seq__26905_26920__$1);
var G__26922 = cljs.core.chunk_rest.call(null,seq__26905_26920__$1);
var G__26923 = c__26445__auto___26921;
var G__26924 = cljs.core.count.call(null,c__26445__auto___26921);
var G__26925 = (0);
seq__26905_26909 = G__26922;
chunk__26906_26910 = G__26923;
count__26907_26911 = G__26924;
i__26908_26912 = G__26925;
continue;
} else {
var k_26926 = cljs.core.first.call(null,seq__26905_26920__$1);
var v_26927 = (b[k_26926]);
(a[k_26926] = v_26927);

var G__26928 = cljs.core.next.call(null,seq__26905_26920__$1);
var G__26929 = null;
var G__26930 = (0);
var G__26931 = (0);
seq__26905_26909 = G__26928;
chunk__26906_26910 = G__26929;
count__26907_26911 = G__26930;
i__26908_26912 = G__26931;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.call(null,m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentArrayMap.fromArray.call(null,arr,true,true);
});

cognitect.transit.MapBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__26194__auto__,writer__26195__auto__,opt__26196__auto__){
return cljs.core._write.call(null,writer__26195__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.call(null,v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentVector.fromArray.call(null,arr,true);
});

cognitect.transit.VectorBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__26194__auto__,writer__26195__auto__,opt__26196__auto__){
return cljs.core._write.call(null,writer__26195__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(var_args){
var args26932 = [];
var len__26725__auto___26935 = arguments.length;
var i__26726__auto___26936 = (0);
while(true){
if((i__26726__auto___26936 < len__26725__auto___26935)){
args26932.push((arguments[i__26726__auto___26936]));

var G__26937 = (i__26726__auto___26936 + (1));
i__26726__auto___26936 = G__26937;
continue;
} else {
}
break;
}

var G__26934 = args26932.length;
switch (G__26934) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26932.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.call(null,type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
return com.cognitect.transit.reader.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,({"handlers": cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, ["$",(function (v){
return cljs.core.symbol.call(null,v);
}),":",(function (v){
return cljs.core.keyword.call(null,v);
}),"set",(function (v){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,v);
}),"list",(function (v){
return cljs.core.into.call(null,cljs.core.List.EMPTY,v.reverse());
}),"cmap",(function (v){
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__26939 = (i + (2));
var G__26940 = cljs.core.assoc_BANG_.call(null,ret,(v[i]),(v[(i + (1))]));
i = G__26939;
ret = G__26940;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,ret);
}
break;
}
})], null),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts))), "mapBuilder": (new cognitect.transit.MapBuilder()), "arrayBuilder": (new cognitect.transit.VectorBuilder()), "prefersStrings": false}),cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;

/**
 * Read a transit encoded string into ClojureScript values given a 
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__26194__auto__,writer__26195__auto__,opt__26196__auto__){
return cljs.core._write.call(null,writer__26195__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__26194__auto__,writer__26195__auto__,opt__26196__auto__){
return cljs.core._write.call(null,writer__26195__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__26941_26945 = cljs.core.seq.call(null,v);
var chunk__26942_26946 = null;
var count__26943_26947 = (0);
var i__26944_26948 = (0);
while(true){
if((i__26944_26948 < count__26943_26947)){
var x_26949 = cljs.core._nth.call(null,chunk__26942_26946,i__26944_26948);
ret.push(x_26949);

var G__26950 = seq__26941_26945;
var G__26951 = chunk__26942_26946;
var G__26952 = count__26943_26947;
var G__26953 = (i__26944_26948 + (1));
seq__26941_26945 = G__26950;
chunk__26942_26946 = G__26951;
count__26943_26947 = G__26952;
i__26944_26948 = G__26953;
continue;
} else {
var temp__6747__auto___26954 = cljs.core.seq.call(null,seq__26941_26945);
if(temp__6747__auto___26954){
var seq__26941_26955__$1 = temp__6747__auto___26954;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26941_26955__$1)){
var c__26445__auto___26956 = cljs.core.chunk_first.call(null,seq__26941_26955__$1);
var G__26957 = cljs.core.chunk_rest.call(null,seq__26941_26955__$1);
var G__26958 = c__26445__auto___26956;
var G__26959 = cljs.core.count.call(null,c__26445__auto___26956);
var G__26960 = (0);
seq__26941_26945 = G__26957;
chunk__26942_26946 = G__26958;
count__26943_26947 = G__26959;
i__26944_26948 = G__26960;
continue;
} else {
var x_26961 = cljs.core.first.call(null,seq__26941_26955__$1);
ret.push(x_26961);

var G__26962 = cljs.core.next.call(null,seq__26941_26955__$1);
var G__26963 = null;
var G__26964 = (0);
var G__26965 = (0);
seq__26941_26945 = G__26962;
chunk__26942_26946 = G__26963;
count__26943_26947 = G__26964;
i__26944_26948 = G__26965;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__26194__auto__,writer__26195__auto__,opt__26196__auto__){
return cljs.core._write.call(null,writer__26195__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__26194__auto__,writer__26195__auto__,opt__26196__auto__){
return cljs.core._write.call(null,writer__26195__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__26966_26970 = cljs.core.seq.call(null,v);
var chunk__26967_26971 = null;
var count__26968_26972 = (0);
var i__26969_26973 = (0);
while(true){
if((i__26969_26973 < count__26968_26972)){
var x_26974 = cljs.core._nth.call(null,chunk__26967_26971,i__26969_26973);
ret.push(x_26974);

var G__26975 = seq__26966_26970;
var G__26976 = chunk__26967_26971;
var G__26977 = count__26968_26972;
var G__26978 = (i__26969_26973 + (1));
seq__26966_26970 = G__26975;
chunk__26967_26971 = G__26976;
count__26968_26972 = G__26977;
i__26969_26973 = G__26978;
continue;
} else {
var temp__6747__auto___26979 = cljs.core.seq.call(null,seq__26966_26970);
if(temp__6747__auto___26979){
var seq__26966_26980__$1 = temp__6747__auto___26979;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26966_26980__$1)){
var c__26445__auto___26981 = cljs.core.chunk_first.call(null,seq__26966_26980__$1);
var G__26982 = cljs.core.chunk_rest.call(null,seq__26966_26980__$1);
var G__26983 = c__26445__auto___26981;
var G__26984 = cljs.core.count.call(null,c__26445__auto___26981);
var G__26985 = (0);
seq__26966_26970 = G__26982;
chunk__26967_26971 = G__26983;
count__26968_26972 = G__26984;
i__26969_26973 = G__26985;
continue;
} else {
var x_26986 = cljs.core.first.call(null,seq__26966_26980__$1);
ret.push(x_26986);

var G__26987 = cljs.core.next.call(null,seq__26966_26980__$1);
var G__26988 = null;
var G__26989 = (0);
var G__26990 = (0);
seq__26966_26970 = G__26987;
chunk__26967_26971 = G__26988;
count__26968_26972 = G__26989;
i__26969_26973 = G__26990;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__26194__auto__,writer__26195__auto__,opt__26196__auto__){
return cljs.core._write.call(null,writer__26195__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__26991_26995 = cljs.core.seq.call(null,v);
var chunk__26992_26996 = null;
var count__26993_26997 = (0);
var i__26994_26998 = (0);
while(true){
if((i__26994_26998 < count__26993_26997)){
var x_26999 = cljs.core._nth.call(null,chunk__26992_26996,i__26994_26998);
ret.push(x_26999);

var G__27000 = seq__26991_26995;
var G__27001 = chunk__26992_26996;
var G__27002 = count__26993_26997;
var G__27003 = (i__26994_26998 + (1));
seq__26991_26995 = G__27000;
chunk__26992_26996 = G__27001;
count__26993_26997 = G__27002;
i__26994_26998 = G__27003;
continue;
} else {
var temp__6747__auto___27004 = cljs.core.seq.call(null,seq__26991_26995);
if(temp__6747__auto___27004){
var seq__26991_27005__$1 = temp__6747__auto___27004;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26991_27005__$1)){
var c__26445__auto___27006 = cljs.core.chunk_first.call(null,seq__26991_27005__$1);
var G__27007 = cljs.core.chunk_rest.call(null,seq__26991_27005__$1);
var G__27008 = c__26445__auto___27006;
var G__27009 = cljs.core.count.call(null,c__26445__auto___27006);
var G__27010 = (0);
seq__26991_26995 = G__27007;
chunk__26992_26996 = G__27008;
count__26993_26997 = G__27009;
i__26994_26998 = G__27010;
continue;
} else {
var x_27011 = cljs.core.first.call(null,seq__26991_27005__$1);
ret.push(x_27011);

var G__27012 = cljs.core.next.call(null,seq__26991_27005__$1);
var G__27013 = null;
var G__27014 = (0);
var G__27015 = (0);
seq__26991_26995 = G__27012;
chunk__26992_26996 = G__27013;
count__26993_26997 = G__27014;
i__26994_26998 = G__27015;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__26194__auto__,writer__26195__auto__,opt__26196__auto__){
return cljs.core._write.call(null,writer__26195__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__26194__auto__,writer__26195__auto__,opt__26196__auto__){
return cljs.core._write.call(null,writer__26195__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 *   opts is a map containing a :handlers entry. :handlers is a map of
 *   type constructors to handler instances.
 */
cognitect.transit.writer = (function cognitect$transit$writer(var_args){
var args27016 = [];
var len__26725__auto___27031 = arguments.length;
var i__26726__auto___27032 = (0);
while(true){
if((i__26726__auto___27032 < len__26725__auto___27031)){
args27016.push((arguments[i__26726__auto___27032]));

var G__27033 = (i__26726__auto___27032 + (1));
i__26726__auto___27032 = G__27033;
continue;
} else {
}
break;
}

var G__27018 = args27016.length;
switch (G__27018) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27016.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.call(null,type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts));
return com.cognitect.transit.writer.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,({"objectBuilder": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv.call(null,((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__27019 = obj;
G__27019.push(kfn.call(null,k),vfn.call(null,v));

return G__27019;
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x27020 = cljs.core.clone.call(null,handlers);
x27020.forEach = ((function (x27020,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__27021 = cljs.core.seq.call(null,coll);
var chunk__27022 = null;
var count__27023 = (0);
var i__27024 = (0);
while(true){
if((i__27024 < count__27023)){
var vec__27025 = cljs.core._nth.call(null,chunk__27022,i__27024);
var k = cljs.core.nth.call(null,vec__27025,(0),null);
var v = cljs.core.nth.call(null,vec__27025,(1),null);
f.call(null,v,k);

var G__27035 = seq__27021;
var G__27036 = chunk__27022;
var G__27037 = count__27023;
var G__27038 = (i__27024 + (1));
seq__27021 = G__27035;
chunk__27022 = G__27036;
count__27023 = G__27037;
i__27024 = G__27038;
continue;
} else {
var temp__6747__auto__ = cljs.core.seq.call(null,seq__27021);
if(temp__6747__auto__){
var seq__27021__$1 = temp__6747__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27021__$1)){
var c__26445__auto__ = cljs.core.chunk_first.call(null,seq__27021__$1);
var G__27039 = cljs.core.chunk_rest.call(null,seq__27021__$1);
var G__27040 = c__26445__auto__;
var G__27041 = cljs.core.count.call(null,c__26445__auto__);
var G__27042 = (0);
seq__27021 = G__27039;
chunk__27022 = G__27040;
count__27023 = G__27041;
i__27024 = G__27042;
continue;
} else {
var vec__27028 = cljs.core.first.call(null,seq__27021__$1);
var k = cljs.core.nth.call(null,vec__27028,(0),null);
var v = cljs.core.nth.call(null,vec__27028,(1),null);
f.call(null,v,k);

var G__27043 = cljs.core.next.call(null,seq__27021__$1);
var G__27044 = null;
var G__27045 = (0);
var G__27046 = (0);
seq__27021 = G__27043;
chunk__27022 = G__27044;
count__27023 = G__27045;
i__27024 = G__27046;
continue;
}
} else {
return null;
}
}
break;
}
});})(x27020,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x27020;
})(), "unpack": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
}),cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;

/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(var_args){
var args27047 = [];
var len__26725__auto___27053 = arguments.length;
var i__26726__auto___27054 = (0);
while(true){
if((i__26726__auto___27054 < len__26725__auto___27053)){
args27047.push((arguments[i__26726__auto___27054]));

var G__27055 = (i__26726__auto___27054 + (1));
i__26726__auto___27054 = G__27055;
continue;
} else {
}
break;
}

var G__27049 = args27047.length;
switch (G__27049) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args27047.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t_cognitect$transit27050 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cognitect.transit.Object}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cognitect.transit.t_cognitect$transit27050 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,meta27051){
this.tag_fn = tag_fn;
this.rep_fn = rep_fn;
this.str_rep_fn = str_rep_fn;
this.verbose_handler_fn = verbose_handler_fn;
this.meta27051 = meta27051;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cognitect.transit.t_cognitect$transit27050.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27052,meta27051__$1){
var self__ = this;
var _27052__$1 = this;
return (new cognitect.transit.t_cognitect$transit27050(self__.tag_fn,self__.rep_fn,self__.str_rep_fn,self__.verbose_handler_fn,meta27051__$1));
});

cognitect.transit.t_cognitect$transit27050.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27052){
var self__ = this;
var _27052__$1 = this;
return self__.meta27051;
});

cognitect.transit.t_cognitect$transit27050.prototype.tag = (function (o){
var self__ = this;
var _ = this;
return self__.tag_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit27050.prototype.rep = (function (o){
var self__ = this;
var _ = this;
return self__.rep_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit27050.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
return self__.str_rep_fn.call(null,o);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit27050.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return self__.verbose_handler_fn.call(null);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit27050.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tag-fn","tag-fn",242055482,null),new cljs.core.Symbol(null,"rep-fn","rep-fn",-1724891035,null),new cljs.core.Symbol(null,"str-rep-fn","str-rep-fn",-1179615016,null),new cljs.core.Symbol(null,"verbose-handler-fn","verbose-handler-fn",547340594,null),new cljs.core.Symbol(null,"meta27051","meta27051",1984974580,null)], null);
});

cognitect.transit.t_cognitect$transit27050.cljs$lang$type = true;

cognitect.transit.t_cognitect$transit27050.cljs$lang$ctorStr = "cognitect.transit/t_cognitect$transit27050";

cognitect.transit.t_cognitect$transit27050.cljs$lang$ctorPrWriter = (function (this__26194__auto__,writer__26195__auto__,opt__26196__auto__){
return cljs.core._write.call(null,writer__26195__auto__,"cognitect.transit/t_cognitect$transit27050");
});

cognitect.transit.__GT_t_cognitect$transit27050 = (function cognitect$transit$__GT_t_cognitect$transit27050(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta27051){
return (new cognitect.transit.t_cognitect$transit27050(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta27051));
});

}

return (new cognitect.transit.t_cognitect$transit27050(tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;

/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
return com.cognitect.transit.types.taggedValue.call(null,tag,rep);
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
return com.cognitect.transit.types.isTaggedValue.call(null,x);
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 *   in the 53bit integer range, a goog.math.Long instance if above. s
 *   may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
return com.cognitect.transit.types.intValue.call(null,s);
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 *   range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
return com.cognitect.transit.types.isInteger.call(null,x);
});
/**
 * Construct a big integer from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
return com.cognitect.transit.types.bigInteger.call(null,s);
});
/**
 * Returns true if x is a transit big integer value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
return com.cognitect.transit.types.isBigInteger.call(null,x);
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
return com.cognitect.transit.types.bigDecimalValue.call(null,s);
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
return com.cognitect.transit.types.isBigDecimal.call(null,x);
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
return com.cognitect.transit.types.uri.call(null,s);
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
return com.cognitect.transit.types.isURI.call(null,x);
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
return com.cognitect.transit.types.uuid.call(null,s);
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var or__25542__auto__ = com.cognitect.transit.types.isUUID.call(null,x);
if(cljs.core.truth_(or__25542__auto__)){
return or__25542__auto__;
} else {
return (x instanceof cljs.core.UUID);
}
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
return com.cognitect.transit.types.binary.call(null,s);
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
return com.cognitect.transit.types.isBinary.call(null,x);
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
return com.cognitect.transit.types.quoted.call(null,x);
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
return com.cognitect.transit.types.isQuoted.call(null,x);
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
return com.cognitect.transit.types.link.call(null,x);
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
return com.cognitect.transit.types.isLink.call(null,x);
});

//# sourceMappingURL=transit.js.map?rel=1476824790329