(ns yunjia.util.component.mysql
  "mysql数据库连接池组件，依赖config组件。"
  (:require [environ.core :refer [env]]
            [duct.component.hikaricp :refer [hikaricp]]
            [com.stuartsierra.component :as component]
            [taoensso.timbre :refer [debug]]))

(defrecord Mysql [config-db-key config pool]
  component/Lifecycle
  (start [this]
    (debug "Starting db component...")
    (if (:pool this)
      this
      (let [db-key (if config-db-key
                     (keyword config-db-key)
                     :db)
            db-config (get-in config [:value db-key])
            {:keys [host port name user password hikaricp-options]} db-config
            subprotocol "mysql"
            port (str (or port "3306"))
            uri (format "jdbc:%s://%s:%s/%s?tinyInt1isBit=false&useSSL=false"
                        subprotocol
                        host
                        port
                        name)
            hikaricp-pool (hikaricp (merge hikaricp-options
                                           {:uri      uri
                                            :username user
                                            :password password}))]
        (assoc this :pool (component/start hikaricp-pool)))))

  (stop [this]
    (debug "Stopping DB component...")
    (if (:pool this)
      (component/stop (:pool this)))
    (assoc this :pool nil)))

(defn make-mysql-component
  ([] (make-mysql-component :db))
  ([config-db-key] (map->Mysql {:config-db-key (keyword config-db-key)})))


