(ns yunjia.util.component.swagger
  "定义swagger1st组件。"
  (:require [com.stuartsierra.component :as component]
            [yunjia.util.swagger :refer [make-swagger1st-handler]]
            [taoensso.timbre :refer [debug]]))

;; Swagger1st组件，负责生成最终符合Ring规范的handler。可能依赖db组件。
(defrecord Swagger [db handler yaml middleware]
  component/Lifecycle

  (start [this]
    (debug "Starting Swagger component...")
    (if (:handler this)
      this
      (let [db-spec (get-in db [:pool :spec])
            h (if db-spec
                (make-swagger1st-handler yaml db-spec)
                (make-swagger1st-handler yaml))
            hh (if middleware
                 (middleware h)
                 h)]
        (assoc this :handler hh))))

  (stop [this]
    (debug "Stopping Swagger component...")
    (assoc this :handler nil)))

(defn make-swagger
  ([yaml]
   (make-swagger yaml nil))
  ([yaml ring-middleware] (map->Swagger
                            {:yaml yaml
                             :middleware ring-middleware})))
