(ns yunjia.util.component.logger
  (:require [com.stuartsierra.component :as component]
            [taoensso.timbre :as timbre]
            [taoensso.timbre.appenders.core :refer [println-appender]]
            [taoensso.timbre.appenders.3rd-party.rolling :as roll]))

(timbre/refer-timbre)

(defrecord Logger [config-logger-key config]
  component/Lifecycle

  (start [this]
    (debug "Starting logger component...")
    (let [logger-key (if config-logger-key
                       (keyword config-logger-key)
                       :logger)
          logger-config (get-in config [:value logger-key])
          {:keys [rolling-appender]} logger-config
          appenders (if rolling-appender
                      {:println (println-appender)
                       :rolling-appender (roll/rolling-appender rolling-appender)}
                      {:println (println-appender)})]
      (timbre/merge-config! {:appenders appenders})
      this))

  (stop [this] (debug "Stopping logger component...")))

(defn make-logger-component
  ([] (make-logger-component :logger))
  ([config-logger-key]
   (map->Logger {:config-logger-key (keyword config-logger-key)})))
