(ns yunjia.util.alioss
  "阿里云存储oss的相关操作。"
  (:require [yunjia.admin.global :refer [get-aliyun-oss]])
  (:import (com.aliyun.oss OSSClient)
           (java.io ByteArrayInputStream)
           (java.time LocalDate)))

(defn upload-object
  "上传阿里云oss存储。"
  [^String endpoint
   ^String access-key-id
   ^String access-key-secret
   ^String bucket-name
   ^String object-key
   bytes]
  (let [client (OSSClient. endpoint access-key-id access-key-secret)]
    (.putObject client bucket-name object-key (ByteArrayInputStream. bytes))
    (.shutdown client)))

(defn make-random-file-name
  [original-file-name]
  (let [s1 (take 9 (shuffle (seq "abcdefghijklmnopqrstuvwxyz")))
        s2 (take 6 (shuffle (seq "0123456789")))
        name (str (apply str s1)
                  (apply str s2))
        i (clojure.string/last-index-of original-file-name ".")
        ext (if i
              (subs original-file-name i)
              "")]
    (str name ext)))


