(ns yunjia.util.time
  (:import (java.time Instant ZonedDateTime ZoneId)
           (java.time.format DateTimeFormatter)))

(def zone-shanghai (ZoneId/of "Asia/Shanghai"))

(def formatter-yyyyMMddHHmm (DateTimeFormatter/ofPattern "yyyyMMddHHmm"))

(defn ^String now-yyyyMMddHHmm
  []
  (let [dt (ZonedDateTime/ofInstant (Instant/now) zone-shanghai)]
    (.format dt formatter-yyyyMMddHHmm)))
