(ns yunjia.util.misc
  (:require [clojure.string :as s]
            [medley.core :as mc]))

(defn dot-notation->embed
  "{:a.b 1 :a.c 2} -> {:a [{:b 1 :c 2}]}"
  [m]
  (let [dot-index #(s/index-of (name %) \.)
        dot-keys (filter dot-index (keys m))
        group-map (group-by #(keyword (subs (name %) 0 (dot-index %))) dot-keys)
        group-seq (for [[k v] group-map
                        :let [x (select-keys m v)
                              y (mc/map-keys #(keyword (subs (name %) (inc (dot-index %))))
                                           x)]]
                    [k [y]])]
    (merge (apply dissoc m dot-keys)
           (into {} group-seq))))

(comment
  (dot-notation->embed {:a.aa 1 :a.bb 2 :x.xx 5 :x.yy 6 :haha 999}))