(ns yunjia.util.misc
  (:require [clojure.string :as s]
            [medley.core :as mc]))

(defn dot-notation->embed
  "{:a.b 1 :a.c 2} -> {:a [{:b 1 :c 2}]}"
  [m]
  (let [dot-index #(s/index-of (name %) \.)
        dot-keys (filter dot-index (keys m))
        group-map (group-by #(keyword (subs (name %) 0 (dot-index %))) dot-keys)
        group-seq (for [[k v] group-map
                        :let [x (select-keys m v)
                              y (mc/map-keys #(keyword (subs (name %) (inc (dot-index %))))
                                           x)]]
                    [k [y]])]
    (merge (apply dissoc m dot-keys)
           (into {} group-seq))))

(comment
  (dot-notation->embed {:a.aa 1 :a.bb 2 :x.xx 5 :x.yy 6 :haha 999}))

(defn dot-notation
  "{:d 4 :e 5 :a {:b 1 :c 2}} -> {:d 4, :e 5, :a {:b 1, :c 2}, :a.b 1, :a.c 2}"
  [a-key a-map resource-map]
  (loop [b-map a-map
         r-map resource-map]
    (let [[key value] (first b-map)]
      (if (keyword? key)
        (recur
          (rest b-map)
          (assoc r-map (keyword (str (name a-key) "." (name key))) value))
        r-map))))

(defn embed->dot-notation
  "{:d 4 :e 5 :a [{:b 1 :c 2}]} -> {:d 4 :e 5 :a.b 1 :a.c 2}"
  [resource-map]
  (loop [r-map resource-map
         a-map {}]
    (let [[key value] (first r-map)]
      (println value)
      (if (keyword? key)
        (recur (rest r-map) (if (or
                                  (vector? value)
                                  (map? value))
                              (merge (-> (dot-notation key (first value) resource-map)
                                         (dissoc key)) a-map)
                              (assoc a-map key value)))
        a-map))))