(ns yunjia.util.component.mysql
  "mysql数据库连接池组件，依赖config组件。"
  (:require [environ.core :refer [env]]
            [duct.component.hikaricp :refer [hikaricp]]
            [com.stuartsierra.component :as component]
            [taoensso.timbre :refer [debug]]))

(defrecord Mysql [config-db-key config pool]
  component/Lifecycle
  (start [this]
    (debug "Starting db component...")
    (if (:pool this)
      this
      (let [db-key (if config-db-key
                     (keyword config-db-key)
                     :db)
            db-config (get-in config [:value db-key])
            subprotocol "mysql"
            host (:host db-config)
            port (str (or (:port db-config) "3306"))
            name (:name db-config)
            user (:user db-config)
            password (:password db-config)
            uri (format "jdbc:%s://%s:%s/%s?tinyInt1isBit=false&useSSL=false"
                        subprotocol
                        host
                        port
                        name)
            hikaricp-pool (hikaricp {:uri      uri
                                     :username user
                                     :password password})]
        (assoc this :pool (component/start hikaricp-pool)))))

  (stop [this]
    (debug "Stopping DB component...")
    (if (:pool this)
      (component/stop (:pool this)))
    (assoc this :pool nil)))

(defn make-mysql-component
  ([] (make-mysql-component :db))
  ([config-db-key] (map->Mysql {:config-db-key (keyword config-db-key)})))


