(ns yunjia.util.db
  (:require [clojure.java.jdbc :as j]
            [clojure.string :as string]
            [taoensso.timbre :as timbre
             :refer (log trace debug info warn error fatal report
                         logf tracef debugf infof warnf errorf fatalf reportf
                         spy get-env log-env)]
            [taoensso.timbre.profiling :as profiling
             :refer (pspy pspy* profile defnp p p*)]))

(defn insert!
  "clojure.java.jdbc/insert!的包装函数，只支持一种参数传递形式，并且始终使用默认选项。"
  [db-spec table row-map & row-maps]
  (let [time (quot (System/currentTimeMillis) 1000)
        m-seq (into [row-map] row-maps)
        ms (for [m m-seq]
            (assoc m :create_time time))]
    (apply j/insert! db-spec table ms)))

(defn update!
  "clojure.java.jdbc/update!的包装函数"
  [db-spec table set-map where-clause & options]
  (let [time (quot (System/currentTimeMillis) 1000)
        map-time (assoc set-map :modify_time time)]
    (apply j/update! db-spec table map-time where-clause options)))

(defn delete!
  "clojure.java.jdbc/delete!的包装函数"
  [db-spec table where-clause & options]
  (apply j/delete! db-spec table where-clause options))

(defn execute!
  "clojure.java.jdbc/execute!的包装函数。只支持一种参数传递形式，并且始终使用默认选项。"
  [db-spec sql-vec]
  (debug (string/join ", " sql-vec))
  (j/execute! db-spec sql-vec))

(defn query
  "clojure.java.jdbc/query的包装函数。只支持一种参数传递形式，并且始终使用默认选项。"
  [db-spec sql-vec]
  (debug (string/join ", " sql-vec))
  (j/query db-spec sql-vec))


