(ns yunjia.util.swagger
  "swagger相关工具。请参考https://github.com/sarnowski/swagger1st。"
  (:require [io.sarnowski.swagger1st.core :as s1st]
            [io.sarnowski.swagger1st.executor :as s1stexec]))

(defn make-swagger1st-handler
  "调用swagger1st库，创建一个Ring的Handler，能够根据swagger-yaml定义处理请求。
  args是swagger定义中处理函数所需的额外参数。"
  [swagger-yaml & args]
  ; resolver-fn返回一个ring handler，handler处理请求时调用swagger定义中的operationId对应的函数。
  (let [resolver-fn (fn [request-definition]
                      (if-let [cljfn (s1stexec/operationId-to-function request-definition)]
                        (fn [request]
                          (apply cljfn request args))))]
    (-> (s1st/context :yaml-cp swagger-yaml)
        (s1st/discoverer)
        (s1st/mapper)
        (s1st/parser)
        (s1st/executor :resolver resolver-fn))))



