(ns yunjia.util.parsed
  (:require [clojure.data.json :as clj-json]))

(defn byte-array-to-json
  "将byte array解析成json格式"
  [byte-array]
  (-> (new String byte-array)
      (clj-json/read-str :key-fn keyword)))

(defn json-to-byte-array
  "将json格式解析成byte array"
  [json]
  (-> (clj-json/write-str json)
      .getBytes))

(defn string-to-json
  "将string格式解析成json"
  [string-param]
  (clj-json/read-str string-param :key-fn keyword))

(defn json-to-string
  "将json格式解析成string"
  [json]
  (clj-json/write-str json))
