(ns yunjia.util.db
  (:require [clojure.java.jdbc :as j]
            [clojure.string :as string]
            [taoensso.timbre :as timbre
             :refer (log trace debug info warn error fatal report
                         logf tracef debugf infof warnf errorf fatalf reportf
                         spy get-env log-env)]
            [taoensso.timbre.profiling :as profiling
             :refer (pspy pspy* profile defnp p p*)]))

(defn insert!
  "clojure.java.jdbc/insert!的包装函数，只支持一种参数传递形式，并且始终使用默认选项。"
  [db-spec table row-map & row-maps]
  (let [time (/ System/currentTimeMillis 1000)
        m-seq (into [row-map] row-maps)
        ms (for [m m-seq]
            (assoc m :create_time time))]
    (apply j/insert! db-spec table ms)))

(defn update!
  "clojure.java.jdbc/update!的包装函数"
  [db-spec table set-map where-clause & options]
  (let [time (/ System/currentTimeMillis 1000)
        map-time (assoc set-map :modify_time time)]
    (apply j/update! db-spec table map-time where-clause options)))

(defn delete!
  "clojure.java.jdbc/delete!的包装函数"
  [db-spec table where-clause & options]
  (apply j/delete! db-spec table where-clause options))

(defn- parse-sql-params
  [sql-params]
  (if (string? sql-params)
    [sql-params nil]
    (let [special (first sql-params)
          sql-is-first (string? special)
          options-are-first (map? special)
          sql (cond sql-is-first special
                    options-are-first (second sql-params))
          params (cond sql-is-first (rest sql-params)
                       options-are-first (rest (rest sql-params))
                       :else (rest sql-params))]
      [sql params])))

(defn- sql-params-to-debug-string
  [sql-params]
  (let [[sql params] (parse-sql-params sql-params)
        v (into [sql] params)]
    (string/join ", " v)))

(defn execute!
  "clojure.java.jdbc/execute!的包装函数"
  [db-spec sql-params & options]
  (debug (sql-params-to-debug-string sql-params))
  (apply j/execute! db-spec sql-params options))

(defn query
  "clojure.java.jdbc/query的包装函数"
  [db-spec sql-params & options]
  (debug (sql-params-to-debug-string sql-params))
  (apply j/query db-spec sql-params options))


