(ns yunjia.util.rest
  "Restful API相关工具。"
  (:require [ring.util.response :as resp]
            [cheshire.core :as json]
            [clj-http.client :as client]))

(def content-type "application/json; charset=utf-8")

(defn json-response
  "将body转换为json字符串。"
  [response]
  (update-in response [:body] (fn [body]
                                (cond
                                  (nil? body) body
                                  (string? body) body
                                  :else (json/encode body)))))

(defn response
  "处理响应map：
  1、增加content-type
  2、如果(associative? body)为真，将body转换为json字符串"
  [response]
  (->
    response
    (resp/content-type content-type)
    json-response))

(defn- process-client-response
  "客户请求rest服务，对得到的响应进行处理，如json解码等。"
  [response]
  (update response :body
          #(if % (json/decode % true))))

(defn client-get
  "clj-http.client/get的包装函数，调用方式和原函数一致。
  对请求做了一些处理，增加了content-type等。
  对响应的body进行json解码。"
  [url & [req]]
  (let [resp (client/get url
                         (merge {:content-type content-type} req))]
    (process-client-response resp)))

(defn client-post
  "clj-http.client/post的包装函数，调用方式和原函数一致。
  对请求做了一些处理，增加了content-type等。
  对响应的body进行json解码。"
  [url & [req]]
  (let [resp (client/post url
                          (merge {:content-type content-type} req))]
    (process-client-response resp)))