(ns yunjia.util.rest
  "Restful API相关工具。"
  (:require [ring.util.response :as resp]
            [cheshire.core :as json]))

(def content-type "application/json; charset=utf-8")

(defn json-response
  "将body转换为json字符串。"
  [response]
  (update-in response [:body] (fn [body]
                                (cond
                                  (nil? body) body
                                  (string? body) body
                                  :else (json/encode body)))))

(defn response
  "处理响应map：
  1、增加content-type
  2、如果(associative? body)为真，将body转换为json字符串"
  [response]
  (->
    response
    (resp/content-type content-type)
    json-response))