(ns yunjia.util.component.swagger
  "定义swagger1st组件。"
  (:require [com.stuartsierra.component :as component]
            [yunjia.util.swagger :refer [make-swagger1st-handler]]
            [taoensso.timbre :refer [debug]]))

;; Swagger1st组件，负责生成最终符合Ring规范的handler。依赖Mysql组件。
(defrecord Swagger [db handler yaml]
  component/Lifecycle

  (start [this]
    (debug "Starting Swagger component...")
    (if (:handler this)
      this
      (let [h (make-swagger1st-handler
                yaml
                (get-in db [:pool :spec]))]
        (assoc this :handler h))))

  (stop [this]
    (debug "Stopping Swagger component...")
    (assoc this :handler nil)))

(defn make-swagger
  [yaml]
  (map->Swagger {:yaml yaml}))
