(ns yunjia.util.db
  (:require [clojure.java.jdbc :as j]
            [clojure.string :as string]
            [taoensso.timbre :as timbre
             :refer (log trace debug info warn error fatal report
                         logf tracef debugf infof warnf errorf fatalf reportf
                         spy get-env log-env)]
            [taoensso.timbre.profiling :as profiling
             :refer (pspy pspy* profile defnp p p*)]))

(defn insert!
  "clojure.java.jdbc/insert!的包装函数"
  {:arglists '([db-spec table row-map :transaction? true :entities identity]
                [db-spec table row-map & row-maps :transaction? true :entities identity]
                [db-spec table col-name-vec col-val-vec & col-val-vecs :transaction? true :entities identity])}
  [db-spec table & options]
  (apply j/insert! db-spec table options))

(defn update!
  "clojure.java.jdbc/update!的包装函数"
  [db-spec table set-map where-clause & options]
  (apply j/update! db-spec table set-map where-clause options))

(defn delete!
  "clojure.java.jdbc/delete!的包装函数"
  [db-spec table where-clause & options]
  (apply j/delete! db-spec table where-clause options))

(defn- parse-sql-params
  [sql-params]
  (if (string? sql-params)
    [sql-params nil]
    (let [special (first sql-params)
          sql-is-first (string? special)
          options-are-first (map? special)
          sql (cond sql-is-first special
                    options-are-first (second sql-params))
          params (cond sql-is-first (rest sql-params)
                       options-are-first (rest (rest sql-params))
                       :else (rest sql-params))]
      [sql params])))

(defn- sql-params-to-debug-string
  [sql-params]
  (let [[sql params] (parse-sql-params sql-params)
        v (into [sql] params)]
    (string/join ", " v)))

(defn execute!
  "clojure.java.jdbc/execute!的包装函数"
  [db-spec sql-params & options]
  (debug (sql-params-to-debug-string sql-params))
  (apply j/execute! db-spec sql-params options))

(defn query
  "clojure.java.jdbc/query的包装函数"
  [db-spec sql-params & options]
  (debug (sql-params-to-debug-string sql-params))
  (apply j/query db-spec sql-params options))


