(ns yunjia.util.component.config
  (:require [clojure.edn :as edn]
            [com.stuartsierra.component :as component]
            [environ.core :refer [env]]
            [taoensso.timbre :refer [debug]]))

(defn- load-config
  "filepath: edn文件路径。
  返回clojure数据结构。"
  [filepath]
  (edn/read-string (slurp filepath)))

(defrecord Config [path value]
  component/Lifecycle

  (start [this]
    (debug "Starting Config component...")
    (assoc this :value (load-config path)))

  (stop [this]
    (assoc this :value nil)))

(defn make-config
  [env-name]
  (let [config (if-let [config-file (env (keyword env-name))]
                 (load-config config-file)
                 (load-config "config.edn"))]
    (map->Config {:path config})))



