(ns yunjia.util.middleware)

(defn wrap-authentication
  "处理认证的Ring中间件，返回Ring的handler。
  放行已认证的请求，拦截未认证的请求。
  通过session实现。在session中增加:auth-access-time，记录最后一次已通过认证请求的访问时间。
  "
  [handler not-found-handler]
  (fn [request]
    (let [visit-time (:visit-time (:session request))
          status (:logged-status (:session request))
          current-time (System/currentTimeMillis)]
      (pprint status)
      (cond
        (= status nil) (not-found-handler request)
        (and status (< (- current-time visit-time)
                       (* 5 60 1000))) (update-in (handler request) [:session :visit-time] (constantly current-time))
        :else (update-in (not-found-handler request) :session nil)))))

