(ns yunjia.util.db
  (:require [clojure.java.jdbc :as j]
            [clojure.string :as str]))

(defn insert!
  "clojure.java.jdbc/insert!的包装函数"
  {:arglists '([db-spec table row-map :transaction? true :entities identity]
                [db-spec table row-map & row-maps :transaction? true :entities identity]
                [db-spec table col-name-vec col-val-vec & col-val-vecs :transaction? true :entities identity])}
  [db-spec table & options]
  (apply j/insert! db-spec table options))

(defn update!
  "clojure.java.jdbc/update!的包装函数"
  [db-spec table set-map where-clause & options]
  (apply j/update! db-spec table set-map where-clause options))

(defn delete!
  "clojure.java.jdbc/delete!的包装函数"
  [db-spec table where-clause & options]
  (apply j/delete! db-spec table where-clause options))

(defn execute!
  "clojure.java.jdbc/execute!的包装函数"
  [db-spec sql-params & options]
  (apply j/execute! db-spec sql-params options))

(defn query
  "clojure.java.jdbc/query的包装函数"
  [db-spec sql-params & options]
  (apply j/query db-spec sql-params options))


