(ns yunjia.util.db
  (:require [clojure.java.jdbc :as j]
            [clojure.string :as str]))

(defn insert!
  "clojure.java.jdbc/insert!的包装函数"
  {:arglists '([db-spec table row-map :transaction? true :entities identity]
                [db-spec table row-map & row-maps :transaction? true :entities identity]
                [db-spec table col-name-vec col-val-vec & col-val-vecs :transaction? true :entities identity])}
  [db-spec table & options]
  (apply j/insert! db-spec table options))

(defn execute!
  "clojure.java.jdbc/execute!的包装函数"
  [db-spec sql-params & {:keys [transaction? multi?]
                    :or {transaction? true multi? false}}]
  (j/execute! db-spec sql-params :transaction? transaction? :multi? multi?))

(defn query
  "clojure.java.jdbc/query的包装函数"
  [db-spec sql-params & {:keys [result-set-fn row-fn identifiers as-arrays?]
                    :or {row-fn identity
                         identifiers str/lower-case}}]
  (j/query db-spec
           sql-params
           :result-set-fn result-set-fn
           :row-fn row-fn
           :identifiers identifiers
           :as-arrays? as-arrays?))


