(ns yunjia.util.template.classic
  "hiccup风格的html模板库，经典风格。"
  (:require [hiccup.core :refer :all]
            [hiccup.page :refer :all]
            [medley.core :refer [map-vals]]))

(defn make-head
  "创建hiccup格式head组件。
  option-map：选项map，接受如下的key：
    :title 可选。
  styles：样式文件列表。"
  [& [option-map styles]]
  [:head
   [:title (or (:title (map-vals str option-map))
               "")]
   [:meta {:charset "utf-8"}]
   [:meta {:http-equiv "X-UA-Compatible" :content "IE=edge"}]
   [:meta {:name "keywords" :content "index"}]
   [:meta {:name "viewport" :content "width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no"}]
   [:meta {:name "renderer" :content "webkit"}]
   [:meta {:http-equiv "Cache-Control" :content "no-siteapp"}]
   (apply include-css
          "common/assets/css/amazeui.css"
          "common/assets/css/public.css"
          "common/assets/sweetalert/sweetalert.css"
          styles)])

(defn make-footer
  "创建hiccup格式footer组件。
  styles：javascript文件列表。"
  [& scripts]
  [:div
   (apply include-js
          "common/assets/js/jquery.min.js"
          "common/assets/js/amazeui.min.js"
          "common/assets/js/jquery.json.min.js"
          "common/assets/sweetalert/sweetalert.min.js"
          "common/assets/js/public.js"
          scripts)])

;(defn- make-level-1
;  "创建第一级菜单项"
;  [index name sub-nodes]
;  (let [target-id (format "do-not-say-%d" index)
;        data-am-collapse (format "{parent: '#accordion', target: '#%s'}" target-id)]
;    [:div {:class "am-panel am-panel-default"}
;     [:div {:class "am-panel-hd"}
;      [:h4 {:class "am-panel-title" :data-am-collapse data-am-collapse}
;       [:span {:class "am-icon-subway am-icon-sm"}]
;       name]]
;     [:div {:id target-id :class "am-panel-collapse am-collapse am-in"}
;      [:div {:class "am-panel-bd"}
;       [:ul {:class "am-list am-list-static am-list-border"}
;        ;; TODO
;        [:li {:onclick ""} [:span {:class "am-icon-home am-icon-sm"}] "菜单A"]]]]]))
;
;(defn make-2-level-menu
;  "创建hiccup格式两级菜单。"
;  [tree]
;
;
;  (for [menu menu-obj]
;    [:div {:class "am-panel-group" :id "accordion"}
;     [:div {:class "am-panel am-panel-default"}
;      [:div {:class "am-panel-hd"}
;       [:h4 {:class "am-panel-title" :data-am-collapse "{parent: '#accordion', target: '#do-not-say-1'}"}
;        [:span {:class "am-icon-subway am-icon-sm"}] menu
;        ]]
;      (meke-sub-menu ["A1" "AS2" "A3" "A4"])
;      ]]
;    )
;  )

(defn make-input
  "创建hiccup格式input组件。
  option-map: 选项map，接受如下的key:
    参考html的元素属性。"
  [option-map]
  (let [options (map-vals str option-map)
        random (rand-int 10000)
        default {:id          (str "input-random-id-" random)
                 :name        (str "input-random-name-" random)
                 :type        "text"
                 :class       "am-form-field"
                 :value       ""
                 :placeholder ""}
        attributes (merge default options)]
    [:input attributes]))

(defn make-textarea
  "创建hiccup格式textarea组件。
  option-map: 选项map，接受如下的key:
    参考html的元素属性。"
  [& [option-map]]
  (let [options (map-vals str option-map)
        random (rand-int 10000)
        default {:id    (str "textarea-random-id-" random)
                 :name  (str "textarea-random-name-" random)
                 :rows  "6"
                 :cols  "20"
                 :value ""}
        attributes (merge default options)]
    [:textarea (dissoc attributes :value) (:value attributes)]))

(defn make-datepicker
  "创建hiccup格式datepicker组件。
  option-map: 选项map，接受如下的key:
    :format 默认yyyy-mm-dd。
    :setValue 默认2015-01-12。
    其他html元素属性。"
  [& [option-map]]
  (let [options (map-vals str option-map)
        o-format (or (:format options)
                     "yyyy-mm-dd")
        o-setValue (or (:setValue options)
                       "2015-01-12")
        data-am-datepicker (format "{format: '%s', setValue: '%s'}" o-format o-setValue)
        random (rand-int 10000)
        default {:id   (str "datepicker-random-id-" random)
                 :name (str "datepicker-random-name-" random)}
        attributes (-> default
                       (merge options)
                       (dissoc :format :setValue))]
    [:input (merge attributes
                   {:type               "text"
                    :data-am-datepicker data-am-datepicker
                    :readonly           "readonly"})]))

(defn make-form
  "创建hiccup格式form组件。
  option-map: 选项map，接受如下的key:
     :form-type 可选。am-container: 带有padding样式，container: 全屏样式。默认为container。
     其他html元素属性。
  elements: 表单元素组件列表。"
  [option-map element & elements]
  (let [options (map-vals str option-map)
        form-type (or (:form-type options)
                      "container")
        random (rand-int 10000)
        default {:id     (str "form-random-id-" random)
                 :name   (str "form-random-name-" random)
                 :class  "am-form"
                 :method "POST"}
        attributes (-> default
                       (merge options)
                       (dissoc :form-type))]
    [:div {:class form-type}
     (into [:form attributes element] elements)]))
