(ns yuan.refactor.core)

(defn f->
  ([s] (f-> s ()))
  ([s fs] (if (and (list? s)
                   (= 2 (count s)))
            (let [[f x] s]
              (recur x (conj fs f)))
            (conj (conj fs s) '->))))

(defmacro r-> [sexp]
  (f-> sexp))

(comment
  (-> 1 inc dec)
  (r-> '(g (f x)))
  (r-> '(f x))
  (r-> '(f (x)))
  )
