// Compiled by ClojureScript 1.7.122 {}
goog.provide('plumbing.core');
goog.require('cljs.core');
goog.require('schema.utils');
goog.require('plumbing.fnk.schema');
/**
 * A sentinel value representing missing portions of the input data.
 */
plumbing.core._PLUS_none_PLUS_ = new cljs.core.Keyword("plumbing.core","missing","plumbing.core/missing",1721767298);
/**
 * Updates the value in map m at k with the function f.
 * 
 *  Like update-in, but for updating a single top-level key.
 *  Any additional args will be passed to f after the value.
 * 
 *  WARNING As of Clojure 1.7 this function exists in clojure.core and
 *  will not be exported by this namespace.
 */
plumbing.core.update = (function plumbing$core$update(var_args){
var args37003 = [];
var len__17407__auto___37012 = arguments.length;
var i__17408__auto___37013 = (0);
while(true){
if((i__17408__auto___37013 < len__17407__auto___37012)){
args37003.push((arguments[i__17408__auto___37013]));

var G__37014 = (i__17408__auto___37013 + (1));
i__17408__auto___37013 = G__37014;
continue;
} else {
}
break;
}

var G__37011 = args37003.length;
switch (G__37011) {
case 3:
return plumbing.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return plumbing.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return plumbing.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args37003.slice((5)),(0)));
return plumbing.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__17426__auto__);

}
});

plumbing.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k)));
});

plumbing.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x1){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1));
});

plumbing.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x1,x2){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1,x2));
});

plumbing.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x1,x2,xs){
return cljs.core.assoc.call(null,m,k,cljs.core.apply.call(null,f,cljs.core.get.call(null,m,k),x1,x2,xs));
});

plumbing.core.update.cljs$lang$applyTo = (function (seq37004){
var G__37005 = cljs.core.first.call(null,seq37004);
var seq37004__$1 = cljs.core.next.call(null,seq37004);
var G__37006 = cljs.core.first.call(null,seq37004__$1);
var seq37004__$2 = cljs.core.next.call(null,seq37004__$1);
var G__37007 = cljs.core.first.call(null,seq37004__$2);
var seq37004__$3 = cljs.core.next.call(null,seq37004__$2);
var G__37008 = cljs.core.first.call(null,seq37004__$3);
var seq37004__$4 = cljs.core.next.call(null,seq37004__$3);
var G__37009 = cljs.core.first.call(null,seq37004__$4);
var seq37004__$5 = cljs.core.next.call(null,seq37004__$4);
return plumbing.core.update.cljs$core$IFn$_invoke$arity$variadic(G__37005,G__37006,G__37007,G__37008,G__37009,seq37004__$5);
});

plumbing.core.update.cljs$lang$maxFixedArity = (5);
/**
 * Build map k -> (f v) for [k v] in map, preserving the initial type
 */
plumbing.core.map_vals = (function plumbing$core$map_vals(f,m){
if(cljs.core.sorted_QMARK_.call(null,m)){
return cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc.call(null,out_m,k,f.call(null,v));
}),cljs.core.sorted_map.call(null),m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc_BANG_.call(null,out_m,k,f.call(null,v));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else {
var m_atom__28896__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__37024_37030 = cljs.core.seq.call(null,m);
var chunk__37025_37031 = null;
var count__37026_37032 = (0);
var i__37027_37033 = (0);
while(true){
if((i__37027_37033 < count__37026_37032)){
var vec__37028_37034 = cljs.core._nth.call(null,chunk__37025_37031,i__37027_37033);
var k_37035 = cljs.core.nth.call(null,vec__37028_37034,(0),null);
var v_37036 = cljs.core.nth.call(null,vec__37028_37034,(1),null);
var m37023_37037 = cljs.core.deref.call(null,m_atom__28896__auto__);
cljs.core.reset_BANG_.call(null,m_atom__28896__auto__,cljs.core.assoc_BANG_.call(null,m37023_37037,k_37035,f.call(null,v_37036)));

var G__37038 = seq__37024_37030;
var G__37039 = chunk__37025_37031;
var G__37040 = count__37026_37032;
var G__37041 = (i__37027_37033 + (1));
seq__37024_37030 = G__37038;
chunk__37025_37031 = G__37039;
count__37026_37032 = G__37040;
i__37027_37033 = G__37041;
continue;
} else {
var temp__4425__auto___37042 = cljs.core.seq.call(null,seq__37024_37030);
if(temp__4425__auto___37042){
var seq__37024_37043__$1 = temp__4425__auto___37042;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__37024_37043__$1)){
var c__17152__auto___37044 = cljs.core.chunk_first.call(null,seq__37024_37043__$1);
var G__37045 = cljs.core.chunk_rest.call(null,seq__37024_37043__$1);
var G__37046 = c__17152__auto___37044;
var G__37047 = cljs.core.count.call(null,c__17152__auto___37044);
var G__37048 = (0);
seq__37024_37030 = G__37045;
chunk__37025_37031 = G__37046;
count__37026_37032 = G__37047;
i__37027_37033 = G__37048;
continue;
} else {
var vec__37029_37049 = cljs.core.first.call(null,seq__37024_37043__$1);
var k_37050 = cljs.core.nth.call(null,vec__37029_37049,(0),null);
var v_37051 = cljs.core.nth.call(null,vec__37029_37049,(1),null);
var m37023_37052 = cljs.core.deref.call(null,m_atom__28896__auto__);
cljs.core.reset_BANG_.call(null,m_atom__28896__auto__,cljs.core.assoc_BANG_.call(null,m37023_37052,k_37050,f.call(null,v_37051)));

var G__37053 = cljs.core.next.call(null,seq__37024_37043__$1);
var G__37054 = null;
var G__37055 = (0);
var G__37056 = (0);
seq__37024_37030 = G__37053;
chunk__37025_37031 = G__37054;
count__37026_37032 = G__37055;
i__37027_37033 = G__37056;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__28896__auto__));

}
}
});
/**
 * Build map (f k) -> v for [k v] in map m
 */
plumbing.core.map_keys = (function plumbing$core$map_keys(f,m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc_BANG_.call(null,out_m,f.call(null,k),v);
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else {
var m_atom__28896__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__37065_37071 = cljs.core.seq.call(null,m);
var chunk__37066_37072 = null;
var count__37067_37073 = (0);
var i__37068_37074 = (0);
while(true){
if((i__37068_37074 < count__37067_37073)){
var vec__37069_37075 = cljs.core._nth.call(null,chunk__37066_37072,i__37068_37074);
var k_37076 = cljs.core.nth.call(null,vec__37069_37075,(0),null);
var v_37077 = cljs.core.nth.call(null,vec__37069_37075,(1),null);
var m37064_37078 = cljs.core.deref.call(null,m_atom__28896__auto__);
cljs.core.reset_BANG_.call(null,m_atom__28896__auto__,cljs.core.assoc_BANG_.call(null,m37064_37078,f.call(null,k_37076),v_37077));

var G__37079 = seq__37065_37071;
var G__37080 = chunk__37066_37072;
var G__37081 = count__37067_37073;
var G__37082 = (i__37068_37074 + (1));
seq__37065_37071 = G__37079;
chunk__37066_37072 = G__37080;
count__37067_37073 = G__37081;
i__37068_37074 = G__37082;
continue;
} else {
var temp__4425__auto___37083 = cljs.core.seq.call(null,seq__37065_37071);
if(temp__4425__auto___37083){
var seq__37065_37084__$1 = temp__4425__auto___37083;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__37065_37084__$1)){
var c__17152__auto___37085 = cljs.core.chunk_first.call(null,seq__37065_37084__$1);
var G__37086 = cljs.core.chunk_rest.call(null,seq__37065_37084__$1);
var G__37087 = c__17152__auto___37085;
var G__37088 = cljs.core.count.call(null,c__17152__auto___37085);
var G__37089 = (0);
seq__37065_37071 = G__37086;
chunk__37066_37072 = G__37087;
count__37067_37073 = G__37088;
i__37068_37074 = G__37089;
continue;
} else {
var vec__37070_37090 = cljs.core.first.call(null,seq__37065_37084__$1);
var k_37091 = cljs.core.nth.call(null,vec__37070_37090,(0),null);
var v_37092 = cljs.core.nth.call(null,vec__37070_37090,(1),null);
var m37064_37093 = cljs.core.deref.call(null,m_atom__28896__auto__);
cljs.core.reset_BANG_.call(null,m_atom__28896__auto__,cljs.core.assoc_BANG_.call(null,m37064_37093,f.call(null,k_37091),v_37092));

var G__37094 = cljs.core.next.call(null,seq__37065_37084__$1);
var G__37095 = null;
var G__37096 = (0);
var G__37097 = (0);
seq__37065_37071 = G__37094;
chunk__37066_37072 = G__37095;
count__37067_37073 = G__37096;
i__37068_37074 = G__37097;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__28896__auto__));
}
});
/**
 * Build map k -> (f k) for keys in ks
 */
plumbing.core.map_from_keys = (function plumbing$core$map_from_keys(f,ks){
var m_atom__28896__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__37104_37108 = cljs.core.seq.call(null,ks);
var chunk__37105_37109 = null;
var count__37106_37110 = (0);
var i__37107_37111 = (0);
while(true){
if((i__37107_37111 < count__37106_37110)){
var k_37112 = cljs.core._nth.call(null,chunk__37105_37109,i__37107_37111);
var m37103_37113 = cljs.core.deref.call(null,m_atom__28896__auto__);
cljs.core.reset_BANG_.call(null,m_atom__28896__auto__,cljs.core.assoc_BANG_.call(null,m37103_37113,k_37112,f.call(null,k_37112)));

var G__37114 = seq__37104_37108;
var G__37115 = chunk__37105_37109;
var G__37116 = count__37106_37110;
var G__37117 = (i__37107_37111 + (1));
seq__37104_37108 = G__37114;
chunk__37105_37109 = G__37115;
count__37106_37110 = G__37116;
i__37107_37111 = G__37117;
continue;
} else {
var temp__4425__auto___37118 = cljs.core.seq.call(null,seq__37104_37108);
if(temp__4425__auto___37118){
var seq__37104_37119__$1 = temp__4425__auto___37118;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__37104_37119__$1)){
var c__17152__auto___37120 = cljs.core.chunk_first.call(null,seq__37104_37119__$1);
var G__37121 = cljs.core.chunk_rest.call(null,seq__37104_37119__$1);
var G__37122 = c__17152__auto___37120;
var G__37123 = cljs.core.count.call(null,c__17152__auto___37120);
var G__37124 = (0);
seq__37104_37108 = G__37121;
chunk__37105_37109 = G__37122;
count__37106_37110 = G__37123;
i__37107_37111 = G__37124;
continue;
} else {
var k_37125 = cljs.core.first.call(null,seq__37104_37119__$1);
var m37103_37126 = cljs.core.deref.call(null,m_atom__28896__auto__);
cljs.core.reset_BANG_.call(null,m_atom__28896__auto__,cljs.core.assoc_BANG_.call(null,m37103_37126,k_37125,f.call(null,k_37125)));

var G__37127 = cljs.core.next.call(null,seq__37104_37119__$1);
var G__37128 = null;
var G__37129 = (0);
var G__37130 = (0);
seq__37104_37108 = G__37127;
chunk__37105_37109 = G__37128;
count__37106_37110 = G__37129;
i__37107_37111 = G__37130;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__28896__auto__));
});
/**
 * Build map (f v) -> v for vals in vs
 */
plumbing.core.map_from_vals = (function plumbing$core$map_from_vals(f,vs){
var m_atom__28896__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__37137_37141 = cljs.core.seq.call(null,vs);
var chunk__37138_37142 = null;
var count__37139_37143 = (0);
var i__37140_37144 = (0);
while(true){
if((i__37140_37144 < count__37139_37143)){
var v_37145 = cljs.core._nth.call(null,chunk__37138_37142,i__37140_37144);
var m37136_37146 = cljs.core.deref.call(null,m_atom__28896__auto__);
cljs.core.reset_BANG_.call(null,m_atom__28896__auto__,cljs.core.assoc_BANG_.call(null,m37136_37146,f.call(null,v_37145),v_37145));

var G__37147 = seq__37137_37141;
var G__37148 = chunk__37138_37142;
var G__37149 = count__37139_37143;
var G__37150 = (i__37140_37144 + (1));
seq__37137_37141 = G__37147;
chunk__37138_37142 = G__37148;
count__37139_37143 = G__37149;
i__37140_37144 = G__37150;
continue;
} else {
var temp__4425__auto___37151 = cljs.core.seq.call(null,seq__37137_37141);
if(temp__4425__auto___37151){
var seq__37137_37152__$1 = temp__4425__auto___37151;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__37137_37152__$1)){
var c__17152__auto___37153 = cljs.core.chunk_first.call(null,seq__37137_37152__$1);
var G__37154 = cljs.core.chunk_rest.call(null,seq__37137_37152__$1);
var G__37155 = c__17152__auto___37153;
var G__37156 = cljs.core.count.call(null,c__17152__auto___37153);
var G__37157 = (0);
seq__37137_37141 = G__37154;
chunk__37138_37142 = G__37155;
count__37139_37143 = G__37156;
i__37140_37144 = G__37157;
continue;
} else {
var v_37158 = cljs.core.first.call(null,seq__37137_37152__$1);
var m37136_37159 = cljs.core.deref.call(null,m_atom__28896__auto__);
cljs.core.reset_BANG_.call(null,m_atom__28896__auto__,cljs.core.assoc_BANG_.call(null,m37136_37159,f.call(null,v_37158),v_37158));

var G__37160 = cljs.core.next.call(null,seq__37137_37152__$1);
var G__37161 = null;
var G__37162 = (0);
var G__37163 = (0);
seq__37137_37141 = G__37160;
chunk__37138_37142 = G__37161;
count__37139_37143 = G__37162;
i__37140_37144 = G__37163;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__28896__auto__));
});
/**
 * Dissociate this keyseq from m, removing any empty maps created as a result
 * (including at the top-level).
 */
plumbing.core.dissoc_in = (function plumbing$core$dissoc_in(m,p__37164){
var vec__37166 = p__37164;
var k = cljs.core.nth.call(null,vec__37166,(0),null);
var ks = cljs.core.nthnext.call(null,vec__37166,(1));
if(cljs.core.truth_(m)){
var temp__4423__auto__ = (function (){var and__16337__auto__ = ks;
if(cljs.core.truth_(and__16337__auto__)){
return plumbing$core$dissoc_in.call(null,cljs.core.get.call(null,m,k),ks);
} else {
return and__16337__auto__;
}
})();
if(cljs.core.truth_(temp__4423__auto__)){
var res = temp__4423__auto__;
return cljs.core.assoc.call(null,m,k,res);
} else {
var res = cljs.core.dissoc.call(null,m,k);
if(cljs.core.empty_QMARK_.call(null,res)){
return null;
} else {
return res;
}
}
} else {
return null;
}
});
/**
 * Recursively convert maps in m (including itself)
 * to have keyword keys instead of string
 */
plumbing.core.keywordize_map = (function plumbing$core$keywordize_map(x){
if(cljs.core.map_QMARK_.call(null,x)){
var m_atom__28896__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__37175_37181 = cljs.core.seq.call(null,x);
var chunk__37176_37182 = null;
var count__37177_37183 = (0);
var i__37178_37184 = (0);
while(true){
if((i__37178_37184 < count__37177_37183)){
var vec__37179_37185 = cljs.core._nth.call(null,chunk__37176_37182,i__37178_37184);
var k_37186 = cljs.core.nth.call(null,vec__37179_37185,(0),null);
var v_37187 = cljs.core.nth.call(null,vec__37179_37185,(1),null);
var m37174_37188 = cljs.core.deref.call(null,m_atom__28896__auto__);
cljs.core.reset_BANG_.call(null,m_atom__28896__auto__,cljs.core.assoc_BANG_.call(null,m37174_37188,((typeof k_37186 === 'string')?cljs.core.keyword.call(null,k_37186):k_37186),plumbing$core$keywordize_map.call(null,v_37187)));

var G__37189 = seq__37175_37181;
var G__37190 = chunk__37176_37182;
var G__37191 = count__37177_37183;
var G__37192 = (i__37178_37184 + (1));
seq__37175_37181 = G__37189;
chunk__37176_37182 = G__37190;
count__37177_37183 = G__37191;
i__37178_37184 = G__37192;
continue;
} else {
var temp__4425__auto___37193 = cljs.core.seq.call(null,seq__37175_37181);
if(temp__4425__auto___37193){
var seq__37175_37194__$1 = temp__4425__auto___37193;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__37175_37194__$1)){
var c__17152__auto___37195 = cljs.core.chunk_first.call(null,seq__37175_37194__$1);
var G__37196 = cljs.core.chunk_rest.call(null,seq__37175_37194__$1);
var G__37197 = c__17152__auto___37195;
var G__37198 = cljs.core.count.call(null,c__17152__auto___37195);
var G__37199 = (0);
seq__37175_37181 = G__37196;
chunk__37176_37182 = G__37197;
count__37177_37183 = G__37198;
i__37178_37184 = G__37199;
continue;
} else {
var vec__37180_37200 = cljs.core.first.call(null,seq__37175_37194__$1);
var k_37201 = cljs.core.nth.call(null,vec__37180_37200,(0),null);
var v_37202 = cljs.core.nth.call(null,vec__37180_37200,(1),null);
var m37174_37203 = cljs.core.deref.call(null,m_atom__28896__auto__);
cljs.core.reset_BANG_.call(null,m_atom__28896__auto__,cljs.core.assoc_BANG_.call(null,m37174_37203,((typeof k_37201 === 'string')?cljs.core.keyword.call(null,k_37201):k_37201),plumbing$core$keywordize_map.call(null,v_37202)));

var G__37204 = cljs.core.next.call(null,seq__37175_37194__$1);
var G__37205 = null;
var G__37206 = (0);
var G__37207 = (0);
seq__37175_37181 = G__37204;
chunk__37176_37182 = G__37205;
count__37177_37183 = G__37206;
i__37178_37184 = G__37207;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__28896__auto__));
} else {
if(cljs.core.seq_QMARK_.call(null,x)){
return cljs.core.map.call(null,plumbing$core$keywordize_map,x);
} else {
if(cljs.core.vector_QMARK_.call(null,x)){
return cljs.core.mapv.call(null,plumbing$core$keywordize_map,x);
} else {
return x;

}
}
}
});
/**
 * Like get but throw an exception if not found
 */
plumbing.core.safe_get = (function plumbing$core$safe_get(m,k){
var temp__4423__auto__ = cljs.core.find.call(null,m,k);
if(cljs.core.truth_(temp__4423__auto__)){
var pair__28972__auto__ = temp__4423__auto__;
return cljs.core.val.call(null,pair__28972__auto__);
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.mapv.call(null,cljs.core.key,m))));

}
});
/**
 * Like get-in but throws exception if not found
 */
plumbing.core.safe_get_in = (function plumbing$core$safe_get_in(m,ks){
while(true){
if(cljs.core.seq.call(null,ks)){
var G__37208 = plumbing.core.safe_get.call(null,m,cljs.core.first.call(null,ks));
var G__37209 = cljs.core.next.call(null,ks);
m = G__37208;
ks = G__37209;
continue;
} else {
return m;
}
break;
}
});
/**
 * Like assoc but only assocs when value is truthy
 */
plumbing.core.assoc_when = (function plumbing$core$assoc_when(var_args){
var args__17414__auto__ = [];
var len__17407__auto___37220 = arguments.length;
var i__17408__auto___37221 = (0);
while(true){
if((i__17408__auto___37221 < len__17407__auto___37220)){
args__17414__auto__.push((arguments[i__17408__auto___37221]));

var G__37222 = (i__17408__auto___37221 + (1));
i__17408__auto___37221 = G__37222;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((1) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((1)),(0))):null);
return plumbing.core.assoc_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17415__auto__);
});

plumbing.core.assoc_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"even?","even?",-1827825394,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"kvs","kvs",-1695980277,null)))))].join('')));
}

return cljs.core.into.call(null,(function (){var or__16349__auto__ = m;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__17121__auto__ = (function plumbing$core$iter__37212(s__37213){
return (new cljs.core.LazySeq(null,(function (){
var s__37213__$1 = s__37213;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__37213__$1);
if(temp__4425__auto__){
var s__37213__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37213__$2)){
var c__17119__auto__ = cljs.core.chunk_first.call(null,s__37213__$2);
var size__17120__auto__ = cljs.core.count.call(null,c__17119__auto__);
var b__37215 = cljs.core.chunk_buffer.call(null,size__17120__auto__);
if((function (){var i__37214 = (0);
while(true){
if((i__37214 < size__17120__auto__)){
var vec__37218 = cljs.core._nth.call(null,c__17119__auto__,i__37214);
var k = cljs.core.nth.call(null,vec__37218,(0),null);
var v = cljs.core.nth.call(null,vec__37218,(1),null);
if(cljs.core.truth_(v)){
cljs.core.chunk_append.call(null,b__37215,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__37223 = (i__37214 + (1));
i__37214 = G__37223;
continue;
} else {
var G__37224 = (i__37214 + (1));
i__37214 = G__37224;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37215),plumbing$core$iter__37212.call(null,cljs.core.chunk_rest.call(null,s__37213__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37215),null);
}
} else {
var vec__37219 = cljs.core.first.call(null,s__37213__$2);
var k = cljs.core.nth.call(null,vec__37219,(0),null);
var v = cljs.core.nth.call(null,vec__37219,(1),null);
if(cljs.core.truth_(v)){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),plumbing$core$iter__37212.call(null,cljs.core.rest.call(null,s__37213__$2)));
} else {
var G__37225 = cljs.core.rest.call(null,s__37213__$2);
s__37213__$1 = G__37225;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__17121__auto__.call(null,cljs.core.partition.call(null,(2),kvs));
})());
});

plumbing.core.assoc_when.cljs$lang$maxFixedArity = (1);

plumbing.core.assoc_when.cljs$lang$applyTo = (function (seq37210){
var G__37211 = cljs.core.first.call(null,seq37210);
var seq37210__$1 = cljs.core.next.call(null,seq37210);
return plumbing.core.assoc_when.cljs$core$IFn$_invoke$arity$variadic(G__37211,seq37210__$1);
});
/**
 * Like update-in but returns m unchanged if key-seq is not present.
 */
plumbing.core.update_in_when = (function plumbing$core$update_in_when(var_args){
var args__17414__auto__ = [];
var len__17407__auto___37230 = arguments.length;
var i__17408__auto___37231 = (0);
while(true){
if((i__17408__auto___37231 < len__17407__auto___37230)){
args__17414__auto__.push((arguments[i__17408__auto___37231]));

var G__37232 = (i__17408__auto___37231 + (1));
i__17408__auto___37231 = G__37232;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((3) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((3)),(0))):null);
return plumbing.core.update_in_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__17415__auto__);
});

plumbing.core.update_in_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,key_seq,f,args){
var found = cljs.core.get_in.call(null,m,key_seq,plumbing.core._PLUS_none_PLUS_);
if(!((plumbing.core._PLUS_none_PLUS_ === found))){
return cljs.core.assoc_in.call(null,m,key_seq,cljs.core.apply.call(null,f,found,args));
} else {
return m;
}
});

plumbing.core.update_in_when.cljs$lang$maxFixedArity = (3);

plumbing.core.update_in_when.cljs$lang$applyTo = (function (seq37226){
var G__37227 = cljs.core.first.call(null,seq37226);
var seq37226__$1 = cljs.core.next.call(null,seq37226);
var G__37228 = cljs.core.first.call(null,seq37226__$1);
var seq37226__$2 = cljs.core.next.call(null,seq37226__$1);
var G__37229 = cljs.core.first.call(null,seq37226__$2);
var seq37226__$3 = cljs.core.next.call(null,seq37226__$2);
return plumbing.core.update_in_when.cljs$core$IFn$_invoke$arity$variadic(G__37227,G__37228,G__37229,seq37226__$3);
});
/**
 * Like group-by, but accepts a map-fn that is applied to values before
 * collected.
 */
plumbing.core.grouped_map = (function plumbing$core$grouped_map(key_fn,map_fn,coll){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (ret,x){
var k = key_fn.call(null,x);
return cljs.core.assoc_BANG_.call(null,ret,k,cljs.core.conj.call(null,cljs.core.get.call(null,ret,k,cljs.core.PersistentVector.EMPTY),map_fn.call(null,x)));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Like (apply concat s) but lazier (and shorter) 
 */
plumbing.core.aconcat = (function plumbing$core$aconcat(s){
return cljs.core.concat.call(null,(new cljs.core.LazySeq(null,(function (){
return cljs.core.first.call(null,s);
}),null,null)),(new cljs.core.LazySeq(null,(function (){
var temp__4425__auto__ = cljs.core.next.call(null,s);
if(temp__4425__auto__){
var n = temp__4425__auto__;
return plumbing$core$aconcat.call(null,n);
} else {
return null;
}
}),null,null)));
});
/**
 * Takes a seqable and returns a lazy sequence that
 * is maximally lazy and doesn't realize elements due to either
 * chunking or apply.
 * 
 * Useful when you don't want chunking, for instance,
 * (first awesome-website? (map slurp +a-bunch-of-urls+))
 * may slurp up to 31 unneed webpages, wherease
 * (first awesome-website? (map slurp (unchunk +a-bunch-of-urls+)))
 * is guaranteed to stop slurping after the first awesome website.
 * 
 *   Taken from http://stackoverflow.com/questions/3407876/how-do-i-avoid-clojures-chunking-behavior-for-lazy-seqs-that-i-want-to-short-ci
 */
plumbing.core.unchunk = (function plumbing$core$unchunk(s){
if(cljs.core.seq.call(null,s)){
return cljs.core.cons.call(null,cljs.core.first.call(null,s),(new cljs.core.LazySeq(null,(function (){
return plumbing$core$unchunk.call(null,cljs.core.rest.call(null,s));
}),null,null)));
} else {
return null;
}
});
/**
 * Return sum of (f x) for each x in xs
 */
plumbing.core.sum = (function plumbing$core$sum(var_args){
var args37233 = [];
var len__17407__auto___37236 = arguments.length;
var i__17408__auto___37237 = (0);
while(true){
if((i__17408__auto___37237 < len__17407__auto___37236)){
args37233.push((arguments[i__17408__auto___37237]));

var G__37238 = (i__17408__auto___37237 + (1));
i__17408__auto___37237 = G__37238;
continue;
} else {
}
break;
}

var G__37235 = args37233.length;
switch (G__37235) {
case 2:
return plumbing.core.sum.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return plumbing.core.sum.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37233.length)].join('')));

}
});

plumbing.core.sum.cljs$core$IFn$_invoke$arity$2 = (function (f,xs){
return cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,f,xs));
});

plumbing.core.sum.cljs$core$IFn$_invoke$arity$1 = (function (xs){
return cljs.core.reduce.call(null,cljs.core._PLUS_,xs);
});

plumbing.core.sum.cljs$lang$maxFixedArity = 2;
/**
 * returns (first xs) when xs has only 1 element
 */
plumbing.core.singleton = (function plumbing$core$singleton(xs){
var temp__4425__auto__ = cljs.core.seq.call(null,xs);
if(temp__4425__auto__){
var xs__$1 = temp__4425__auto__;
if(cljs.core.next.call(null,xs__$1)){
return null;
} else {
return cljs.core.first.call(null,xs__$1);
}
} else {
return null;
}
});
/**
 * Returns [idx x] for x in seqable s
 */
plumbing.core.indexed = (function plumbing$core$indexed(s){
return cljs.core.map_indexed.call(null,cljs.core.vector,s);
});
/**
 * Returns indices idx of sequence s where (f (nth s idx))
 */
plumbing.core.positions = (function plumbing$core$positions(f,s){
return cljs.core.keep_indexed.call(null,(function (i,x){
if(cljs.core.truth_(f.call(null,x))){
return i;
} else {
return null;
}
}),s);
});
/**
 * Returns elements of xs which return unique
 * values according to f. If multiple elements of xs return the same
 * value under f, the first is returned
 */
plumbing.core.distinct_by = (function plumbing$core$distinct_by(f,xs){
var s = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var iter__17121__auto__ = ((function (s){
return (function plumbing$core$distinct_by_$_iter__37244(s__37245){
return (new cljs.core.LazySeq(null,((function (s){
return (function (){
var s__37245__$1 = s__37245;
while(true){
var temp__4425__auto__ = cljs.core.seq.call(null,s__37245__$1);
if(temp__4425__auto__){
var s__37245__$2 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37245__$2)){
var c__17119__auto__ = cljs.core.chunk_first.call(null,s__37245__$2);
var size__17120__auto__ = cljs.core.count.call(null,c__17119__auto__);
var b__37247 = cljs.core.chunk_buffer.call(null,size__17120__auto__);
if((function (){var i__37246 = (0);
while(true){
if((i__37246 < size__17120__auto__)){
var x = cljs.core._nth.call(null,c__17119__auto__,i__37246);
var id = f.call(null,x);
if(!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id))){
cljs.core.chunk_append.call(null,b__37247,(function (){
cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);

return x;
})()
);

var G__37248 = (i__37246 + (1));
i__37246 = G__37248;
continue;
} else {
var G__37249 = (i__37246 + (1));
i__37246 = G__37249;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37247),plumbing$core$distinct_by_$_iter__37244.call(null,cljs.core.chunk_rest.call(null,s__37245__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37247),null);
}
} else {
var x = cljs.core.first.call(null,s__37245__$2);
var id = f.call(null,x);
if(!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id))){
return cljs.core.cons.call(null,(function (){
cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);

return x;
})()
,plumbing$core$distinct_by_$_iter__37244.call(null,cljs.core.rest.call(null,s__37245__$2)));
} else {
var G__37250 = cljs.core.rest.call(null,s__37245__$2);
s__37245__$1 = G__37250;
continue;
}
}
} else {
return null;
}
break;
}
});})(s))
,null,null));
});})(s))
;
return iter__17121__auto__.call(null,xs);
});
/**
 * Analogy: partition:partition-all :: interleave:interleave-all
 */
plumbing.core.interleave_all = (function plumbing$core$interleave_all(var_args){
var args__17414__auto__ = [];
var len__17407__auto___37252 = arguments.length;
var i__17408__auto___37253 = (0);
while(true){
if((i__17408__auto___37253 < len__17407__auto___37252)){
args__17414__auto__.push((arguments[i__17408__auto___37253]));

var G__37254 = (i__17408__auto___37253 + (1));
i__17408__auto___37253 = G__37254;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((0) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((0)),(0))):null);
return plumbing.core.interleave_all.cljs$core$IFn$_invoke$arity$variadic(argseq__17415__auto__);
});

plumbing.core.interleave_all.cljs$core$IFn$_invoke$arity$variadic = (function (colls){
return (new cljs.core.LazySeq(null,(function (){
return (function plumbing$core$helper(seqs){
if(cljs.core.seq.call(null,seqs)){
return cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.first,seqs),(new cljs.core.LazySeq(null,(function (){
return plumbing$core$helper.call(null,cljs.core.keep.call(null,cljs.core.next,seqs));
}),null,null)));
} else {
return null;
}
}).call(null,cljs.core.keep.call(null,cljs.core.seq,colls));
}),null,null));
});

plumbing.core.interleave_all.cljs$lang$maxFixedArity = (0);

plumbing.core.interleave_all.cljs$lang$applyTo = (function (seq37251){
return plumbing.core.interleave_all.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37251));
});
/**
 * Returns # of elements of xs where pred holds
 */
plumbing.core.count_when = (function plumbing$core$count_when(pred,xs){
return cljs.core.count.call(null,cljs.core.filter.call(null,pred,xs));
});
/**
 * Like conj but ignores non-truthy values
 */
plumbing.core.conj_when = (function plumbing$core$conj_when(var_args){
var args37255 = [];
var len__17407__auto___37261 = arguments.length;
var i__17408__auto___37262 = (0);
while(true){
if((i__17408__auto___37262 < len__17407__auto___37261)){
args37255.push((arguments[i__17408__auto___37262]));

var G__37263 = (i__17408__auto___37262 + (1));
i__17408__auto___37262 = G__37263;
continue;
} else {
}
break;
}

var G__37260 = args37255.length;
switch (G__37260) {
case 2:
return plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args37255.slice((2)),(0)));
return plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17426__auto__);

}
});

plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if(cljs.core.truth_(x)){
return cljs.core.conj.call(null,coll,x);
} else {
return coll;
}
});

plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__37265 = plumbing.core.conj_when.call(null,coll,x);
var G__37266 = cljs.core.first.call(null,xs);
var G__37267 = cljs.core.next.call(null,xs);
coll = G__37265;
x = G__37266;
xs = G__37267;
continue;
} else {
return plumbing.core.conj_when.call(null,coll,x);
}
break;
}
});

plumbing.core.conj_when.cljs$lang$applyTo = (function (seq37256){
var G__37257 = cljs.core.first.call(null,seq37256);
var seq37256__$1 = cljs.core.next.call(null,seq37256);
var G__37258 = cljs.core.first.call(null,seq37256__$1);
var seq37256__$2 = cljs.core.next.call(null,seq37256__$1);
return plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$variadic(G__37257,G__37258,seq37256__$2);
});

plumbing.core.conj_when.cljs$lang$maxFixedArity = (2);
/**
 * Like cons but does nothing if x is non-truthy.
 */
plumbing.core.cons_when = (function plumbing$core$cons_when(x,s){
if(cljs.core.truth_(x)){
return cljs.core.cons.call(null,x,s);
} else {
return s;
}
});
/**
 * Like sort-by, but prefers higher values rather than lower ones.
 */
plumbing.core.rsort_by = cljs.core.comp.call(null,cljs.core.reverse,cljs.core.sort_by);
/**
 * Like swap! but returns a pair [old-val new-val]
 */
plumbing.core.swap_pair_BANG_ = (function plumbing$core$swap_pair_BANG_(var_args){
var args37269 = [];
var len__17407__auto___37275 = arguments.length;
var i__17408__auto___37276 = (0);
while(true){
if((i__17408__auto___37276 < len__17407__auto___37275)){
args37269.push((arguments[i__17408__auto___37276]));

var G__37277 = (i__17408__auto___37276 + (1));
i__17408__auto___37276 = G__37277;
continue;
} else {
}
break;
}

var G__37274 = args37269.length;
switch (G__37274) {
case 2:
return plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args37269.slice((2)),(0)));
return plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17426__auto__);

}
});

plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
while(true){
var old_val = cljs.core.deref.call(null,a);
var new_val = f.call(null,old_val);
if(cljs.core.truth_(cljs.core.compare_and_set_BANG_.call(null,a,old_val,new_val))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_val,new_val], null);
} else {
continue;
}
break;
}
});

plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,args){
return plumbing.core.swap_pair_BANG_.call(null,a,(function (p1__37268_SHARP_){
return cljs.core.apply.call(null,f,p1__37268_SHARP_,args);
}));
});

plumbing.core.swap_pair_BANG_.cljs$lang$applyTo = (function (seq37270){
var G__37271 = cljs.core.first.call(null,seq37270);
var seq37270__$1 = cljs.core.next.call(null,seq37270);
var G__37272 = cljs.core.first.call(null,seq37270__$1);
var seq37270__$2 = cljs.core.next.call(null,seq37270__$1);
return plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__37271,G__37272,seq37270__$2);
});

plumbing.core.swap_pair_BANG_.cljs$lang$maxFixedArity = (2);
/**
 * Like reset! but returns old-val
 */
plumbing.core.get_and_set_BANG_ = (function plumbing$core$get_and_set_BANG_(a,new_val){
return cljs.core.first.call(null,plumbing.core.swap_pair_BANG_.call(null,a,cljs.core.constantly.call(null,new_val)));
});
plumbing.core.millis = (function plumbing$core$millis(){
return (new Date()).getTime();
});
/**
 * Like apply, but applies a map to a function with positional map
 *   arguments. Can take optional initial args just like apply.
 */
plumbing.core.mapply = (function plumbing$core$mapply(var_args){
var args37279 = [];
var len__17407__auto___37285 = arguments.length;
var i__17408__auto___37286 = (0);
while(true){
if((i__17408__auto___37286 < len__17407__auto___37285)){
args37279.push((arguments[i__17408__auto___37286]));

var G__37287 = (i__17408__auto___37286 + (1));
i__17408__auto___37286 = G__37287;
continue;
} else {
}
break;
}

var G__37284 = args37279.length;
switch (G__37284) {
case 2:
return plumbing.core.mapply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args37279.slice((2)),(0)));
return plumbing.core.mapply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__17426__auto__);

}
});

plumbing.core.mapply.cljs$core$IFn$_invoke$arity$2 = (function (f,m){
return cljs.core.apply.call(null,f,cljs.core.apply.call(null,cljs.core.concat,m));
});

plumbing.core.mapply.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg,args){
return cljs.core.apply.call(null,f,arg,cljs.core.concat.call(null,cljs.core.butlast.call(null,args),cljs.core.apply.call(null,cljs.core.concat,cljs.core.last.call(null,args))));
});

plumbing.core.mapply.cljs$lang$applyTo = (function (seq37280){
var G__37281 = cljs.core.first.call(null,seq37280);
var seq37280__$1 = cljs.core.next.call(null,seq37280);
var G__37282 = cljs.core.first.call(null,seq37280__$1);
var seq37280__$2 = cljs.core.next.call(null,seq37280__$1);
return plumbing.core.mapply.cljs$core$IFn$_invoke$arity$variadic(G__37281,G__37282,seq37280__$2);
});

plumbing.core.mapply.cljs$lang$maxFixedArity = (2);

//# sourceMappingURL=core.js.map?rel=1449783509612