// Compiled by ClojureScript 1.7.122 {}
goog.provide('om_tools.dom');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('om.dom');
/**
 * Converts kebab-case to camelCase
 */
om_tools.dom.camel_case = (function om_tools$dom$camel_case(s){
return clojure.string.replace.call(null,s,/-(\w)/,cljs.core.comp.call(null,clojure.string.upper_case,cljs.core.second));
});
/**
 * Converts attributes that are kebab-case and should be camelCase
 */
om_tools.dom.opt_key_case = (function om_tools$dom$opt_key_case(attr){
if(cljs.core.truth_((function (){var or__16349__auto__ = (cljs.core.count.call(null,attr) < (5));
if(or__16349__auto__){
return or__16349__auto__;
} else {
var G__34611 = cljs.core.subs.call(null,attr,(0),(5));
switch (G__34611) {
case "data-":
case "aria-":
return true;

break;
default:
return false;

}
}
})())){
return attr;
} else {
return om_tools.dom.camel_case.call(null,attr);
}
});
/**
 * Converts aliased attributes
 */
om_tools.dom.opt_key_alias = (function om_tools$dom$opt_key_alias(opt){
var G__34614 = (((opt instanceof cljs.core.Keyword))?opt.fqn:null);
switch (G__34614) {
case "class":
return new cljs.core.Keyword(null,"className","className",-1983287057);

break;
case "for":
return new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720);

break;
default:
return opt;

}
});
/**
 * Returns potentially formatted name for DOM element attribute.
 * Converts kebab-case to camelCase.
 */
om_tools.dom.format_opt_key = (function om_tools$dom$format_opt_key(opt_key){
return cljs.core.keyword.call(null,om_tools.dom.opt_key_case.call(null,cljs.core.name.call(null,om_tools.dom.opt_key_alias.call(null,opt_key))));
});
om_tools.dom.format_opts;
/**
 * Returns potentially modified value for DOM element attribute.
 * Recursively formats map values (ie :style attribute)
 */
om_tools.dom.format_opt_val = (function om_tools$dom$format_opt_val(opt_val){
if(cljs.core.map_QMARK_.call(null,opt_val)){
return om_tools.dom.format_opts.call(null,opt_val);
} else {
return opt_val;

}
});
/**
 * Returns JavaScript object for React DOM attributes from opts map
 */
om_tools.dom.format_opts = (function om_tools$dom$format_opts(opts){
if(cljs.core.map_QMARK_.call(null,opts)){
return cljs.core.clj__GT_js.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__34618){
var vec__34619 = p__34618;
var k = cljs.core.nth.call(null,vec__34619,(0),null);
var v = cljs.core.nth.call(null,vec__34619,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_tools.dom.format_opt_key.call(null,k),om_tools.dom.format_opt_val.call(null,v)], null);
}),opts)));
} else {
return opts;
}
});
om_tools.dom.possible_coll_QMARK_ = (function om_tools$dom$possible_coll_QMARK_(form){
return (cljs.core.coll_QMARK_.call(null,form)) || ((form instanceof cljs.core.Symbol)) || (cljs.core.list_QMARK_.call(null,form));
});
om_tools.dom.valid_element_QMARK_ = (function om_tools$dom$valid_element_QMARK_(x){
return (function (){var or__16349__auto__ = React.isValidElement;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return React.isValidComponent;
}
})().call(null,x);
});
om_tools.dom.js_opts_QMARK_ = (function om_tools$dom$js_opts_QMARK_(x){
return (cljs.core.object_QMARK_.call(null,x)) && (!(om_tools.dom.valid_element_QMARK_.call(null,x)));
});
/**
 * Returns a vector of [opts children] for from first and second
 *   argument given to DOM function
 */
om_tools.dom.element_args = (function om_tools$dom$element_args(opts,children){
if((opts == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,children], null);
} else {
if(cljs.core.map_QMARK_.call(null,opts)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [om_tools.dom.format_opts.call(null,opts),children], null);
} else {
if(cljs.core.truth_(om_tools.dom.js_opts_QMARK_.call(null,opts))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [opts,children], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.cons.call(null,opts,children)], null);

}
}
}
});
om_tools.dom.element = (function om_tools$dom$element(ctor,opts,children){
var vec__34621 = om_tools.dom.element_args.call(null,opts,children);
var opts__$1 = cljs.core.nth.call(null,vec__34621,(0),null);
var children__$1 = cljs.core.nth.call(null,vec__34621,(1),null);
return cljs.core.apply.call(null,ctor,cljs.core.flatten.call(null,cljs.core.cons.call(null,opts__$1,children__$1)));
});
om_tools.dom.a = (function om_tools$dom$a(var_args){
var args34622 = [];
var len__17407__auto___35247 = arguments.length;
var i__17408__auto___35248 = (0);
while(true){
if((i__17408__auto___35248 < len__17407__auto___35247)){
args34622.push((arguments[i__17408__auto___35248]));

var G__35249 = (i__17408__auto___35248 + (1));
i__17408__auto___35248 = G__35249;
continue;
} else {
}
break;
}

var G__34626 = args34622.length;
switch (G__34626) {
case 0:
return om_tools.dom.a.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34622.slice((1)),(0)));
return om_tools.dom.a.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.a.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.a,null,null);
});

om_tools.dom.a.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.a,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.a.cljs$lang$applyTo = (function (seq34623){
var G__34624 = cljs.core.first.call(null,seq34623);
var seq34623__$1 = cljs.core.next.call(null,seq34623);
return om_tools.dom.a.cljs$core$IFn$_invoke$arity$variadic(G__34624,seq34623__$1);
});

om_tools.dom.a.cljs$lang$maxFixedArity = (1);

om_tools.dom.abbr = (function om_tools$dom$abbr(var_args){
var args34627 = [];
var len__17407__auto___35251 = arguments.length;
var i__17408__auto___35252 = (0);
while(true){
if((i__17408__auto___35252 < len__17407__auto___35251)){
args34627.push((arguments[i__17408__auto___35252]));

var G__35253 = (i__17408__auto___35252 + (1));
i__17408__auto___35252 = G__35253;
continue;
} else {
}
break;
}

var G__34631 = args34627.length;
switch (G__34631) {
case 0:
return om_tools.dom.abbr.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34627.slice((1)),(0)));
return om_tools.dom.abbr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.abbr.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.abbr,null,null);
});

om_tools.dom.abbr.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.abbr,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.abbr.cljs$lang$applyTo = (function (seq34628){
var G__34629 = cljs.core.first.call(null,seq34628);
var seq34628__$1 = cljs.core.next.call(null,seq34628);
return om_tools.dom.abbr.cljs$core$IFn$_invoke$arity$variadic(G__34629,seq34628__$1);
});

om_tools.dom.abbr.cljs$lang$maxFixedArity = (1);

om_tools.dom.address = (function om_tools$dom$address(var_args){
var args34632 = [];
var len__17407__auto___35255 = arguments.length;
var i__17408__auto___35256 = (0);
while(true){
if((i__17408__auto___35256 < len__17407__auto___35255)){
args34632.push((arguments[i__17408__auto___35256]));

var G__35257 = (i__17408__auto___35256 + (1));
i__17408__auto___35256 = G__35257;
continue;
} else {
}
break;
}

var G__34636 = args34632.length;
switch (G__34636) {
case 0:
return om_tools.dom.address.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34632.slice((1)),(0)));
return om_tools.dom.address.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.address.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.address,null,null);
});

om_tools.dom.address.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.address,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.address.cljs$lang$applyTo = (function (seq34633){
var G__34634 = cljs.core.first.call(null,seq34633);
var seq34633__$1 = cljs.core.next.call(null,seq34633);
return om_tools.dom.address.cljs$core$IFn$_invoke$arity$variadic(G__34634,seq34633__$1);
});

om_tools.dom.address.cljs$lang$maxFixedArity = (1);

om_tools.dom.area = (function om_tools$dom$area(var_args){
var args34637 = [];
var len__17407__auto___35259 = arguments.length;
var i__17408__auto___35260 = (0);
while(true){
if((i__17408__auto___35260 < len__17407__auto___35259)){
args34637.push((arguments[i__17408__auto___35260]));

var G__35261 = (i__17408__auto___35260 + (1));
i__17408__auto___35260 = G__35261;
continue;
} else {
}
break;
}

var G__34641 = args34637.length;
switch (G__34641) {
case 0:
return om_tools.dom.area.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34637.slice((1)),(0)));
return om_tools.dom.area.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.area.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.area,null,null);
});

om_tools.dom.area.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.area,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.area.cljs$lang$applyTo = (function (seq34638){
var G__34639 = cljs.core.first.call(null,seq34638);
var seq34638__$1 = cljs.core.next.call(null,seq34638);
return om_tools.dom.area.cljs$core$IFn$_invoke$arity$variadic(G__34639,seq34638__$1);
});

om_tools.dom.area.cljs$lang$maxFixedArity = (1);

om_tools.dom.article = (function om_tools$dom$article(var_args){
var args34642 = [];
var len__17407__auto___35263 = arguments.length;
var i__17408__auto___35264 = (0);
while(true){
if((i__17408__auto___35264 < len__17407__auto___35263)){
args34642.push((arguments[i__17408__auto___35264]));

var G__35265 = (i__17408__auto___35264 + (1));
i__17408__auto___35264 = G__35265;
continue;
} else {
}
break;
}

var G__34646 = args34642.length;
switch (G__34646) {
case 0:
return om_tools.dom.article.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34642.slice((1)),(0)));
return om_tools.dom.article.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.article.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.article,null,null);
});

om_tools.dom.article.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.article,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.article.cljs$lang$applyTo = (function (seq34643){
var G__34644 = cljs.core.first.call(null,seq34643);
var seq34643__$1 = cljs.core.next.call(null,seq34643);
return om_tools.dom.article.cljs$core$IFn$_invoke$arity$variadic(G__34644,seq34643__$1);
});

om_tools.dom.article.cljs$lang$maxFixedArity = (1);

om_tools.dom.aside = (function om_tools$dom$aside(var_args){
var args34647 = [];
var len__17407__auto___35267 = arguments.length;
var i__17408__auto___35268 = (0);
while(true){
if((i__17408__auto___35268 < len__17407__auto___35267)){
args34647.push((arguments[i__17408__auto___35268]));

var G__35269 = (i__17408__auto___35268 + (1));
i__17408__auto___35268 = G__35269;
continue;
} else {
}
break;
}

var G__34651 = args34647.length;
switch (G__34651) {
case 0:
return om_tools.dom.aside.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34647.slice((1)),(0)));
return om_tools.dom.aside.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.aside.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.aside,null,null);
});

om_tools.dom.aside.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.aside,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.aside.cljs$lang$applyTo = (function (seq34648){
var G__34649 = cljs.core.first.call(null,seq34648);
var seq34648__$1 = cljs.core.next.call(null,seq34648);
return om_tools.dom.aside.cljs$core$IFn$_invoke$arity$variadic(G__34649,seq34648__$1);
});

om_tools.dom.aside.cljs$lang$maxFixedArity = (1);

om_tools.dom.audio = (function om_tools$dom$audio(var_args){
var args34652 = [];
var len__17407__auto___35271 = arguments.length;
var i__17408__auto___35272 = (0);
while(true){
if((i__17408__auto___35272 < len__17407__auto___35271)){
args34652.push((arguments[i__17408__auto___35272]));

var G__35273 = (i__17408__auto___35272 + (1));
i__17408__auto___35272 = G__35273;
continue;
} else {
}
break;
}

var G__34656 = args34652.length;
switch (G__34656) {
case 0:
return om_tools.dom.audio.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34652.slice((1)),(0)));
return om_tools.dom.audio.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.audio.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.audio,null,null);
});

om_tools.dom.audio.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.audio,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.audio.cljs$lang$applyTo = (function (seq34653){
var G__34654 = cljs.core.first.call(null,seq34653);
var seq34653__$1 = cljs.core.next.call(null,seq34653);
return om_tools.dom.audio.cljs$core$IFn$_invoke$arity$variadic(G__34654,seq34653__$1);
});

om_tools.dom.audio.cljs$lang$maxFixedArity = (1);

om_tools.dom.b = (function om_tools$dom$b(var_args){
var args34657 = [];
var len__17407__auto___35275 = arguments.length;
var i__17408__auto___35276 = (0);
while(true){
if((i__17408__auto___35276 < len__17407__auto___35275)){
args34657.push((arguments[i__17408__auto___35276]));

var G__35277 = (i__17408__auto___35276 + (1));
i__17408__auto___35276 = G__35277;
continue;
} else {
}
break;
}

var G__34661 = args34657.length;
switch (G__34661) {
case 0:
return om_tools.dom.b.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34657.slice((1)),(0)));
return om_tools.dom.b.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.b.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.b,null,null);
});

om_tools.dom.b.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.b,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.b.cljs$lang$applyTo = (function (seq34658){
var G__34659 = cljs.core.first.call(null,seq34658);
var seq34658__$1 = cljs.core.next.call(null,seq34658);
return om_tools.dom.b.cljs$core$IFn$_invoke$arity$variadic(G__34659,seq34658__$1);
});

om_tools.dom.b.cljs$lang$maxFixedArity = (1);

om_tools.dom.base = (function om_tools$dom$base(var_args){
var args34662 = [];
var len__17407__auto___35279 = arguments.length;
var i__17408__auto___35280 = (0);
while(true){
if((i__17408__auto___35280 < len__17407__auto___35279)){
args34662.push((arguments[i__17408__auto___35280]));

var G__35281 = (i__17408__auto___35280 + (1));
i__17408__auto___35280 = G__35281;
continue;
} else {
}
break;
}

var G__34666 = args34662.length;
switch (G__34666) {
case 0:
return om_tools.dom.base.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34662.slice((1)),(0)));
return om_tools.dom.base.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.base.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.base,null,null);
});

om_tools.dom.base.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.base,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.base.cljs$lang$applyTo = (function (seq34663){
var G__34664 = cljs.core.first.call(null,seq34663);
var seq34663__$1 = cljs.core.next.call(null,seq34663);
return om_tools.dom.base.cljs$core$IFn$_invoke$arity$variadic(G__34664,seq34663__$1);
});

om_tools.dom.base.cljs$lang$maxFixedArity = (1);

om_tools.dom.bdi = (function om_tools$dom$bdi(var_args){
var args34667 = [];
var len__17407__auto___35283 = arguments.length;
var i__17408__auto___35284 = (0);
while(true){
if((i__17408__auto___35284 < len__17407__auto___35283)){
args34667.push((arguments[i__17408__auto___35284]));

var G__35285 = (i__17408__auto___35284 + (1));
i__17408__auto___35284 = G__35285;
continue;
} else {
}
break;
}

var G__34671 = args34667.length;
switch (G__34671) {
case 0:
return om_tools.dom.bdi.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34667.slice((1)),(0)));
return om_tools.dom.bdi.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.bdi.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.bdi,null,null);
});

om_tools.dom.bdi.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.bdi,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.bdi.cljs$lang$applyTo = (function (seq34668){
var G__34669 = cljs.core.first.call(null,seq34668);
var seq34668__$1 = cljs.core.next.call(null,seq34668);
return om_tools.dom.bdi.cljs$core$IFn$_invoke$arity$variadic(G__34669,seq34668__$1);
});

om_tools.dom.bdi.cljs$lang$maxFixedArity = (1);

om_tools.dom.bdo = (function om_tools$dom$bdo(var_args){
var args34672 = [];
var len__17407__auto___35287 = arguments.length;
var i__17408__auto___35288 = (0);
while(true){
if((i__17408__auto___35288 < len__17407__auto___35287)){
args34672.push((arguments[i__17408__auto___35288]));

var G__35289 = (i__17408__auto___35288 + (1));
i__17408__auto___35288 = G__35289;
continue;
} else {
}
break;
}

var G__34676 = args34672.length;
switch (G__34676) {
case 0:
return om_tools.dom.bdo.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34672.slice((1)),(0)));
return om_tools.dom.bdo.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.bdo.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.bdo,null,null);
});

om_tools.dom.bdo.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.bdo,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.bdo.cljs$lang$applyTo = (function (seq34673){
var G__34674 = cljs.core.first.call(null,seq34673);
var seq34673__$1 = cljs.core.next.call(null,seq34673);
return om_tools.dom.bdo.cljs$core$IFn$_invoke$arity$variadic(G__34674,seq34673__$1);
});

om_tools.dom.bdo.cljs$lang$maxFixedArity = (1);

om_tools.dom.big = (function om_tools$dom$big(var_args){
var args34677 = [];
var len__17407__auto___35291 = arguments.length;
var i__17408__auto___35292 = (0);
while(true){
if((i__17408__auto___35292 < len__17407__auto___35291)){
args34677.push((arguments[i__17408__auto___35292]));

var G__35293 = (i__17408__auto___35292 + (1));
i__17408__auto___35292 = G__35293;
continue;
} else {
}
break;
}

var G__34681 = args34677.length;
switch (G__34681) {
case 0:
return om_tools.dom.big.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34677.slice((1)),(0)));
return om_tools.dom.big.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.big.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.big,null,null);
});

om_tools.dom.big.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.big,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.big.cljs$lang$applyTo = (function (seq34678){
var G__34679 = cljs.core.first.call(null,seq34678);
var seq34678__$1 = cljs.core.next.call(null,seq34678);
return om_tools.dom.big.cljs$core$IFn$_invoke$arity$variadic(G__34679,seq34678__$1);
});

om_tools.dom.big.cljs$lang$maxFixedArity = (1);

om_tools.dom.blockquote = (function om_tools$dom$blockquote(var_args){
var args34682 = [];
var len__17407__auto___35295 = arguments.length;
var i__17408__auto___35296 = (0);
while(true){
if((i__17408__auto___35296 < len__17407__auto___35295)){
args34682.push((arguments[i__17408__auto___35296]));

var G__35297 = (i__17408__auto___35296 + (1));
i__17408__auto___35296 = G__35297;
continue;
} else {
}
break;
}

var G__34686 = args34682.length;
switch (G__34686) {
case 0:
return om_tools.dom.blockquote.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34682.slice((1)),(0)));
return om_tools.dom.blockquote.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.blockquote.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.blockquote,null,null);
});

om_tools.dom.blockquote.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.blockquote,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.blockquote.cljs$lang$applyTo = (function (seq34683){
var G__34684 = cljs.core.first.call(null,seq34683);
var seq34683__$1 = cljs.core.next.call(null,seq34683);
return om_tools.dom.blockquote.cljs$core$IFn$_invoke$arity$variadic(G__34684,seq34683__$1);
});

om_tools.dom.blockquote.cljs$lang$maxFixedArity = (1);

om_tools.dom.body = (function om_tools$dom$body(var_args){
var args34687 = [];
var len__17407__auto___35299 = arguments.length;
var i__17408__auto___35300 = (0);
while(true){
if((i__17408__auto___35300 < len__17407__auto___35299)){
args34687.push((arguments[i__17408__auto___35300]));

var G__35301 = (i__17408__auto___35300 + (1));
i__17408__auto___35300 = G__35301;
continue;
} else {
}
break;
}

var G__34691 = args34687.length;
switch (G__34691) {
case 0:
return om_tools.dom.body.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34687.slice((1)),(0)));
return om_tools.dom.body.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.body.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.body,null,null);
});

om_tools.dom.body.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.body,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.body.cljs$lang$applyTo = (function (seq34688){
var G__34689 = cljs.core.first.call(null,seq34688);
var seq34688__$1 = cljs.core.next.call(null,seq34688);
return om_tools.dom.body.cljs$core$IFn$_invoke$arity$variadic(G__34689,seq34688__$1);
});

om_tools.dom.body.cljs$lang$maxFixedArity = (1);

om_tools.dom.br = (function om_tools$dom$br(var_args){
var args34692 = [];
var len__17407__auto___35303 = arguments.length;
var i__17408__auto___35304 = (0);
while(true){
if((i__17408__auto___35304 < len__17407__auto___35303)){
args34692.push((arguments[i__17408__auto___35304]));

var G__35305 = (i__17408__auto___35304 + (1));
i__17408__auto___35304 = G__35305;
continue;
} else {
}
break;
}

var G__34696 = args34692.length;
switch (G__34696) {
case 0:
return om_tools.dom.br.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34692.slice((1)),(0)));
return om_tools.dom.br.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.br.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.br,null,null);
});

om_tools.dom.br.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.br,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.br.cljs$lang$applyTo = (function (seq34693){
var G__34694 = cljs.core.first.call(null,seq34693);
var seq34693__$1 = cljs.core.next.call(null,seq34693);
return om_tools.dom.br.cljs$core$IFn$_invoke$arity$variadic(G__34694,seq34693__$1);
});

om_tools.dom.br.cljs$lang$maxFixedArity = (1);

om_tools.dom.button = (function om_tools$dom$button(var_args){
var args34697 = [];
var len__17407__auto___35307 = arguments.length;
var i__17408__auto___35308 = (0);
while(true){
if((i__17408__auto___35308 < len__17407__auto___35307)){
args34697.push((arguments[i__17408__auto___35308]));

var G__35309 = (i__17408__auto___35308 + (1));
i__17408__auto___35308 = G__35309;
continue;
} else {
}
break;
}

var G__34701 = args34697.length;
switch (G__34701) {
case 0:
return om_tools.dom.button.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34697.slice((1)),(0)));
return om_tools.dom.button.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.button.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.button,null,null);
});

om_tools.dom.button.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.button,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.button.cljs$lang$applyTo = (function (seq34698){
var G__34699 = cljs.core.first.call(null,seq34698);
var seq34698__$1 = cljs.core.next.call(null,seq34698);
return om_tools.dom.button.cljs$core$IFn$_invoke$arity$variadic(G__34699,seq34698__$1);
});

om_tools.dom.button.cljs$lang$maxFixedArity = (1);

om_tools.dom.canvas = (function om_tools$dom$canvas(var_args){
var args34702 = [];
var len__17407__auto___35311 = arguments.length;
var i__17408__auto___35312 = (0);
while(true){
if((i__17408__auto___35312 < len__17407__auto___35311)){
args34702.push((arguments[i__17408__auto___35312]));

var G__35313 = (i__17408__auto___35312 + (1));
i__17408__auto___35312 = G__35313;
continue;
} else {
}
break;
}

var G__34706 = args34702.length;
switch (G__34706) {
case 0:
return om_tools.dom.canvas.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34702.slice((1)),(0)));
return om_tools.dom.canvas.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.canvas.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.canvas,null,null);
});

om_tools.dom.canvas.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.canvas,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.canvas.cljs$lang$applyTo = (function (seq34703){
var G__34704 = cljs.core.first.call(null,seq34703);
var seq34703__$1 = cljs.core.next.call(null,seq34703);
return om_tools.dom.canvas.cljs$core$IFn$_invoke$arity$variadic(G__34704,seq34703__$1);
});

om_tools.dom.canvas.cljs$lang$maxFixedArity = (1);

om_tools.dom.caption = (function om_tools$dom$caption(var_args){
var args34707 = [];
var len__17407__auto___35315 = arguments.length;
var i__17408__auto___35316 = (0);
while(true){
if((i__17408__auto___35316 < len__17407__auto___35315)){
args34707.push((arguments[i__17408__auto___35316]));

var G__35317 = (i__17408__auto___35316 + (1));
i__17408__auto___35316 = G__35317;
continue;
} else {
}
break;
}

var G__34711 = args34707.length;
switch (G__34711) {
case 0:
return om_tools.dom.caption.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34707.slice((1)),(0)));
return om_tools.dom.caption.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.caption.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.caption,null,null);
});

om_tools.dom.caption.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.caption,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.caption.cljs$lang$applyTo = (function (seq34708){
var G__34709 = cljs.core.first.call(null,seq34708);
var seq34708__$1 = cljs.core.next.call(null,seq34708);
return om_tools.dom.caption.cljs$core$IFn$_invoke$arity$variadic(G__34709,seq34708__$1);
});

om_tools.dom.caption.cljs$lang$maxFixedArity = (1);

om_tools.dom.cite = (function om_tools$dom$cite(var_args){
var args34712 = [];
var len__17407__auto___35319 = arguments.length;
var i__17408__auto___35320 = (0);
while(true){
if((i__17408__auto___35320 < len__17407__auto___35319)){
args34712.push((arguments[i__17408__auto___35320]));

var G__35321 = (i__17408__auto___35320 + (1));
i__17408__auto___35320 = G__35321;
continue;
} else {
}
break;
}

var G__34716 = args34712.length;
switch (G__34716) {
case 0:
return om_tools.dom.cite.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34712.slice((1)),(0)));
return om_tools.dom.cite.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.cite.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.cite,null,null);
});

om_tools.dom.cite.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.cite,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.cite.cljs$lang$applyTo = (function (seq34713){
var G__34714 = cljs.core.first.call(null,seq34713);
var seq34713__$1 = cljs.core.next.call(null,seq34713);
return om_tools.dom.cite.cljs$core$IFn$_invoke$arity$variadic(G__34714,seq34713__$1);
});

om_tools.dom.cite.cljs$lang$maxFixedArity = (1);

om_tools.dom.code = (function om_tools$dom$code(var_args){
var args34717 = [];
var len__17407__auto___35323 = arguments.length;
var i__17408__auto___35324 = (0);
while(true){
if((i__17408__auto___35324 < len__17407__auto___35323)){
args34717.push((arguments[i__17408__auto___35324]));

var G__35325 = (i__17408__auto___35324 + (1));
i__17408__auto___35324 = G__35325;
continue;
} else {
}
break;
}

var G__34721 = args34717.length;
switch (G__34721) {
case 0:
return om_tools.dom.code.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34717.slice((1)),(0)));
return om_tools.dom.code.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.code.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.code,null,null);
});

om_tools.dom.code.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.code,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.code.cljs$lang$applyTo = (function (seq34718){
var G__34719 = cljs.core.first.call(null,seq34718);
var seq34718__$1 = cljs.core.next.call(null,seq34718);
return om_tools.dom.code.cljs$core$IFn$_invoke$arity$variadic(G__34719,seq34718__$1);
});

om_tools.dom.code.cljs$lang$maxFixedArity = (1);

om_tools.dom.col = (function om_tools$dom$col(var_args){
var args34722 = [];
var len__17407__auto___35327 = arguments.length;
var i__17408__auto___35328 = (0);
while(true){
if((i__17408__auto___35328 < len__17407__auto___35327)){
args34722.push((arguments[i__17408__auto___35328]));

var G__35329 = (i__17408__auto___35328 + (1));
i__17408__auto___35328 = G__35329;
continue;
} else {
}
break;
}

var G__34726 = args34722.length;
switch (G__34726) {
case 0:
return om_tools.dom.col.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34722.slice((1)),(0)));
return om_tools.dom.col.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.col.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.col,null,null);
});

om_tools.dom.col.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.col,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.col.cljs$lang$applyTo = (function (seq34723){
var G__34724 = cljs.core.first.call(null,seq34723);
var seq34723__$1 = cljs.core.next.call(null,seq34723);
return om_tools.dom.col.cljs$core$IFn$_invoke$arity$variadic(G__34724,seq34723__$1);
});

om_tools.dom.col.cljs$lang$maxFixedArity = (1);

om_tools.dom.colgroup = (function om_tools$dom$colgroup(var_args){
var args34727 = [];
var len__17407__auto___35331 = arguments.length;
var i__17408__auto___35332 = (0);
while(true){
if((i__17408__auto___35332 < len__17407__auto___35331)){
args34727.push((arguments[i__17408__auto___35332]));

var G__35333 = (i__17408__auto___35332 + (1));
i__17408__auto___35332 = G__35333;
continue;
} else {
}
break;
}

var G__34731 = args34727.length;
switch (G__34731) {
case 0:
return om_tools.dom.colgroup.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34727.slice((1)),(0)));
return om_tools.dom.colgroup.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.colgroup.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.colgroup,null,null);
});

om_tools.dom.colgroup.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.colgroup,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.colgroup.cljs$lang$applyTo = (function (seq34728){
var G__34729 = cljs.core.first.call(null,seq34728);
var seq34728__$1 = cljs.core.next.call(null,seq34728);
return om_tools.dom.colgroup.cljs$core$IFn$_invoke$arity$variadic(G__34729,seq34728__$1);
});

om_tools.dom.colgroup.cljs$lang$maxFixedArity = (1);

om_tools.dom.data = (function om_tools$dom$data(var_args){
var args34732 = [];
var len__17407__auto___35335 = arguments.length;
var i__17408__auto___35336 = (0);
while(true){
if((i__17408__auto___35336 < len__17407__auto___35335)){
args34732.push((arguments[i__17408__auto___35336]));

var G__35337 = (i__17408__auto___35336 + (1));
i__17408__auto___35336 = G__35337;
continue;
} else {
}
break;
}

var G__34736 = args34732.length;
switch (G__34736) {
case 0:
return om_tools.dom.data.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34732.slice((1)),(0)));
return om_tools.dom.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.data.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.data,null,null);
});

om_tools.dom.data.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.data,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.data.cljs$lang$applyTo = (function (seq34733){
var G__34734 = cljs.core.first.call(null,seq34733);
var seq34733__$1 = cljs.core.next.call(null,seq34733);
return om_tools.dom.data.cljs$core$IFn$_invoke$arity$variadic(G__34734,seq34733__$1);
});

om_tools.dom.data.cljs$lang$maxFixedArity = (1);

om_tools.dom.datalist = (function om_tools$dom$datalist(var_args){
var args34737 = [];
var len__17407__auto___35339 = arguments.length;
var i__17408__auto___35340 = (0);
while(true){
if((i__17408__auto___35340 < len__17407__auto___35339)){
args34737.push((arguments[i__17408__auto___35340]));

var G__35341 = (i__17408__auto___35340 + (1));
i__17408__auto___35340 = G__35341;
continue;
} else {
}
break;
}

var G__34741 = args34737.length;
switch (G__34741) {
case 0:
return om_tools.dom.datalist.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34737.slice((1)),(0)));
return om_tools.dom.datalist.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.datalist.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.datalist,null,null);
});

om_tools.dom.datalist.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.datalist,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.datalist.cljs$lang$applyTo = (function (seq34738){
var G__34739 = cljs.core.first.call(null,seq34738);
var seq34738__$1 = cljs.core.next.call(null,seq34738);
return om_tools.dom.datalist.cljs$core$IFn$_invoke$arity$variadic(G__34739,seq34738__$1);
});

om_tools.dom.datalist.cljs$lang$maxFixedArity = (1);

om_tools.dom.dd = (function om_tools$dom$dd(var_args){
var args34742 = [];
var len__17407__auto___35343 = arguments.length;
var i__17408__auto___35344 = (0);
while(true){
if((i__17408__auto___35344 < len__17407__auto___35343)){
args34742.push((arguments[i__17408__auto___35344]));

var G__35345 = (i__17408__auto___35344 + (1));
i__17408__auto___35344 = G__35345;
continue;
} else {
}
break;
}

var G__34746 = args34742.length;
switch (G__34746) {
case 0:
return om_tools.dom.dd.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34742.slice((1)),(0)));
return om_tools.dom.dd.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.dd.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.dd,null,null);
});

om_tools.dom.dd.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.dd,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.dd.cljs$lang$applyTo = (function (seq34743){
var G__34744 = cljs.core.first.call(null,seq34743);
var seq34743__$1 = cljs.core.next.call(null,seq34743);
return om_tools.dom.dd.cljs$core$IFn$_invoke$arity$variadic(G__34744,seq34743__$1);
});

om_tools.dom.dd.cljs$lang$maxFixedArity = (1);

om_tools.dom.del = (function om_tools$dom$del(var_args){
var args34747 = [];
var len__17407__auto___35347 = arguments.length;
var i__17408__auto___35348 = (0);
while(true){
if((i__17408__auto___35348 < len__17407__auto___35347)){
args34747.push((arguments[i__17408__auto___35348]));

var G__35349 = (i__17408__auto___35348 + (1));
i__17408__auto___35348 = G__35349;
continue;
} else {
}
break;
}

var G__34751 = args34747.length;
switch (G__34751) {
case 0:
return om_tools.dom.del.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34747.slice((1)),(0)));
return om_tools.dom.del.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.del.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.del,null,null);
});

om_tools.dom.del.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.del,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.del.cljs$lang$applyTo = (function (seq34748){
var G__34749 = cljs.core.first.call(null,seq34748);
var seq34748__$1 = cljs.core.next.call(null,seq34748);
return om_tools.dom.del.cljs$core$IFn$_invoke$arity$variadic(G__34749,seq34748__$1);
});

om_tools.dom.del.cljs$lang$maxFixedArity = (1);

om_tools.dom.dfn = (function om_tools$dom$dfn(var_args){
var args34752 = [];
var len__17407__auto___35351 = arguments.length;
var i__17408__auto___35352 = (0);
while(true){
if((i__17408__auto___35352 < len__17407__auto___35351)){
args34752.push((arguments[i__17408__auto___35352]));

var G__35353 = (i__17408__auto___35352 + (1));
i__17408__auto___35352 = G__35353;
continue;
} else {
}
break;
}

var G__34756 = args34752.length;
switch (G__34756) {
case 0:
return om_tools.dom.dfn.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34752.slice((1)),(0)));
return om_tools.dom.dfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.dfn.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.dfn,null,null);
});

om_tools.dom.dfn.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.dfn,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.dfn.cljs$lang$applyTo = (function (seq34753){
var G__34754 = cljs.core.first.call(null,seq34753);
var seq34753__$1 = cljs.core.next.call(null,seq34753);
return om_tools.dom.dfn.cljs$core$IFn$_invoke$arity$variadic(G__34754,seq34753__$1);
});

om_tools.dom.dfn.cljs$lang$maxFixedArity = (1);

om_tools.dom.div = (function om_tools$dom$div(var_args){
var args34757 = [];
var len__17407__auto___35355 = arguments.length;
var i__17408__auto___35356 = (0);
while(true){
if((i__17408__auto___35356 < len__17407__auto___35355)){
args34757.push((arguments[i__17408__auto___35356]));

var G__35357 = (i__17408__auto___35356 + (1));
i__17408__auto___35356 = G__35357;
continue;
} else {
}
break;
}

var G__34761 = args34757.length;
switch (G__34761) {
case 0:
return om_tools.dom.div.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34757.slice((1)),(0)));
return om_tools.dom.div.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.div.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.div,null,null);
});

om_tools.dom.div.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.div,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.div.cljs$lang$applyTo = (function (seq34758){
var G__34759 = cljs.core.first.call(null,seq34758);
var seq34758__$1 = cljs.core.next.call(null,seq34758);
return om_tools.dom.div.cljs$core$IFn$_invoke$arity$variadic(G__34759,seq34758__$1);
});

om_tools.dom.div.cljs$lang$maxFixedArity = (1);

om_tools.dom.dl = (function om_tools$dom$dl(var_args){
var args34762 = [];
var len__17407__auto___35359 = arguments.length;
var i__17408__auto___35360 = (0);
while(true){
if((i__17408__auto___35360 < len__17407__auto___35359)){
args34762.push((arguments[i__17408__auto___35360]));

var G__35361 = (i__17408__auto___35360 + (1));
i__17408__auto___35360 = G__35361;
continue;
} else {
}
break;
}

var G__34766 = args34762.length;
switch (G__34766) {
case 0:
return om_tools.dom.dl.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34762.slice((1)),(0)));
return om_tools.dom.dl.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.dl.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.dl,null,null);
});

om_tools.dom.dl.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.dl,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.dl.cljs$lang$applyTo = (function (seq34763){
var G__34764 = cljs.core.first.call(null,seq34763);
var seq34763__$1 = cljs.core.next.call(null,seq34763);
return om_tools.dom.dl.cljs$core$IFn$_invoke$arity$variadic(G__34764,seq34763__$1);
});

om_tools.dom.dl.cljs$lang$maxFixedArity = (1);

om_tools.dom.dt = (function om_tools$dom$dt(var_args){
var args34767 = [];
var len__17407__auto___35363 = arguments.length;
var i__17408__auto___35364 = (0);
while(true){
if((i__17408__auto___35364 < len__17407__auto___35363)){
args34767.push((arguments[i__17408__auto___35364]));

var G__35365 = (i__17408__auto___35364 + (1));
i__17408__auto___35364 = G__35365;
continue;
} else {
}
break;
}

var G__34771 = args34767.length;
switch (G__34771) {
case 0:
return om_tools.dom.dt.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34767.slice((1)),(0)));
return om_tools.dom.dt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.dt.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.dt,null,null);
});

om_tools.dom.dt.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.dt,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.dt.cljs$lang$applyTo = (function (seq34768){
var G__34769 = cljs.core.first.call(null,seq34768);
var seq34768__$1 = cljs.core.next.call(null,seq34768);
return om_tools.dom.dt.cljs$core$IFn$_invoke$arity$variadic(G__34769,seq34768__$1);
});

om_tools.dom.dt.cljs$lang$maxFixedArity = (1);

om_tools.dom.em = (function om_tools$dom$em(var_args){
var args34772 = [];
var len__17407__auto___35367 = arguments.length;
var i__17408__auto___35368 = (0);
while(true){
if((i__17408__auto___35368 < len__17407__auto___35367)){
args34772.push((arguments[i__17408__auto___35368]));

var G__35369 = (i__17408__auto___35368 + (1));
i__17408__auto___35368 = G__35369;
continue;
} else {
}
break;
}

var G__34776 = args34772.length;
switch (G__34776) {
case 0:
return om_tools.dom.em.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34772.slice((1)),(0)));
return om_tools.dom.em.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.em.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.em,null,null);
});

om_tools.dom.em.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.em,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.em.cljs$lang$applyTo = (function (seq34773){
var G__34774 = cljs.core.first.call(null,seq34773);
var seq34773__$1 = cljs.core.next.call(null,seq34773);
return om_tools.dom.em.cljs$core$IFn$_invoke$arity$variadic(G__34774,seq34773__$1);
});

om_tools.dom.em.cljs$lang$maxFixedArity = (1);

om_tools.dom.embed = (function om_tools$dom$embed(var_args){
var args34777 = [];
var len__17407__auto___35371 = arguments.length;
var i__17408__auto___35372 = (0);
while(true){
if((i__17408__auto___35372 < len__17407__auto___35371)){
args34777.push((arguments[i__17408__auto___35372]));

var G__35373 = (i__17408__auto___35372 + (1));
i__17408__auto___35372 = G__35373;
continue;
} else {
}
break;
}

var G__34781 = args34777.length;
switch (G__34781) {
case 0:
return om_tools.dom.embed.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34777.slice((1)),(0)));
return om_tools.dom.embed.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.embed.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.embed,null,null);
});

om_tools.dom.embed.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.embed,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.embed.cljs$lang$applyTo = (function (seq34778){
var G__34779 = cljs.core.first.call(null,seq34778);
var seq34778__$1 = cljs.core.next.call(null,seq34778);
return om_tools.dom.embed.cljs$core$IFn$_invoke$arity$variadic(G__34779,seq34778__$1);
});

om_tools.dom.embed.cljs$lang$maxFixedArity = (1);

om_tools.dom.fieldset = (function om_tools$dom$fieldset(var_args){
var args34787 = [];
var len__17407__auto___35375 = arguments.length;
var i__17408__auto___35376 = (0);
while(true){
if((i__17408__auto___35376 < len__17407__auto___35375)){
args34787.push((arguments[i__17408__auto___35376]));

var G__35377 = (i__17408__auto___35376 + (1));
i__17408__auto___35376 = G__35377;
continue;
} else {
}
break;
}

var G__34791 = args34787.length;
switch (G__34791) {
case 0:
return om_tools.dom.fieldset.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34787.slice((1)),(0)));
return om_tools.dom.fieldset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.fieldset.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.fieldset,null,null);
});

om_tools.dom.fieldset.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.fieldset,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.fieldset.cljs$lang$applyTo = (function (seq34788){
var G__34789 = cljs.core.first.call(null,seq34788);
var seq34788__$1 = cljs.core.next.call(null,seq34788);
return om_tools.dom.fieldset.cljs$core$IFn$_invoke$arity$variadic(G__34789,seq34788__$1);
});

om_tools.dom.fieldset.cljs$lang$maxFixedArity = (1);

om_tools.dom.figcaption = (function om_tools$dom$figcaption(var_args){
var args34792 = [];
var len__17407__auto___35379 = arguments.length;
var i__17408__auto___35380 = (0);
while(true){
if((i__17408__auto___35380 < len__17407__auto___35379)){
args34792.push((arguments[i__17408__auto___35380]));

var G__35381 = (i__17408__auto___35380 + (1));
i__17408__auto___35380 = G__35381;
continue;
} else {
}
break;
}

var G__34796 = args34792.length;
switch (G__34796) {
case 0:
return om_tools.dom.figcaption.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34792.slice((1)),(0)));
return om_tools.dom.figcaption.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.figcaption.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.figcaption,null,null);
});

om_tools.dom.figcaption.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.figcaption,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.figcaption.cljs$lang$applyTo = (function (seq34793){
var G__34794 = cljs.core.first.call(null,seq34793);
var seq34793__$1 = cljs.core.next.call(null,seq34793);
return om_tools.dom.figcaption.cljs$core$IFn$_invoke$arity$variadic(G__34794,seq34793__$1);
});

om_tools.dom.figcaption.cljs$lang$maxFixedArity = (1);

om_tools.dom.figure = (function om_tools$dom$figure(var_args){
var args34797 = [];
var len__17407__auto___35383 = arguments.length;
var i__17408__auto___35384 = (0);
while(true){
if((i__17408__auto___35384 < len__17407__auto___35383)){
args34797.push((arguments[i__17408__auto___35384]));

var G__35385 = (i__17408__auto___35384 + (1));
i__17408__auto___35384 = G__35385;
continue;
} else {
}
break;
}

var G__34801 = args34797.length;
switch (G__34801) {
case 0:
return om_tools.dom.figure.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34797.slice((1)),(0)));
return om_tools.dom.figure.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.figure.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.figure,null,null);
});

om_tools.dom.figure.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.figure,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.figure.cljs$lang$applyTo = (function (seq34798){
var G__34799 = cljs.core.first.call(null,seq34798);
var seq34798__$1 = cljs.core.next.call(null,seq34798);
return om_tools.dom.figure.cljs$core$IFn$_invoke$arity$variadic(G__34799,seq34798__$1);
});

om_tools.dom.figure.cljs$lang$maxFixedArity = (1);

om_tools.dom.footer = (function om_tools$dom$footer(var_args){
var args34802 = [];
var len__17407__auto___35387 = arguments.length;
var i__17408__auto___35388 = (0);
while(true){
if((i__17408__auto___35388 < len__17407__auto___35387)){
args34802.push((arguments[i__17408__auto___35388]));

var G__35389 = (i__17408__auto___35388 + (1));
i__17408__auto___35388 = G__35389;
continue;
} else {
}
break;
}

var G__34806 = args34802.length;
switch (G__34806) {
case 0:
return om_tools.dom.footer.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34802.slice((1)),(0)));
return om_tools.dom.footer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.footer.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.footer,null,null);
});

om_tools.dom.footer.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.footer,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.footer.cljs$lang$applyTo = (function (seq34803){
var G__34804 = cljs.core.first.call(null,seq34803);
var seq34803__$1 = cljs.core.next.call(null,seq34803);
return om_tools.dom.footer.cljs$core$IFn$_invoke$arity$variadic(G__34804,seq34803__$1);
});

om_tools.dom.footer.cljs$lang$maxFixedArity = (1);

om_tools.dom.form = (function om_tools$dom$form(var_args){
var args34807 = [];
var len__17407__auto___35391 = arguments.length;
var i__17408__auto___35392 = (0);
while(true){
if((i__17408__auto___35392 < len__17407__auto___35391)){
args34807.push((arguments[i__17408__auto___35392]));

var G__35393 = (i__17408__auto___35392 + (1));
i__17408__auto___35392 = G__35393;
continue;
} else {
}
break;
}

var G__34811 = args34807.length;
switch (G__34811) {
case 0:
return om_tools.dom.form.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34807.slice((1)),(0)));
return om_tools.dom.form.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.form.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.form,null,null);
});

om_tools.dom.form.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.form,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.form.cljs$lang$applyTo = (function (seq34808){
var G__34809 = cljs.core.first.call(null,seq34808);
var seq34808__$1 = cljs.core.next.call(null,seq34808);
return om_tools.dom.form.cljs$core$IFn$_invoke$arity$variadic(G__34809,seq34808__$1);
});

om_tools.dom.form.cljs$lang$maxFixedArity = (1);

om_tools.dom.h1 = (function om_tools$dom$h1(var_args){
var args34812 = [];
var len__17407__auto___35395 = arguments.length;
var i__17408__auto___35396 = (0);
while(true){
if((i__17408__auto___35396 < len__17407__auto___35395)){
args34812.push((arguments[i__17408__auto___35396]));

var G__35397 = (i__17408__auto___35396 + (1));
i__17408__auto___35396 = G__35397;
continue;
} else {
}
break;
}

var G__34816 = args34812.length;
switch (G__34816) {
case 0:
return om_tools.dom.h1.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34812.slice((1)),(0)));
return om_tools.dom.h1.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.h1.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.h1,null,null);
});

om_tools.dom.h1.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.h1,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.h1.cljs$lang$applyTo = (function (seq34813){
var G__34814 = cljs.core.first.call(null,seq34813);
var seq34813__$1 = cljs.core.next.call(null,seq34813);
return om_tools.dom.h1.cljs$core$IFn$_invoke$arity$variadic(G__34814,seq34813__$1);
});

om_tools.dom.h1.cljs$lang$maxFixedArity = (1);

om_tools.dom.h2 = (function om_tools$dom$h2(var_args){
var args34817 = [];
var len__17407__auto___35399 = arguments.length;
var i__17408__auto___35400 = (0);
while(true){
if((i__17408__auto___35400 < len__17407__auto___35399)){
args34817.push((arguments[i__17408__auto___35400]));

var G__35401 = (i__17408__auto___35400 + (1));
i__17408__auto___35400 = G__35401;
continue;
} else {
}
break;
}

var G__34821 = args34817.length;
switch (G__34821) {
case 0:
return om_tools.dom.h2.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34817.slice((1)),(0)));
return om_tools.dom.h2.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.h2.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.h2,null,null);
});

om_tools.dom.h2.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.h2,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.h2.cljs$lang$applyTo = (function (seq34818){
var G__34819 = cljs.core.first.call(null,seq34818);
var seq34818__$1 = cljs.core.next.call(null,seq34818);
return om_tools.dom.h2.cljs$core$IFn$_invoke$arity$variadic(G__34819,seq34818__$1);
});

om_tools.dom.h2.cljs$lang$maxFixedArity = (1);

om_tools.dom.h3 = (function om_tools$dom$h3(var_args){
var args34822 = [];
var len__17407__auto___35403 = arguments.length;
var i__17408__auto___35404 = (0);
while(true){
if((i__17408__auto___35404 < len__17407__auto___35403)){
args34822.push((arguments[i__17408__auto___35404]));

var G__35405 = (i__17408__auto___35404 + (1));
i__17408__auto___35404 = G__35405;
continue;
} else {
}
break;
}

var G__34826 = args34822.length;
switch (G__34826) {
case 0:
return om_tools.dom.h3.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34822.slice((1)),(0)));
return om_tools.dom.h3.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.h3.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.h3,null,null);
});

om_tools.dom.h3.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.h3,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.h3.cljs$lang$applyTo = (function (seq34823){
var G__34824 = cljs.core.first.call(null,seq34823);
var seq34823__$1 = cljs.core.next.call(null,seq34823);
return om_tools.dom.h3.cljs$core$IFn$_invoke$arity$variadic(G__34824,seq34823__$1);
});

om_tools.dom.h3.cljs$lang$maxFixedArity = (1);

om_tools.dom.h4 = (function om_tools$dom$h4(var_args){
var args34827 = [];
var len__17407__auto___35407 = arguments.length;
var i__17408__auto___35408 = (0);
while(true){
if((i__17408__auto___35408 < len__17407__auto___35407)){
args34827.push((arguments[i__17408__auto___35408]));

var G__35409 = (i__17408__auto___35408 + (1));
i__17408__auto___35408 = G__35409;
continue;
} else {
}
break;
}

var G__34831 = args34827.length;
switch (G__34831) {
case 0:
return om_tools.dom.h4.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34827.slice((1)),(0)));
return om_tools.dom.h4.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.h4.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.h4,null,null);
});

om_tools.dom.h4.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.h4,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.h4.cljs$lang$applyTo = (function (seq34828){
var G__34829 = cljs.core.first.call(null,seq34828);
var seq34828__$1 = cljs.core.next.call(null,seq34828);
return om_tools.dom.h4.cljs$core$IFn$_invoke$arity$variadic(G__34829,seq34828__$1);
});

om_tools.dom.h4.cljs$lang$maxFixedArity = (1);

om_tools.dom.h5 = (function om_tools$dom$h5(var_args){
var args34832 = [];
var len__17407__auto___35411 = arguments.length;
var i__17408__auto___35412 = (0);
while(true){
if((i__17408__auto___35412 < len__17407__auto___35411)){
args34832.push((arguments[i__17408__auto___35412]));

var G__35413 = (i__17408__auto___35412 + (1));
i__17408__auto___35412 = G__35413;
continue;
} else {
}
break;
}

var G__34836 = args34832.length;
switch (G__34836) {
case 0:
return om_tools.dom.h5.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34832.slice((1)),(0)));
return om_tools.dom.h5.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.h5.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.h5,null,null);
});

om_tools.dom.h5.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.h5,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.h5.cljs$lang$applyTo = (function (seq34833){
var G__34834 = cljs.core.first.call(null,seq34833);
var seq34833__$1 = cljs.core.next.call(null,seq34833);
return om_tools.dom.h5.cljs$core$IFn$_invoke$arity$variadic(G__34834,seq34833__$1);
});

om_tools.dom.h5.cljs$lang$maxFixedArity = (1);

om_tools.dom.h6 = (function om_tools$dom$h6(var_args){
var args34837 = [];
var len__17407__auto___35415 = arguments.length;
var i__17408__auto___35416 = (0);
while(true){
if((i__17408__auto___35416 < len__17407__auto___35415)){
args34837.push((arguments[i__17408__auto___35416]));

var G__35417 = (i__17408__auto___35416 + (1));
i__17408__auto___35416 = G__35417;
continue;
} else {
}
break;
}

var G__34841 = args34837.length;
switch (G__34841) {
case 0:
return om_tools.dom.h6.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34837.slice((1)),(0)));
return om_tools.dom.h6.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.h6.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.h6,null,null);
});

om_tools.dom.h6.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.h6,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.h6.cljs$lang$applyTo = (function (seq34838){
var G__34839 = cljs.core.first.call(null,seq34838);
var seq34838__$1 = cljs.core.next.call(null,seq34838);
return om_tools.dom.h6.cljs$core$IFn$_invoke$arity$variadic(G__34839,seq34838__$1);
});

om_tools.dom.h6.cljs$lang$maxFixedArity = (1);

om_tools.dom.head = (function om_tools$dom$head(var_args){
var args34842 = [];
var len__17407__auto___35419 = arguments.length;
var i__17408__auto___35420 = (0);
while(true){
if((i__17408__auto___35420 < len__17407__auto___35419)){
args34842.push((arguments[i__17408__auto___35420]));

var G__35421 = (i__17408__auto___35420 + (1));
i__17408__auto___35420 = G__35421;
continue;
} else {
}
break;
}

var G__34846 = args34842.length;
switch (G__34846) {
case 0:
return om_tools.dom.head.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34842.slice((1)),(0)));
return om_tools.dom.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.head.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.head,null,null);
});

om_tools.dom.head.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.head,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.head.cljs$lang$applyTo = (function (seq34843){
var G__34844 = cljs.core.first.call(null,seq34843);
var seq34843__$1 = cljs.core.next.call(null,seq34843);
return om_tools.dom.head.cljs$core$IFn$_invoke$arity$variadic(G__34844,seq34843__$1);
});

om_tools.dom.head.cljs$lang$maxFixedArity = (1);

om_tools.dom.header = (function om_tools$dom$header(var_args){
var args34847 = [];
var len__17407__auto___35423 = arguments.length;
var i__17408__auto___35424 = (0);
while(true){
if((i__17408__auto___35424 < len__17407__auto___35423)){
args34847.push((arguments[i__17408__auto___35424]));

var G__35425 = (i__17408__auto___35424 + (1));
i__17408__auto___35424 = G__35425;
continue;
} else {
}
break;
}

var G__34851 = args34847.length;
switch (G__34851) {
case 0:
return om_tools.dom.header.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34847.slice((1)),(0)));
return om_tools.dom.header.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.header.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.header,null,null);
});

om_tools.dom.header.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.header,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.header.cljs$lang$applyTo = (function (seq34848){
var G__34849 = cljs.core.first.call(null,seq34848);
var seq34848__$1 = cljs.core.next.call(null,seq34848);
return om_tools.dom.header.cljs$core$IFn$_invoke$arity$variadic(G__34849,seq34848__$1);
});

om_tools.dom.header.cljs$lang$maxFixedArity = (1);

om_tools.dom.hr = (function om_tools$dom$hr(var_args){
var args34852 = [];
var len__17407__auto___35427 = arguments.length;
var i__17408__auto___35428 = (0);
while(true){
if((i__17408__auto___35428 < len__17407__auto___35427)){
args34852.push((arguments[i__17408__auto___35428]));

var G__35429 = (i__17408__auto___35428 + (1));
i__17408__auto___35428 = G__35429;
continue;
} else {
}
break;
}

var G__34856 = args34852.length;
switch (G__34856) {
case 0:
return om_tools.dom.hr.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34852.slice((1)),(0)));
return om_tools.dom.hr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.hr.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.hr,null,null);
});

om_tools.dom.hr.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.hr,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.hr.cljs$lang$applyTo = (function (seq34853){
var G__34854 = cljs.core.first.call(null,seq34853);
var seq34853__$1 = cljs.core.next.call(null,seq34853);
return om_tools.dom.hr.cljs$core$IFn$_invoke$arity$variadic(G__34854,seq34853__$1);
});

om_tools.dom.hr.cljs$lang$maxFixedArity = (1);

om_tools.dom.html = (function om_tools$dom$html(var_args){
var args34857 = [];
var len__17407__auto___35431 = arguments.length;
var i__17408__auto___35432 = (0);
while(true){
if((i__17408__auto___35432 < len__17407__auto___35431)){
args34857.push((arguments[i__17408__auto___35432]));

var G__35433 = (i__17408__auto___35432 + (1));
i__17408__auto___35432 = G__35433;
continue;
} else {
}
break;
}

var G__34861 = args34857.length;
switch (G__34861) {
case 0:
return om_tools.dom.html.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34857.slice((1)),(0)));
return om_tools.dom.html.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.html.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.html,null,null);
});

om_tools.dom.html.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.html,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.html.cljs$lang$applyTo = (function (seq34858){
var G__34859 = cljs.core.first.call(null,seq34858);
var seq34858__$1 = cljs.core.next.call(null,seq34858);
return om_tools.dom.html.cljs$core$IFn$_invoke$arity$variadic(G__34859,seq34858__$1);
});

om_tools.dom.html.cljs$lang$maxFixedArity = (1);

om_tools.dom.i = (function om_tools$dom$i(var_args){
var args34862 = [];
var len__17407__auto___35435 = arguments.length;
var i__17408__auto___35436 = (0);
while(true){
if((i__17408__auto___35436 < len__17407__auto___35435)){
args34862.push((arguments[i__17408__auto___35436]));

var G__35437 = (i__17408__auto___35436 + (1));
i__17408__auto___35436 = G__35437;
continue;
} else {
}
break;
}

var G__34866 = args34862.length;
switch (G__34866) {
case 0:
return om_tools.dom.i.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34862.slice((1)),(0)));
return om_tools.dom.i.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.i.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.i,null,null);
});

om_tools.dom.i.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.i,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.i.cljs$lang$applyTo = (function (seq34863){
var G__34864 = cljs.core.first.call(null,seq34863);
var seq34863__$1 = cljs.core.next.call(null,seq34863);
return om_tools.dom.i.cljs$core$IFn$_invoke$arity$variadic(G__34864,seq34863__$1);
});

om_tools.dom.i.cljs$lang$maxFixedArity = (1);

om_tools.dom.iframe = (function om_tools$dom$iframe(var_args){
var args34867 = [];
var len__17407__auto___35439 = arguments.length;
var i__17408__auto___35440 = (0);
while(true){
if((i__17408__auto___35440 < len__17407__auto___35439)){
args34867.push((arguments[i__17408__auto___35440]));

var G__35441 = (i__17408__auto___35440 + (1));
i__17408__auto___35440 = G__35441;
continue;
} else {
}
break;
}

var G__34871 = args34867.length;
switch (G__34871) {
case 0:
return om_tools.dom.iframe.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34867.slice((1)),(0)));
return om_tools.dom.iframe.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.iframe.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.iframe,null,null);
});

om_tools.dom.iframe.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.iframe,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.iframe.cljs$lang$applyTo = (function (seq34868){
var G__34869 = cljs.core.first.call(null,seq34868);
var seq34868__$1 = cljs.core.next.call(null,seq34868);
return om_tools.dom.iframe.cljs$core$IFn$_invoke$arity$variadic(G__34869,seq34868__$1);
});

om_tools.dom.iframe.cljs$lang$maxFixedArity = (1);

om_tools.dom.img = (function om_tools$dom$img(var_args){
var args34872 = [];
var len__17407__auto___35443 = arguments.length;
var i__17408__auto___35444 = (0);
while(true){
if((i__17408__auto___35444 < len__17407__auto___35443)){
args34872.push((arguments[i__17408__auto___35444]));

var G__35445 = (i__17408__auto___35444 + (1));
i__17408__auto___35444 = G__35445;
continue;
} else {
}
break;
}

var G__34876 = args34872.length;
switch (G__34876) {
case 0:
return om_tools.dom.img.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34872.slice((1)),(0)));
return om_tools.dom.img.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.img.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.img,null,null);
});

om_tools.dom.img.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.img,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.img.cljs$lang$applyTo = (function (seq34873){
var G__34874 = cljs.core.first.call(null,seq34873);
var seq34873__$1 = cljs.core.next.call(null,seq34873);
return om_tools.dom.img.cljs$core$IFn$_invoke$arity$variadic(G__34874,seq34873__$1);
});

om_tools.dom.img.cljs$lang$maxFixedArity = (1);

om_tools.dom.ins = (function om_tools$dom$ins(var_args){
var args34877 = [];
var len__17407__auto___35447 = arguments.length;
var i__17408__auto___35448 = (0);
while(true){
if((i__17408__auto___35448 < len__17407__auto___35447)){
args34877.push((arguments[i__17408__auto___35448]));

var G__35449 = (i__17408__auto___35448 + (1));
i__17408__auto___35448 = G__35449;
continue;
} else {
}
break;
}

var G__34881 = args34877.length;
switch (G__34881) {
case 0:
return om_tools.dom.ins.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34877.slice((1)),(0)));
return om_tools.dom.ins.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.ins.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.ins,null,null);
});

om_tools.dom.ins.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.ins,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.ins.cljs$lang$applyTo = (function (seq34878){
var G__34879 = cljs.core.first.call(null,seq34878);
var seq34878__$1 = cljs.core.next.call(null,seq34878);
return om_tools.dom.ins.cljs$core$IFn$_invoke$arity$variadic(G__34879,seq34878__$1);
});

om_tools.dom.ins.cljs$lang$maxFixedArity = (1);

om_tools.dom.kbd = (function om_tools$dom$kbd(var_args){
var args34882 = [];
var len__17407__auto___35451 = arguments.length;
var i__17408__auto___35452 = (0);
while(true){
if((i__17408__auto___35452 < len__17407__auto___35451)){
args34882.push((arguments[i__17408__auto___35452]));

var G__35453 = (i__17408__auto___35452 + (1));
i__17408__auto___35452 = G__35453;
continue;
} else {
}
break;
}

var G__34886 = args34882.length;
switch (G__34886) {
case 0:
return om_tools.dom.kbd.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34882.slice((1)),(0)));
return om_tools.dom.kbd.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.kbd.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.kbd,null,null);
});

om_tools.dom.kbd.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.kbd,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.kbd.cljs$lang$applyTo = (function (seq34883){
var G__34884 = cljs.core.first.call(null,seq34883);
var seq34883__$1 = cljs.core.next.call(null,seq34883);
return om_tools.dom.kbd.cljs$core$IFn$_invoke$arity$variadic(G__34884,seq34883__$1);
});

om_tools.dom.kbd.cljs$lang$maxFixedArity = (1);

om_tools.dom.keygen = (function om_tools$dom$keygen(var_args){
var args34887 = [];
var len__17407__auto___35455 = arguments.length;
var i__17408__auto___35456 = (0);
while(true){
if((i__17408__auto___35456 < len__17407__auto___35455)){
args34887.push((arguments[i__17408__auto___35456]));

var G__35457 = (i__17408__auto___35456 + (1));
i__17408__auto___35456 = G__35457;
continue;
} else {
}
break;
}

var G__34891 = args34887.length;
switch (G__34891) {
case 0:
return om_tools.dom.keygen.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34887.slice((1)),(0)));
return om_tools.dom.keygen.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.keygen.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.keygen,null,null);
});

om_tools.dom.keygen.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.keygen,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.keygen.cljs$lang$applyTo = (function (seq34888){
var G__34889 = cljs.core.first.call(null,seq34888);
var seq34888__$1 = cljs.core.next.call(null,seq34888);
return om_tools.dom.keygen.cljs$core$IFn$_invoke$arity$variadic(G__34889,seq34888__$1);
});

om_tools.dom.keygen.cljs$lang$maxFixedArity = (1);

om_tools.dom.label = (function om_tools$dom$label(var_args){
var args34892 = [];
var len__17407__auto___35459 = arguments.length;
var i__17408__auto___35460 = (0);
while(true){
if((i__17408__auto___35460 < len__17407__auto___35459)){
args34892.push((arguments[i__17408__auto___35460]));

var G__35461 = (i__17408__auto___35460 + (1));
i__17408__auto___35460 = G__35461;
continue;
} else {
}
break;
}

var G__34896 = args34892.length;
switch (G__34896) {
case 0:
return om_tools.dom.label.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34892.slice((1)),(0)));
return om_tools.dom.label.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.label.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.label,null,null);
});

om_tools.dom.label.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.label,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.label.cljs$lang$applyTo = (function (seq34893){
var G__34894 = cljs.core.first.call(null,seq34893);
var seq34893__$1 = cljs.core.next.call(null,seq34893);
return om_tools.dom.label.cljs$core$IFn$_invoke$arity$variadic(G__34894,seq34893__$1);
});

om_tools.dom.label.cljs$lang$maxFixedArity = (1);

om_tools.dom.legend = (function om_tools$dom$legend(var_args){
var args34897 = [];
var len__17407__auto___35463 = arguments.length;
var i__17408__auto___35464 = (0);
while(true){
if((i__17408__auto___35464 < len__17407__auto___35463)){
args34897.push((arguments[i__17408__auto___35464]));

var G__35465 = (i__17408__auto___35464 + (1));
i__17408__auto___35464 = G__35465;
continue;
} else {
}
break;
}

var G__34901 = args34897.length;
switch (G__34901) {
case 0:
return om_tools.dom.legend.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34897.slice((1)),(0)));
return om_tools.dom.legend.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.legend.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.legend,null,null);
});

om_tools.dom.legend.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.legend,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.legend.cljs$lang$applyTo = (function (seq34898){
var G__34899 = cljs.core.first.call(null,seq34898);
var seq34898__$1 = cljs.core.next.call(null,seq34898);
return om_tools.dom.legend.cljs$core$IFn$_invoke$arity$variadic(G__34899,seq34898__$1);
});

om_tools.dom.legend.cljs$lang$maxFixedArity = (1);

om_tools.dom.li = (function om_tools$dom$li(var_args){
var args34902 = [];
var len__17407__auto___35467 = arguments.length;
var i__17408__auto___35468 = (0);
while(true){
if((i__17408__auto___35468 < len__17407__auto___35467)){
args34902.push((arguments[i__17408__auto___35468]));

var G__35469 = (i__17408__auto___35468 + (1));
i__17408__auto___35468 = G__35469;
continue;
} else {
}
break;
}

var G__34906 = args34902.length;
switch (G__34906) {
case 0:
return om_tools.dom.li.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34902.slice((1)),(0)));
return om_tools.dom.li.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.li.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.li,null,null);
});

om_tools.dom.li.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.li,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.li.cljs$lang$applyTo = (function (seq34903){
var G__34904 = cljs.core.first.call(null,seq34903);
var seq34903__$1 = cljs.core.next.call(null,seq34903);
return om_tools.dom.li.cljs$core$IFn$_invoke$arity$variadic(G__34904,seq34903__$1);
});

om_tools.dom.li.cljs$lang$maxFixedArity = (1);

om_tools.dom.link = (function om_tools$dom$link(var_args){
var args34907 = [];
var len__17407__auto___35471 = arguments.length;
var i__17408__auto___35472 = (0);
while(true){
if((i__17408__auto___35472 < len__17407__auto___35471)){
args34907.push((arguments[i__17408__auto___35472]));

var G__35473 = (i__17408__auto___35472 + (1));
i__17408__auto___35472 = G__35473;
continue;
} else {
}
break;
}

var G__34911 = args34907.length;
switch (G__34911) {
case 0:
return om_tools.dom.link.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34907.slice((1)),(0)));
return om_tools.dom.link.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.link.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.link,null,null);
});

om_tools.dom.link.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.link,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.link.cljs$lang$applyTo = (function (seq34908){
var G__34909 = cljs.core.first.call(null,seq34908);
var seq34908__$1 = cljs.core.next.call(null,seq34908);
return om_tools.dom.link.cljs$core$IFn$_invoke$arity$variadic(G__34909,seq34908__$1);
});

om_tools.dom.link.cljs$lang$maxFixedArity = (1);

om_tools.dom.main = (function om_tools$dom$main(var_args){
var args34912 = [];
var len__17407__auto___35475 = arguments.length;
var i__17408__auto___35476 = (0);
while(true){
if((i__17408__auto___35476 < len__17407__auto___35475)){
args34912.push((arguments[i__17408__auto___35476]));

var G__35477 = (i__17408__auto___35476 + (1));
i__17408__auto___35476 = G__35477;
continue;
} else {
}
break;
}

var G__34916 = args34912.length;
switch (G__34916) {
case 0:
return om_tools.dom.main.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34912.slice((1)),(0)));
return om_tools.dom.main.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.main.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.main,null,null);
});

om_tools.dom.main.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.main,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.main.cljs$lang$applyTo = (function (seq34913){
var G__34914 = cljs.core.first.call(null,seq34913);
var seq34913__$1 = cljs.core.next.call(null,seq34913);
return om_tools.dom.main.cljs$core$IFn$_invoke$arity$variadic(G__34914,seq34913__$1);
});

om_tools.dom.main.cljs$lang$maxFixedArity = (1);

om_tools.dom.map = (function om_tools$dom$map(var_args){
var args34917 = [];
var len__17407__auto___35479 = arguments.length;
var i__17408__auto___35480 = (0);
while(true){
if((i__17408__auto___35480 < len__17407__auto___35479)){
args34917.push((arguments[i__17408__auto___35480]));

var G__35481 = (i__17408__auto___35480 + (1));
i__17408__auto___35480 = G__35481;
continue;
} else {
}
break;
}

var G__34921 = args34917.length;
switch (G__34921) {
case 0:
return om_tools.dom.map.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34917.slice((1)),(0)));
return om_tools.dom.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.map.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.map,null,null);
});

om_tools.dom.map.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.map,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.map.cljs$lang$applyTo = (function (seq34918){
var G__34919 = cljs.core.first.call(null,seq34918);
var seq34918__$1 = cljs.core.next.call(null,seq34918);
return om_tools.dom.map.cljs$core$IFn$_invoke$arity$variadic(G__34919,seq34918__$1);
});

om_tools.dom.map.cljs$lang$maxFixedArity = (1);

om_tools.dom.mark = (function om_tools$dom$mark(var_args){
var args34922 = [];
var len__17407__auto___35483 = arguments.length;
var i__17408__auto___35484 = (0);
while(true){
if((i__17408__auto___35484 < len__17407__auto___35483)){
args34922.push((arguments[i__17408__auto___35484]));

var G__35485 = (i__17408__auto___35484 + (1));
i__17408__auto___35484 = G__35485;
continue;
} else {
}
break;
}

var G__34926 = args34922.length;
switch (G__34926) {
case 0:
return om_tools.dom.mark.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34922.slice((1)),(0)));
return om_tools.dom.mark.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.mark.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.mark,null,null);
});

om_tools.dom.mark.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.mark,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.mark.cljs$lang$applyTo = (function (seq34923){
var G__34924 = cljs.core.first.call(null,seq34923);
var seq34923__$1 = cljs.core.next.call(null,seq34923);
return om_tools.dom.mark.cljs$core$IFn$_invoke$arity$variadic(G__34924,seq34923__$1);
});

om_tools.dom.mark.cljs$lang$maxFixedArity = (1);

om_tools.dom.marquee = (function om_tools$dom$marquee(var_args){
var args34927 = [];
var len__17407__auto___35487 = arguments.length;
var i__17408__auto___35488 = (0);
while(true){
if((i__17408__auto___35488 < len__17407__auto___35487)){
args34927.push((arguments[i__17408__auto___35488]));

var G__35489 = (i__17408__auto___35488 + (1));
i__17408__auto___35488 = G__35489;
continue;
} else {
}
break;
}

var G__34931 = args34927.length;
switch (G__34931) {
case 0:
return om_tools.dom.marquee.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34927.slice((1)),(0)));
return om_tools.dom.marquee.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.marquee.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.marquee,null,null);
});

om_tools.dom.marquee.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.marquee,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.marquee.cljs$lang$applyTo = (function (seq34928){
var G__34929 = cljs.core.first.call(null,seq34928);
var seq34928__$1 = cljs.core.next.call(null,seq34928);
return om_tools.dom.marquee.cljs$core$IFn$_invoke$arity$variadic(G__34929,seq34928__$1);
});

om_tools.dom.marquee.cljs$lang$maxFixedArity = (1);

om_tools.dom.menu = (function om_tools$dom$menu(var_args){
var args34932 = [];
var len__17407__auto___35491 = arguments.length;
var i__17408__auto___35492 = (0);
while(true){
if((i__17408__auto___35492 < len__17407__auto___35491)){
args34932.push((arguments[i__17408__auto___35492]));

var G__35493 = (i__17408__auto___35492 + (1));
i__17408__auto___35492 = G__35493;
continue;
} else {
}
break;
}

var G__34936 = args34932.length;
switch (G__34936) {
case 0:
return om_tools.dom.menu.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34932.slice((1)),(0)));
return om_tools.dom.menu.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.menu.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.menu,null,null);
});

om_tools.dom.menu.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.menu,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.menu.cljs$lang$applyTo = (function (seq34933){
var G__34934 = cljs.core.first.call(null,seq34933);
var seq34933__$1 = cljs.core.next.call(null,seq34933);
return om_tools.dom.menu.cljs$core$IFn$_invoke$arity$variadic(G__34934,seq34933__$1);
});

om_tools.dom.menu.cljs$lang$maxFixedArity = (1);

om_tools.dom.menuitem = (function om_tools$dom$menuitem(var_args){
var args34937 = [];
var len__17407__auto___35495 = arguments.length;
var i__17408__auto___35496 = (0);
while(true){
if((i__17408__auto___35496 < len__17407__auto___35495)){
args34937.push((arguments[i__17408__auto___35496]));

var G__35497 = (i__17408__auto___35496 + (1));
i__17408__auto___35496 = G__35497;
continue;
} else {
}
break;
}

var G__34941 = args34937.length;
switch (G__34941) {
case 0:
return om_tools.dom.menuitem.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34937.slice((1)),(0)));
return om_tools.dom.menuitem.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.menuitem.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.menuitem,null,null);
});

om_tools.dom.menuitem.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.menuitem,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.menuitem.cljs$lang$applyTo = (function (seq34938){
var G__34939 = cljs.core.first.call(null,seq34938);
var seq34938__$1 = cljs.core.next.call(null,seq34938);
return om_tools.dom.menuitem.cljs$core$IFn$_invoke$arity$variadic(G__34939,seq34938__$1);
});

om_tools.dom.menuitem.cljs$lang$maxFixedArity = (1);

om_tools.dom.meta = (function om_tools$dom$meta(var_args){
var args34942 = [];
var len__17407__auto___35499 = arguments.length;
var i__17408__auto___35500 = (0);
while(true){
if((i__17408__auto___35500 < len__17407__auto___35499)){
args34942.push((arguments[i__17408__auto___35500]));

var G__35501 = (i__17408__auto___35500 + (1));
i__17408__auto___35500 = G__35501;
continue;
} else {
}
break;
}

var G__34946 = args34942.length;
switch (G__34946) {
case 0:
return om_tools.dom.meta.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34942.slice((1)),(0)));
return om_tools.dom.meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.meta.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.meta,null,null);
});

om_tools.dom.meta.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.meta,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.meta.cljs$lang$applyTo = (function (seq34943){
var G__34944 = cljs.core.first.call(null,seq34943);
var seq34943__$1 = cljs.core.next.call(null,seq34943);
return om_tools.dom.meta.cljs$core$IFn$_invoke$arity$variadic(G__34944,seq34943__$1);
});

om_tools.dom.meta.cljs$lang$maxFixedArity = (1);

om_tools.dom.meter = (function om_tools$dom$meter(var_args){
var args34947 = [];
var len__17407__auto___35503 = arguments.length;
var i__17408__auto___35504 = (0);
while(true){
if((i__17408__auto___35504 < len__17407__auto___35503)){
args34947.push((arguments[i__17408__auto___35504]));

var G__35505 = (i__17408__auto___35504 + (1));
i__17408__auto___35504 = G__35505;
continue;
} else {
}
break;
}

var G__34951 = args34947.length;
switch (G__34951) {
case 0:
return om_tools.dom.meter.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34947.slice((1)),(0)));
return om_tools.dom.meter.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.meter.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.meter,null,null);
});

om_tools.dom.meter.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.meter,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.meter.cljs$lang$applyTo = (function (seq34948){
var G__34949 = cljs.core.first.call(null,seq34948);
var seq34948__$1 = cljs.core.next.call(null,seq34948);
return om_tools.dom.meter.cljs$core$IFn$_invoke$arity$variadic(G__34949,seq34948__$1);
});

om_tools.dom.meter.cljs$lang$maxFixedArity = (1);

om_tools.dom.nav = (function om_tools$dom$nav(var_args){
var args34952 = [];
var len__17407__auto___35507 = arguments.length;
var i__17408__auto___35508 = (0);
while(true){
if((i__17408__auto___35508 < len__17407__auto___35507)){
args34952.push((arguments[i__17408__auto___35508]));

var G__35509 = (i__17408__auto___35508 + (1));
i__17408__auto___35508 = G__35509;
continue;
} else {
}
break;
}

var G__34956 = args34952.length;
switch (G__34956) {
case 0:
return om_tools.dom.nav.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34952.slice((1)),(0)));
return om_tools.dom.nav.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.nav.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.nav,null,null);
});

om_tools.dom.nav.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.nav,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.nav.cljs$lang$applyTo = (function (seq34953){
var G__34954 = cljs.core.first.call(null,seq34953);
var seq34953__$1 = cljs.core.next.call(null,seq34953);
return om_tools.dom.nav.cljs$core$IFn$_invoke$arity$variadic(G__34954,seq34953__$1);
});

om_tools.dom.nav.cljs$lang$maxFixedArity = (1);

om_tools.dom.noscript = (function om_tools$dom$noscript(var_args){
var args34957 = [];
var len__17407__auto___35511 = arguments.length;
var i__17408__auto___35512 = (0);
while(true){
if((i__17408__auto___35512 < len__17407__auto___35511)){
args34957.push((arguments[i__17408__auto___35512]));

var G__35513 = (i__17408__auto___35512 + (1));
i__17408__auto___35512 = G__35513;
continue;
} else {
}
break;
}

var G__34961 = args34957.length;
switch (G__34961) {
case 0:
return om_tools.dom.noscript.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34957.slice((1)),(0)));
return om_tools.dom.noscript.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.noscript.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.noscript,null,null);
});

om_tools.dom.noscript.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.noscript,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.noscript.cljs$lang$applyTo = (function (seq34958){
var G__34959 = cljs.core.first.call(null,seq34958);
var seq34958__$1 = cljs.core.next.call(null,seq34958);
return om_tools.dom.noscript.cljs$core$IFn$_invoke$arity$variadic(G__34959,seq34958__$1);
});

om_tools.dom.noscript.cljs$lang$maxFixedArity = (1);

om_tools.dom.object = (function om_tools$dom$object(var_args){
var args34962 = [];
var len__17407__auto___35515 = arguments.length;
var i__17408__auto___35516 = (0);
while(true){
if((i__17408__auto___35516 < len__17407__auto___35515)){
args34962.push((arguments[i__17408__auto___35516]));

var G__35517 = (i__17408__auto___35516 + (1));
i__17408__auto___35516 = G__35517;
continue;
} else {
}
break;
}

var G__34966 = args34962.length;
switch (G__34966) {
case 0:
return om_tools.dom.object.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34962.slice((1)),(0)));
return om_tools.dom.object.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.object.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.object,null,null);
});

om_tools.dom.object.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.object,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.object.cljs$lang$applyTo = (function (seq34963){
var G__34964 = cljs.core.first.call(null,seq34963);
var seq34963__$1 = cljs.core.next.call(null,seq34963);
return om_tools.dom.object.cljs$core$IFn$_invoke$arity$variadic(G__34964,seq34963__$1);
});

om_tools.dom.object.cljs$lang$maxFixedArity = (1);

om_tools.dom.ol = (function om_tools$dom$ol(var_args){
var args34967 = [];
var len__17407__auto___35519 = arguments.length;
var i__17408__auto___35520 = (0);
while(true){
if((i__17408__auto___35520 < len__17407__auto___35519)){
args34967.push((arguments[i__17408__auto___35520]));

var G__35521 = (i__17408__auto___35520 + (1));
i__17408__auto___35520 = G__35521;
continue;
} else {
}
break;
}

var G__34971 = args34967.length;
switch (G__34971) {
case 0:
return om_tools.dom.ol.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34967.slice((1)),(0)));
return om_tools.dom.ol.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.ol.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.ol,null,null);
});

om_tools.dom.ol.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.ol,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.ol.cljs$lang$applyTo = (function (seq34968){
var G__34969 = cljs.core.first.call(null,seq34968);
var seq34968__$1 = cljs.core.next.call(null,seq34968);
return om_tools.dom.ol.cljs$core$IFn$_invoke$arity$variadic(G__34969,seq34968__$1);
});

om_tools.dom.ol.cljs$lang$maxFixedArity = (1);

om_tools.dom.optgroup = (function om_tools$dom$optgroup(var_args){
var args34972 = [];
var len__17407__auto___35523 = arguments.length;
var i__17408__auto___35524 = (0);
while(true){
if((i__17408__auto___35524 < len__17407__auto___35523)){
args34972.push((arguments[i__17408__auto___35524]));

var G__35525 = (i__17408__auto___35524 + (1));
i__17408__auto___35524 = G__35525;
continue;
} else {
}
break;
}

var G__34976 = args34972.length;
switch (G__34976) {
case 0:
return om_tools.dom.optgroup.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34972.slice((1)),(0)));
return om_tools.dom.optgroup.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.optgroup.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.optgroup,null,null);
});

om_tools.dom.optgroup.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.optgroup,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.optgroup.cljs$lang$applyTo = (function (seq34973){
var G__34974 = cljs.core.first.call(null,seq34973);
var seq34973__$1 = cljs.core.next.call(null,seq34973);
return om_tools.dom.optgroup.cljs$core$IFn$_invoke$arity$variadic(G__34974,seq34973__$1);
});

om_tools.dom.optgroup.cljs$lang$maxFixedArity = (1);

om_tools.dom.output = (function om_tools$dom$output(var_args){
var args34977 = [];
var len__17407__auto___35527 = arguments.length;
var i__17408__auto___35528 = (0);
while(true){
if((i__17408__auto___35528 < len__17407__auto___35527)){
args34977.push((arguments[i__17408__auto___35528]));

var G__35529 = (i__17408__auto___35528 + (1));
i__17408__auto___35528 = G__35529;
continue;
} else {
}
break;
}

var G__34981 = args34977.length;
switch (G__34981) {
case 0:
return om_tools.dom.output.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34977.slice((1)),(0)));
return om_tools.dom.output.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.output.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.output,null,null);
});

om_tools.dom.output.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.output,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.output.cljs$lang$applyTo = (function (seq34978){
var G__34979 = cljs.core.first.call(null,seq34978);
var seq34978__$1 = cljs.core.next.call(null,seq34978);
return om_tools.dom.output.cljs$core$IFn$_invoke$arity$variadic(G__34979,seq34978__$1);
});

om_tools.dom.output.cljs$lang$maxFixedArity = (1);

om_tools.dom.p = (function om_tools$dom$p(var_args){
var args34982 = [];
var len__17407__auto___35531 = arguments.length;
var i__17408__auto___35532 = (0);
while(true){
if((i__17408__auto___35532 < len__17407__auto___35531)){
args34982.push((arguments[i__17408__auto___35532]));

var G__35533 = (i__17408__auto___35532 + (1));
i__17408__auto___35532 = G__35533;
continue;
} else {
}
break;
}

var G__34986 = args34982.length;
switch (G__34986) {
case 0:
return om_tools.dom.p.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34982.slice((1)),(0)));
return om_tools.dom.p.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.p.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.p,null,null);
});

om_tools.dom.p.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.p,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.p.cljs$lang$applyTo = (function (seq34983){
var G__34984 = cljs.core.first.call(null,seq34983);
var seq34983__$1 = cljs.core.next.call(null,seq34983);
return om_tools.dom.p.cljs$core$IFn$_invoke$arity$variadic(G__34984,seq34983__$1);
});

om_tools.dom.p.cljs$lang$maxFixedArity = (1);

om_tools.dom.param = (function om_tools$dom$param(var_args){
var args34987 = [];
var len__17407__auto___35535 = arguments.length;
var i__17408__auto___35536 = (0);
while(true){
if((i__17408__auto___35536 < len__17407__auto___35535)){
args34987.push((arguments[i__17408__auto___35536]));

var G__35537 = (i__17408__auto___35536 + (1));
i__17408__auto___35536 = G__35537;
continue;
} else {
}
break;
}

var G__34991 = args34987.length;
switch (G__34991) {
case 0:
return om_tools.dom.param.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34987.slice((1)),(0)));
return om_tools.dom.param.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.param.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.param,null,null);
});

om_tools.dom.param.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.param,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.param.cljs$lang$applyTo = (function (seq34988){
var G__34989 = cljs.core.first.call(null,seq34988);
var seq34988__$1 = cljs.core.next.call(null,seq34988);
return om_tools.dom.param.cljs$core$IFn$_invoke$arity$variadic(G__34989,seq34988__$1);
});

om_tools.dom.param.cljs$lang$maxFixedArity = (1);

om_tools.dom.pre = (function om_tools$dom$pre(var_args){
var args34992 = [];
var len__17407__auto___35539 = arguments.length;
var i__17408__auto___35540 = (0);
while(true){
if((i__17408__auto___35540 < len__17407__auto___35539)){
args34992.push((arguments[i__17408__auto___35540]));

var G__35541 = (i__17408__auto___35540 + (1));
i__17408__auto___35540 = G__35541;
continue;
} else {
}
break;
}

var G__34996 = args34992.length;
switch (G__34996) {
case 0:
return om_tools.dom.pre.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34992.slice((1)),(0)));
return om_tools.dom.pre.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.pre.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.pre,null,null);
});

om_tools.dom.pre.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.pre,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.pre.cljs$lang$applyTo = (function (seq34993){
var G__34994 = cljs.core.first.call(null,seq34993);
var seq34993__$1 = cljs.core.next.call(null,seq34993);
return om_tools.dom.pre.cljs$core$IFn$_invoke$arity$variadic(G__34994,seq34993__$1);
});

om_tools.dom.pre.cljs$lang$maxFixedArity = (1);

om_tools.dom.progress = (function om_tools$dom$progress(var_args){
var args34997 = [];
var len__17407__auto___35543 = arguments.length;
var i__17408__auto___35544 = (0);
while(true){
if((i__17408__auto___35544 < len__17407__auto___35543)){
args34997.push((arguments[i__17408__auto___35544]));

var G__35545 = (i__17408__auto___35544 + (1));
i__17408__auto___35544 = G__35545;
continue;
} else {
}
break;
}

var G__35001 = args34997.length;
switch (G__35001) {
case 0:
return om_tools.dom.progress.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34997.slice((1)),(0)));
return om_tools.dom.progress.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.progress.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.progress,null,null);
});

om_tools.dom.progress.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.progress,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.progress.cljs$lang$applyTo = (function (seq34998){
var G__34999 = cljs.core.first.call(null,seq34998);
var seq34998__$1 = cljs.core.next.call(null,seq34998);
return om_tools.dom.progress.cljs$core$IFn$_invoke$arity$variadic(G__34999,seq34998__$1);
});

om_tools.dom.progress.cljs$lang$maxFixedArity = (1);

om_tools.dom.q = (function om_tools$dom$q(var_args){
var args35002 = [];
var len__17407__auto___35547 = arguments.length;
var i__17408__auto___35548 = (0);
while(true){
if((i__17408__auto___35548 < len__17407__auto___35547)){
args35002.push((arguments[i__17408__auto___35548]));

var G__35549 = (i__17408__auto___35548 + (1));
i__17408__auto___35548 = G__35549;
continue;
} else {
}
break;
}

var G__35006 = args35002.length;
switch (G__35006) {
case 0:
return om_tools.dom.q.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35002.slice((1)),(0)));
return om_tools.dom.q.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.q.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.q,null,null);
});

om_tools.dom.q.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.q,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.q.cljs$lang$applyTo = (function (seq35003){
var G__35004 = cljs.core.first.call(null,seq35003);
var seq35003__$1 = cljs.core.next.call(null,seq35003);
return om_tools.dom.q.cljs$core$IFn$_invoke$arity$variadic(G__35004,seq35003__$1);
});

om_tools.dom.q.cljs$lang$maxFixedArity = (1);

om_tools.dom.rp = (function om_tools$dom$rp(var_args){
var args35007 = [];
var len__17407__auto___35551 = arguments.length;
var i__17408__auto___35552 = (0);
while(true){
if((i__17408__auto___35552 < len__17407__auto___35551)){
args35007.push((arguments[i__17408__auto___35552]));

var G__35553 = (i__17408__auto___35552 + (1));
i__17408__auto___35552 = G__35553;
continue;
} else {
}
break;
}

var G__35011 = args35007.length;
switch (G__35011) {
case 0:
return om_tools.dom.rp.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35007.slice((1)),(0)));
return om_tools.dom.rp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.rp.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.rp,null,null);
});

om_tools.dom.rp.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.rp,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.rp.cljs$lang$applyTo = (function (seq35008){
var G__35009 = cljs.core.first.call(null,seq35008);
var seq35008__$1 = cljs.core.next.call(null,seq35008);
return om_tools.dom.rp.cljs$core$IFn$_invoke$arity$variadic(G__35009,seq35008__$1);
});

om_tools.dom.rp.cljs$lang$maxFixedArity = (1);

om_tools.dom.rt = (function om_tools$dom$rt(var_args){
var args35012 = [];
var len__17407__auto___35555 = arguments.length;
var i__17408__auto___35556 = (0);
while(true){
if((i__17408__auto___35556 < len__17407__auto___35555)){
args35012.push((arguments[i__17408__auto___35556]));

var G__35557 = (i__17408__auto___35556 + (1));
i__17408__auto___35556 = G__35557;
continue;
} else {
}
break;
}

var G__35016 = args35012.length;
switch (G__35016) {
case 0:
return om_tools.dom.rt.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35012.slice((1)),(0)));
return om_tools.dom.rt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.rt.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.rt,null,null);
});

om_tools.dom.rt.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.rt,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.rt.cljs$lang$applyTo = (function (seq35013){
var G__35014 = cljs.core.first.call(null,seq35013);
var seq35013__$1 = cljs.core.next.call(null,seq35013);
return om_tools.dom.rt.cljs$core$IFn$_invoke$arity$variadic(G__35014,seq35013__$1);
});

om_tools.dom.rt.cljs$lang$maxFixedArity = (1);

om_tools.dom.ruby = (function om_tools$dom$ruby(var_args){
var args35017 = [];
var len__17407__auto___35559 = arguments.length;
var i__17408__auto___35560 = (0);
while(true){
if((i__17408__auto___35560 < len__17407__auto___35559)){
args35017.push((arguments[i__17408__auto___35560]));

var G__35561 = (i__17408__auto___35560 + (1));
i__17408__auto___35560 = G__35561;
continue;
} else {
}
break;
}

var G__35021 = args35017.length;
switch (G__35021) {
case 0:
return om_tools.dom.ruby.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35017.slice((1)),(0)));
return om_tools.dom.ruby.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.ruby.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.ruby,null,null);
});

om_tools.dom.ruby.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.ruby,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.ruby.cljs$lang$applyTo = (function (seq35018){
var G__35019 = cljs.core.first.call(null,seq35018);
var seq35018__$1 = cljs.core.next.call(null,seq35018);
return om_tools.dom.ruby.cljs$core$IFn$_invoke$arity$variadic(G__35019,seq35018__$1);
});

om_tools.dom.ruby.cljs$lang$maxFixedArity = (1);

om_tools.dom.s = (function om_tools$dom$s(var_args){
var args35022 = [];
var len__17407__auto___35563 = arguments.length;
var i__17408__auto___35564 = (0);
while(true){
if((i__17408__auto___35564 < len__17407__auto___35563)){
args35022.push((arguments[i__17408__auto___35564]));

var G__35565 = (i__17408__auto___35564 + (1));
i__17408__auto___35564 = G__35565;
continue;
} else {
}
break;
}

var G__35026 = args35022.length;
switch (G__35026) {
case 0:
return om_tools.dom.s.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35022.slice((1)),(0)));
return om_tools.dom.s.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.s.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.s,null,null);
});

om_tools.dom.s.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.s,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.s.cljs$lang$applyTo = (function (seq35023){
var G__35024 = cljs.core.first.call(null,seq35023);
var seq35023__$1 = cljs.core.next.call(null,seq35023);
return om_tools.dom.s.cljs$core$IFn$_invoke$arity$variadic(G__35024,seq35023__$1);
});

om_tools.dom.s.cljs$lang$maxFixedArity = (1);

om_tools.dom.samp = (function om_tools$dom$samp(var_args){
var args35027 = [];
var len__17407__auto___35567 = arguments.length;
var i__17408__auto___35568 = (0);
while(true){
if((i__17408__auto___35568 < len__17407__auto___35567)){
args35027.push((arguments[i__17408__auto___35568]));

var G__35569 = (i__17408__auto___35568 + (1));
i__17408__auto___35568 = G__35569;
continue;
} else {
}
break;
}

var G__35031 = args35027.length;
switch (G__35031) {
case 0:
return om_tools.dom.samp.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35027.slice((1)),(0)));
return om_tools.dom.samp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.samp.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.samp,null,null);
});

om_tools.dom.samp.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.samp,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.samp.cljs$lang$applyTo = (function (seq35028){
var G__35029 = cljs.core.first.call(null,seq35028);
var seq35028__$1 = cljs.core.next.call(null,seq35028);
return om_tools.dom.samp.cljs$core$IFn$_invoke$arity$variadic(G__35029,seq35028__$1);
});

om_tools.dom.samp.cljs$lang$maxFixedArity = (1);

om_tools.dom.script = (function om_tools$dom$script(var_args){
var args35032 = [];
var len__17407__auto___35571 = arguments.length;
var i__17408__auto___35572 = (0);
while(true){
if((i__17408__auto___35572 < len__17407__auto___35571)){
args35032.push((arguments[i__17408__auto___35572]));

var G__35573 = (i__17408__auto___35572 + (1));
i__17408__auto___35572 = G__35573;
continue;
} else {
}
break;
}

var G__35036 = args35032.length;
switch (G__35036) {
case 0:
return om_tools.dom.script.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35032.slice((1)),(0)));
return om_tools.dom.script.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.script.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.script,null,null);
});

om_tools.dom.script.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.script,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.script.cljs$lang$applyTo = (function (seq35033){
var G__35034 = cljs.core.first.call(null,seq35033);
var seq35033__$1 = cljs.core.next.call(null,seq35033);
return om_tools.dom.script.cljs$core$IFn$_invoke$arity$variadic(G__35034,seq35033__$1);
});

om_tools.dom.script.cljs$lang$maxFixedArity = (1);

om_tools.dom.section = (function om_tools$dom$section(var_args){
var args35037 = [];
var len__17407__auto___35575 = arguments.length;
var i__17408__auto___35576 = (0);
while(true){
if((i__17408__auto___35576 < len__17407__auto___35575)){
args35037.push((arguments[i__17408__auto___35576]));

var G__35577 = (i__17408__auto___35576 + (1));
i__17408__auto___35576 = G__35577;
continue;
} else {
}
break;
}

var G__35041 = args35037.length;
switch (G__35041) {
case 0:
return om_tools.dom.section.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35037.slice((1)),(0)));
return om_tools.dom.section.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.section.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.section,null,null);
});

om_tools.dom.section.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.section,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.section.cljs$lang$applyTo = (function (seq35038){
var G__35039 = cljs.core.first.call(null,seq35038);
var seq35038__$1 = cljs.core.next.call(null,seq35038);
return om_tools.dom.section.cljs$core$IFn$_invoke$arity$variadic(G__35039,seq35038__$1);
});

om_tools.dom.section.cljs$lang$maxFixedArity = (1);

om_tools.dom.select = (function om_tools$dom$select(var_args){
var args35042 = [];
var len__17407__auto___35579 = arguments.length;
var i__17408__auto___35580 = (0);
while(true){
if((i__17408__auto___35580 < len__17407__auto___35579)){
args35042.push((arguments[i__17408__auto___35580]));

var G__35581 = (i__17408__auto___35580 + (1));
i__17408__auto___35580 = G__35581;
continue;
} else {
}
break;
}

var G__35046 = args35042.length;
switch (G__35046) {
case 0:
return om_tools.dom.select.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35042.slice((1)),(0)));
return om_tools.dom.select.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.select.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.select,null,null);
});

om_tools.dom.select.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.select,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.select.cljs$lang$applyTo = (function (seq35043){
var G__35044 = cljs.core.first.call(null,seq35043);
var seq35043__$1 = cljs.core.next.call(null,seq35043);
return om_tools.dom.select.cljs$core$IFn$_invoke$arity$variadic(G__35044,seq35043__$1);
});

om_tools.dom.select.cljs$lang$maxFixedArity = (1);

om_tools.dom.small = (function om_tools$dom$small(var_args){
var args35047 = [];
var len__17407__auto___35583 = arguments.length;
var i__17408__auto___35584 = (0);
while(true){
if((i__17408__auto___35584 < len__17407__auto___35583)){
args35047.push((arguments[i__17408__auto___35584]));

var G__35585 = (i__17408__auto___35584 + (1));
i__17408__auto___35584 = G__35585;
continue;
} else {
}
break;
}

var G__35051 = args35047.length;
switch (G__35051) {
case 0:
return om_tools.dom.small.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35047.slice((1)),(0)));
return om_tools.dom.small.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.small.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.small,null,null);
});

om_tools.dom.small.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.small,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.small.cljs$lang$applyTo = (function (seq35048){
var G__35049 = cljs.core.first.call(null,seq35048);
var seq35048__$1 = cljs.core.next.call(null,seq35048);
return om_tools.dom.small.cljs$core$IFn$_invoke$arity$variadic(G__35049,seq35048__$1);
});

om_tools.dom.small.cljs$lang$maxFixedArity = (1);

om_tools.dom.source = (function om_tools$dom$source(var_args){
var args35052 = [];
var len__17407__auto___35587 = arguments.length;
var i__17408__auto___35588 = (0);
while(true){
if((i__17408__auto___35588 < len__17407__auto___35587)){
args35052.push((arguments[i__17408__auto___35588]));

var G__35589 = (i__17408__auto___35588 + (1));
i__17408__auto___35588 = G__35589;
continue;
} else {
}
break;
}

var G__35056 = args35052.length;
switch (G__35056) {
case 0:
return om_tools.dom.source.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35052.slice((1)),(0)));
return om_tools.dom.source.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.source.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.source,null,null);
});

om_tools.dom.source.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.source,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.source.cljs$lang$applyTo = (function (seq35053){
var G__35054 = cljs.core.first.call(null,seq35053);
var seq35053__$1 = cljs.core.next.call(null,seq35053);
return om_tools.dom.source.cljs$core$IFn$_invoke$arity$variadic(G__35054,seq35053__$1);
});

om_tools.dom.source.cljs$lang$maxFixedArity = (1);

om_tools.dom.span = (function om_tools$dom$span(var_args){
var args35057 = [];
var len__17407__auto___35591 = arguments.length;
var i__17408__auto___35592 = (0);
while(true){
if((i__17408__auto___35592 < len__17407__auto___35591)){
args35057.push((arguments[i__17408__auto___35592]));

var G__35593 = (i__17408__auto___35592 + (1));
i__17408__auto___35592 = G__35593;
continue;
} else {
}
break;
}

var G__35061 = args35057.length;
switch (G__35061) {
case 0:
return om_tools.dom.span.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35057.slice((1)),(0)));
return om_tools.dom.span.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.span.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.span,null,null);
});

om_tools.dom.span.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.span,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.span.cljs$lang$applyTo = (function (seq35058){
var G__35059 = cljs.core.first.call(null,seq35058);
var seq35058__$1 = cljs.core.next.call(null,seq35058);
return om_tools.dom.span.cljs$core$IFn$_invoke$arity$variadic(G__35059,seq35058__$1);
});

om_tools.dom.span.cljs$lang$maxFixedArity = (1);

om_tools.dom.strong = (function om_tools$dom$strong(var_args){
var args35062 = [];
var len__17407__auto___35595 = arguments.length;
var i__17408__auto___35596 = (0);
while(true){
if((i__17408__auto___35596 < len__17407__auto___35595)){
args35062.push((arguments[i__17408__auto___35596]));

var G__35597 = (i__17408__auto___35596 + (1));
i__17408__auto___35596 = G__35597;
continue;
} else {
}
break;
}

var G__35066 = args35062.length;
switch (G__35066) {
case 0:
return om_tools.dom.strong.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35062.slice((1)),(0)));
return om_tools.dom.strong.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.strong.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.strong,null,null);
});

om_tools.dom.strong.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.strong,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.strong.cljs$lang$applyTo = (function (seq35063){
var G__35064 = cljs.core.first.call(null,seq35063);
var seq35063__$1 = cljs.core.next.call(null,seq35063);
return om_tools.dom.strong.cljs$core$IFn$_invoke$arity$variadic(G__35064,seq35063__$1);
});

om_tools.dom.strong.cljs$lang$maxFixedArity = (1);

om_tools.dom.style = (function om_tools$dom$style(var_args){
var args35067 = [];
var len__17407__auto___35599 = arguments.length;
var i__17408__auto___35600 = (0);
while(true){
if((i__17408__auto___35600 < len__17407__auto___35599)){
args35067.push((arguments[i__17408__auto___35600]));

var G__35601 = (i__17408__auto___35600 + (1));
i__17408__auto___35600 = G__35601;
continue;
} else {
}
break;
}

var G__35071 = args35067.length;
switch (G__35071) {
case 0:
return om_tools.dom.style.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35067.slice((1)),(0)));
return om_tools.dom.style.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.style.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.style,null,null);
});

om_tools.dom.style.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.style,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.style.cljs$lang$applyTo = (function (seq35068){
var G__35069 = cljs.core.first.call(null,seq35068);
var seq35068__$1 = cljs.core.next.call(null,seq35068);
return om_tools.dom.style.cljs$core$IFn$_invoke$arity$variadic(G__35069,seq35068__$1);
});

om_tools.dom.style.cljs$lang$maxFixedArity = (1);

om_tools.dom.sub = (function om_tools$dom$sub(var_args){
var args35072 = [];
var len__17407__auto___35603 = arguments.length;
var i__17408__auto___35604 = (0);
while(true){
if((i__17408__auto___35604 < len__17407__auto___35603)){
args35072.push((arguments[i__17408__auto___35604]));

var G__35605 = (i__17408__auto___35604 + (1));
i__17408__auto___35604 = G__35605;
continue;
} else {
}
break;
}

var G__35076 = args35072.length;
switch (G__35076) {
case 0:
return om_tools.dom.sub.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35072.slice((1)),(0)));
return om_tools.dom.sub.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.sub.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.sub,null,null);
});

om_tools.dom.sub.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.sub,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.sub.cljs$lang$applyTo = (function (seq35073){
var G__35074 = cljs.core.first.call(null,seq35073);
var seq35073__$1 = cljs.core.next.call(null,seq35073);
return om_tools.dom.sub.cljs$core$IFn$_invoke$arity$variadic(G__35074,seq35073__$1);
});

om_tools.dom.sub.cljs$lang$maxFixedArity = (1);

om_tools.dom.summary = (function om_tools$dom$summary(var_args){
var args35077 = [];
var len__17407__auto___35607 = arguments.length;
var i__17408__auto___35608 = (0);
while(true){
if((i__17408__auto___35608 < len__17407__auto___35607)){
args35077.push((arguments[i__17408__auto___35608]));

var G__35609 = (i__17408__auto___35608 + (1));
i__17408__auto___35608 = G__35609;
continue;
} else {
}
break;
}

var G__35081 = args35077.length;
switch (G__35081) {
case 0:
return om_tools.dom.summary.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35077.slice((1)),(0)));
return om_tools.dom.summary.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.summary.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.summary,null,null);
});

om_tools.dom.summary.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.summary,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.summary.cljs$lang$applyTo = (function (seq35078){
var G__35079 = cljs.core.first.call(null,seq35078);
var seq35078__$1 = cljs.core.next.call(null,seq35078);
return om_tools.dom.summary.cljs$core$IFn$_invoke$arity$variadic(G__35079,seq35078__$1);
});

om_tools.dom.summary.cljs$lang$maxFixedArity = (1);

om_tools.dom.sup = (function om_tools$dom$sup(var_args){
var args35082 = [];
var len__17407__auto___35611 = arguments.length;
var i__17408__auto___35612 = (0);
while(true){
if((i__17408__auto___35612 < len__17407__auto___35611)){
args35082.push((arguments[i__17408__auto___35612]));

var G__35613 = (i__17408__auto___35612 + (1));
i__17408__auto___35612 = G__35613;
continue;
} else {
}
break;
}

var G__35086 = args35082.length;
switch (G__35086) {
case 0:
return om_tools.dom.sup.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35082.slice((1)),(0)));
return om_tools.dom.sup.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.sup.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.sup,null,null);
});

om_tools.dom.sup.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.sup,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.sup.cljs$lang$applyTo = (function (seq35083){
var G__35084 = cljs.core.first.call(null,seq35083);
var seq35083__$1 = cljs.core.next.call(null,seq35083);
return om_tools.dom.sup.cljs$core$IFn$_invoke$arity$variadic(G__35084,seq35083__$1);
});

om_tools.dom.sup.cljs$lang$maxFixedArity = (1);

om_tools.dom.table = (function om_tools$dom$table(var_args){
var args35087 = [];
var len__17407__auto___35615 = arguments.length;
var i__17408__auto___35616 = (0);
while(true){
if((i__17408__auto___35616 < len__17407__auto___35615)){
args35087.push((arguments[i__17408__auto___35616]));

var G__35617 = (i__17408__auto___35616 + (1));
i__17408__auto___35616 = G__35617;
continue;
} else {
}
break;
}

var G__35091 = args35087.length;
switch (G__35091) {
case 0:
return om_tools.dom.table.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35087.slice((1)),(0)));
return om_tools.dom.table.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.table.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.table,null,null);
});

om_tools.dom.table.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.table,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.table.cljs$lang$applyTo = (function (seq35088){
var G__35089 = cljs.core.first.call(null,seq35088);
var seq35088__$1 = cljs.core.next.call(null,seq35088);
return om_tools.dom.table.cljs$core$IFn$_invoke$arity$variadic(G__35089,seq35088__$1);
});

om_tools.dom.table.cljs$lang$maxFixedArity = (1);

om_tools.dom.tbody = (function om_tools$dom$tbody(var_args){
var args35092 = [];
var len__17407__auto___35619 = arguments.length;
var i__17408__auto___35620 = (0);
while(true){
if((i__17408__auto___35620 < len__17407__auto___35619)){
args35092.push((arguments[i__17408__auto___35620]));

var G__35621 = (i__17408__auto___35620 + (1));
i__17408__auto___35620 = G__35621;
continue;
} else {
}
break;
}

var G__35096 = args35092.length;
switch (G__35096) {
case 0:
return om_tools.dom.tbody.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35092.slice((1)),(0)));
return om_tools.dom.tbody.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.tbody.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.tbody,null,null);
});

om_tools.dom.tbody.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.tbody,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.tbody.cljs$lang$applyTo = (function (seq35093){
var G__35094 = cljs.core.first.call(null,seq35093);
var seq35093__$1 = cljs.core.next.call(null,seq35093);
return om_tools.dom.tbody.cljs$core$IFn$_invoke$arity$variadic(G__35094,seq35093__$1);
});

om_tools.dom.tbody.cljs$lang$maxFixedArity = (1);

om_tools.dom.td = (function om_tools$dom$td(var_args){
var args35097 = [];
var len__17407__auto___35623 = arguments.length;
var i__17408__auto___35624 = (0);
while(true){
if((i__17408__auto___35624 < len__17407__auto___35623)){
args35097.push((arguments[i__17408__auto___35624]));

var G__35625 = (i__17408__auto___35624 + (1));
i__17408__auto___35624 = G__35625;
continue;
} else {
}
break;
}

var G__35101 = args35097.length;
switch (G__35101) {
case 0:
return om_tools.dom.td.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35097.slice((1)),(0)));
return om_tools.dom.td.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.td.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.td,null,null);
});

om_tools.dom.td.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.td,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.td.cljs$lang$applyTo = (function (seq35098){
var G__35099 = cljs.core.first.call(null,seq35098);
var seq35098__$1 = cljs.core.next.call(null,seq35098);
return om_tools.dom.td.cljs$core$IFn$_invoke$arity$variadic(G__35099,seq35098__$1);
});

om_tools.dom.td.cljs$lang$maxFixedArity = (1);

om_tools.dom.tfoot = (function om_tools$dom$tfoot(var_args){
var args35102 = [];
var len__17407__auto___35627 = arguments.length;
var i__17408__auto___35628 = (0);
while(true){
if((i__17408__auto___35628 < len__17407__auto___35627)){
args35102.push((arguments[i__17408__auto___35628]));

var G__35629 = (i__17408__auto___35628 + (1));
i__17408__auto___35628 = G__35629;
continue;
} else {
}
break;
}

var G__35106 = args35102.length;
switch (G__35106) {
case 0:
return om_tools.dom.tfoot.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35102.slice((1)),(0)));
return om_tools.dom.tfoot.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.tfoot.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.tfoot,null,null);
});

om_tools.dom.tfoot.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.tfoot,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.tfoot.cljs$lang$applyTo = (function (seq35103){
var G__35104 = cljs.core.first.call(null,seq35103);
var seq35103__$1 = cljs.core.next.call(null,seq35103);
return om_tools.dom.tfoot.cljs$core$IFn$_invoke$arity$variadic(G__35104,seq35103__$1);
});

om_tools.dom.tfoot.cljs$lang$maxFixedArity = (1);

om_tools.dom.th = (function om_tools$dom$th(var_args){
var args35107 = [];
var len__17407__auto___35631 = arguments.length;
var i__17408__auto___35632 = (0);
while(true){
if((i__17408__auto___35632 < len__17407__auto___35631)){
args35107.push((arguments[i__17408__auto___35632]));

var G__35633 = (i__17408__auto___35632 + (1));
i__17408__auto___35632 = G__35633;
continue;
} else {
}
break;
}

var G__35111 = args35107.length;
switch (G__35111) {
case 0:
return om_tools.dom.th.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35107.slice((1)),(0)));
return om_tools.dom.th.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.th.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.th,null,null);
});

om_tools.dom.th.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.th,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.th.cljs$lang$applyTo = (function (seq35108){
var G__35109 = cljs.core.first.call(null,seq35108);
var seq35108__$1 = cljs.core.next.call(null,seq35108);
return om_tools.dom.th.cljs$core$IFn$_invoke$arity$variadic(G__35109,seq35108__$1);
});

om_tools.dom.th.cljs$lang$maxFixedArity = (1);

om_tools.dom.thead = (function om_tools$dom$thead(var_args){
var args35112 = [];
var len__17407__auto___35635 = arguments.length;
var i__17408__auto___35636 = (0);
while(true){
if((i__17408__auto___35636 < len__17407__auto___35635)){
args35112.push((arguments[i__17408__auto___35636]));

var G__35637 = (i__17408__auto___35636 + (1));
i__17408__auto___35636 = G__35637;
continue;
} else {
}
break;
}

var G__35116 = args35112.length;
switch (G__35116) {
case 0:
return om_tools.dom.thead.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35112.slice((1)),(0)));
return om_tools.dom.thead.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.thead.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.thead,null,null);
});

om_tools.dom.thead.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.thead,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.thead.cljs$lang$applyTo = (function (seq35113){
var G__35114 = cljs.core.first.call(null,seq35113);
var seq35113__$1 = cljs.core.next.call(null,seq35113);
return om_tools.dom.thead.cljs$core$IFn$_invoke$arity$variadic(G__35114,seq35113__$1);
});

om_tools.dom.thead.cljs$lang$maxFixedArity = (1);

om_tools.dom.time = (function om_tools$dom$time(var_args){
var args35117 = [];
var len__17407__auto___35639 = arguments.length;
var i__17408__auto___35640 = (0);
while(true){
if((i__17408__auto___35640 < len__17407__auto___35639)){
args35117.push((arguments[i__17408__auto___35640]));

var G__35641 = (i__17408__auto___35640 + (1));
i__17408__auto___35640 = G__35641;
continue;
} else {
}
break;
}

var G__35121 = args35117.length;
switch (G__35121) {
case 0:
return om_tools.dom.time.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35117.slice((1)),(0)));
return om_tools.dom.time.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.time.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.time,null,null);
});

om_tools.dom.time.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.time,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.time.cljs$lang$applyTo = (function (seq35118){
var G__35119 = cljs.core.first.call(null,seq35118);
var seq35118__$1 = cljs.core.next.call(null,seq35118);
return om_tools.dom.time.cljs$core$IFn$_invoke$arity$variadic(G__35119,seq35118__$1);
});

om_tools.dom.time.cljs$lang$maxFixedArity = (1);

om_tools.dom.title = (function om_tools$dom$title(var_args){
var args35122 = [];
var len__17407__auto___35643 = arguments.length;
var i__17408__auto___35644 = (0);
while(true){
if((i__17408__auto___35644 < len__17407__auto___35643)){
args35122.push((arguments[i__17408__auto___35644]));

var G__35645 = (i__17408__auto___35644 + (1));
i__17408__auto___35644 = G__35645;
continue;
} else {
}
break;
}

var G__35126 = args35122.length;
switch (G__35126) {
case 0:
return om_tools.dom.title.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35122.slice((1)),(0)));
return om_tools.dom.title.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.title.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.title,null,null);
});

om_tools.dom.title.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.title,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.title.cljs$lang$applyTo = (function (seq35123){
var G__35124 = cljs.core.first.call(null,seq35123);
var seq35123__$1 = cljs.core.next.call(null,seq35123);
return om_tools.dom.title.cljs$core$IFn$_invoke$arity$variadic(G__35124,seq35123__$1);
});

om_tools.dom.title.cljs$lang$maxFixedArity = (1);

om_tools.dom.tr = (function om_tools$dom$tr(var_args){
var args35127 = [];
var len__17407__auto___35647 = arguments.length;
var i__17408__auto___35648 = (0);
while(true){
if((i__17408__auto___35648 < len__17407__auto___35647)){
args35127.push((arguments[i__17408__auto___35648]));

var G__35649 = (i__17408__auto___35648 + (1));
i__17408__auto___35648 = G__35649;
continue;
} else {
}
break;
}

var G__35131 = args35127.length;
switch (G__35131) {
case 0:
return om_tools.dom.tr.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35127.slice((1)),(0)));
return om_tools.dom.tr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.tr.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.tr,null,null);
});

om_tools.dom.tr.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.tr,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.tr.cljs$lang$applyTo = (function (seq35128){
var G__35129 = cljs.core.first.call(null,seq35128);
var seq35128__$1 = cljs.core.next.call(null,seq35128);
return om_tools.dom.tr.cljs$core$IFn$_invoke$arity$variadic(G__35129,seq35128__$1);
});

om_tools.dom.tr.cljs$lang$maxFixedArity = (1);

om_tools.dom.track = (function om_tools$dom$track(var_args){
var args35132 = [];
var len__17407__auto___35651 = arguments.length;
var i__17408__auto___35652 = (0);
while(true){
if((i__17408__auto___35652 < len__17407__auto___35651)){
args35132.push((arguments[i__17408__auto___35652]));

var G__35653 = (i__17408__auto___35652 + (1));
i__17408__auto___35652 = G__35653;
continue;
} else {
}
break;
}

var G__35136 = args35132.length;
switch (G__35136) {
case 0:
return om_tools.dom.track.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35132.slice((1)),(0)));
return om_tools.dom.track.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.track.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.track,null,null);
});

om_tools.dom.track.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.track,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.track.cljs$lang$applyTo = (function (seq35133){
var G__35134 = cljs.core.first.call(null,seq35133);
var seq35133__$1 = cljs.core.next.call(null,seq35133);
return om_tools.dom.track.cljs$core$IFn$_invoke$arity$variadic(G__35134,seq35133__$1);
});

om_tools.dom.track.cljs$lang$maxFixedArity = (1);

om_tools.dom.u = (function om_tools$dom$u(var_args){
var args35137 = [];
var len__17407__auto___35655 = arguments.length;
var i__17408__auto___35656 = (0);
while(true){
if((i__17408__auto___35656 < len__17407__auto___35655)){
args35137.push((arguments[i__17408__auto___35656]));

var G__35657 = (i__17408__auto___35656 + (1));
i__17408__auto___35656 = G__35657;
continue;
} else {
}
break;
}

var G__35141 = args35137.length;
switch (G__35141) {
case 0:
return om_tools.dom.u.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35137.slice((1)),(0)));
return om_tools.dom.u.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.u.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.u,null,null);
});

om_tools.dom.u.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.u,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.u.cljs$lang$applyTo = (function (seq35138){
var G__35139 = cljs.core.first.call(null,seq35138);
var seq35138__$1 = cljs.core.next.call(null,seq35138);
return om_tools.dom.u.cljs$core$IFn$_invoke$arity$variadic(G__35139,seq35138__$1);
});

om_tools.dom.u.cljs$lang$maxFixedArity = (1);

om_tools.dom.ul = (function om_tools$dom$ul(var_args){
var args35142 = [];
var len__17407__auto___35659 = arguments.length;
var i__17408__auto___35660 = (0);
while(true){
if((i__17408__auto___35660 < len__17407__auto___35659)){
args35142.push((arguments[i__17408__auto___35660]));

var G__35661 = (i__17408__auto___35660 + (1));
i__17408__auto___35660 = G__35661;
continue;
} else {
}
break;
}

var G__35146 = args35142.length;
switch (G__35146) {
case 0:
return om_tools.dom.ul.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35142.slice((1)),(0)));
return om_tools.dom.ul.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.ul.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.ul,null,null);
});

om_tools.dom.ul.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.ul,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.ul.cljs$lang$applyTo = (function (seq35143){
var G__35144 = cljs.core.first.call(null,seq35143);
var seq35143__$1 = cljs.core.next.call(null,seq35143);
return om_tools.dom.ul.cljs$core$IFn$_invoke$arity$variadic(G__35144,seq35143__$1);
});

om_tools.dom.ul.cljs$lang$maxFixedArity = (1);

om_tools.dom.var$ = (function om_tools$dom$var(var_args){
var args35147 = [];
var len__17407__auto___35663 = arguments.length;
var i__17408__auto___35664 = (0);
while(true){
if((i__17408__auto___35664 < len__17407__auto___35663)){
args35147.push((arguments[i__17408__auto___35664]));

var G__35665 = (i__17408__auto___35664 + (1));
i__17408__auto___35664 = G__35665;
continue;
} else {
}
break;
}

var G__35151 = args35147.length;
switch (G__35151) {
case 0:
return om_tools.dom.var$.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35147.slice((1)),(0)));
return om_tools.dom.var$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.var$.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.var$,null,null);
});

om_tools.dom.var$.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.var$,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.var$.cljs$lang$applyTo = (function (seq35148){
var G__35149 = cljs.core.first.call(null,seq35148);
var seq35148__$1 = cljs.core.next.call(null,seq35148);
return om_tools.dom.var$.cljs$core$IFn$_invoke$arity$variadic(G__35149,seq35148__$1);
});

om_tools.dom.var$.cljs$lang$maxFixedArity = (1);

om_tools.dom.video = (function om_tools$dom$video(var_args){
var args35152 = [];
var len__17407__auto___35667 = arguments.length;
var i__17408__auto___35668 = (0);
while(true){
if((i__17408__auto___35668 < len__17407__auto___35667)){
args35152.push((arguments[i__17408__auto___35668]));

var G__35669 = (i__17408__auto___35668 + (1));
i__17408__auto___35668 = G__35669;
continue;
} else {
}
break;
}

var G__35156 = args35152.length;
switch (G__35156) {
case 0:
return om_tools.dom.video.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35152.slice((1)),(0)));
return om_tools.dom.video.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.video.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.video,null,null);
});

om_tools.dom.video.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.video,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.video.cljs$lang$applyTo = (function (seq35153){
var G__35154 = cljs.core.first.call(null,seq35153);
var seq35153__$1 = cljs.core.next.call(null,seq35153);
return om_tools.dom.video.cljs$core$IFn$_invoke$arity$variadic(G__35154,seq35153__$1);
});

om_tools.dom.video.cljs$lang$maxFixedArity = (1);

om_tools.dom.wbr = (function om_tools$dom$wbr(var_args){
var args35157 = [];
var len__17407__auto___35671 = arguments.length;
var i__17408__auto___35672 = (0);
while(true){
if((i__17408__auto___35672 < len__17407__auto___35671)){
args35157.push((arguments[i__17408__auto___35672]));

var G__35673 = (i__17408__auto___35672 + (1));
i__17408__auto___35672 = G__35673;
continue;
} else {
}
break;
}

var G__35161 = args35157.length;
switch (G__35161) {
case 0:
return om_tools.dom.wbr.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35157.slice((1)),(0)));
return om_tools.dom.wbr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.wbr.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.wbr,null,null);
});

om_tools.dom.wbr.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.wbr,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.wbr.cljs$lang$applyTo = (function (seq35158){
var G__35159 = cljs.core.first.call(null,seq35158);
var seq35158__$1 = cljs.core.next.call(null,seq35158);
return om_tools.dom.wbr.cljs$core$IFn$_invoke$arity$variadic(G__35159,seq35158__$1);
});

om_tools.dom.wbr.cljs$lang$maxFixedArity = (1);

om_tools.dom.circle = (function om_tools$dom$circle(var_args){
var args35162 = [];
var len__17407__auto___35675 = arguments.length;
var i__17408__auto___35676 = (0);
while(true){
if((i__17408__auto___35676 < len__17407__auto___35675)){
args35162.push((arguments[i__17408__auto___35676]));

var G__35677 = (i__17408__auto___35676 + (1));
i__17408__auto___35676 = G__35677;
continue;
} else {
}
break;
}

var G__35166 = args35162.length;
switch (G__35166) {
case 0:
return om_tools.dom.circle.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35162.slice((1)),(0)));
return om_tools.dom.circle.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.circle.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.circle,null,null);
});

om_tools.dom.circle.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.circle,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.circle.cljs$lang$applyTo = (function (seq35163){
var G__35164 = cljs.core.first.call(null,seq35163);
var seq35163__$1 = cljs.core.next.call(null,seq35163);
return om_tools.dom.circle.cljs$core$IFn$_invoke$arity$variadic(G__35164,seq35163__$1);
});

om_tools.dom.circle.cljs$lang$maxFixedArity = (1);

om_tools.dom.ellipse = (function om_tools$dom$ellipse(var_args){
var args35167 = [];
var len__17407__auto___35679 = arguments.length;
var i__17408__auto___35680 = (0);
while(true){
if((i__17408__auto___35680 < len__17407__auto___35679)){
args35167.push((arguments[i__17408__auto___35680]));

var G__35681 = (i__17408__auto___35680 + (1));
i__17408__auto___35680 = G__35681;
continue;
} else {
}
break;
}

var G__35171 = args35167.length;
switch (G__35171) {
case 0:
return om_tools.dom.ellipse.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35167.slice((1)),(0)));
return om_tools.dom.ellipse.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.ellipse.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.ellipse,null,null);
});

om_tools.dom.ellipse.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.ellipse,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.ellipse.cljs$lang$applyTo = (function (seq35168){
var G__35169 = cljs.core.first.call(null,seq35168);
var seq35168__$1 = cljs.core.next.call(null,seq35168);
return om_tools.dom.ellipse.cljs$core$IFn$_invoke$arity$variadic(G__35169,seq35168__$1);
});

om_tools.dom.ellipse.cljs$lang$maxFixedArity = (1);

om_tools.dom.g = (function om_tools$dom$g(var_args){
var args35172 = [];
var len__17407__auto___35683 = arguments.length;
var i__17408__auto___35684 = (0);
while(true){
if((i__17408__auto___35684 < len__17407__auto___35683)){
args35172.push((arguments[i__17408__auto___35684]));

var G__35685 = (i__17408__auto___35684 + (1));
i__17408__auto___35684 = G__35685;
continue;
} else {
}
break;
}

var G__35176 = args35172.length;
switch (G__35176) {
case 0:
return om_tools.dom.g.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35172.slice((1)),(0)));
return om_tools.dom.g.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.g.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.g,null,null);
});

om_tools.dom.g.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.g,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.g.cljs$lang$applyTo = (function (seq35173){
var G__35174 = cljs.core.first.call(null,seq35173);
var seq35173__$1 = cljs.core.next.call(null,seq35173);
return om_tools.dom.g.cljs$core$IFn$_invoke$arity$variadic(G__35174,seq35173__$1);
});

om_tools.dom.g.cljs$lang$maxFixedArity = (1);

om_tools.dom.line = (function om_tools$dom$line(var_args){
var args35177 = [];
var len__17407__auto___35687 = arguments.length;
var i__17408__auto___35688 = (0);
while(true){
if((i__17408__auto___35688 < len__17407__auto___35687)){
args35177.push((arguments[i__17408__auto___35688]));

var G__35689 = (i__17408__auto___35688 + (1));
i__17408__auto___35688 = G__35689;
continue;
} else {
}
break;
}

var G__35181 = args35177.length;
switch (G__35181) {
case 0:
return om_tools.dom.line.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35177.slice((1)),(0)));
return om_tools.dom.line.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.line.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.line,null,null);
});

om_tools.dom.line.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.line,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.line.cljs$lang$applyTo = (function (seq35178){
var G__35179 = cljs.core.first.call(null,seq35178);
var seq35178__$1 = cljs.core.next.call(null,seq35178);
return om_tools.dom.line.cljs$core$IFn$_invoke$arity$variadic(G__35179,seq35178__$1);
});

om_tools.dom.line.cljs$lang$maxFixedArity = (1);

om_tools.dom.path = (function om_tools$dom$path(var_args){
var args35182 = [];
var len__17407__auto___35691 = arguments.length;
var i__17408__auto___35692 = (0);
while(true){
if((i__17408__auto___35692 < len__17407__auto___35691)){
args35182.push((arguments[i__17408__auto___35692]));

var G__35693 = (i__17408__auto___35692 + (1));
i__17408__auto___35692 = G__35693;
continue;
} else {
}
break;
}

var G__35186 = args35182.length;
switch (G__35186) {
case 0:
return om_tools.dom.path.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35182.slice((1)),(0)));
return om_tools.dom.path.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.path.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.path,null,null);
});

om_tools.dom.path.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.path,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.path.cljs$lang$applyTo = (function (seq35183){
var G__35184 = cljs.core.first.call(null,seq35183);
var seq35183__$1 = cljs.core.next.call(null,seq35183);
return om_tools.dom.path.cljs$core$IFn$_invoke$arity$variadic(G__35184,seq35183__$1);
});

om_tools.dom.path.cljs$lang$maxFixedArity = (1);

om_tools.dom.polyline = (function om_tools$dom$polyline(var_args){
var args35187 = [];
var len__17407__auto___35695 = arguments.length;
var i__17408__auto___35696 = (0);
while(true){
if((i__17408__auto___35696 < len__17407__auto___35695)){
args35187.push((arguments[i__17408__auto___35696]));

var G__35697 = (i__17408__auto___35696 + (1));
i__17408__auto___35696 = G__35697;
continue;
} else {
}
break;
}

var G__35191 = args35187.length;
switch (G__35191) {
case 0:
return om_tools.dom.polyline.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35187.slice((1)),(0)));
return om_tools.dom.polyline.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.polyline.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.polyline,null,null);
});

om_tools.dom.polyline.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.polyline,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.polyline.cljs$lang$applyTo = (function (seq35188){
var G__35189 = cljs.core.first.call(null,seq35188);
var seq35188__$1 = cljs.core.next.call(null,seq35188);
return om_tools.dom.polyline.cljs$core$IFn$_invoke$arity$variadic(G__35189,seq35188__$1);
});

om_tools.dom.polyline.cljs$lang$maxFixedArity = (1);

om_tools.dom.rect = (function om_tools$dom$rect(var_args){
var args35192 = [];
var len__17407__auto___35699 = arguments.length;
var i__17408__auto___35700 = (0);
while(true){
if((i__17408__auto___35700 < len__17407__auto___35699)){
args35192.push((arguments[i__17408__auto___35700]));

var G__35701 = (i__17408__auto___35700 + (1));
i__17408__auto___35700 = G__35701;
continue;
} else {
}
break;
}

var G__35196 = args35192.length;
switch (G__35196) {
case 0:
return om_tools.dom.rect.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35192.slice((1)),(0)));
return om_tools.dom.rect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.rect.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.rect,null,null);
});

om_tools.dom.rect.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.rect,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.rect.cljs$lang$applyTo = (function (seq35193){
var G__35194 = cljs.core.first.call(null,seq35193);
var seq35193__$1 = cljs.core.next.call(null,seq35193);
return om_tools.dom.rect.cljs$core$IFn$_invoke$arity$variadic(G__35194,seq35193__$1);
});

om_tools.dom.rect.cljs$lang$maxFixedArity = (1);

om_tools.dom.svg = (function om_tools$dom$svg(var_args){
var args35197 = [];
var len__17407__auto___35703 = arguments.length;
var i__17408__auto___35704 = (0);
while(true){
if((i__17408__auto___35704 < len__17407__auto___35703)){
args35197.push((arguments[i__17408__auto___35704]));

var G__35705 = (i__17408__auto___35704 + (1));
i__17408__auto___35704 = G__35705;
continue;
} else {
}
break;
}

var G__35201 = args35197.length;
switch (G__35201) {
case 0:
return om_tools.dom.svg.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35197.slice((1)),(0)));
return om_tools.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.svg.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.svg,null,null);
});

om_tools.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.svg,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.svg.cljs$lang$applyTo = (function (seq35198){
var G__35199 = cljs.core.first.call(null,seq35198);
var seq35198__$1 = cljs.core.next.call(null,seq35198);
return om_tools.dom.svg.cljs$core$IFn$_invoke$arity$variadic(G__35199,seq35198__$1);
});

om_tools.dom.svg.cljs$lang$maxFixedArity = (1);

om_tools.dom.text = (function om_tools$dom$text(var_args){
var args35202 = [];
var len__17407__auto___35707 = arguments.length;
var i__17408__auto___35708 = (0);
while(true){
if((i__17408__auto___35708 < len__17407__auto___35707)){
args35202.push((arguments[i__17408__auto___35708]));

var G__35709 = (i__17408__auto___35708 + (1));
i__17408__auto___35708 = G__35709;
continue;
} else {
}
break;
}

var G__35206 = args35202.length;
switch (G__35206) {
case 0:
return om_tools.dom.text.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35202.slice((1)),(0)));
return om_tools.dom.text.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.text.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.text,null,null);
});

om_tools.dom.text.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.text,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.text.cljs$lang$applyTo = (function (seq35203){
var G__35204 = cljs.core.first.call(null,seq35203);
var seq35203__$1 = cljs.core.next.call(null,seq35203);
return om_tools.dom.text.cljs$core$IFn$_invoke$arity$variadic(G__35204,seq35203__$1);
});

om_tools.dom.text.cljs$lang$maxFixedArity = (1);

om_tools.dom.defs = (function om_tools$dom$defs(var_args){
var args35207 = [];
var len__17407__auto___35711 = arguments.length;
var i__17408__auto___35712 = (0);
while(true){
if((i__17408__auto___35712 < len__17407__auto___35711)){
args35207.push((arguments[i__17408__auto___35712]));

var G__35713 = (i__17408__auto___35712 + (1));
i__17408__auto___35712 = G__35713;
continue;
} else {
}
break;
}

var G__35211 = args35207.length;
switch (G__35211) {
case 0:
return om_tools.dom.defs.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35207.slice((1)),(0)));
return om_tools.dom.defs.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.defs.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.defs,null,null);
});

om_tools.dom.defs.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.defs,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.defs.cljs$lang$applyTo = (function (seq35208){
var G__35209 = cljs.core.first.call(null,seq35208);
var seq35208__$1 = cljs.core.next.call(null,seq35208);
return om_tools.dom.defs.cljs$core$IFn$_invoke$arity$variadic(G__35209,seq35208__$1);
});

om_tools.dom.defs.cljs$lang$maxFixedArity = (1);

om_tools.dom.linearGradient = (function om_tools$dom$linearGradient(var_args){
var args35212 = [];
var len__17407__auto___35715 = arguments.length;
var i__17408__auto___35716 = (0);
while(true){
if((i__17408__auto___35716 < len__17407__auto___35715)){
args35212.push((arguments[i__17408__auto___35716]));

var G__35717 = (i__17408__auto___35716 + (1));
i__17408__auto___35716 = G__35717;
continue;
} else {
}
break;
}

var G__35216 = args35212.length;
switch (G__35216) {
case 0:
return om_tools.dom.linearGradient.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35212.slice((1)),(0)));
return om_tools.dom.linearGradient.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.linearGradient.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.linearGradient,null,null);
});

om_tools.dom.linearGradient.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.linearGradient,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.linearGradient.cljs$lang$applyTo = (function (seq35213){
var G__35214 = cljs.core.first.call(null,seq35213);
var seq35213__$1 = cljs.core.next.call(null,seq35213);
return om_tools.dom.linearGradient.cljs$core$IFn$_invoke$arity$variadic(G__35214,seq35213__$1);
});

om_tools.dom.linearGradient.cljs$lang$maxFixedArity = (1);

om_tools.dom.polygon = (function om_tools$dom$polygon(var_args){
var args35217 = [];
var len__17407__auto___35719 = arguments.length;
var i__17408__auto___35720 = (0);
while(true){
if((i__17408__auto___35720 < len__17407__auto___35719)){
args35217.push((arguments[i__17408__auto___35720]));

var G__35721 = (i__17408__auto___35720 + (1));
i__17408__auto___35720 = G__35721;
continue;
} else {
}
break;
}

var G__35221 = args35217.length;
switch (G__35221) {
case 0:
return om_tools.dom.polygon.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35217.slice((1)),(0)));
return om_tools.dom.polygon.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.polygon.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.polygon,null,null);
});

om_tools.dom.polygon.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.polygon,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.polygon.cljs$lang$applyTo = (function (seq35218){
var G__35219 = cljs.core.first.call(null,seq35218);
var seq35218__$1 = cljs.core.next.call(null,seq35218);
return om_tools.dom.polygon.cljs$core$IFn$_invoke$arity$variadic(G__35219,seq35218__$1);
});

om_tools.dom.polygon.cljs$lang$maxFixedArity = (1);

om_tools.dom.radialGradient = (function om_tools$dom$radialGradient(var_args){
var args35222 = [];
var len__17407__auto___35723 = arguments.length;
var i__17408__auto___35724 = (0);
while(true){
if((i__17408__auto___35724 < len__17407__auto___35723)){
args35222.push((arguments[i__17408__auto___35724]));

var G__35725 = (i__17408__auto___35724 + (1));
i__17408__auto___35724 = G__35725;
continue;
} else {
}
break;
}

var G__35226 = args35222.length;
switch (G__35226) {
case 0:
return om_tools.dom.radialGradient.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35222.slice((1)),(0)));
return om_tools.dom.radialGradient.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.radialGradient.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.radialGradient,null,null);
});

om_tools.dom.radialGradient.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.radialGradient,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.radialGradient.cljs$lang$applyTo = (function (seq35223){
var G__35224 = cljs.core.first.call(null,seq35223);
var seq35223__$1 = cljs.core.next.call(null,seq35223);
return om_tools.dom.radialGradient.cljs$core$IFn$_invoke$arity$variadic(G__35224,seq35223__$1);
});

om_tools.dom.radialGradient.cljs$lang$maxFixedArity = (1);

om_tools.dom.stop = (function om_tools$dom$stop(var_args){
var args35227 = [];
var len__17407__auto___35727 = arguments.length;
var i__17408__auto___35728 = (0);
while(true){
if((i__17408__auto___35728 < len__17407__auto___35727)){
args35227.push((arguments[i__17408__auto___35728]));

var G__35729 = (i__17408__auto___35728 + (1));
i__17408__auto___35728 = G__35729;
continue;
} else {
}
break;
}

var G__35231 = args35227.length;
switch (G__35231) {
case 0:
return om_tools.dom.stop.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35227.slice((1)),(0)));
return om_tools.dom.stop.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.stop.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.stop,null,null);
});

om_tools.dom.stop.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.stop,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.stop.cljs$lang$applyTo = (function (seq35228){
var G__35229 = cljs.core.first.call(null,seq35228);
var seq35228__$1 = cljs.core.next.call(null,seq35228);
return om_tools.dom.stop.cljs$core$IFn$_invoke$arity$variadic(G__35229,seq35228__$1);
});

om_tools.dom.stop.cljs$lang$maxFixedArity = (1);

om_tools.dom.tspan = (function om_tools$dom$tspan(var_args){
var args35232 = [];
var len__17407__auto___35731 = arguments.length;
var i__17408__auto___35732 = (0);
while(true){
if((i__17408__auto___35732 < len__17407__auto___35731)){
args35232.push((arguments[i__17408__auto___35732]));

var G__35733 = (i__17408__auto___35732 + (1));
i__17408__auto___35732 = G__35733;
continue;
} else {
}
break;
}

var G__35236 = args35232.length;
switch (G__35236) {
case 0:
return om_tools.dom.tspan.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35232.slice((1)),(0)));
return om_tools.dom.tspan.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.tspan.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,React.DOM.tspan,null,null);
});

om_tools.dom.tspan.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,React.DOM.tspan,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.tspan.cljs$lang$applyTo = (function (seq35233){
var G__35234 = cljs.core.first.call(null,seq35233);
var seq35233__$1 = cljs.core.next.call(null,seq35233);
return om_tools.dom.tspan.cljs$core$IFn$_invoke$arity$variadic(G__35234,seq35233__$1);
});

om_tools.dom.tspan.cljs$lang$maxFixedArity = (1);

om_tools.dom.input = (function om_tools$dom$input(var_args){
var args35237 = [];
var len__17407__auto___35735 = arguments.length;
var i__17408__auto___35736 = (0);
while(true){
if((i__17408__auto___35736 < len__17407__auto___35735)){
args35237.push((arguments[i__17408__auto___35736]));

var G__35737 = (i__17408__auto___35736 + (1));
i__17408__auto___35736 = G__35737;
continue;
} else {
}
break;
}

var G__35241 = args35237.length;
switch (G__35241) {
case 0:
return om_tools.dom.input.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35237.slice((1)),(0)));
return om_tools.dom.input.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.input.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,om.dom.input,null,null);
});

om_tools.dom.input.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,om.dom.input,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.input.cljs$lang$applyTo = (function (seq35238){
var G__35239 = cljs.core.first.call(null,seq35238);
var seq35238__$1 = cljs.core.next.call(null,seq35238);
return om_tools.dom.input.cljs$core$IFn$_invoke$arity$variadic(G__35239,seq35238__$1);
});

om_tools.dom.input.cljs$lang$maxFixedArity = (1);

om_tools.dom.textarea = (function om_tools$dom$textarea(var_args){
var args35242 = [];
var len__17407__auto___35739 = arguments.length;
var i__17408__auto___35740 = (0);
while(true){
if((i__17408__auto___35740 < len__17407__auto___35739)){
args35242.push((arguments[i__17408__auto___35740]));

var G__35741 = (i__17408__auto___35740 + (1));
i__17408__auto___35740 = G__35741;
continue;
} else {
}
break;
}

var G__35246 = args35242.length;
switch (G__35246) {
case 0:
return om_tools.dom.textarea.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args35242.slice((1)),(0)));
return om_tools.dom.textarea.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.textarea.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,om.dom.textarea,null,null);
});

om_tools.dom.textarea.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,om.dom.textarea,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.textarea.cljs$lang$applyTo = (function (seq35243){
var G__35244 = cljs.core.first.call(null,seq35243);
var seq35243__$1 = cljs.core.next.call(null,seq35243);
return om_tools.dom.textarea.cljs$core$IFn$_invoke$arity$variadic(G__35244,seq35243__$1);
});

om_tools.dom.textarea.cljs$lang$maxFixedArity = (1);

om_tools.dom.option = (function om_tools$dom$option(var_args){
var args34782 = [];
var len__17407__auto___35743 = arguments.length;
var i__17408__auto___35744 = (0);
while(true){
if((i__17408__auto___35744 < len__17407__auto___35743)){
args34782.push((arguments[i__17408__auto___35744]));

var G__35745 = (i__17408__auto___35744 + (1));
i__17408__auto___35744 = G__35745;
continue;
} else {
}
break;
}

var G__34786 = args34782.length;
switch (G__34786) {
case 0:
return om_tools.dom.option.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__17426__auto__ = (new cljs.core.IndexedSeq(args34782.slice((1)),(0)));
return om_tools.dom.option.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__17426__auto__);

}
});

om_tools.dom.option.cljs$core$IFn$_invoke$arity$0 = (function (){
return om_tools.dom.element.call(null,om.dom.option,null,null);
});

om_tools.dom.option.cljs$core$IFn$_invoke$arity$variadic = (function (opts__26109__auto__,children__26110__auto__){
return om_tools.dom.element.call(null,om.dom.option,opts__26109__auto__,children__26110__auto__);
});

om_tools.dom.option.cljs$lang$applyTo = (function (seq34783){
var G__34784 = cljs.core.first.call(null,seq34783);
var seq34783__$1 = cljs.core.next.call(null,seq34783);
return om_tools.dom.option.cljs$core$IFn$_invoke$arity$variadic(G__34784,seq34783__$1);
});

om_tools.dom.option.cljs$lang$maxFixedArity = (1);
om_tools.dom.class_set = (function om_tools$dom$class_set(m){

var temp__4425__auto__ = cljs.core.seq.call(null,cljs.core.distinct.call(null,cljs.core.map.call(null,cljs.core.name,cljs.core.keys.call(null,cljs.core.filter.call(null,cljs.core.val,m)))));
if(temp__4425__auto__){
var ks = temp__4425__auto__;
return clojure.string.join.call(null," ",ks);
} else {
return null;
}
});

//# sourceMappingURL=dom.js.map?rel=1449783505012