// Compiled by ClojureScript 1.7.122 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
figwheel.client.file_reloading.queued_file_reload;
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__16349__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__16349__auto__){
return or__16349__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__16349__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__41923_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__41923_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__41928 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__41929 = null;
var count__41930 = (0);
var i__41931 = (0);
while(true){
if((i__41931 < count__41930)){
var n = cljs.core._nth.call(null,chunk__41929,i__41931);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__41932 = seq__41928;
var G__41933 = chunk__41929;
var G__41934 = count__41930;
var G__41935 = (i__41931 + (1));
seq__41928 = G__41932;
chunk__41929 = G__41933;
count__41930 = G__41934;
i__41931 = G__41935;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__41928);
if(temp__4425__auto__){
var seq__41928__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__41928__$1)){
var c__17152__auto__ = cljs.core.chunk_first.call(null,seq__41928__$1);
var G__41936 = cljs.core.chunk_rest.call(null,seq__41928__$1);
var G__41937 = c__17152__auto__;
var G__41938 = cljs.core.count.call(null,c__17152__auto__);
var G__41939 = (0);
seq__41928 = G__41936;
chunk__41929 = G__41937;
count__41930 = G__41938;
i__41931 = G__41939;
continue;
} else {
var n = cljs.core.first.call(null,seq__41928__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__41940 = cljs.core.next.call(null,seq__41928__$1);
var G__41941 = null;
var G__41942 = (0);
var G__41943 = (0);
seq__41928 = G__41940;
chunk__41929 = G__41941;
count__41930 = G__41942;
i__41931 = G__41943;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__41982_41989 = cljs.core.seq.call(null,deps);
var chunk__41983_41990 = null;
var count__41984_41991 = (0);
var i__41985_41992 = (0);
while(true){
if((i__41985_41992 < count__41984_41991)){
var dep_41993 = cljs.core._nth.call(null,chunk__41983_41990,i__41985_41992);
topo_sort_helper_STAR_.call(null,dep_41993,(depth + (1)),state);

var G__41994 = seq__41982_41989;
var G__41995 = chunk__41983_41990;
var G__41996 = count__41984_41991;
var G__41997 = (i__41985_41992 + (1));
seq__41982_41989 = G__41994;
chunk__41983_41990 = G__41995;
count__41984_41991 = G__41996;
i__41985_41992 = G__41997;
continue;
} else {
var temp__4425__auto___41998 = cljs.core.seq.call(null,seq__41982_41989);
if(temp__4425__auto___41998){
var seq__41982_41999__$1 = temp__4425__auto___41998;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__41982_41999__$1)){
var c__17152__auto___42000 = cljs.core.chunk_first.call(null,seq__41982_41999__$1);
var G__42001 = cljs.core.chunk_rest.call(null,seq__41982_41999__$1);
var G__42002 = c__17152__auto___42000;
var G__42003 = cljs.core.count.call(null,c__17152__auto___42000);
var G__42004 = (0);
seq__41982_41989 = G__42001;
chunk__41983_41990 = G__42002;
count__41984_41991 = G__42003;
i__41985_41992 = G__42004;
continue;
} else {
var dep_42005 = cljs.core.first.call(null,seq__41982_41999__$1);
topo_sort_helper_STAR_.call(null,dep_42005,(depth + (1)),state);

var G__42006 = cljs.core.next.call(null,seq__41982_41999__$1);
var G__42007 = null;
var G__42008 = (0);
var G__42009 = (0);
seq__41982_41989 = G__42006;
chunk__41983_41990 = G__42007;
count__41984_41991 = G__42008;
i__41985_41992 = G__42009;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__41986){
var vec__41988 = p__41986;
var x = cljs.core.nth.call(null,vec__41988,(0),null);
var xs = cljs.core.nthnext.call(null,vec__41988,(1));
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__41988,x,xs,get_deps__$1){
return (function (p1__41944_SHARP_){
return clojure.set.difference.call(null,p1__41944_SHARP_,x);
});})(vec__41988,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__42022 = cljs.core.seq.call(null,provides);
var chunk__42023 = null;
var count__42024 = (0);
var i__42025 = (0);
while(true){
if((i__42025 < count__42024)){
var prov = cljs.core._nth.call(null,chunk__42023,i__42025);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__42026_42034 = cljs.core.seq.call(null,requires);
var chunk__42027_42035 = null;
var count__42028_42036 = (0);
var i__42029_42037 = (0);
while(true){
if((i__42029_42037 < count__42028_42036)){
var req_42038 = cljs.core._nth.call(null,chunk__42027_42035,i__42029_42037);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_42038,prov);

var G__42039 = seq__42026_42034;
var G__42040 = chunk__42027_42035;
var G__42041 = count__42028_42036;
var G__42042 = (i__42029_42037 + (1));
seq__42026_42034 = G__42039;
chunk__42027_42035 = G__42040;
count__42028_42036 = G__42041;
i__42029_42037 = G__42042;
continue;
} else {
var temp__4425__auto___42043 = cljs.core.seq.call(null,seq__42026_42034);
if(temp__4425__auto___42043){
var seq__42026_42044__$1 = temp__4425__auto___42043;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42026_42044__$1)){
var c__17152__auto___42045 = cljs.core.chunk_first.call(null,seq__42026_42044__$1);
var G__42046 = cljs.core.chunk_rest.call(null,seq__42026_42044__$1);
var G__42047 = c__17152__auto___42045;
var G__42048 = cljs.core.count.call(null,c__17152__auto___42045);
var G__42049 = (0);
seq__42026_42034 = G__42046;
chunk__42027_42035 = G__42047;
count__42028_42036 = G__42048;
i__42029_42037 = G__42049;
continue;
} else {
var req_42050 = cljs.core.first.call(null,seq__42026_42044__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_42050,prov);

var G__42051 = cljs.core.next.call(null,seq__42026_42044__$1);
var G__42052 = null;
var G__42053 = (0);
var G__42054 = (0);
seq__42026_42034 = G__42051;
chunk__42027_42035 = G__42052;
count__42028_42036 = G__42053;
i__42029_42037 = G__42054;
continue;
}
} else {
}
}
break;
}

var G__42055 = seq__42022;
var G__42056 = chunk__42023;
var G__42057 = count__42024;
var G__42058 = (i__42025 + (1));
seq__42022 = G__42055;
chunk__42023 = G__42056;
count__42024 = G__42057;
i__42025 = G__42058;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__42022);
if(temp__4425__auto__){
var seq__42022__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42022__$1)){
var c__17152__auto__ = cljs.core.chunk_first.call(null,seq__42022__$1);
var G__42059 = cljs.core.chunk_rest.call(null,seq__42022__$1);
var G__42060 = c__17152__auto__;
var G__42061 = cljs.core.count.call(null,c__17152__auto__);
var G__42062 = (0);
seq__42022 = G__42059;
chunk__42023 = G__42060;
count__42024 = G__42061;
i__42025 = G__42062;
continue;
} else {
var prov = cljs.core.first.call(null,seq__42022__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__42030_42063 = cljs.core.seq.call(null,requires);
var chunk__42031_42064 = null;
var count__42032_42065 = (0);
var i__42033_42066 = (0);
while(true){
if((i__42033_42066 < count__42032_42065)){
var req_42067 = cljs.core._nth.call(null,chunk__42031_42064,i__42033_42066);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_42067,prov);

var G__42068 = seq__42030_42063;
var G__42069 = chunk__42031_42064;
var G__42070 = count__42032_42065;
var G__42071 = (i__42033_42066 + (1));
seq__42030_42063 = G__42068;
chunk__42031_42064 = G__42069;
count__42032_42065 = G__42070;
i__42033_42066 = G__42071;
continue;
} else {
var temp__4425__auto___42072__$1 = cljs.core.seq.call(null,seq__42030_42063);
if(temp__4425__auto___42072__$1){
var seq__42030_42073__$1 = temp__4425__auto___42072__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42030_42073__$1)){
var c__17152__auto___42074 = cljs.core.chunk_first.call(null,seq__42030_42073__$1);
var G__42075 = cljs.core.chunk_rest.call(null,seq__42030_42073__$1);
var G__42076 = c__17152__auto___42074;
var G__42077 = cljs.core.count.call(null,c__17152__auto___42074);
var G__42078 = (0);
seq__42030_42063 = G__42075;
chunk__42031_42064 = G__42076;
count__42032_42065 = G__42077;
i__42033_42066 = G__42078;
continue;
} else {
var req_42079 = cljs.core.first.call(null,seq__42030_42073__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_42079,prov);

var G__42080 = cljs.core.next.call(null,seq__42030_42073__$1);
var G__42081 = null;
var G__42082 = (0);
var G__42083 = (0);
seq__42030_42063 = G__42080;
chunk__42031_42064 = G__42081;
count__42032_42065 = G__42082;
i__42033_42066 = G__42083;
continue;
}
} else {
}
}
break;
}

var G__42084 = cljs.core.next.call(null,seq__42022__$1);
var G__42085 = null;
var G__42086 = (0);
var G__42087 = (0);
seq__42022 = G__42084;
chunk__42023 = G__42085;
count__42024 = G__42086;
i__42025 = G__42087;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__42092_42096 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__42093_42097 = null;
var count__42094_42098 = (0);
var i__42095_42099 = (0);
while(true){
if((i__42095_42099 < count__42094_42098)){
var ns_42100 = cljs.core._nth.call(null,chunk__42093_42097,i__42095_42099);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_42100);

var G__42101 = seq__42092_42096;
var G__42102 = chunk__42093_42097;
var G__42103 = count__42094_42098;
var G__42104 = (i__42095_42099 + (1));
seq__42092_42096 = G__42101;
chunk__42093_42097 = G__42102;
count__42094_42098 = G__42103;
i__42095_42099 = G__42104;
continue;
} else {
var temp__4425__auto___42105 = cljs.core.seq.call(null,seq__42092_42096);
if(temp__4425__auto___42105){
var seq__42092_42106__$1 = temp__4425__auto___42105;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42092_42106__$1)){
var c__17152__auto___42107 = cljs.core.chunk_first.call(null,seq__42092_42106__$1);
var G__42108 = cljs.core.chunk_rest.call(null,seq__42092_42106__$1);
var G__42109 = c__17152__auto___42107;
var G__42110 = cljs.core.count.call(null,c__17152__auto___42107);
var G__42111 = (0);
seq__42092_42096 = G__42108;
chunk__42093_42097 = G__42109;
count__42094_42098 = G__42110;
i__42095_42099 = G__42111;
continue;
} else {
var ns_42112 = cljs.core.first.call(null,seq__42092_42106__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_42112);

var G__42113 = cljs.core.next.call(null,seq__42092_42106__$1);
var G__42114 = null;
var G__42115 = (0);
var G__42116 = (0);
seq__42092_42096 = G__42113;
chunk__42093_42097 = G__42114;
count__42094_42098 = G__42115;
i__42095_42099 = G__42116;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__16349__auto__ = goog.require__;
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__42117__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__42117 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__42118__i = 0, G__42118__a = new Array(arguments.length -  0);
while (G__42118__i < G__42118__a.length) {G__42118__a[G__42118__i] = arguments[G__42118__i + 0]; ++G__42118__i;}
  args = new cljs.core.IndexedSeq(G__42118__a,0);
} 
return G__42117__delegate.call(this,args);};
G__42117.cljs$lang$maxFixedArity = 0;
G__42117.cljs$lang$applyTo = (function (arglist__42119){
var args = cljs.core.seq(arglist__42119);
return G__42117__delegate(args);
});
G__42117.cljs$core$IFn$_invoke$arity$variadic = G__42117__delegate;
return G__42117;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__42121 = cljs.core._EQ_;
var expr__42122 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__42121.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__42122))){
var path_parts = ((function (pred__42121,expr__42122){
return (function (p1__42120_SHARP_){
return clojure.string.split.call(null,p1__42120_SHARP_,/[\/\\]/);
});})(pred__42121,expr__42122))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__42121,expr__42122){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(clojure.string.join.call(null,"/",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [".","..",request_url], null)));
}catch (e42124){if((e42124 instanceof Error)){
var e = e42124;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e42124;

}
}})());
});
;})(path_parts,sep,root,pred__42121,expr__42122))
} else {
if(cljs.core.truth_(pred__42121.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__42122))){
return ((function (pred__42121,expr__42122){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred,pred__42121,expr__42122){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__42121,expr__42122))
);

return deferred.addErrback(((function (deferred,pred__42121,expr__42122){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__42121,expr__42122))
);
});
;})(pred__42121,expr__42122))
} else {
return ((function (pred__42121,expr__42122){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__42121,expr__42122))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__42125,callback){
var map__42128 = p__42125;
var map__42128__$1 = ((((!((map__42128 == null)))?((((map__42128.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42128.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42128):map__42128);
var file_msg = map__42128__$1;
var request_url = cljs.core.get.call(null,map__42128__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__42128,map__42128__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__42128,map__42128__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__19429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto__){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto__){
return (function (state_42152){
var state_val_42153 = (state_42152[(1)]);
if((state_val_42153 === (7))){
var inst_42148 = (state_42152[(2)]);
var state_42152__$1 = state_42152;
var statearr_42154_42174 = state_42152__$1;
(statearr_42154_42174[(2)] = inst_42148);

(statearr_42154_42174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42153 === (1))){
var state_42152__$1 = state_42152;
var statearr_42155_42175 = state_42152__$1;
(statearr_42155_42175[(2)] = null);

(statearr_42155_42175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42153 === (4))){
var inst_42132 = (state_42152[(7)]);
var inst_42132__$1 = (state_42152[(2)]);
var state_42152__$1 = (function (){var statearr_42156 = state_42152;
(statearr_42156[(7)] = inst_42132__$1);

return statearr_42156;
})();
if(cljs.core.truth_(inst_42132__$1)){
var statearr_42157_42176 = state_42152__$1;
(statearr_42157_42176[(1)] = (5));

} else {
var statearr_42158_42177 = state_42152__$1;
(statearr_42158_42177[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42153 === (6))){
var state_42152__$1 = state_42152;
var statearr_42159_42178 = state_42152__$1;
(statearr_42159_42178[(2)] = null);

(statearr_42159_42178[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42153 === (3))){
var inst_42150 = (state_42152[(2)]);
var state_42152__$1 = state_42152;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42152__$1,inst_42150);
} else {
if((state_val_42153 === (2))){
var state_42152__$1 = state_42152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42152__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_42153 === (11))){
var inst_42144 = (state_42152[(2)]);
var state_42152__$1 = (function (){var statearr_42160 = state_42152;
(statearr_42160[(8)] = inst_42144);

return statearr_42160;
})();
var statearr_42161_42179 = state_42152__$1;
(statearr_42161_42179[(2)] = null);

(statearr_42161_42179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42153 === (9))){
var inst_42138 = (state_42152[(9)]);
var inst_42136 = (state_42152[(10)]);
var inst_42140 = inst_42138.call(null,inst_42136);
var state_42152__$1 = state_42152;
var statearr_42162_42180 = state_42152__$1;
(statearr_42162_42180[(2)] = inst_42140);

(statearr_42162_42180[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42153 === (5))){
var inst_42132 = (state_42152[(7)]);
var inst_42134 = figwheel.client.file_reloading.blocking_load.call(null,inst_42132);
var state_42152__$1 = state_42152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42152__$1,(8),inst_42134);
} else {
if((state_val_42153 === (10))){
var inst_42136 = (state_42152[(10)]);
var inst_42142 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_42136);
var state_42152__$1 = state_42152;
var statearr_42163_42181 = state_42152__$1;
(statearr_42163_42181[(2)] = inst_42142);

(statearr_42163_42181[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42153 === (8))){
var inst_42132 = (state_42152[(7)]);
var inst_42138 = (state_42152[(9)]);
var inst_42136 = (state_42152[(2)]);
var inst_42137 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_42138__$1 = cljs.core.get.call(null,inst_42137,inst_42132);
var state_42152__$1 = (function (){var statearr_42164 = state_42152;
(statearr_42164[(9)] = inst_42138__$1);

(statearr_42164[(10)] = inst_42136);

return statearr_42164;
})();
if(cljs.core.truth_(inst_42138__$1)){
var statearr_42165_42182 = state_42152__$1;
(statearr_42165_42182[(1)] = (9));

} else {
var statearr_42166_42183 = state_42152__$1;
(statearr_42166_42183[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto__))
;
return ((function (switch__19364__auto__,c__19429__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__19365__auto__ = null;
var figwheel$client$file_reloading$state_machine__19365__auto____0 = (function (){
var statearr_42170 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42170[(0)] = figwheel$client$file_reloading$state_machine__19365__auto__);

(statearr_42170[(1)] = (1));

return statearr_42170;
});
var figwheel$client$file_reloading$state_machine__19365__auto____1 = (function (state_42152){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_42152);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e42171){if((e42171 instanceof Object)){
var ex__19368__auto__ = e42171;
var statearr_42172_42184 = state_42152;
(statearr_42172_42184[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42152);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42171;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42185 = state_42152;
state_42152 = G__42185;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__19365__auto__ = function(state_42152){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__19365__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__19365__auto____1.call(this,state_42152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__19365__auto____0;
figwheel$client$file_reloading$state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__19365__auto____1;
return figwheel$client$file_reloading$state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto__))
})();
var state__19431__auto__ = (function (){var statearr_42173 = f__19430__auto__.call(null);
(statearr_42173[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto__);

return statearr_42173;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto__))
);

return c__19429__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__42186,callback){
var map__42189 = p__42186;
var map__42189__$1 = ((((!((map__42189 == null)))?((((map__42189.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42189.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42189):map__42189);
var file_msg = map__42189__$1;
var namespace = cljs.core.get.call(null,map__42189__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__42189,map__42189__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__42189,map__42189__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__42191){
var map__42194 = p__42191;
var map__42194__$1 = ((((!((map__42194 == null)))?((((map__42194.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42194.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42194):map__42194);
var file_msg = map__42194__$1;
var namespace = cljs.core.get.call(null,map__42194__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__16337__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__16337__auto__){
var or__16349__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
var or__16349__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__16349__auto____$1)){
return or__16349__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__16337__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__42196,callback){
var map__42199 = p__42196;
var map__42199__$1 = ((((!((map__42199 == null)))?((((map__42199.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42199.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42199):map__42199);
var file_msg = map__42199__$1;
var request_url = cljs.core.get.call(null,map__42199__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__42199__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__19429__auto___42287 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___42287,out){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___42287,out){
return (function (state_42269){
var state_val_42270 = (state_42269[(1)]);
if((state_val_42270 === (1))){
var inst_42247 = cljs.core.nth.call(null,files,(0),null);
var inst_42248 = cljs.core.nthnext.call(null,files,(1));
var inst_42249 = files;
var state_42269__$1 = (function (){var statearr_42271 = state_42269;
(statearr_42271[(7)] = inst_42247);

(statearr_42271[(8)] = inst_42249);

(statearr_42271[(9)] = inst_42248);

return statearr_42271;
})();
var statearr_42272_42288 = state_42269__$1;
(statearr_42272_42288[(2)] = null);

(statearr_42272_42288[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42270 === (2))){
var inst_42249 = (state_42269[(8)]);
var inst_42252 = (state_42269[(10)]);
var inst_42252__$1 = cljs.core.nth.call(null,inst_42249,(0),null);
var inst_42253 = cljs.core.nthnext.call(null,inst_42249,(1));
var inst_42254 = (inst_42252__$1 == null);
var inst_42255 = cljs.core.not.call(null,inst_42254);
var state_42269__$1 = (function (){var statearr_42273 = state_42269;
(statearr_42273[(11)] = inst_42253);

(statearr_42273[(10)] = inst_42252__$1);

return statearr_42273;
})();
if(inst_42255){
var statearr_42274_42289 = state_42269__$1;
(statearr_42274_42289[(1)] = (4));

} else {
var statearr_42275_42290 = state_42269__$1;
(statearr_42275_42290[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42270 === (3))){
var inst_42267 = (state_42269[(2)]);
var state_42269__$1 = state_42269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42269__$1,inst_42267);
} else {
if((state_val_42270 === (4))){
var inst_42252 = (state_42269[(10)]);
var inst_42257 = figwheel.client.file_reloading.reload_js_file.call(null,inst_42252);
var state_42269__$1 = state_42269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42269__$1,(7),inst_42257);
} else {
if((state_val_42270 === (5))){
var inst_42263 = cljs.core.async.close_BANG_.call(null,out);
var state_42269__$1 = state_42269;
var statearr_42276_42291 = state_42269__$1;
(statearr_42276_42291[(2)] = inst_42263);

(statearr_42276_42291[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42270 === (6))){
var inst_42265 = (state_42269[(2)]);
var state_42269__$1 = state_42269;
var statearr_42277_42292 = state_42269__$1;
(statearr_42277_42292[(2)] = inst_42265);

(statearr_42277_42292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42270 === (7))){
var inst_42253 = (state_42269[(11)]);
var inst_42259 = (state_42269[(2)]);
var inst_42260 = cljs.core.async.put_BANG_.call(null,out,inst_42259);
var inst_42249 = inst_42253;
var state_42269__$1 = (function (){var statearr_42278 = state_42269;
(statearr_42278[(8)] = inst_42249);

(statearr_42278[(12)] = inst_42260);

return statearr_42278;
})();
var statearr_42279_42293 = state_42269__$1;
(statearr_42279_42293[(2)] = null);

(statearr_42279_42293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__19429__auto___42287,out))
;
return ((function (switch__19364__auto__,c__19429__auto___42287,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__19365__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__19365__auto____0 = (function (){
var statearr_42283 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42283[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__19365__auto__);

(statearr_42283[(1)] = (1));

return statearr_42283;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__19365__auto____1 = (function (state_42269){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_42269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e42284){if((e42284 instanceof Object)){
var ex__19368__auto__ = e42284;
var statearr_42285_42294 = state_42269;
(statearr_42285_42294[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42269);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42284;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42295 = state_42269;
state_42269 = G__42295;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__19365__auto__ = function(state_42269){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__19365__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__19365__auto____1.call(this,state_42269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__19365__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__19365__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___42287,out))
})();
var state__19431__auto__ = (function (){var statearr_42286 = f__19430__auto__.call(null);
(statearr_42286[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___42287);

return statearr_42286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___42287,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__42296,opts){
var map__42300 = p__42296;
var map__42300__$1 = ((((!((map__42300 == null)))?((((map__42300.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42300.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42300):map__42300);
var eval_body__$1 = cljs.core.get.call(null,map__42300__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__42300__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__16337__auto__ = eval_body__$1;
if(cljs.core.truth_(and__16337__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__16337__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e42302){var e = e42302;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4423__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__42303_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__42303_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4423__auto__)){
var file_msg = temp__4423__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__42308){
var vec__42309 = p__42308;
var k = cljs.core.nth.call(null,vec__42309,(0),null);
var v = cljs.core.nth.call(null,vec__42309,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__42310){
var vec__42311 = p__42310;
var k = cljs.core.nth.call(null,vec__42311,(0),null);
var v = cljs.core.nth.call(null,vec__42311,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__42315,p__42316){
var map__42563 = p__42315;
var map__42563__$1 = ((((!((map__42563 == null)))?((((map__42563.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42563.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42563):map__42563);
var opts = map__42563__$1;
var before_jsload = cljs.core.get.call(null,map__42563__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__42563__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__42563__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__42564 = p__42316;
var map__42564__$1 = ((((!((map__42564 == null)))?((((map__42564.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42564.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42564):map__42564);
var msg = map__42564__$1;
var files = cljs.core.get.call(null,map__42564__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__42564__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__42564__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__19429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_42717){
var state_val_42718 = (state_42717[(1)]);
if((state_val_42718 === (7))){
var inst_42580 = (state_42717[(7)]);
var inst_42578 = (state_42717[(8)]);
var inst_42581 = (state_42717[(9)]);
var inst_42579 = (state_42717[(10)]);
var inst_42586 = cljs.core._nth.call(null,inst_42579,inst_42581);
var inst_42587 = figwheel.client.file_reloading.eval_body.call(null,inst_42586,opts);
var inst_42588 = (inst_42581 + (1));
var tmp42719 = inst_42580;
var tmp42720 = inst_42578;
var tmp42721 = inst_42579;
var inst_42578__$1 = tmp42720;
var inst_42579__$1 = tmp42721;
var inst_42580__$1 = tmp42719;
var inst_42581__$1 = inst_42588;
var state_42717__$1 = (function (){var statearr_42722 = state_42717;
(statearr_42722[(11)] = inst_42587);

(statearr_42722[(7)] = inst_42580__$1);

(statearr_42722[(8)] = inst_42578__$1);

(statearr_42722[(9)] = inst_42581__$1);

(statearr_42722[(10)] = inst_42579__$1);

return statearr_42722;
})();
var statearr_42723_42809 = state_42717__$1;
(statearr_42723_42809[(2)] = null);

(statearr_42723_42809[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (20))){
var inst_42621 = (state_42717[(12)]);
var inst_42629 = figwheel.client.file_reloading.sort_files.call(null,inst_42621);
var state_42717__$1 = state_42717;
var statearr_42724_42810 = state_42717__$1;
(statearr_42724_42810[(2)] = inst_42629);

(statearr_42724_42810[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (27))){
var state_42717__$1 = state_42717;
var statearr_42725_42811 = state_42717__$1;
(statearr_42725_42811[(2)] = null);

(statearr_42725_42811[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (1))){
var inst_42570 = (state_42717[(13)]);
var inst_42567 = before_jsload.call(null,files);
var inst_42568 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_42569 = (function (){return ((function (inst_42570,inst_42567,inst_42568,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__42312_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__42312_SHARP_);
});
;})(inst_42570,inst_42567,inst_42568,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_42570__$1 = cljs.core.filter.call(null,inst_42569,files);
var inst_42571 = cljs.core.not_empty.call(null,inst_42570__$1);
var state_42717__$1 = (function (){var statearr_42726 = state_42717;
(statearr_42726[(14)] = inst_42568);

(statearr_42726[(13)] = inst_42570__$1);

(statearr_42726[(15)] = inst_42567);

return statearr_42726;
})();
if(cljs.core.truth_(inst_42571)){
var statearr_42727_42812 = state_42717__$1;
(statearr_42727_42812[(1)] = (2));

} else {
var statearr_42728_42813 = state_42717__$1;
(statearr_42728_42813[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (24))){
var state_42717__$1 = state_42717;
var statearr_42729_42814 = state_42717__$1;
(statearr_42729_42814[(2)] = null);

(statearr_42729_42814[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (39))){
var inst_42671 = (state_42717[(16)]);
var state_42717__$1 = state_42717;
var statearr_42730_42815 = state_42717__$1;
(statearr_42730_42815[(2)] = inst_42671);

(statearr_42730_42815[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (46))){
var inst_42712 = (state_42717[(2)]);
var state_42717__$1 = state_42717;
var statearr_42731_42816 = state_42717__$1;
(statearr_42731_42816[(2)] = inst_42712);

(statearr_42731_42816[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (4))){
var inst_42615 = (state_42717[(2)]);
var inst_42616 = cljs.core.List.EMPTY;
var inst_42617 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_42616);
var inst_42618 = (function (){return ((function (inst_42615,inst_42616,inst_42617,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__42313_SHARP_){
var and__16337__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__42313_SHARP_);
if(cljs.core.truth_(and__16337__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__42313_SHARP_));
} else {
return and__16337__auto__;
}
});
;})(inst_42615,inst_42616,inst_42617,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_42619 = cljs.core.filter.call(null,inst_42618,files);
var inst_42620 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_42621 = cljs.core.concat.call(null,inst_42619,inst_42620);
var state_42717__$1 = (function (){var statearr_42732 = state_42717;
(statearr_42732[(12)] = inst_42621);

(statearr_42732[(17)] = inst_42615);

(statearr_42732[(18)] = inst_42617);

return statearr_42732;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_42733_42817 = state_42717__$1;
(statearr_42733_42817[(1)] = (16));

} else {
var statearr_42734_42818 = state_42717__$1;
(statearr_42734_42818[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (15))){
var inst_42605 = (state_42717[(2)]);
var state_42717__$1 = state_42717;
var statearr_42735_42819 = state_42717__$1;
(statearr_42735_42819[(2)] = inst_42605);

(statearr_42735_42819[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (21))){
var inst_42631 = (state_42717[(19)]);
var inst_42631__$1 = (state_42717[(2)]);
var inst_42632 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_42631__$1);
var state_42717__$1 = (function (){var statearr_42736 = state_42717;
(statearr_42736[(19)] = inst_42631__$1);

return statearr_42736;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_42717__$1,(22),inst_42632);
} else {
if((state_val_42718 === (31))){
var inst_42715 = (state_42717[(2)]);
var state_42717__$1 = state_42717;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_42717__$1,inst_42715);
} else {
if((state_val_42718 === (32))){
var inst_42671 = (state_42717[(16)]);
var inst_42676 = inst_42671.cljs$lang$protocol_mask$partition0$;
var inst_42677 = (inst_42676 & (64));
var inst_42678 = inst_42671.cljs$core$ISeq$;
var inst_42679 = (inst_42677) || (inst_42678);
var state_42717__$1 = state_42717;
if(cljs.core.truth_(inst_42679)){
var statearr_42737_42820 = state_42717__$1;
(statearr_42737_42820[(1)] = (35));

} else {
var statearr_42738_42821 = state_42717__$1;
(statearr_42738_42821[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (40))){
var inst_42692 = (state_42717[(20)]);
var inst_42691 = (state_42717[(2)]);
var inst_42692__$1 = cljs.core.get.call(null,inst_42691,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_42693 = cljs.core.get.call(null,inst_42691,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_42694 = cljs.core.not_empty.call(null,inst_42692__$1);
var state_42717__$1 = (function (){var statearr_42739 = state_42717;
(statearr_42739[(21)] = inst_42693);

(statearr_42739[(20)] = inst_42692__$1);

return statearr_42739;
})();
if(cljs.core.truth_(inst_42694)){
var statearr_42740_42822 = state_42717__$1;
(statearr_42740_42822[(1)] = (41));

} else {
var statearr_42741_42823 = state_42717__$1;
(statearr_42741_42823[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (33))){
var state_42717__$1 = state_42717;
var statearr_42742_42824 = state_42717__$1;
(statearr_42742_42824[(2)] = false);

(statearr_42742_42824[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (13))){
var inst_42591 = (state_42717[(22)]);
var inst_42595 = cljs.core.chunk_first.call(null,inst_42591);
var inst_42596 = cljs.core.chunk_rest.call(null,inst_42591);
var inst_42597 = cljs.core.count.call(null,inst_42595);
var inst_42578 = inst_42596;
var inst_42579 = inst_42595;
var inst_42580 = inst_42597;
var inst_42581 = (0);
var state_42717__$1 = (function (){var statearr_42743 = state_42717;
(statearr_42743[(7)] = inst_42580);

(statearr_42743[(8)] = inst_42578);

(statearr_42743[(9)] = inst_42581);

(statearr_42743[(10)] = inst_42579);

return statearr_42743;
})();
var statearr_42744_42825 = state_42717__$1;
(statearr_42744_42825[(2)] = null);

(statearr_42744_42825[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (22))){
var inst_42631 = (state_42717[(19)]);
var inst_42635 = (state_42717[(23)]);
var inst_42639 = (state_42717[(24)]);
var inst_42634 = (state_42717[(25)]);
var inst_42634__$1 = (state_42717[(2)]);
var inst_42635__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_42634__$1);
var inst_42636 = (function (){var all_files = inst_42631;
var res_SINGLEQUOTE_ = inst_42634__$1;
var res = inst_42635__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_42631,inst_42635,inst_42639,inst_42634,inst_42634__$1,inst_42635__$1,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__42314_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__42314_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_42631,inst_42635,inst_42639,inst_42634,inst_42634__$1,inst_42635__$1,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_42637 = cljs.core.filter.call(null,inst_42636,inst_42634__$1);
var inst_42638 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_42639__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_42638);
var inst_42640 = cljs.core.not_empty.call(null,inst_42639__$1);
var state_42717__$1 = (function (){var statearr_42745 = state_42717;
(statearr_42745[(23)] = inst_42635__$1);

(statearr_42745[(24)] = inst_42639__$1);

(statearr_42745[(25)] = inst_42634__$1);

(statearr_42745[(26)] = inst_42637);

return statearr_42745;
})();
if(cljs.core.truth_(inst_42640)){
var statearr_42746_42826 = state_42717__$1;
(statearr_42746_42826[(1)] = (23));

} else {
var statearr_42747_42827 = state_42717__$1;
(statearr_42747_42827[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (36))){
var state_42717__$1 = state_42717;
var statearr_42748_42828 = state_42717__$1;
(statearr_42748_42828[(2)] = false);

(statearr_42748_42828[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (41))){
var inst_42692 = (state_42717[(20)]);
var inst_42696 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_42697 = cljs.core.map.call(null,inst_42696,inst_42692);
var inst_42698 = cljs.core.pr_str.call(null,inst_42697);
var inst_42699 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_42698)].join('');
var inst_42700 = figwheel.client.utils.log.call(null,inst_42699);
var state_42717__$1 = state_42717;
var statearr_42749_42829 = state_42717__$1;
(statearr_42749_42829[(2)] = inst_42700);

(statearr_42749_42829[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (43))){
var inst_42693 = (state_42717[(21)]);
var inst_42703 = (state_42717[(2)]);
var inst_42704 = cljs.core.not_empty.call(null,inst_42693);
var state_42717__$1 = (function (){var statearr_42750 = state_42717;
(statearr_42750[(27)] = inst_42703);

return statearr_42750;
})();
if(cljs.core.truth_(inst_42704)){
var statearr_42751_42830 = state_42717__$1;
(statearr_42751_42830[(1)] = (44));

} else {
var statearr_42752_42831 = state_42717__$1;
(statearr_42752_42831[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (29))){
var inst_42631 = (state_42717[(19)]);
var inst_42671 = (state_42717[(16)]);
var inst_42635 = (state_42717[(23)]);
var inst_42639 = (state_42717[(24)]);
var inst_42634 = (state_42717[(25)]);
var inst_42637 = (state_42717[(26)]);
var inst_42667 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_42670 = (function (){var all_files = inst_42631;
var res_SINGLEQUOTE_ = inst_42634;
var res = inst_42635;
var files_not_loaded = inst_42637;
var dependencies_that_loaded = inst_42639;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_42631,inst_42671,inst_42635,inst_42639,inst_42634,inst_42637,inst_42667,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__42669){
var map__42753 = p__42669;
var map__42753__$1 = ((((!((map__42753 == null)))?((((map__42753.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42753.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42753):map__42753);
var namespace = cljs.core.get.call(null,map__42753__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_42631,inst_42671,inst_42635,inst_42639,inst_42634,inst_42637,inst_42667,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_42671__$1 = cljs.core.group_by.call(null,inst_42670,inst_42637);
var inst_42673 = (inst_42671__$1 == null);
var inst_42674 = cljs.core.not.call(null,inst_42673);
var state_42717__$1 = (function (){var statearr_42755 = state_42717;
(statearr_42755[(16)] = inst_42671__$1);

(statearr_42755[(28)] = inst_42667);

return statearr_42755;
})();
if(inst_42674){
var statearr_42756_42832 = state_42717__$1;
(statearr_42756_42832[(1)] = (32));

} else {
var statearr_42757_42833 = state_42717__$1;
(statearr_42757_42833[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (44))){
var inst_42693 = (state_42717[(21)]);
var inst_42706 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_42693);
var inst_42707 = cljs.core.pr_str.call(null,inst_42706);
var inst_42708 = [cljs.core.str("not required: "),cljs.core.str(inst_42707)].join('');
var inst_42709 = figwheel.client.utils.log.call(null,inst_42708);
var state_42717__$1 = state_42717;
var statearr_42758_42834 = state_42717__$1;
(statearr_42758_42834[(2)] = inst_42709);

(statearr_42758_42834[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (6))){
var inst_42612 = (state_42717[(2)]);
var state_42717__$1 = state_42717;
var statearr_42759_42835 = state_42717__$1;
(statearr_42759_42835[(2)] = inst_42612);

(statearr_42759_42835[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (28))){
var inst_42637 = (state_42717[(26)]);
var inst_42664 = (state_42717[(2)]);
var inst_42665 = cljs.core.not_empty.call(null,inst_42637);
var state_42717__$1 = (function (){var statearr_42760 = state_42717;
(statearr_42760[(29)] = inst_42664);

return statearr_42760;
})();
if(cljs.core.truth_(inst_42665)){
var statearr_42761_42836 = state_42717__$1;
(statearr_42761_42836[(1)] = (29));

} else {
var statearr_42762_42837 = state_42717__$1;
(statearr_42762_42837[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (25))){
var inst_42635 = (state_42717[(23)]);
var inst_42651 = (state_42717[(2)]);
var inst_42652 = cljs.core.not_empty.call(null,inst_42635);
var state_42717__$1 = (function (){var statearr_42763 = state_42717;
(statearr_42763[(30)] = inst_42651);

return statearr_42763;
})();
if(cljs.core.truth_(inst_42652)){
var statearr_42764_42838 = state_42717__$1;
(statearr_42764_42838[(1)] = (26));

} else {
var statearr_42765_42839 = state_42717__$1;
(statearr_42765_42839[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (34))){
var inst_42686 = (state_42717[(2)]);
var state_42717__$1 = state_42717;
if(cljs.core.truth_(inst_42686)){
var statearr_42766_42840 = state_42717__$1;
(statearr_42766_42840[(1)] = (38));

} else {
var statearr_42767_42841 = state_42717__$1;
(statearr_42767_42841[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (17))){
var state_42717__$1 = state_42717;
var statearr_42768_42842 = state_42717__$1;
(statearr_42768_42842[(2)] = recompile_dependents);

(statearr_42768_42842[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (3))){
var state_42717__$1 = state_42717;
var statearr_42769_42843 = state_42717__$1;
(statearr_42769_42843[(2)] = null);

(statearr_42769_42843[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (12))){
var inst_42608 = (state_42717[(2)]);
var state_42717__$1 = state_42717;
var statearr_42770_42844 = state_42717__$1;
(statearr_42770_42844[(2)] = inst_42608);

(statearr_42770_42844[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (2))){
var inst_42570 = (state_42717[(13)]);
var inst_42577 = cljs.core.seq.call(null,inst_42570);
var inst_42578 = inst_42577;
var inst_42579 = null;
var inst_42580 = (0);
var inst_42581 = (0);
var state_42717__$1 = (function (){var statearr_42771 = state_42717;
(statearr_42771[(7)] = inst_42580);

(statearr_42771[(8)] = inst_42578);

(statearr_42771[(9)] = inst_42581);

(statearr_42771[(10)] = inst_42579);

return statearr_42771;
})();
var statearr_42772_42845 = state_42717__$1;
(statearr_42772_42845[(2)] = null);

(statearr_42772_42845[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (23))){
var inst_42631 = (state_42717[(19)]);
var inst_42635 = (state_42717[(23)]);
var inst_42639 = (state_42717[(24)]);
var inst_42634 = (state_42717[(25)]);
var inst_42637 = (state_42717[(26)]);
var inst_42642 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_42644 = (function (){var all_files = inst_42631;
var res_SINGLEQUOTE_ = inst_42634;
var res = inst_42635;
var files_not_loaded = inst_42637;
var dependencies_that_loaded = inst_42639;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_42631,inst_42635,inst_42639,inst_42634,inst_42637,inst_42642,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__42643){
var map__42773 = p__42643;
var map__42773__$1 = ((((!((map__42773 == null)))?((((map__42773.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42773.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42773):map__42773);
var request_url = cljs.core.get.call(null,map__42773__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_42631,inst_42635,inst_42639,inst_42634,inst_42637,inst_42642,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_42645 = cljs.core.reverse.call(null,inst_42639);
var inst_42646 = cljs.core.map.call(null,inst_42644,inst_42645);
var inst_42647 = cljs.core.pr_str.call(null,inst_42646);
var inst_42648 = figwheel.client.utils.log.call(null,inst_42647);
var state_42717__$1 = (function (){var statearr_42775 = state_42717;
(statearr_42775[(31)] = inst_42642);

return statearr_42775;
})();
var statearr_42776_42846 = state_42717__$1;
(statearr_42776_42846[(2)] = inst_42648);

(statearr_42776_42846[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (35))){
var state_42717__$1 = state_42717;
var statearr_42777_42847 = state_42717__$1;
(statearr_42777_42847[(2)] = true);

(statearr_42777_42847[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (19))){
var inst_42621 = (state_42717[(12)]);
var inst_42627 = figwheel.client.file_reloading.expand_files.call(null,inst_42621);
var state_42717__$1 = state_42717;
var statearr_42778_42848 = state_42717__$1;
(statearr_42778_42848[(2)] = inst_42627);

(statearr_42778_42848[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (11))){
var state_42717__$1 = state_42717;
var statearr_42779_42849 = state_42717__$1;
(statearr_42779_42849[(2)] = null);

(statearr_42779_42849[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (9))){
var inst_42610 = (state_42717[(2)]);
var state_42717__$1 = state_42717;
var statearr_42780_42850 = state_42717__$1;
(statearr_42780_42850[(2)] = inst_42610);

(statearr_42780_42850[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (5))){
var inst_42580 = (state_42717[(7)]);
var inst_42581 = (state_42717[(9)]);
var inst_42583 = (inst_42581 < inst_42580);
var inst_42584 = inst_42583;
var state_42717__$1 = state_42717;
if(cljs.core.truth_(inst_42584)){
var statearr_42781_42851 = state_42717__$1;
(statearr_42781_42851[(1)] = (7));

} else {
var statearr_42782_42852 = state_42717__$1;
(statearr_42782_42852[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (14))){
var inst_42591 = (state_42717[(22)]);
var inst_42600 = cljs.core.first.call(null,inst_42591);
var inst_42601 = figwheel.client.file_reloading.eval_body.call(null,inst_42600,opts);
var inst_42602 = cljs.core.next.call(null,inst_42591);
var inst_42578 = inst_42602;
var inst_42579 = null;
var inst_42580 = (0);
var inst_42581 = (0);
var state_42717__$1 = (function (){var statearr_42783 = state_42717;
(statearr_42783[(7)] = inst_42580);

(statearr_42783[(8)] = inst_42578);

(statearr_42783[(9)] = inst_42581);

(statearr_42783[(10)] = inst_42579);

(statearr_42783[(32)] = inst_42601);

return statearr_42783;
})();
var statearr_42784_42853 = state_42717__$1;
(statearr_42784_42853[(2)] = null);

(statearr_42784_42853[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (45))){
var state_42717__$1 = state_42717;
var statearr_42785_42854 = state_42717__$1;
(statearr_42785_42854[(2)] = null);

(statearr_42785_42854[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (26))){
var inst_42631 = (state_42717[(19)]);
var inst_42635 = (state_42717[(23)]);
var inst_42639 = (state_42717[(24)]);
var inst_42634 = (state_42717[(25)]);
var inst_42637 = (state_42717[(26)]);
var inst_42654 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_42656 = (function (){var all_files = inst_42631;
var res_SINGLEQUOTE_ = inst_42634;
var res = inst_42635;
var files_not_loaded = inst_42637;
var dependencies_that_loaded = inst_42639;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_42631,inst_42635,inst_42639,inst_42634,inst_42637,inst_42654,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__42655){
var map__42786 = p__42655;
var map__42786__$1 = ((((!((map__42786 == null)))?((((map__42786.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42786.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42786):map__42786);
var namespace = cljs.core.get.call(null,map__42786__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__42786__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_42631,inst_42635,inst_42639,inst_42634,inst_42637,inst_42654,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_42657 = cljs.core.map.call(null,inst_42656,inst_42635);
var inst_42658 = cljs.core.pr_str.call(null,inst_42657);
var inst_42659 = figwheel.client.utils.log.call(null,inst_42658);
var inst_42660 = (function (){var all_files = inst_42631;
var res_SINGLEQUOTE_ = inst_42634;
var res = inst_42635;
var files_not_loaded = inst_42637;
var dependencies_that_loaded = inst_42639;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_42631,inst_42635,inst_42639,inst_42634,inst_42637,inst_42654,inst_42656,inst_42657,inst_42658,inst_42659,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_42631,inst_42635,inst_42639,inst_42634,inst_42637,inst_42654,inst_42656,inst_42657,inst_42658,inst_42659,state_val_42718,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_42661 = setTimeout(inst_42660,(10));
var state_42717__$1 = (function (){var statearr_42788 = state_42717;
(statearr_42788[(33)] = inst_42659);

(statearr_42788[(34)] = inst_42654);

return statearr_42788;
})();
var statearr_42789_42855 = state_42717__$1;
(statearr_42789_42855[(2)] = inst_42661);

(statearr_42789_42855[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (16))){
var state_42717__$1 = state_42717;
var statearr_42790_42856 = state_42717__$1;
(statearr_42790_42856[(2)] = reload_dependents);

(statearr_42790_42856[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (38))){
var inst_42671 = (state_42717[(16)]);
var inst_42688 = cljs.core.apply.call(null,cljs.core.hash_map,inst_42671);
var state_42717__$1 = state_42717;
var statearr_42791_42857 = state_42717__$1;
(statearr_42791_42857[(2)] = inst_42688);

(statearr_42791_42857[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (30))){
var state_42717__$1 = state_42717;
var statearr_42792_42858 = state_42717__$1;
(statearr_42792_42858[(2)] = null);

(statearr_42792_42858[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (10))){
var inst_42591 = (state_42717[(22)]);
var inst_42593 = cljs.core.chunked_seq_QMARK_.call(null,inst_42591);
var state_42717__$1 = state_42717;
if(inst_42593){
var statearr_42793_42859 = state_42717__$1;
(statearr_42793_42859[(1)] = (13));

} else {
var statearr_42794_42860 = state_42717__$1;
(statearr_42794_42860[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (18))){
var inst_42625 = (state_42717[(2)]);
var state_42717__$1 = state_42717;
if(cljs.core.truth_(inst_42625)){
var statearr_42795_42861 = state_42717__$1;
(statearr_42795_42861[(1)] = (19));

} else {
var statearr_42796_42862 = state_42717__$1;
(statearr_42796_42862[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (42))){
var state_42717__$1 = state_42717;
var statearr_42797_42863 = state_42717__$1;
(statearr_42797_42863[(2)] = null);

(statearr_42797_42863[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (37))){
var inst_42683 = (state_42717[(2)]);
var state_42717__$1 = state_42717;
var statearr_42798_42864 = state_42717__$1;
(statearr_42798_42864[(2)] = inst_42683);

(statearr_42798_42864[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_42718 === (8))){
var inst_42578 = (state_42717[(8)]);
var inst_42591 = (state_42717[(22)]);
var inst_42591__$1 = cljs.core.seq.call(null,inst_42578);
var state_42717__$1 = (function (){var statearr_42799 = state_42717;
(statearr_42799[(22)] = inst_42591__$1);

return statearr_42799;
})();
if(inst_42591__$1){
var statearr_42800_42865 = state_42717__$1;
(statearr_42800_42865[(1)] = (10));

} else {
var statearr_42801_42866 = state_42717__$1;
(statearr_42801_42866[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__19364__auto__,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__19365__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__19365__auto____0 = (function (){
var statearr_42805 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42805[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__19365__auto__);

(statearr_42805[(1)] = (1));

return statearr_42805;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__19365__auto____1 = (function (state_42717){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_42717);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e42806){if((e42806 instanceof Object)){
var ex__19368__auto__ = e42806;
var statearr_42807_42867 = state_42717;
(statearr_42807_42867[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_42717);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e42806;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42868 = state_42717;
state_42717 = G__42868;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__19365__auto__ = function(state_42717){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__19365__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__19365__auto____1.call(this,state_42717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__19365__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__19365__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__19431__auto__ = (function (){var statearr_42808 = f__19430__auto__.call(null);
(statearr_42808[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto__);

return statearr_42808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto__,map__42563,map__42563__$1,opts,before_jsload,on_jsload,reload_dependents,map__42564,map__42564__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__19429__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__42871,link){
var map__42874 = p__42871;
var map__42874__$1 = ((((!((map__42874 == null)))?((((map__42874.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42874.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42874):map__42874);
var file = cljs.core.get.call(null,map__42874__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = link.href;
if(cljs.core.truth_(temp__4425__auto__)){
var link_href = temp__4425__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4425__auto__,map__42874,map__42874__$1,file){
return (function (p1__42869_SHARP_,p2__42870_SHARP_){
if(cljs.core._EQ_.call(null,p1__42869_SHARP_,p2__42870_SHARP_)){
return p1__42869_SHARP_;
} else {
return false;
}
});})(link_href,temp__4425__auto__,map__42874,map__42874__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4425__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__42880){
var map__42881 = p__42880;
var map__42881__$1 = ((((!((map__42881 == null)))?((((map__42881.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42881.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42881):map__42881);
var match_length = cljs.core.get.call(null,map__42881__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__42881__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__42876_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__42876_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4425__auto__)){
var res = temp__4425__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args42883 = [];
var len__17407__auto___42886 = arguments.length;
var i__17408__auto___42887 = (0);
while(true){
if((i__17408__auto___42887 < len__17407__auto___42886)){
args42883.push((arguments[i__17408__auto___42887]));

var G__42888 = (i__17408__auto___42887 + (1));
i__17408__auto___42887 = G__42888;
continue;
} else {
}
break;
}

var G__42885 = args42883.length;
switch (G__42885) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42883.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__42890_SHARP_,p2__42891_SHARP_){
return cljs.core.assoc.call(null,p1__42890_SHARP_,cljs.core.get.call(null,p2__42891_SHARP_,key),p2__42891_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__42892){
var map__42895 = p__42892;
var map__42895__$1 = ((((!((map__42895 == null)))?((((map__42895.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42895.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42895):map__42895);
var f_data = map__42895__$1;
var file = cljs.core.get.call(null,map__42895__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4425__auto__)){
var link = temp__4425__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__42897,files_msg){
var map__42904 = p__42897;
var map__42904__$1 = ((((!((map__42904 == null)))?((((map__42904.cljs$lang$protocol_mask$partition0$ & (64))) || (map__42904.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__42904):map__42904);
var opts = map__42904__$1;
var on_cssload = cljs.core.get.call(null,map__42904__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__42906_42910 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__42907_42911 = null;
var count__42908_42912 = (0);
var i__42909_42913 = (0);
while(true){
if((i__42909_42913 < count__42908_42912)){
var f_42914 = cljs.core._nth.call(null,chunk__42907_42911,i__42909_42913);
figwheel.client.file_reloading.reload_css_file.call(null,f_42914);

var G__42915 = seq__42906_42910;
var G__42916 = chunk__42907_42911;
var G__42917 = count__42908_42912;
var G__42918 = (i__42909_42913 + (1));
seq__42906_42910 = G__42915;
chunk__42907_42911 = G__42916;
count__42908_42912 = G__42917;
i__42909_42913 = G__42918;
continue;
} else {
var temp__4425__auto___42919 = cljs.core.seq.call(null,seq__42906_42910);
if(temp__4425__auto___42919){
var seq__42906_42920__$1 = temp__4425__auto___42919;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42906_42920__$1)){
var c__17152__auto___42921 = cljs.core.chunk_first.call(null,seq__42906_42920__$1);
var G__42922 = cljs.core.chunk_rest.call(null,seq__42906_42920__$1);
var G__42923 = c__17152__auto___42921;
var G__42924 = cljs.core.count.call(null,c__17152__auto___42921);
var G__42925 = (0);
seq__42906_42910 = G__42922;
chunk__42907_42911 = G__42923;
count__42908_42912 = G__42924;
i__42909_42913 = G__42925;
continue;
} else {
var f_42926 = cljs.core.first.call(null,seq__42906_42920__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_42926);

var G__42927 = cljs.core.next.call(null,seq__42906_42920__$1);
var G__42928 = null;
var G__42929 = (0);
var G__42930 = (0);
seq__42906_42910 = G__42927;
chunk__42907_42911 = G__42928;
count__42908_42912 = G__42929;
i__42909_42913 = G__42930;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__42904,map__42904__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__42904,map__42904__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1449783516598