// Compiled by ClojureScript 1.7.122 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
goog.require('cljs.repl');
goog.require('figwheel.client.heads_up');
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),args], null));

return args;
});
figwheel.client.autoload_QMARK_ = (cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?(function (){
var pred__40876 = cljs.core._EQ_;
var expr__40877 = (function (){var or__16349__auto__ = localStorage.getItem("figwheel_autoload");
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return "true";
}
})();
if(cljs.core.truth_(pred__40876.call(null,"true",expr__40877))){
return true;
} else {
if(cljs.core.truth_(pred__40876.call(null,"false",expr__40877))){
return false;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__40877)].join('')));
}
}
}):(function (){
return true;
}));
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
localStorage.setItem("figwheel_autoload",cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));

return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Figwheel autoloading "),cljs.core.str((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));
} else {
return null;
}
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
figwheel.client.console_print = (function figwheel$client$console_print(args){
console.log.apply(console,cljs.core.into_array.call(null,args));

return args;
});
figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__40879__delegate = function (args){
return figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));
};
var G__40879 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__40880__i = 0, G__40880__a = new Array(arguments.length -  0);
while (G__40880__i < G__40880__a.length) {G__40880__a[G__40880__i] = arguments[G__40880__i + 0]; ++G__40880__i;}
  args = new cljs.core.IndexedSeq(G__40880__a,0);
} 
return G__40879__delegate.call(this,args);};
G__40879.cljs$lang$maxFixedArity = 0;
G__40879.cljs$lang$applyTo = (function (arglist__40881){
var args = cljs.core.seq(arglist__40881);
return G__40879__delegate(args);
});
G__40879.cljs$core$IFn$_invoke$arity$variadic = G__40879__delegate;
return G__40879;
})()
;
});
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel$client$get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__40882){
var map__40885 = p__40882;
var map__40885__$1 = ((((!((map__40885 == null)))?((((map__40885.cljs$lang$protocol_mask$partition0$ & (64))) || (map__40885.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40885):map__40885);
var message = cljs.core.get.call(null,map__40885__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__40885__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str(class$),cljs.core.str(" : "),cljs.core.str(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__16349__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__16349__auto__)){
return or__16349__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__16337__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__16337__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__16337__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__19429__auto___41047 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___41047,ch){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___41047,ch){
return (function (state_41016){
var state_val_41017 = (state_41016[(1)]);
if((state_val_41017 === (7))){
var inst_41012 = (state_41016[(2)]);
var state_41016__$1 = state_41016;
var statearr_41018_41048 = state_41016__$1;
(statearr_41018_41048[(2)] = inst_41012);

(statearr_41018_41048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41017 === (1))){
var state_41016__$1 = state_41016;
var statearr_41019_41049 = state_41016__$1;
(statearr_41019_41049[(2)] = null);

(statearr_41019_41049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41017 === (4))){
var inst_40969 = (state_41016[(7)]);
var inst_40969__$1 = (state_41016[(2)]);
var state_41016__$1 = (function (){var statearr_41020 = state_41016;
(statearr_41020[(7)] = inst_40969__$1);

return statearr_41020;
})();
if(cljs.core.truth_(inst_40969__$1)){
var statearr_41021_41050 = state_41016__$1;
(statearr_41021_41050[(1)] = (5));

} else {
var statearr_41022_41051 = state_41016__$1;
(statearr_41022_41051[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41017 === (15))){
var inst_40976 = (state_41016[(8)]);
var inst_40991 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_40976);
var inst_40992 = cljs.core.first.call(null,inst_40991);
var inst_40993 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_40992);
var inst_40994 = [cljs.core.str("Figwheel: Not loading code with warnings - "),cljs.core.str(inst_40993)].join('');
var inst_40995 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_40994);
var state_41016__$1 = state_41016;
var statearr_41023_41052 = state_41016__$1;
(statearr_41023_41052[(2)] = inst_40995);

(statearr_41023_41052[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41017 === (13))){
var inst_41000 = (state_41016[(2)]);
var state_41016__$1 = state_41016;
var statearr_41024_41053 = state_41016__$1;
(statearr_41024_41053[(2)] = inst_41000);

(statearr_41024_41053[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41017 === (6))){
var state_41016__$1 = state_41016;
var statearr_41025_41054 = state_41016__$1;
(statearr_41025_41054[(2)] = null);

(statearr_41025_41054[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41017 === (17))){
var inst_40998 = (state_41016[(2)]);
var state_41016__$1 = state_41016;
var statearr_41026_41055 = state_41016__$1;
(statearr_41026_41055[(2)] = inst_40998);

(statearr_41026_41055[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41017 === (3))){
var inst_41014 = (state_41016[(2)]);
var state_41016__$1 = state_41016;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41016__$1,inst_41014);
} else {
if((state_val_41017 === (12))){
var inst_40975 = (state_41016[(9)]);
var inst_40989 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_40975,opts);
var state_41016__$1 = state_41016;
if(cljs.core.truth_(inst_40989)){
var statearr_41027_41056 = state_41016__$1;
(statearr_41027_41056[(1)] = (15));

} else {
var statearr_41028_41057 = state_41016__$1;
(statearr_41028_41057[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41017 === (2))){
var state_41016__$1 = state_41016;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41016__$1,(4),ch);
} else {
if((state_val_41017 === (11))){
var inst_40976 = (state_41016[(8)]);
var inst_40981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40982 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_40976);
var inst_40983 = cljs.core.async.timeout.call(null,(1000));
var inst_40984 = [inst_40982,inst_40983];
var inst_40985 = (new cljs.core.PersistentVector(null,2,(5),inst_40981,inst_40984,null));
var state_41016__$1 = state_41016;
return cljs.core.async.ioc_alts_BANG_.call(null,state_41016__$1,(14),inst_40985);
} else {
if((state_val_41017 === (9))){
var inst_40976 = (state_41016[(8)]);
var inst_41002 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_41003 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_40976);
var inst_41004 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_41003);
var inst_41005 = [cljs.core.str("Not loading: "),cljs.core.str(inst_41004)].join('');
var inst_41006 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_41005);
var state_41016__$1 = (function (){var statearr_41029 = state_41016;
(statearr_41029[(10)] = inst_41002);

return statearr_41029;
})();
var statearr_41030_41058 = state_41016__$1;
(statearr_41030_41058[(2)] = inst_41006);

(statearr_41030_41058[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41017 === (5))){
var inst_40969 = (state_41016[(7)]);
var inst_40971 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_40972 = (new cljs.core.PersistentArrayMap(null,2,inst_40971,null));
var inst_40973 = (new cljs.core.PersistentHashSet(null,inst_40972,null));
var inst_40974 = figwheel.client.focus_msgs.call(null,inst_40973,inst_40969);
var inst_40975 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_40974);
var inst_40976 = cljs.core.first.call(null,inst_40974);
var inst_40977 = figwheel.client.autoload_QMARK_.call(null);
var state_41016__$1 = (function (){var statearr_41031 = state_41016;
(statearr_41031[(8)] = inst_40976);

(statearr_41031[(9)] = inst_40975);

return statearr_41031;
})();
if(cljs.core.truth_(inst_40977)){
var statearr_41032_41059 = state_41016__$1;
(statearr_41032_41059[(1)] = (8));

} else {
var statearr_41033_41060 = state_41016__$1;
(statearr_41033_41060[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41017 === (14))){
var inst_40987 = (state_41016[(2)]);
var state_41016__$1 = state_41016;
var statearr_41034_41061 = state_41016__$1;
(statearr_41034_41061[(2)] = inst_40987);

(statearr_41034_41061[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41017 === (16))){
var state_41016__$1 = state_41016;
var statearr_41035_41062 = state_41016__$1;
(statearr_41035_41062[(2)] = null);

(statearr_41035_41062[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41017 === (10))){
var inst_41008 = (state_41016[(2)]);
var state_41016__$1 = (function (){var statearr_41036 = state_41016;
(statearr_41036[(11)] = inst_41008);

return statearr_41036;
})();
var statearr_41037_41063 = state_41016__$1;
(statearr_41037_41063[(2)] = null);

(statearr_41037_41063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41017 === (8))){
var inst_40975 = (state_41016[(9)]);
var inst_40979 = figwheel.client.reload_file_state_QMARK_.call(null,inst_40975,opts);
var state_41016__$1 = state_41016;
if(cljs.core.truth_(inst_40979)){
var statearr_41038_41064 = state_41016__$1;
(statearr_41038_41064[(1)] = (11));

} else {
var statearr_41039_41065 = state_41016__$1;
(statearr_41039_41065[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto___41047,ch))
;
return ((function (switch__19364__auto__,c__19429__auto___41047,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__19365__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__19365__auto____0 = (function (){
var statearr_41043 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41043[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__19365__auto__);

(statearr_41043[(1)] = (1));

return statearr_41043;
});
var figwheel$client$file_reloader_plugin_$_state_machine__19365__auto____1 = (function (state_41016){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_41016);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e41044){if((e41044 instanceof Object)){
var ex__19368__auto__ = e41044;
var statearr_41045_41066 = state_41016;
(statearr_41045_41066[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_41016);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41044;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41067 = state_41016;
state_41016 = G__41067;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__19365__auto__ = function(state_41016){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__19365__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__19365__auto____1.call(this,state_41016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__19365__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__19365__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___41047,ch))
})();
var state__19431__auto__ = (function (){var statearr_41046 = f__19430__auto__.call(null);
(statearr_41046[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___41047);

return statearr_41046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___41047,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__41068_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__41068_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_41075 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_41075){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var _STAR_print_fn_STAR_41073 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR_41074 = cljs.core._STAR_print_newline_STAR_;
cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_fn_STAR_41073,_STAR_print_newline_STAR_41074,base_path_41075){
return (function() { 
var G__41076__delegate = function (args){
return figwheel.client.figwheel_repl_print.call(null,figwheel.client.console_print.call(null,args));
};
var G__41076 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__41077__i = 0, G__41077__a = new Array(arguments.length -  0);
while (G__41077__i < G__41077__a.length) {G__41077__a[G__41077__i] = arguments[G__41077__i + 0]; ++G__41077__i;}
  args = new cljs.core.IndexedSeq(G__41077__a,0);
} 
return G__41076__delegate.call(this,args);};
G__41076.cljs$lang$maxFixedArity = 0;
G__41076.cljs$lang$applyTo = (function (arglist__41078){
var args = cljs.core.seq(arglist__41078);
return G__41076__delegate(args);
});
G__41076.cljs$core$IFn$_invoke$arity$variadic = G__41076__delegate;
return G__41076;
})()
;})(_STAR_print_fn_STAR_41073,_STAR_print_newline_STAR_41074,base_path_41075))
;

cljs.core._STAR_print_newline_STAR_ = false;

try{return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),[cljs.core.str(figwheel.client.utils.eval_helper.call(null,code,opts))].join('')], null));
}finally {cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_41074;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_41073;
}}catch (e41072){if((e41072 instanceof Error)){
var e = e41072;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_41075], null));
} else {
var e = e41072;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_41075))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = {};
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__41079){
var map__41086 = p__41079;
var map__41086__$1 = ((((!((map__41086 == null)))?((((map__41086.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41086.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41086):map__41086);
var opts = map__41086__$1;
var build_id = cljs.core.get.call(null,map__41086__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__41086,map__41086__$1,opts,build_id){
return (function (p__41088){
var vec__41089 = p__41088;
var map__41090 = cljs.core.nth.call(null,vec__41089,(0),null);
var map__41090__$1 = ((((!((map__41090 == null)))?((((map__41090.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41090.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41090):map__41090);
var msg = map__41090__$1;
var msg_name = cljs.core.get.call(null,map__41090__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__41089,(1));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__41089,map__41090,map__41090__$1,msg,msg_name,_,map__41086,map__41086__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__41089,map__41090,map__41090__$1,msg,msg_name,_,map__41086,map__41086__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__41086,map__41086__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__41096){
var vec__41097 = p__41096;
var map__41098 = cljs.core.nth.call(null,vec__41097,(0),null);
var map__41098__$1 = ((((!((map__41098 == null)))?((((map__41098.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41098.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41098):map__41098);
var msg = map__41098__$1;
var msg_name = cljs.core.get.call(null,map__41098__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__41097,(1));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__41100){
var map__41110 = p__41100;
var map__41110__$1 = ((((!((map__41110 == null)))?((((map__41110.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41110.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41110):map__41110);
var on_compile_warning = cljs.core.get.call(null,map__41110__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__41110__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__41110,map__41110__$1,on_compile_warning,on_compile_fail){
return (function (p__41112){
var vec__41113 = p__41112;
var map__41114 = cljs.core.nth.call(null,vec__41113,(0),null);
var map__41114__$1 = ((((!((map__41114 == null)))?((((map__41114.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41114.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41114):map__41114);
var msg = map__41114__$1;
var msg_name = cljs.core.get.call(null,map__41114__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = cljs.core.nthnext.call(null,vec__41113,(1));
var pred__41116 = cljs.core._EQ_;
var expr__41117 = msg_name;
if(cljs.core.truth_(pred__41116.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__41117))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__41116.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__41117))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__41110,map__41110__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__19429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto__,msg_hist,msg_names,msg){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto__,msg_hist,msg_names,msg){
return (function (state_41333){
var state_val_41334 = (state_41333[(1)]);
if((state_val_41334 === (7))){
var inst_41257 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
if(cljs.core.truth_(inst_41257)){
var statearr_41335_41381 = state_41333__$1;
(statearr_41335_41381[(1)] = (8));

} else {
var statearr_41336_41382 = state_41333__$1;
(statearr_41336_41382[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (20))){
var inst_41327 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41337_41383 = state_41333__$1;
(statearr_41337_41383[(2)] = inst_41327);

(statearr_41337_41383[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (27))){
var inst_41323 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41338_41384 = state_41333__$1;
(statearr_41338_41384[(2)] = inst_41323);

(statearr_41338_41384[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (1))){
var inst_41250 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_41333__$1 = state_41333;
if(cljs.core.truth_(inst_41250)){
var statearr_41339_41385 = state_41333__$1;
(statearr_41339_41385[(1)] = (2));

} else {
var statearr_41340_41386 = state_41333__$1;
(statearr_41340_41386[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (24))){
var inst_41325 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41341_41387 = state_41333__$1;
(statearr_41341_41387[(2)] = inst_41325);

(statearr_41341_41387[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (4))){
var inst_41331 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41333__$1,inst_41331);
} else {
if((state_val_41334 === (15))){
var inst_41329 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41342_41388 = state_41333__$1;
(statearr_41342_41388[(2)] = inst_41329);

(statearr_41342_41388[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (21))){
var inst_41288 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41343_41389 = state_41333__$1;
(statearr_41343_41389[(2)] = inst_41288);

(statearr_41343_41389[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (31))){
var inst_41312 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_41333__$1 = state_41333;
if(cljs.core.truth_(inst_41312)){
var statearr_41344_41390 = state_41333__$1;
(statearr_41344_41390[(1)] = (34));

} else {
var statearr_41345_41391 = state_41333__$1;
(statearr_41345_41391[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (32))){
var inst_41321 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41346_41392 = state_41333__$1;
(statearr_41346_41392[(2)] = inst_41321);

(statearr_41346_41392[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (33))){
var inst_41310 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41347_41393 = state_41333__$1;
(statearr_41347_41393[(2)] = inst_41310);

(statearr_41347_41393[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (13))){
var inst_41271 = figwheel.client.heads_up.clear.call(null);
var state_41333__$1 = state_41333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41333__$1,(16),inst_41271);
} else {
if((state_val_41334 === (22))){
var inst_41292 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41293 = figwheel.client.heads_up.append_message.call(null,inst_41292);
var state_41333__$1 = state_41333;
var statearr_41348_41394 = state_41333__$1;
(statearr_41348_41394[(2)] = inst_41293);

(statearr_41348_41394[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (36))){
var inst_41319 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41349_41395 = state_41333__$1;
(statearr_41349_41395[(2)] = inst_41319);

(statearr_41349_41395[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (29))){
var inst_41303 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41350_41396 = state_41333__$1;
(statearr_41350_41396[(2)] = inst_41303);

(statearr_41350_41396[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (6))){
var inst_41252 = (state_41333[(7)]);
var state_41333__$1 = state_41333;
var statearr_41351_41397 = state_41333__$1;
(statearr_41351_41397[(2)] = inst_41252);

(statearr_41351_41397[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (28))){
var inst_41299 = (state_41333[(2)]);
var inst_41300 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41301 = figwheel.client.heads_up.display_warning.call(null,inst_41300);
var state_41333__$1 = (function (){var statearr_41352 = state_41333;
(statearr_41352[(8)] = inst_41299);

return statearr_41352;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41333__$1,(29),inst_41301);
} else {
if((state_val_41334 === (25))){
var inst_41297 = figwheel.client.heads_up.clear.call(null);
var state_41333__$1 = state_41333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41333__$1,(28),inst_41297);
} else {
if((state_val_41334 === (34))){
var inst_41314 = figwheel.client.heads_up.flash_loaded.call(null);
var state_41333__$1 = state_41333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41333__$1,(37),inst_41314);
} else {
if((state_val_41334 === (17))){
var inst_41279 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41353_41398 = state_41333__$1;
(statearr_41353_41398[(2)] = inst_41279);

(statearr_41353_41398[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (3))){
var inst_41269 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_41333__$1 = state_41333;
if(cljs.core.truth_(inst_41269)){
var statearr_41354_41399 = state_41333__$1;
(statearr_41354_41399[(1)] = (13));

} else {
var statearr_41355_41400 = state_41333__$1;
(statearr_41355_41400[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (12))){
var inst_41265 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41356_41401 = state_41333__$1;
(statearr_41356_41401[(2)] = inst_41265);

(statearr_41356_41401[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (2))){
var inst_41252 = (state_41333[(7)]);
var inst_41252__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_41333__$1 = (function (){var statearr_41357 = state_41333;
(statearr_41357[(7)] = inst_41252__$1);

return statearr_41357;
})();
if(cljs.core.truth_(inst_41252__$1)){
var statearr_41358_41402 = state_41333__$1;
(statearr_41358_41402[(1)] = (5));

} else {
var statearr_41359_41403 = state_41333__$1;
(statearr_41359_41403[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (23))){
var inst_41295 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_41333__$1 = state_41333;
if(cljs.core.truth_(inst_41295)){
var statearr_41360_41404 = state_41333__$1;
(statearr_41360_41404[(1)] = (25));

} else {
var statearr_41361_41405 = state_41333__$1;
(statearr_41361_41405[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (35))){
var state_41333__$1 = state_41333;
var statearr_41362_41406 = state_41333__$1;
(statearr_41362_41406[(2)] = null);

(statearr_41362_41406[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (19))){
var inst_41290 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_41333__$1 = state_41333;
if(cljs.core.truth_(inst_41290)){
var statearr_41363_41407 = state_41333__$1;
(statearr_41363_41407[(1)] = (22));

} else {
var statearr_41364_41408 = state_41333__$1;
(statearr_41364_41408[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (11))){
var inst_41261 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41365_41409 = state_41333__$1;
(statearr_41365_41409[(2)] = inst_41261);

(statearr_41365_41409[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (9))){
var inst_41263 = figwheel.client.heads_up.clear.call(null);
var state_41333__$1 = state_41333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41333__$1,(12),inst_41263);
} else {
if((state_val_41334 === (5))){
var inst_41254 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_41333__$1 = state_41333;
var statearr_41366_41410 = state_41333__$1;
(statearr_41366_41410[(2)] = inst_41254);

(statearr_41366_41410[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (14))){
var inst_41281 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_41333__$1 = state_41333;
if(cljs.core.truth_(inst_41281)){
var statearr_41367_41411 = state_41333__$1;
(statearr_41367_41411[(1)] = (18));

} else {
var statearr_41368_41412 = state_41333__$1;
(statearr_41368_41412[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (26))){
var inst_41305 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_41333__$1 = state_41333;
if(cljs.core.truth_(inst_41305)){
var statearr_41369_41413 = state_41333__$1;
(statearr_41369_41413[(1)] = (30));

} else {
var statearr_41370_41414 = state_41333__$1;
(statearr_41370_41414[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (16))){
var inst_41273 = (state_41333[(2)]);
var inst_41274 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41275 = figwheel.client.format_messages.call(null,inst_41274);
var inst_41276 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41277 = figwheel.client.heads_up.display_error.call(null,inst_41275,inst_41276);
var state_41333__$1 = (function (){var statearr_41371 = state_41333;
(statearr_41371[(9)] = inst_41273);

return statearr_41371;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41333__$1,(17),inst_41277);
} else {
if((state_val_41334 === (30))){
var inst_41307 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41308 = figwheel.client.heads_up.display_warning.call(null,inst_41307);
var state_41333__$1 = state_41333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41333__$1,(33),inst_41308);
} else {
if((state_val_41334 === (10))){
var inst_41267 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41372_41415 = state_41333__$1;
(statearr_41372_41415[(2)] = inst_41267);

(statearr_41372_41415[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (18))){
var inst_41283 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41284 = figwheel.client.format_messages.call(null,inst_41283);
var inst_41285 = new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(msg);
var inst_41286 = figwheel.client.heads_up.display_error.call(null,inst_41284,inst_41285);
var state_41333__$1 = state_41333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41333__$1,(21),inst_41286);
} else {
if((state_val_41334 === (37))){
var inst_41316 = (state_41333[(2)]);
var state_41333__$1 = state_41333;
var statearr_41373_41416 = state_41333__$1;
(statearr_41373_41416[(2)] = inst_41316);

(statearr_41373_41416[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41334 === (8))){
var inst_41259 = figwheel.client.heads_up.flash_loaded.call(null);
var state_41333__$1 = state_41333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41333__$1,(11),inst_41259);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19429__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__19364__auto__,c__19429__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__19365__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__19365__auto____0 = (function (){
var statearr_41377 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41377[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__19365__auto__);

(statearr_41377[(1)] = (1));

return statearr_41377;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__19365__auto____1 = (function (state_41333){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_41333);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e41378){if((e41378 instanceof Object)){
var ex__19368__auto__ = e41378;
var statearr_41379_41417 = state_41333;
(statearr_41379_41417[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_41333);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41378;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41418 = state_41333;
state_41333 = G__41418;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__19365__auto__ = function(state_41333){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__19365__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__19365__auto____1.call(this,state_41333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__19365__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__19365__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto__,msg_hist,msg_names,msg))
})();
var state__19431__auto__ = (function (){var statearr_41380 = f__19430__auto__.call(null);
(statearr_41380[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto__);

return statearr_41380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto__,msg_hist,msg_names,msg))
);

return c__19429__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__19429__auto___41481 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto___41481,ch){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto___41481,ch){
return (function (state_41464){
var state_val_41465 = (state_41464[(1)]);
if((state_val_41465 === (1))){
var state_41464__$1 = state_41464;
var statearr_41466_41482 = state_41464__$1;
(statearr_41466_41482[(2)] = null);

(statearr_41466_41482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41465 === (2))){
var state_41464__$1 = state_41464;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41464__$1,(4),ch);
} else {
if((state_val_41465 === (3))){
var inst_41462 = (state_41464[(2)]);
var state_41464__$1 = state_41464;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41464__$1,inst_41462);
} else {
if((state_val_41465 === (4))){
var inst_41452 = (state_41464[(7)]);
var inst_41452__$1 = (state_41464[(2)]);
var state_41464__$1 = (function (){var statearr_41467 = state_41464;
(statearr_41467[(7)] = inst_41452__$1);

return statearr_41467;
})();
if(cljs.core.truth_(inst_41452__$1)){
var statearr_41468_41483 = state_41464__$1;
(statearr_41468_41483[(1)] = (5));

} else {
var statearr_41469_41484 = state_41464__$1;
(statearr_41469_41484[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41465 === (5))){
var inst_41452 = (state_41464[(7)]);
var inst_41454 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_41452);
var state_41464__$1 = state_41464;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41464__$1,(8),inst_41454);
} else {
if((state_val_41465 === (6))){
var state_41464__$1 = state_41464;
var statearr_41470_41485 = state_41464__$1;
(statearr_41470_41485[(2)] = null);

(statearr_41470_41485[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41465 === (7))){
var inst_41460 = (state_41464[(2)]);
var state_41464__$1 = state_41464;
var statearr_41471_41486 = state_41464__$1;
(statearr_41471_41486[(2)] = inst_41460);

(statearr_41471_41486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41465 === (8))){
var inst_41456 = (state_41464[(2)]);
var state_41464__$1 = (function (){var statearr_41472 = state_41464;
(statearr_41472[(8)] = inst_41456);

return statearr_41472;
})();
var statearr_41473_41487 = state_41464__$1;
(statearr_41473_41487[(2)] = null);

(statearr_41473_41487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19429__auto___41481,ch))
;
return ((function (switch__19364__auto__,c__19429__auto___41481,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__19365__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__19365__auto____0 = (function (){
var statearr_41477 = [null,null,null,null,null,null,null,null,null];
(statearr_41477[(0)] = figwheel$client$heads_up_plugin_$_state_machine__19365__auto__);

(statearr_41477[(1)] = (1));

return statearr_41477;
});
var figwheel$client$heads_up_plugin_$_state_machine__19365__auto____1 = (function (state_41464){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_41464);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e41478){if((e41478 instanceof Object)){
var ex__19368__auto__ = e41478;
var statearr_41479_41488 = state_41464;
(statearr_41479_41488[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_41464);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41478;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41489 = state_41464;
state_41464 = G__41489;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__19365__auto__ = function(state_41464){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__19365__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__19365__auto____1.call(this,state_41464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__19365__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__19365__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto___41481,ch))
})();
var state__19431__auto__ = (function (){var statearr_41480 = f__19430__auto__.call(null);
(statearr_41480[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto___41481);

return statearr_41480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto___41481,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__19429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19429__auto__){
return (function (){
var f__19430__auto__ = (function (){var switch__19364__auto__ = ((function (c__19429__auto__){
return (function (state_41510){
var state_val_41511 = (state_41510[(1)]);
if((state_val_41511 === (1))){
var inst_41505 = cljs.core.async.timeout.call(null,(3000));
var state_41510__$1 = state_41510;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_41510__$1,(2),inst_41505);
} else {
if((state_val_41511 === (2))){
var inst_41507 = (state_41510[(2)]);
var inst_41508 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_41510__$1 = (function (){var statearr_41512 = state_41510;
(statearr_41512[(7)] = inst_41507);

return statearr_41512;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_41510__$1,inst_41508);
} else {
return null;
}
}
});})(c__19429__auto__))
;
return ((function (switch__19364__auto__,c__19429__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__19365__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__19365__auto____0 = (function (){
var statearr_41516 = [null,null,null,null,null,null,null,null];
(statearr_41516[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__19365__auto__);

(statearr_41516[(1)] = (1));

return statearr_41516;
});
var figwheel$client$enforce_project_plugin_$_state_machine__19365__auto____1 = (function (state_41510){
while(true){
var ret_value__19366__auto__ = (function (){try{while(true){
var result__19367__auto__ = switch__19364__auto__.call(null,state_41510);
if(cljs.core.keyword_identical_QMARK_.call(null,result__19367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__19367__auto__;
}
break;
}
}catch (e41517){if((e41517 instanceof Object)){
var ex__19368__auto__ = e41517;
var statearr_41518_41520 = state_41510;
(statearr_41518_41520[(5)] = ex__19368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_41510);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41517;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__19366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41521 = state_41510;
state_41510 = G__41521;
continue;
} else {
return ret_value__19366__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__19365__auto__ = function(state_41510){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__19365__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__19365__auto____1.call(this,state_41510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__19365__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__19365__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__19365__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__19365__auto__;
})()
;})(switch__19364__auto__,c__19429__auto__))
})();
var state__19431__auto__ = (function (){var statearr_41519 = f__19430__auto__.call(null);
(statearr_41519[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19429__auto__);

return statearr_41519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19431__auto__);
});})(c__19429__auto__))
);

return c__19429__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__41522){
var map__41529 = p__41522;
var map__41529__$1 = ((((!((map__41529 == null)))?((((map__41529.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41529.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41529):map__41529);
var ed = map__41529__$1;
var formatted_exception = cljs.core.get.call(null,map__41529__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__41529__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__41529__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__41531_41535 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__41532_41536 = null;
var count__41533_41537 = (0);
var i__41534_41538 = (0);
while(true){
if((i__41534_41538 < count__41533_41537)){
var msg_41539 = cljs.core._nth.call(null,chunk__41532_41536,i__41534_41538);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_41539);

var G__41540 = seq__41531_41535;
var G__41541 = chunk__41532_41536;
var G__41542 = count__41533_41537;
var G__41543 = (i__41534_41538 + (1));
seq__41531_41535 = G__41540;
chunk__41532_41536 = G__41541;
count__41533_41537 = G__41542;
i__41534_41538 = G__41543;
continue;
} else {
var temp__4425__auto___41544 = cljs.core.seq.call(null,seq__41531_41535);
if(temp__4425__auto___41544){
var seq__41531_41545__$1 = temp__4425__auto___41544;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__41531_41545__$1)){
var c__17152__auto___41546 = cljs.core.chunk_first.call(null,seq__41531_41545__$1);
var G__41547 = cljs.core.chunk_rest.call(null,seq__41531_41545__$1);
var G__41548 = c__17152__auto___41546;
var G__41549 = cljs.core.count.call(null,c__17152__auto___41546);
var G__41550 = (0);
seq__41531_41535 = G__41547;
chunk__41532_41536 = G__41548;
count__41533_41537 = G__41549;
i__41534_41538 = G__41550;
continue;
} else {
var msg_41551 = cljs.core.first.call(null,seq__41531_41545__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_41551);

var G__41552 = cljs.core.next.call(null,seq__41531_41545__$1);
var G__41553 = null;
var G__41554 = (0);
var G__41555 = (0);
seq__41531_41535 = G__41552;
chunk__41532_41536 = G__41553;
count__41533_41537 = G__41554;
i__41534_41538 = G__41555;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str("Error on file "),cljs.core.str(new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", line "),cljs.core.str(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(cause)),cljs.core.str(", column "),cljs.core.str(new cljs.core.Keyword(null,"column","column",2078222095).cljs$core$IFn$_invoke$arity$1(cause))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__41556){
var map__41559 = p__41556;
var map__41559__$1 = ((((!((map__41559 == null)))?((((map__41559.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41559.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41559):map__41559);
var w = map__41559__$1;
var message = cljs.core.get.call(null,map__41559__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str("Figwheel: Compile Warning - "),cljs.core.str(message)].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[figwheel.client.default_on_compile_warning,figwheel.client.default_on_jsload,true,figwheel.client.default_on_compile_fail,false,true,[cljs.core.str("ws://"),cljs.core.str((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str("/figwheel-ws")].join(''),figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__16337__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__16337__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__16337__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__41567 = cljs.core.seq.call(null,plugins);
var chunk__41568 = null;
var count__41569 = (0);
var i__41570 = (0);
while(true){
if((i__41570 < count__41569)){
var vec__41571 = cljs.core._nth.call(null,chunk__41568,i__41570);
var k = cljs.core.nth.call(null,vec__41571,(0),null);
var plugin = cljs.core.nth.call(null,vec__41571,(1),null);
if(cljs.core.truth_(plugin)){
var pl_41573 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__41567,chunk__41568,count__41569,i__41570,pl_41573,vec__41571,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_41573.call(null,msg_hist);
});})(seq__41567,chunk__41568,count__41569,i__41570,pl_41573,vec__41571,k,plugin))
);
} else {
}

var G__41574 = seq__41567;
var G__41575 = chunk__41568;
var G__41576 = count__41569;
var G__41577 = (i__41570 + (1));
seq__41567 = G__41574;
chunk__41568 = G__41575;
count__41569 = G__41576;
i__41570 = G__41577;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__41567);
if(temp__4425__auto__){
var seq__41567__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__41567__$1)){
var c__17152__auto__ = cljs.core.chunk_first.call(null,seq__41567__$1);
var G__41578 = cljs.core.chunk_rest.call(null,seq__41567__$1);
var G__41579 = c__17152__auto__;
var G__41580 = cljs.core.count.call(null,c__17152__auto__);
var G__41581 = (0);
seq__41567 = G__41578;
chunk__41568 = G__41579;
count__41569 = G__41580;
i__41570 = G__41581;
continue;
} else {
var vec__41572 = cljs.core.first.call(null,seq__41567__$1);
var k = cljs.core.nth.call(null,vec__41572,(0),null);
var plugin = cljs.core.nth.call(null,vec__41572,(1),null);
if(cljs.core.truth_(plugin)){
var pl_41582 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__41567,chunk__41568,count__41569,i__41570,pl_41582,vec__41572,k,plugin,seq__41567__$1,temp__4425__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_41582.call(null,msg_hist);
});})(seq__41567,chunk__41568,count__41569,i__41570,pl_41582,vec__41572,k,plugin,seq__41567__$1,temp__4425__auto__))
);
} else {
}

var G__41583 = cljs.core.next.call(null,seq__41567__$1);
var G__41584 = null;
var G__41585 = (0);
var G__41586 = (0);
seq__41567 = G__41583;
chunk__41568 = G__41584;
count__41569 = G__41585;
i__41570 = G__41586;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args41587 = [];
var len__17407__auto___41590 = arguments.length;
var i__17408__auto___41591 = (0);
while(true){
if((i__17408__auto___41591 < len__17407__auto___41590)){
args41587.push((arguments[i__17408__auto___41591]));

var G__41592 = (i__17408__auto___41591 + (1));
i__17408__auto___41591 = G__41592;
continue;
} else {
}
break;
}

var G__41589 = args41587.length;
switch (G__41589) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args41587.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

return figwheel.client.socket.open.call(null,system_options);
}));
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;
figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__17414__auto__ = [];
var len__17407__auto___41598 = arguments.length;
var i__17408__auto___41599 = (0);
while(true){
if((i__17408__auto___41599 < len__17407__auto___41598)){
args__17414__auto__.push((arguments[i__17408__auto___41599]));

var G__41600 = (i__17408__auto___41599 + (1));
i__17408__auto___41599 = G__41600;
continue;
} else {
}
break;
}

var argseq__17415__auto__ = ((((0) < args__17414__auto__.length))?(new cljs.core.IndexedSeq(args__17414__auto__.slice((0)),(0))):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__17415__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__41595){
var map__41596 = p__41595;
var map__41596__$1 = ((((!((map__41596 == null)))?((((map__41596.cljs$lang$protocol_mask$partition0$ & (64))) || (map__41596.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41596):map__41596);
var opts = map__41596__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq41594){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq41594));
});

//# sourceMappingURL=client.js.map?rel=1449783515320