(defproject yieldbot/flambo "0.2.0"
  :description "A Clojure DSL for Apache Spark"
  :url "https://github.com/yieldbot/flambo"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :repositories {"releases" {:url "s3p://maven.yieldbot.com/releases/"
                             :username :env :passphrase :env}
                 "snapshots" {:url "s3p://maven.yieldbot.com/snapshots/"
                              :username :env :passphrase :env}}
  :dependencies [[org.clojure/clojure "1.6.0"]
                 [org.clojure/tools.logging "0.2.6"]
                 [yieldbot/serializable-fn "0.0.5"]
                 [com.twitter/carbonite "1.3.3"]
                 [com.twitter/chill_2.10 "0.3.5"]
                 [prismatic/schema "0.2.1"]]
  :plugins [[s3-wagon-private "1.1.2"]]
  :profiles {:dev
             {;; so gen-class stuff works in the repl
              :aot [flambo.function]}
             :provided
             {:dependencies
              [[org.apache.spark/spark-core_2.10 "0.9.1"]
               [org.apache.spark/spark-streaming_2.10 "0.9.1"]
               [org.apache.spark/spark-streaming-kafka_2.10 "0.9.1"]]}
             :1.5.1
             {:dependencies [[org.clojure/clojure "1.5.1"]]}}
  :source-paths ["src/clj"]
  :java-source-paths ["src/jvm"]
  :global-vars {*warn-on-reflection* true})
