(ns yetibot.core.commands.that
  (:require
    [taoensso.timbre :refer [info warn error]]
    [yetibot.core.models.history :as h]
    [yetibot.core.hooks :refer [cmd-hook]]))

(defn get-that [chat-source cmd?]
  ;; the cmd used to call this will be in history, so get the last two then get
  ;; the first for it
  (let [result (last (h/last-chat-for-room chat-source cmd? 2))]
    {:result/value (:body result)
     :result/data result}))

(defn that-with-cmd-cmd
  "that cmd # retrieve last command from history"
  {:yb/cat #{:util}}
  [{:keys [chat-source]}]
  (get-that chat-source true))

(defn that-cmd
  "that # retrieve last non-command chat from history"
  {:yb/cat #{:util}}
  [{:keys [chat-source]}]
  (get-that chat-source false))

(cmd-hook ["that" #"^that$"]
  #"cmd" that-with-cmd-cmd
  _ that-cmd)
